/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;

public final class TagTableModel
extends AbstractTableModel {
    private List<String> keys;
    private final PointInTimeType pointInTimeType;
    private final HistoryBrowserModel model;

    public TagTableModel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) {
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        this.initKeyList();
    }

    void initKeyList() {
        this.keys = new ArrayList<String>(this.model.getKeySet());
        Collections.sort(this.keys);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.keys == null) {
            return 0;
        }
        return this.keys.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getKeyAt(n);
    }

    public String getKeyAt(int n) {
        return this.keys.get(n);
    }

    public boolean hasTag(String string) {
        HistoryOsmPrimitive historyOsmPrimitive = this.model.getPointInTime(this.pointInTimeType);
        return historyOsmPrimitive != null && historyOsmPrimitive.hasKey(string);
    }

    public String getValue(String string) {
        HistoryOsmPrimitive historyOsmPrimitive = this.model.getPointInTime(this.pointInTimeType);
        if (historyOsmPrimitive == null) {
            return null;
        }
        return historyOsmPrimitive.get(string);
    }

    public boolean oppositeHasTag(String string) {
        HistoryOsmPrimitive historyOsmPrimitive = this.model.getPointInTime(this.pointInTimeType.opposite());
        return historyOsmPrimitive != null && historyOsmPrimitive.hasKey(string);
    }

    public String getOppositeValue(String string) {
        HistoryOsmPrimitive historyOsmPrimitive = this.model.getPointInTime(this.pointInTimeType.opposite());
        if (historyOsmPrimitive == null) {
            return null;
        }
        return historyOsmPrimitive.get(string);
    }

    public boolean hasSameValueAsOpposite(String string) {
        String string2 = this.getValue(string);
        String string3 = this.getOppositeValue(string);
        return string2 != null && string2.equals(string3);
    }

    public PointInTimeType getPointInTimeType() {
        return this.pointInTimeType;
    }

    public boolean isCurrentPointInTime() {
        return this.pointInTimeType.equals((Object)PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    public boolean isReferencePointInTime() {
        return this.pointInTimeType.equals((Object)PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }
}

