/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadFileTask
extends PleaseWaitRunnable {
    private final String address;
    private final File file;
    private final boolean mkdir;
    private final boolean unpack;
    private boolean canceled;
    private HttpClient downloadConnection;

    public DownloadFileTask(Component component, String string, File file, boolean bl, boolean bl2) {
        super(component, I18n.tr("Downloading file", new Object[0]), false);
        this.address = string;
        this.file = file;
        this.mkdir = bl;
        this.unpack = bl2;
    }

    private synchronized void closeConnectionIfNeeded() {
        if (this.downloadConnection != null) {
            this.downloadConnection.disconnect();
        }
        this.downloadConnection = null;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        this.closeConnectionIfNeeded();
    }

    @Override
    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() throws DownloadException {
        try {
            long l;
            Serializable serializable;
            if (this.mkdir && !(serializable = this.file.getParentFile()).exists()) {
                Utils.mkDirs(serializable);
            }
            serializable = new URL(this.address);
            Object object = this;
            synchronized (object) {
                this.downloadConnection = HttpClient.create((URL)serializable).useCache(false);
                this.downloadConnection.connect();
                l = this.downloadConnection.getResponse().getContentLength();
            }
            this.progressMonitor.setTicksCount(100);
            this.progressMonitor.subTask(I18n.tr("Downloading File {0}: {1} bytes...", this.file.getName(), l));
            object = this.downloadConnection.getResponse().getContent();
            Throwable throwable = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                byte[] byArray = new byte[32768];
                int n = 0;
                long l2 = 0L;
                int n2 = ((InputStream)object).read(byArray);
                while (n2 != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    n += n2;
                    if (this.canceled) {
                        break;
                    }
                    long l3 = 100L * (long)n / l;
                    if (l3 != l2) {
                        this.progressMonitor.setTicks((int)l3);
                        l2 = l3;
                    }
                    n2 = ((InputStream)object).read(byArray);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            if (!this.canceled) {
                Logging.info(I18n.tr("Download finished", new Object[0]));
                if (this.unpack) {
                    Logging.info(I18n.tr("Unpacking {0} into {1}", this.file.getAbsolutePath(), this.file.getParent()));
                    DownloadFileTask.unzipFileRecursively(this.file, this.file.getParent());
                    Utils.deleteFile(this.file);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            String string = I18n.tr("Cannot download file ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", this.file.getName(), this.address);
            Logging.warn(string);
            throw new DownloadException(string, malformedURLException);
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            throw new DownloadException(iOException.getMessage(), iOException);
        }
        finally {
            this.closeConnectionIfNeeded();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException {
        if (this.canceled) {
            return;
        }
        try {
            this.download();
        }
        catch (DownloadException downloadException) {
            Logging.error(downloadException);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public static void unzipFileRecursively(File file, String string) throws IOException {
        try (ZipFile zipFile = new ZipFile(file, StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(string, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    Utils.mkDirs(file2);
                    continue;
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    Files.copy(inputStream, file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    private static class DownloadException
    extends Exception {
        DownloadException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

