/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.io.ValidatorErrorWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ValidatorErrorExporter
extends FileExporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("xml", "xml", I18n.tr("Validation Error Files", new Object[0]) + " (*.xml)");

    public ValidatorErrorExporter() {
        super(FILE_FILTER);
    }

    @Override
    public boolean acceptFile(File file, Layer layer) {
        if (!(layer instanceof ValidatorLayer)) {
            return false;
        }
        return super.acceptFile(file, layer);
    }

    @Override
    public void exportData(File file, Layer layer) throws IOException {
        OsmDataLayer osmDataLayer = MainApplication.getLayerManager().getEditLayer();
        if (layer instanceof ValidatorLayer && osmDataLayer != null) {
            Logging.info("exporting validation errors to file: " + file);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 ValidatorErrorWriter validatorErrorWriter = new ValidatorErrorWriter(fileOutputStream);){
                validatorErrorWriter.write(osmDataLayer.validationErrors);
            }
        }
    }
}

