/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.gpx.DateFilterPanel;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class ChooseTrackVisibilityAction
extends AbstractAction {
    private final transient GpxLayer layer;
    private DateFilterPanel dateFilter;
    private JTable table;
    private boolean noUpdates;

    public ChooseTrackVisibilityAction(GpxLayer gpxLayer) {
        super(I18n.tr("Choose visible tracks", new Object[0]), ImageProvider.get("dialogs/filter"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/ChooseTrackVisibility"));
    }

    private Object[][] buildTableContents() {
        Object[][] objectArray = new Object[this.layer.data.tracks.size()][5];
        int n = 0;
        for (GpxTrack gpxTrack : this.layer.data.tracks) {
            Map<String, Object> map = gpxTrack.getAttributes();
            String string = (String)Optional.ofNullable(map.get("name")).orElse("");
            String string2 = (String)Optional.ofNullable(map.get("desc")).orElse("");
            String string3 = GpxLayer.getTimespanForTrack(gpxTrack);
            TrackLength trackLength = new TrackLength(gpxTrack.length());
            String string4 = (String)Optional.ofNullable(map.get("url")).orElse("");
            objectArray[n] = new Object[]{string, string2, string3, trackLength, string4};
            ++n;
        }
        return objectArray;
    }

    private static JTable buildTable(Object[] ... objectArray) {
        Object[] objectArray2 = new String[]{I18n.tr("Name", new Object[0]), I18n.tr("Description", new Object[0]), I18n.tr("Timespan", new Object[0]), I18n.tr("Length", new Object[0]), I18n.tr("URL", new Object[0])};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2);
        JTable jTable = new JTable(defaultTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setToolTipText(this.getValueAt(n, n2).toString());
                }
                return component;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        TableRowSorter<DefaultTableModel> tableRowSorter = new TableRowSorter<DefaultTableModel>();
        jTable.setRowSorter(tableRowSorter);
        tableRowSorter.setModel(defaultTableModel);
        tableRowSorter.setComparator(3, new LengthContentComparator());
        jTable.getColumnModel().getColumn(0).setPreferredWidth(220);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        jTable.getColumnModel().getColumn(2).setPreferredWidth(200);
        jTable.getColumnModel().getColumn(3).setPreferredWidth(50);
        jTable.getColumnModel().getColumn(4).setPreferredWidth(100);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() != 2) {
                    return;
                }
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.convertColumnIndexToModel(jTable.columnAtPoint(mouseEvent.getPoint()));
                if (n != 4) {
                    return;
                }
                int n2 = jTable.rowAtPoint(mouseEvent.getPoint());
                String string = (String)jTable.getValueAt(n2, n);
                if (string == null || string.isEmpty()) {
                    return;
                }
                OpenBrowser.displayUrl(string);
            }
        };
        jTable.addMouseListener(mouseAdapter);
        jTable.setFillsViewportHeight(true);
        return jTable;
    }

    private void selectVisibleTracksInTable() {
        if (!this.layer.isVisible()) {
            return;
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel.clearSelection();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            if (!this.layer.trackVisibility[i]) continue;
            listSelectionModel.addSelectionInterval(i, i);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    private void listenToSelectionChanges() {
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (this.noUpdates || !(listSelectionEvent.getSource() instanceof ListSelectionModel)) {
                return;
            }
            this.updateVisibilityFromTable();
        });
    }

    private void updateVisibilityFromTable() {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = listSelectionModel.isSelectedIndex(i);
        }
        this.layer.invalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent2) {
        Object object;
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.dateFilter = new DateFilterPanel(this.layer, "gpx.traces", false);
        this.dateFilter.setFilterAppliedListener(actionEvent -> {
            this.noUpdates = true;
            this.selectVisibleTracksInTable();
            this.noUpdates = false;
            this.layer.invalidate();
        });
        this.dateFilter.loadFromPrefs();
        JToggleButton jToggleButton = new JToggleButton(new AbstractAction(I18n.tr("Select by date", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JToggleButton)actionEvent.getSource()).isSelected()) {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(true);
                    ChooseTrackVisibilityAction.this.dateFilter.applyFilter();
                } else {
                    ChooseTrackVisibilityAction.this.dateFilter.setEnabled(false);
                }
            }
        });
        this.dateFilter.setEnabled(false);
        jPanel.add((Component)jToggleButton, GBC.std().insets(0, 0, 5, 0));
        jPanel.add((Component)this.dateFilter, GBC.eol().insets(0, 0, 10, 0).fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("<html>Select all tracks that you want to be displayed. You can drag select a range of tracks or use CTRL+Click to select specific ones. The map is updated live in the background. Open the URLs by double clicking them.</html>", new Object[0])), GBC.eop().fill(2));
        boolean[] blArray = (boolean[])this.layer.trackVisibility.clone();
        this.table = ChooseTrackVisibilityAction.buildTable(this.buildTableContents());
        this.selectVisibleTracksInTable();
        this.listenToSelectionChanges();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        int n = 1;
        if (!GraphicsEnvironment.isHeadless()) {
            object = new ExtendedDialog(Main.parent, I18n.tr("Set track visibility for {0}", this.layer.getName()), I18n.tr("Show all", new Object[0]), I18n.tr("Show selected only", new Object[0]), I18n.tr("Cancel", new Object[0]));
            ((ExtendedDialog)object).setButtonIcons("eye", "dialogs/filter", "cancel");
            ((ExtendedDialog)object).setContent(jPanel, false);
            ((ExtendedDialog)object).setDefaultButton(2);
            ((ExtendedDialog)object).setCancelButton(3);
            ((ExtendedDialog)object).configureContextsensitiveHelp("/Action/ChooseTrackVisibility", true);
            ((ExtendedDialog)object).setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(1000, 500)));
            ((ExtendedDialog)object).showDialog();
            this.dateFilter.saveInPrefs();
            n = ((ExtendedDialog)object).getValue();
            if (n != 1 && n != 2) {
                this.layer.trackVisibility = Arrays.copyOf(blArray, this.layer.trackVisibility.length);
                MainApplication.getMap().repaint();
                return;
            }
        }
        object = this.table.getSelectionModel();
        boolean bl = n == 1 || object.isSelectionEmpty();
        for (int i = 0; i < this.layer.trackVisibility.length; ++i) {
            this.layer.trackVisibility[this.table.convertRowIndexToModel((int)i)] = bl || object.isSelectedIndex(i);
        }
        this.layer.invalidate();
        this.layer.setVisible(n == 1 || !object.isSelectionEmpty());
    }

    private static final class LengthContentComparator
    implements Comparator<TrackLength>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LengthContentComparator() {
        }

        @Override
        public int compare(TrackLength trackLength, TrackLength trackLength2) {
            return Double.compare(trackLength.value, trackLength2.value);
        }
    }

    private static final class TrackLength {
        private final double value;

        TrackLength(double d) {
            this.value = d;
        }

        public String toString() {
            return SystemOfMeasurement.getSystemOfMeasurement().getDistText(this.value);
        }
    }
}

