/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.gui.layer.ImageProcessor;
import org.openstreetmap.josm.gui.layer.imagery.ColorfulFilter;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ColorfulImageProcessor
implements ImageProcessor,
SessionAwareReadApply {
    private ColorfulFilter op;
    private double colorfulness = 1.0;

    public double getColorfulness() {
        return this.colorfulness;
    }

    public void setColorfulness(double d) {
        this.colorfulness = d < 0.0 ? 0.0 : d;
        this.op = this.colorfulness < 0.95 || this.colorfulness > 1.05 ? new ColorfulFilter(this.colorfulness) : null;
    }

    @Override
    public BufferedImage process(BufferedImage bufferedImage) {
        if (this.op != null) {
            return this.op.filter(bufferedImage, null);
        }
        return bufferedImage;
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> map) {
        String string = map.get("colorfulness");
        if (string != null) {
            try {
                this.setColorfulness(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.trace(numberFormatException);
            }
        }
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        if (Utils.equalsEpsilon(this.colorfulness, 1.0)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("colorfulness", Double.toString(this.colorfulness));
    }

    public String toString() {
        return "ColorfulImageProcessor [colorfulness=" + this.colorfulness + ']';
    }
}

