/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class MapPaintStyleLoader
extends PleaseWaitRunnable {
    private boolean canceled;
    private final Collection<StyleSource> sources;

    public MapPaintStyleLoader(Collection<StyleSource> collection) {
        super(I18n.tr("Reloading style sources", new Object[0]));
        this.sources = collection;
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void finish() {
        MapPaintStyles.fireMapPaintSylesUpdated();
    }

    @Override
    protected void realRun() {
        ProgressMonitor progressMonitor = this.getProgressMonitor();
        progressMonitor.setTicksCount(this.sources.size());
        for (StyleSource styleSource : this.sources) {
            if (this.canceled) {
                return;
            }
            progressMonitor.subTask(I18n.tr("loading style ''{0}''...", styleSource.getDisplayString()));
            styleSource.loadStyleSource();
            progressMonitor.worked(1);
        }
    }

    public static void reloadStyles(int ... nArray) {
        ArrayList<StyleSource> arrayList = new ArrayList<StyleSource>();
        List<StyleSource> list = MapPaintStyles.getStyles().getStyleSources();
        for (int n : nArray) {
            arrayList.add(list.get(n));
        }
        MainApplication.worker.submit(new MapPaintStyleLoader(arrayList));
    }
}

