/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.BoxTextElement;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class MapImage {
    private static final int MAX_SIZE = 48;
    private BufferedImage img;
    public int alpha = 255;
    public String name;
    public StyleSource source;
    public boolean autoRescale;
    public int width = -1;
    public int height = -1;
    public int offsetX;
    public int offsetY;
    private boolean temporary;
    private BufferedImage disabledImgCache;

    public MapImage(String string, StyleSource styleSource) {
        this(string, styleSource, true);
    }

    public MapImage(String string, StyleSource styleSource, boolean bl) {
        this.name = string;
        this.source = styleSource;
        this.autoRescale = bl;
    }

    public BufferedImage getImage(boolean bl) {
        if (bl) {
            return this.getDisabled();
        }
        return this.getImage();
    }

    private BufferedImage getDisabled() {
        Image image;
        if (this.disabledImgCache != null) {
            return this.disabledImgCache;
        }
        if (this.img == null) {
            this.getImage();
        }
        if ((image = GuiHelper.getDisabledImage(this.img)) instanceof BufferedImage) {
            this.disabledImgCache = (BufferedImage)image;
        } else {
            this.disabledImgCache = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics graphics = this.disabledImgCache.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
        }
        return this.disabledImgCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.temporary = false;
        new ImageProvider(this.name).setDirs(MapPaintStyles.getIconSourceDirs(this.source)).setId("mappaint." + this.source.getPrefName()).setArchive(this.source.zipIcons).setInArchiveDir(this.source.getZipEntryDirName()).setWidth(this.width).setHeight(this.height).setOptional(true).getAsync().thenAccept(imageIcon -> {
            MapImage mapImage = this;
            synchronized (mapImage) {
                Serializable serializable;
                if (imageIcon == null) {
                    this.source.logWarning(I18n.tr("Failed to locate image ''{0}''", this.name));
                    serializable = MapPaintStyles.getNoIconIcon(this.source);
                    this.img = serializable == null ? null : (BufferedImage)((ImageIcon)serializable).getImage();
                } else {
                    this.img = (BufferedImage)this.rescale(imageIcon.getImage());
                }
                if (this.temporary) {
                    this.disabledImgCache = null;
                    serializable = MainApplication.getMap().mapView;
                    ((MapView)serializable).preferenceChanged(null);
                    ((MapView)serializable).repaint();
                }
                this.temporary = false;
            }
        });
        MapImage mapImage = this;
        synchronized (mapImage) {
            if (this.img == null) {
                this.img = (BufferedImage)ImageProvider.get("clock").getImage();
                this.temporary = true;
            }
        }
        return this.img;
    }

    public int getWidth() {
        return this.getImage().getWidth(null);
    }

    public int getHeight() {
        return this.getImage().getHeight(null);
    }

    public float getAlphaFloat() {
        return Utils.colorInt2float(this.alpha).floatValue();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public BoxTextElement.BoxProvider getBoxProvider() {
        return new MapImageBoxProvider();
    }

    private Image rescale(Image image) {
        if (image == null) {
            return null;
        }
        if (this.mustRescale(image)) {
            return ImageProvider.createBoundedImage(image, 16);
        }
        return image;
    }

    private boolean mustRescale(Image image) {
        return this.autoRescale && this.width == -1 && image.getWidth(null) > 48 && this.height == -1 && image.getHeight(null) > 48;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapImage mapImage = (MapImage)object;
        return this.alpha == mapImage.alpha && this.autoRescale == mapImage.autoRescale && this.width == mapImage.width && this.height == mapImage.height && Objects.equals(this.name, mapImage.name) && Objects.equals(this.source, mapImage.source);
    }

    public int hashCode() {
        return Objects.hash(this.alpha, this.name, this.source, this.autoRescale, this.width, this.height);
    }

    public String toString() {
        return this.name;
    }

    protected class MapImageBoxProvider
    implements BoxTextElement.BoxProvider {
        protected MapImageBoxProvider() {
        }

        @Override
        public BoxTextElement.BoxProviderResult get() {
            return new BoxTextElement.BoxProviderResult(this.box(), MapImage.this.temporary);
        }

        private Rectangle box() {
            int n = MapImage.this.getWidth();
            int n2 = MapImage.this.getHeight();
            if (MapImage.this.mustRescale(MapImage.this.getImage())) {
                n = 16;
                n2 = 16;
            }
            return new Rectangle(-n / 2, -n2 / 2, n, n2);
        }

        private MapImage getParent() {
            return MapImage.this;
        }

        public int hashCode() {
            return MapImage.this.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof BoxTextElement.BoxProvider)) {
                return false;
            }
            if (object instanceof MapImageBoxProvider) {
                MapImageBoxProvider mapImageBoxProvider = (MapImageBoxProvider)object;
                return MapImage.this.equals(mapImageBoxProvider.getParent());
            }
            if (MapImage.this.temporary) {
                return false;
            }
            BoxTextElement.BoxProvider boxProvider = (BoxTextElement.BoxProvider)object;
            BoxTextElement.BoxProviderResult boxProviderResult = boxProvider.get();
            if (boxProviderResult.isTemporary()) {
                return false;
            }
            return this.box().equals(boxProviderResult.getBox());
        }
    }
}

