/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public class CompletelyInsideAreaStrategy
implements PositionForAreaStrategy {
    public static final CompletelyInsideAreaStrategy INSTANCE = new CompletelyInsideAreaStrategy(0.0, 0.0);
    protected final double offsetX;
    protected final double offsetY;

    protected CompletelyInsideAreaStrategy(double d, double d2) {
        this.offsetX = d;
        this.offsetY = d2;
    }

    @Override
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath mapViewPath, Rectangle2D rectangle2D) {
        int n;
        int n2;
        double d;
        int n3;
        Rectangle rectangle = mapViewPath.getBounds();
        if ((double)rectangle.width < rectangle2D.getWidth() || (double)rectangle.height < rectangle2D.getHeight()) {
            return null;
        }
        double d2 = (double)rectangle.width - rectangle2D.getWidth();
        int n4 = rectangle.x + (int)(d2 / 2.0);
        Rectangle rectangle2 = new Rectangle(n4, n3 = rectangle.y + (int)((d = (double)rectangle.height - rectangle2D.getHeight()) / 2.0), n2 = (int)rectangle2D.getWidth(), n = (int)rectangle2D.getHeight());
        if (mapViewPath.contains(rectangle2)) {
            return this.centerOf(mapViewPath.getMapViewState(), rectangle2);
        }
        int n5 = rectangle.x + (int)(0.25 * d2);
        int n6 = rectangle.x + (int)(0.75 * d2);
        int n7 = rectangle.y + (int)(0.25 * d);
        int n8 = rectangle.y + (int)(0.75 * d);
        Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n4, n7, n2, n), new Rectangle(n6, n3, n2, n), new Rectangle(n4, n8, n2, n), new Rectangle(n5, n3, n2, n), new Rectangle(n5, n7, n2, n), new Rectangle(n6, n7, n2, n), new Rectangle(n6, n8, n2, n), new Rectangle(n5, n8, n2, n)};
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangle2 = rectangleArray[i];
            if (!mapViewPath.contains(rectangle2)) continue;
            return this.centerOf(mapViewPath.getMapViewState(), rectangle2);
        }
        return null;
    }

    private MapViewPositionAndRotation centerOf(MapViewState mapViewState, Rectangle rectangle) {
        double d = rectangle.getCenterX() + this.offsetX;
        double d2 = rectangle.getCenterY() + this.offsetY;
        return new MapViewPositionAndRotation(mapViewState.getForView(d, d2), 0.0);
    }

    @Override
    public boolean supportsGlyphVector() {
        return false;
    }

    @Override
    public PositionForAreaStrategy withAddedOffset(Point2D point2D) {
        if (Math.abs(point2D.getX()) < 1.0E-5 && Math.abs(point2D.getY()) < 1.0E-5) {
            return this;
        }
        return new CompletelyInsideAreaStrategy(this.offsetX + point2D.getX(), this.offsetY - point2D.getY());
    }

    public String toString() {
        return "CompletelyInsideAreaStrategy [offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + "]";
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.offsetX);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.offsetY);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CompletelyInsideAreaStrategy completelyInsideAreaStrategy = (CompletelyInsideAreaStrategy)object;
        return Double.doubleToLongBits(this.offsetX) == Double.doubleToLongBits(completelyInsideAreaStrategy.offsetX) && Double.doubleToLongBits(this.offsetY) == Double.doubleToLongBits(completelyInsideAreaStrategy.offsetY);
    }
}

