/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.gui.io.CustomConfigurator;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ExportProfileAction
extends AbstractAction {
    private final String prefPattern;
    private final String schemaKey;
    private final transient Preferences prefs;

    public ExportProfileAction(Preferences preferences, String string, String string2) {
        super(I18n.tr("Save {0} profile", I18n.tr(string, new Object[0])));
        this.prefs = preferences;
        this.prefPattern = string2;
        this.schemaKey = string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, Setting<?>> map = this.prefs.getAllSettings();
        for (String string : map.keySet()) {
            if (!string.matches(this.prefPattern)) continue;
            arrayList.add(string);
        }
        if (arrayList.isEmpty()) {
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("All the preferences of this group are default, nothing to save", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            }
            return;
        }
        File file = this.askUserForCustomSettingsFile();
        if (file != null) {
            CustomConfigurator.exportPreferencesKeysToFile(file.getAbsolutePath(), false, arrayList);
        }
    }

    private File askUserForCustomSettingsFile() {
        AbstractFileChooser abstractFileChooser;
        String string = I18n.tr("Choose profile file", new Object[0]);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || Utils.hasExtension(file, "xml") && file.getName().toLowerCase(Locale.ENGLISH).startsWith(ExportProfileAction.this.schemaKey);
            }

            @Override
            public String getDescription() {
                return I18n.tr("JOSM custom settings files (*.xml)", new Object[0]);
            }
        };
        if (!GraphicsEnvironment.isHeadless() && (abstractFileChooser = DiskAccessAction.createAndOpenFileChooser(false, false, string, fileFilter, 0, "customsettings.lastDirectory")) != null) {
            File file = abstractFileChooser.getSelectedFile();
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getAbsolutePath() + ".xml");
            }
            if (!file.getName().startsWith(this.schemaKey)) {
                file = new File(file.getParentFile().getAbsolutePath() + '/' + this.schemaKey + '_' + file.getName());
            }
            return file;
        }
        return null;
    }
}

