/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class LambertProjectionChoice
extends ListProjectionChoice {
    private static final String[] LAMBERT_4_ZONES = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, "51.30", "48.15"), I18n.tr("{0} ({1} to {2} degrees)", 2, "48.15", "45.45"), I18n.tr("{0} ({1} to {2} degrees)", 3, "45.45", "42.76"), I18n.tr("{0} (Corsica)", 4)};

    public LambertProjectionChoice() {
        super(I18n.tr("Lambert 4 Zones (France)", new Object[0]), "core:lambert", LAMBERT_4_ZONES, I18n.tr("Lambert CC Zone", new Object[0]));
    }

    @Override
    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new LambertCBPanel(this.entries, this.index, this.label, actionListener);
    }

    @Override
    public String getCurrentCode() {
        return "EPSG:" + Integer.toString(27561 + this.index);
    }

    @Override
    public String getProjectionName() {
        return I18n.tr("Lambert 4 Zones (France)", new Object[0]);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = "EPSG:" + (27561 + i);
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:2756") && string.length() == 10) {
            try {
                String string2 = string.substring(9);
                int n = Integer.parseInt(string2);
                if (n >= 1 && n <= 4) {
                    return Collections.singleton(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Logging.warn(numberFormatException);
            }
        }
        return null;
    }

    @Override
    protected String indexToZone(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    protected int zoneToIndex(String string) {
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.warn(numberFormatException);
            return this.defaultIndex;
        }
    }

    private static class LambertCBPanel
    extends ListProjectionChoice.CBPanel {
        LambertCBPanel(String[] stringArray, int n, String string, ActionListener actionListener) {
            super(stringArray, n, string, actionListener);
            this.add((Component)new JLabel(ImageProvider.get("data/projection", "Departements_Lambert4Zones")), GBC.eol().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
        }
    }
}

