/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetListener;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.KeyedItem;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public final class TaggingPresets {
    private static final Collection<TaggingPreset> taggingPresets = new ArrayList<TaggingPreset>();
    private static final MultiMap<String, String> PRESET_TAG_CACHE = new MultiMap();
    private static final Set<String> PRESET_ROLE_CACHE = new HashSet<String>();
    private static final Collection<TaggingPresetListener> listeners = new ArrayList<TaggingPresetListener>();

    private TaggingPresets() {
    }

    public static void readFromPreferences() {
        taggingPresets.clear();
        taggingPresets.addAll(TaggingPresetReader.readFromPreferences(false, false));
        TaggingPresets.cachePresets(taggingPresets);
    }

    public static void initialize() {
        TaggingPresets.readFromPreferences();
        for (TaggingPreset object : taggingPresets) {
            if (object instanceof TaggingPresetSeparator) continue;
            MainApplication.getToolbar().register(object);
        }
        if (taggingPresets.isEmpty()) {
            MainApplication.getMenu().presetsMenu.setVisible(false);
        } else {
            HashMap hashMap = new HashMap();
            for (TaggingPreset taggingPreset : taggingPresets) {
                JMenuItem jMenuItem;
                JMenu jMenu;
                JMenu jMenu2 = jMenu = taggingPreset.group != null ? (JMenu)hashMap.get(taggingPreset.group) : MainApplication.getMenu().presetsMenu;
                if (jMenu == null && taggingPreset.group != null) {
                    Logging.error("No tagging preset submenu for " + taggingPreset.group);
                    continue;
                }
                if (jMenu == null) {
                    Logging.error("No tagging preset menu. Tagging preset " + taggingPreset + " won't be available there");
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetSeparator) {
                    jMenu.add(new JSeparator());
                    continue;
                }
                if (taggingPreset instanceof TaggingPresetMenu) {
                    jMenuItem = new JMenu(taggingPreset);
                    jMenuItem.setText(taggingPreset.getLocaleName());
                    ((TaggingPresetMenu)taggingPreset).menu = jMenuItem;
                    hashMap.put((TaggingPresetMenu)taggingPreset, jMenuItem);
                    jMenu.add(jMenuItem);
                    continue;
                }
                jMenuItem = new JMenuItem(taggingPreset);
                jMenuItem.setText(taggingPreset.getLocaleName());
                jMenu.add(jMenuItem);
            }
            for (JMenu jMenu : hashMap.values()) {
                if (jMenu.getItemCount() < Main.pref.getInteger("taggingpreset.min-elements-for-scroller", 15)) continue;
                MenuScroller.setScrollerFor(jMenu);
            }
        }
        if (Main.pref.getBoolean("taggingpreset.sortmenu")) {
            TaggingPresetMenu.sortMenu(MainApplication.getMenu().presetsMenu);
        }
    }

    public static void cachePresets(Collection<TaggingPreset> collection) {
        for (TaggingPreset taggingPreset : collection) {
            for (TaggingPresetItem taggingPresetItem : taggingPreset.data) {
                TaggingPresets.cachePresetItem(taggingPreset, taggingPresetItem);
            }
        }
    }

    private static void cachePresetItem(TaggingPreset taggingPreset, TaggingPresetItem taggingPresetItem) {
        block6: {
            block5: {
                if (!(taggingPresetItem instanceof KeyedItem)) break block5;
                KeyedItem keyedItem = (KeyedItem)taggingPresetItem;
                if (keyedItem.key == null || keyedItem.getValues() == null) break block6;
                PRESET_TAG_CACHE.putAll(keyedItem.key, keyedItem.getValues());
                break block6;
            }
            if (taggingPresetItem instanceof Roles) {
                Roles roles = (Roles)taggingPresetItem;
                for (Roles.Role role : roles.roles) {
                    if (role.key == null) continue;
                    PRESET_ROLE_CACHE.add(role.key);
                }
            } else if (taggingPresetItem instanceof CheckGroup) {
                for (KeyedItem keyedItem : ((CheckGroup)taggingPresetItem).checks) {
                    TaggingPresets.cachePresetItem(taggingPreset, keyedItem);
                }
            }
        }
    }

    public static Collection<TaggingPreset> getTaggingPresets() {
        return Collections.unmodifiableCollection(taggingPresets);
    }

    public static Set<String> getPresetRoles() {
        return Collections.unmodifiableSet(PRESET_ROLE_CACHE);
    }

    public static Set<String> getPresetKeys() {
        return Collections.unmodifiableSet(PRESET_TAG_CACHE.keySet());
    }

    public static Set<String> getPresetValues(String string) {
        Set<String> set = PRESET_TAG_CACHE.get(string);
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    public static Collection<TaggingPreset> getMatchingPresets(Collection<TaggingPresetType> collection, Map<String, String> map, boolean bl) {
        return SubclassFilteredCollection.filter(TaggingPresets.getTaggingPresets(), taggingPreset -> taggingPreset.matches(collection, map, bl));
    }

    public static Collection<TaggingPreset> getMatchingPresets(OsmPrimitive osmPrimitive) {
        return SubclassFilteredCollection.filter(TaggingPresets.getTaggingPresets(), taggingPreset -> taggingPreset.test(osmPrimitive));
    }

    public static void addTaggingPresets(Collection<TaggingPreset> collection) {
        if (collection != null && taggingPresets.addAll(collection)) {
            for (TaggingPresetListener taggingPresetListener : listeners) {
                taggingPresetListener.taggingPresetsModified();
            }
        }
    }

    public static void addListener(TaggingPresetListener taggingPresetListener) {
        if (taggingPresetListener != null) {
            listeners.add(taggingPresetListener);
        }
    }

    public static void removeListener(TaggingPresetListener taggingPresetListener) {
        if (taggingPresetListener != null) {
            listeners.remove(taggingPresetListener);
        }
    }
}

