/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class DisableShortcutsOnFocusGainedTextField
extends JosmTextField {
    private final transient List<Pair<Action, Shortcut>> unregisteredActionShortcuts = new ArrayList<Pair<Action, Shortcut>>();
    private final Set<JosmAction> disabledMenuActions = new HashSet<JosmAction>();

    public DisableShortcutsOnFocusGainedTextField() {
    }

    public DisableShortcutsOnFocusGainedTextField(String string) {
        super(string);
    }

    public DisableShortcutsOnFocusGainedTextField(int n) {
        super(n);
    }

    public DisableShortcutsOnFocusGainedTextField(String string, int n) {
        super(string, n);
    }

    public DisableShortcutsOnFocusGainedTextField(Document document, String string, int n) {
        super(document, string, n);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.disableMenuActions();
        this.unregisterActionShortcuts();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.restoreActionShortcuts();
        this.restoreMenuActions();
    }

    protected void disableMenuActions() {
        this.disabledMenuActions.clear();
        for (int i = 0; i < MainApplication.getMenu().getMenuCount(); ++i) {
            JMenu jMenu = MainApplication.getMenu().getMenu(i);
            if (jMenu == null) continue;
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                KeyStroke keyStroke;
                Shortcut shortcut;
                Action action;
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof JosmAction) || !action.isEnabled() || (shortcut = ((JosmAction)action).getShortcut()) == null || !this.hasToBeDisabled(keyStroke = shortcut.getKeyStroke())) continue;
                action.setEnabled(false);
                this.disabledMenuActions.add((JosmAction)action);
            }
        }
    }

    protected void unregisterActionShortcuts() {
        this.unregisteredActionShortcuts.clear();
        for (Shortcut shortcut : Shortcut.listAll()) {
            Action action;
            KeyStroke keyStroke = shortcut.getKeyStroke();
            if (!this.hasToBeDisabled(keyStroke) || (action = MainApplication.getRegisteredActionShortcut(shortcut)) == null) continue;
            MainApplication.unregisterActionShortcut(action, shortcut);
            this.unregisteredActionShortcuts.add(new Pair<Action, Shortcut>(action, shortcut));
        }
    }

    protected boolean hasToBeDisabled(KeyStroke keyStroke) {
        return keyStroke != null && keyStroke.getModifiers() == 0 && !new KeyEvent(this, 401, 0L, keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar()).isActionKey();
    }

    protected void restoreMenuActions() {
        for (JosmAction josmAction : this.disabledMenuActions) {
            josmAction.setEnabled(true);
        }
        this.disabledMenuActions.clear();
    }

    protected void restoreActionShortcuts() {
        for (Pair<Action, Shortcut> pair : this.unregisteredActionShortcuts) {
            MainApplication.registerActionShortcut((Action)pair.a, (Shortcut)pair.b);
        }
        this.unregisteredActionShortcuts.clear();
    }
}

