/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class OsmServerReader
extends OsmConnection {
    private final OsmApi api = OsmApi.getOsmApi();
    private boolean doAuthenticate;
    protected boolean gpxParsedProperly;

    public OsmServerReader() {
        try {
            this.doAuthenticate = OsmApi.isUsingOAuth() && CredentialsManager.getInstance().lookupOAuthAccessToken() != null;
        }
        catch (CredentialsAgentException credentialsAgentException) {
            Logging.warn(credentialsAgentException);
        }
    }

    protected InputStream getInputStream(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStream(string, progressMonitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(String string, ProgressMonitor progressMonitor, String string2) throws OsmTransferException {
        try {
            this.api.initialize(progressMonitor);
            String string3 = string.startsWith("http") ? string : this.getBaseUrl() + string;
            InputStream inputStream = this.getInputStreamRaw(string3, progressMonitor, string2);
            return inputStream;
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    protected String getBaseUrl() {
        return this.api.getBaseUrl();
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getInputStreamRaw(string, progressMonitor, null);
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor, String string2) throws OsmTransferException {
        return this.getInputStreamRaw(string, progressMonitor, string2, false);
    }

    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor, String string2, boolean bl) throws OsmTransferException {
        return this.getInputStreamRaw(string, progressMonitor, string2, bl, "GET", null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream getInputStreamRaw(String string, ProgressMonitor progressMonitor, String string2, boolean bl, String string3, byte[] byArray) throws OsmTransferException {
        HttpClient.Response response;
        HttpClient httpClient;
        URL uRL;
        block19: {
            OnlineResource.JOSM_WEBSITE.checkOfflineAccess(string, Main.getJOSMWebsite());
            OnlineResource.OSM_API.checkOfflineAccess(string, OsmApi.getOsmApi().getServerUrl());
            uRL = null;
            try {
                uRL = new URL(string.replace(" ", "%20"));
            }
            catch (MalformedURLException malformedURLException) {
                throw new OsmTransferException(malformedURLException);
            }
            if ("file".equals(uRL.getProtocol())) {
                try {
                    InputStream inputStream = uRL.openStream();
                    return inputStream;
                }
                catch (IOException iOException) {
                    throw new OsmTransferException(iOException);
                }
            }
            this.activeConnection = httpClient = HttpClient.create(uRL, string3).setFinishOnCloseOutput(false).setReasonForRequest(string2).setOutputMessage(I18n.tr("Downloading data...", new Object[0])).setRequestBody(byArray);
            this.adaptRequest(httpClient);
            if (!this.doAuthenticate) break block19;
            this.addAuth(httpClient);
        }
        if (this.cancel) {
            throw new OsmTransferCanceledException("Operation canceled");
        }
        try {
            response = httpClient.connect(progressMonitor);
        }
        catch (IOException iOException) {
            Logging.error(iOException);
            OsmTransferException osmTransferException = new OsmTransferException(I18n.tr("Could not connect to the OSM server. Please check your internet connection.", new Object[0]), iOException);
            osmTransferException.setUrl(uRL.toString());
            throw osmTransferException;
        }
        try {
            if (response.getResponseCode() == 401) {
                throw new OsmApiException(401, null, null);
            }
            if (response.getResponseCode() == 407) {
                throw new OsmTransferCanceledException("Proxy Authentication Required");
            }
            if (response.getResponseCode() != 200) {
                String string4 = response.getHeaderField("Error");
                String string5 = OsmServerReader.fetchResponseText(response);
                throw new OsmApiException(response.getResponseCode(), string4, string5, uRL.toString());
            }
            response.uncompressAccordingToContentDisposition(bl);
            return response.getContent();
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
            catch (IOException iOException) {
                throw new OsmTransferException(iOException);
            }
        }
        finally {
            progressMonitor.invalidate();
        }
    }

    private static String fetchResponseText(HttpClient.Response response) {
        try {
            return response.fetchContent();
        }
        catch (IOException iOException) {
            Logging.error(iOException);
            return I18n.tr("Reading error text failed.", new Object[0]);
        }
    }

    protected void adaptRequest(HttpClient httpClient) {
    }

    public abstract DataSet parseOsm(ProgressMonitor var1) throws OsmTransferException;

    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChangeBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmChangeGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public GpxData parseRawGpsBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public DataSet parseOsmZip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public boolean isDoAuthenticate() {
        return this.doAuthenticate;
    }

    public void setDoAuthenticate(boolean bl) {
        this.doAuthenticate = bl;
    }

    public final boolean isGpxParsedProperly() {
        return this.gpxParsedProperly;
    }

    public List<Note> parseNotes(int n, int n2, ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotes(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public List<Note> parseRawNotesBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    protected static String getAttribute(Node node, String string) {
        return node.getAttributes().getNamedItem(string).getNodeValue();
    }

    /*
     * Exception decompiling
     */
    public <T> T fetchData(String var1_1, String var2_2, DomParser<T> var3_3, ProgressMonitor var4_4, String var5_5) throws OsmTransferException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    protected static interface DomParser<R> {
        public R parse(Document var1) throws XmlParsingException;
    }
}

