/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class LoadAndZoomHandler
extends RequestHandler {
    public static final String command = "load_and_zoom";
    public static final String command2 = "zoom";
    private double minlat;
    private double maxlat;
    private double minlon;
    private double maxlon;
    private final Set<SimplePrimitiveId> toSelect = new HashSet<SimplePrimitiveId>();

    @Override
    public String getPermissionMessage() {
        String string = I18n.tr("Remote Control has been asked to load data from the API.", new Object[0]) + "<br>" + I18n.tr("Bounding box: ", new Object[0]) + new BBox(this.minlon, this.minlat, this.maxlon, this.maxlat).toStringCSV(", ");
        if (this.args.containsKey("select") && !this.toSelect.isEmpty()) {
            string = string + "<br>" + I18n.tr("Selection: {0}", this.toSelect.size());
        }
        return string;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"bottom", "top", "left", "right"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "layer_name", "addtags", "select", "zoom_mode", "changeset_comment", "changeset_source", "search"};
    }

    @Override
    public String getUsage() {
        return "download a bounding box from the API, zoom to the downloaded area and optionally select one or more objects";
    }

    @Override
    public String[] getUsageExamples() {
        return this.getUsageExamples(this.myCommand);
    }

    @Override
    public String[] getUsageExamples(String string) {
        if (command.equals(string)) {
            return new String[]{"/load_and_zoom?addtags=wikipedia:de=Wei%C3%9Fe_Gasse|maxspeed=5&select=way23071688,way23076176,way23076177,&left=13.740&right=13.741&top=51.05&bottom=51.049", "/load_and_zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&select=node413602999&new_layer=true"};
        }
        return new String[]{"/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&select=node413602999", "/zoom?left=8.19&right=8.20&top=48.605&bottom=48.590&search=highway+OR+railway"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        Object object;
        Object object2;
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask(){
            {
                this.newLayerName = (String)LoadAndZoomHandler.this.args.get("layer_name");
            }
        };
        try {
            boolean bl = this.isLoadInNewLayer();
            if (command.equals(this.myCommand)) {
                if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
                    Logging.info("RemoteControl: download forbidden by preferences");
                } else {
                    object2 = null;
                    if (!bl) {
                        object = null;
                        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
                        if (dataSet != null) {
                            object = dataSet.getDataSourceArea();
                        }
                        if (object != null && !((Area)object).isEmpty()) {
                            object2 = new Area(new Rectangle2D.Double(this.minlon, this.minlat, this.maxlon - this.minlon, this.maxlat - this.minlat));
                            ((Area)object2).subtract((Area)object);
                            if (!((Area)object2).isEmpty()) {
                                Rectangle2D rectangle2D = ((Area)object2).getBounds2D();
                                this.minlat = rectangle2D.getMinY();
                                this.minlon = rectangle2D.getMinX();
                                this.maxlat = rectangle2D.getMaxY();
                                this.maxlon = rectangle2D.getMaxX();
                            }
                        }
                    }
                    if (object2 != null && ((Area)object2).isEmpty()) {
                        Logging.info("RemoteControl: no download necessary");
                    } else {
                        object = downloadOsmTask.download(bl, new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon), null);
                        MainApplication.worker.submit(new PostDownloadHandler(downloadOsmTask, (Future<?>)object));
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            Logging.warn("RemoteControl: Error parsing load_and_zoom remote control request:");
            Logging.error(runtimeException);
            throw new RequestHandler.RequestHandlerErrorException(runtimeException);
        }
        if (this.args.containsKey("addtags")) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
                if (dataSet == null) {
                    return;
                }
                dataSet.clearSelection();
            });
        }
        HashSet hashSet = new HashSet();
        object2 = new Bounds(this.minlat, this.minlon, this.maxlat, this.maxlon);
        if (this.args.containsKey("select") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            GuiHelper.executeByMainWorkerInEDT(() -> this.lambda$handleRequest$1(hashSet, (Bounds)object2));
        } else if (this.args.containsKey("search") && PermissionPrefWithDefault.CHANGE_SELECTION.isAllowed()) {
            try {
                object = SearchCompiler.compile((String)this.args.get("search"));
                MainApplication.worker.submit(() -> this.lambda$handleRequest$2((SearchCompiler.Match)object, hashSet, (Bounds)object2));
            }
            catch (SearchParseError searchParseError) {
                Logging.error(searchParseError);
                throw new RequestHandler.RequestHandlerErrorException(searchParseError);
            }
        } else {
            this.zoom(Collections.emptySet(), (Bounds)object2);
        }
        if (this.args.containsKey("changeset_comment") || this.args.containsKey("changeset_source")) {
            MainApplication.worker.submit(() -> {
                if (MainApplication.getLayerManager().getEditDataSet() != null) {
                    if (this.args.containsKey("changeset_comment")) {
                        MainApplication.getLayerManager().getEditDataSet().addChangeSetTag("comment", (String)this.args.get("changeset_comment"));
                    }
                    if (this.args.containsKey("changeset_source")) {
                        MainApplication.getLayerManager().getEditDataSet().addChangeSetTag("source", (String)this.args.get("changeset_source"));
                    }
                }
            });
        }
        AddTagsDialog.addTags(this.args, this.sender, hashSet);
    }

    protected void zoom(Collection<OsmPrimitive> collection, Bounds bounds) {
        if (!PermissionPrefWithDefault.CHANGE_VIEWPORT.isAllowed()) {
            return;
        }
        if (!"download".equals(this.args.get("zoom_mode")) && !collection.isEmpty()) {
            AutoScaleAction.autoScale("selection");
        } else if (MainApplication.isDisplayingMapView()) {
            GuiHelper.executeByMainWorkerInEDT(() -> {
                BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                boundingXYVisitor.visit(bounds);
                MainApplication.getMap().mapView.zoomTo(boundingXYVisitor);
            });
        }
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return null;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.minlat = 0.0;
        this.maxlat = 0.0;
        this.minlon = 0.0;
        this.maxlon = 0.0;
        try {
            this.minlat = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("bottom") : ""));
            this.maxlat = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("top") : ""));
            this.minlon = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("left") : ""));
            this.maxlon = LatLon.roundToOsmPrecision(Double.parseDouble(this.args != null ? (String)this.args.get("right") : ""));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException (" + numberFormatException.getMessage() + ')', numberFormatException);
        }
        if (!LatLon.isValidLat(this.minlat) || !LatLon.isValidLat(this.maxlat)) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The latitudes must be between {0} and {1}", -90.0, 90.0));
        }
        if (!LatLon.isValidLon(this.minlon) || !LatLon.isValidLon(this.maxlon)) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The longitudes must be between {0} and {1}", -180.0, 180.0));
        }
        if (this.minlat > this.maxlat || this.minlon > this.maxlon) {
            throw new RequestHandler.RequestHandlerBadRequestException(I18n.tr("The minima must be less than the maxima", new Object[0]));
        }
        if (this.args != null && this.args.containsKey("select")) {
            this.toSelect.clear();
            for (String string : ((String)this.args.get("select")).split(",")) {
                if (string.isEmpty()) continue;
                try {
                    this.toSelect.add(SimplePrimitiveId.fromString(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logging.log(Logging.LEVEL_WARN, "RemoteControl: invalid selection '" + string + "' ignored", illegalArgumentException);
                }
            }
        }
    }

    private /* synthetic */ void lambda$handleRequest$2(SearchCompiler.Match match, Collection collection, Bounds bounds) {
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        SubclassFilteredCollection<OsmPrimitive, OsmPrimitive> subclassFilteredCollection = SubclassFilteredCollection.filter(dataSet.allPrimitives(), match);
        dataSet.setSelected(subclassFilteredCollection);
        collection.addAll(subclassFilteredCollection);
        this.zoom(subclassFilteredCollection, bounds);
    }

    private /* synthetic */ void lambda$handleRequest$1(Collection collection, Bounds bounds) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        DataSet dataSet = MainApplication.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return;
        }
        for (SimplePrimitiveId simplePrimitiveId : this.toSelect) {
            OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(simplePrimitiveId);
            if (osmPrimitive == null) continue;
            hashSet.add(osmPrimitive);
            collection.add(osmPrimitive);
        }
        this.toSelect.clear();
        dataSet.setSelected(hashSet);
        this.zoom(hashSet, bounds);
        MapFrame mapFrame = MainApplication.getMap();
        if (MainApplication.isDisplayingMapView() && mapFrame.relationListDialog != null) {
            mapFrame.relationListDialog.selectRelations(null);
            mapFrame.relationListDialog.dataChanged(null);
            mapFrame.relationListDialog.selectRelations(Utils.filteredCollection(hashSet, Relation.class));
        }
    }
}

