/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.Logging;
import org.w3c.dom.Element;

public class GeoImageSessionExporter
extends AbstractSessionExporter<GeoImageLayer> {
    public GeoImageSessionExporter(GeoImageLayer geoImageLayer) {
        super(geoImageLayer);
    }

    @Override
    public Collection<Layer> getDependencies() {
        if (((GeoImageLayer)this.layer).getGpxLayer() != null) {
            return Collections.singleton(((GeoImageLayer)this.layer).getGpxLayer());
        }
        return Collections.emptySet();
    }

    @Override
    public Component getExportPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel jLabel = new JLabel(((GeoImageLayer)this.layer).getName(), ((GeoImageLayer)this.layer).getIcon(), 2);
        jLabel.setToolTipText(((GeoImageLayer)this.layer).getToolTipText());
        jLabel.setLabelFor(this.export);
        jPanel.add((Component)this.export, GBC.std());
        jPanel.add((Component)jLabel, GBC.std());
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        return jPanel;
    }

    @Override
    public Element export(SessionWriter.ExportSupport exportSupport) throws IOException {
        Element element = exportSupport.createElement("layer");
        element.setAttribute("type", "geoimage");
        element.setAttribute("version", "0.1");
        GeoImageSessionExporter.addAttr("show-thumbnails", Boolean.toString(((GeoImageLayer)this.layer).isUseThumbs()), element, exportSupport);
        for (ImageEntry imageEntry : ((GeoImageLayer)this.layer).getImages()) {
            Element element2;
            Element element3 = exportSupport.createElement("geoimage");
            if (imageEntry.getFile() == null) {
                Logging.warn("No file attribute for image - skipping entry");
                break;
            }
            GeoImageSessionExporter.addAttr("file", imageEntry.getFile().getPath(), element3, exportSupport);
            GeoImageSessionExporter.addAttr("thumbnail", Boolean.toString(imageEntry.hasThumbnail()), element3, exportSupport);
            if (imageEntry.getPos() != null) {
                element2 = exportSupport.createElement("position");
                element2.setAttribute("lat", Double.toString(imageEntry.getPos().lat()));
                element2.setAttribute("lon", Double.toString(imageEntry.getPos().lon()));
                element3.appendChild(element2);
            }
            if (imageEntry.getSpeed() != null) {
                GeoImageSessionExporter.addAttr("speed", imageEntry.getSpeed().toString(), element3, exportSupport);
            }
            if (imageEntry.getElevation() != null) {
                GeoImageSessionExporter.addAttr("elevation", imageEntry.getElevation().toString(), element3, exportSupport);
            }
            if (imageEntry.hasGpsTime()) {
                GeoImageSessionExporter.addAttr("gps-time", Long.toString(imageEntry.getGpsTime().getTime()), element3, exportSupport);
            }
            if (imageEntry.getExifOrientation() != null) {
                GeoImageSessionExporter.addAttr("exif-orientation", Integer.toString(imageEntry.getExifOrientation()), element3, exportSupport);
            }
            if (imageEntry.hasExifTime()) {
                GeoImageSessionExporter.addAttr("exif-time", Long.toString(imageEntry.getExifTime().getTime()), element3, exportSupport);
            }
            if (imageEntry.hasExifGpsTime()) {
                GeoImageSessionExporter.addAttr("exif-gps-time", Long.toString(imageEntry.getExifGpsTime().getTime()), element3, exportSupport);
            }
            if (imageEntry.getExifCoor() != null) {
                element2 = exportSupport.createElement("exif-coordinates");
                element2.setAttribute("lat", Double.toString(imageEntry.getExifCoor().lat()));
                element2.setAttribute("lon", Double.toString(imageEntry.getExifCoor().lon()));
                element3.appendChild(element2);
            }
            if (imageEntry.getExifImgDir() != null) {
                GeoImageSessionExporter.addAttr("exif-image-direction", imageEntry.getExifImgDir().toString(), element3, exportSupport);
            }
            if (imageEntry.hasNewGpsData()) {
                GeoImageSessionExporter.addAttr("is-new-gps-data", Boolean.toString(imageEntry.hasNewGpsData()), element3, exportSupport);
            }
            element.appendChild(element3);
        }
        return element;
    }

    private static void addAttr(String string, String string2, Element element, SessionWriter.ExportSupport exportSupport) {
        Element element2 = exportSupport.createElement(string);
        element2.appendChild(exportSupport.createTextNode(string2));
        element.appendChild(element2);
    }
}

