/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImagerySessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element element, SessionReader.ImportSupport importSupport, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        ImageryFilterSettings imageryFilterSettings;
        String string = element.getAttribute("version");
        if (!"0.1".equals(string)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for imagery layer is not supported. Expected: 0.1", string));
        }
        Map<String, String> map = ImagerySessionImporter.readProperties(element);
        ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = Preferences.deserializeStruct(map, ImageryInfo.ImageryPreferenceEntry.class);
        ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
        ImageryLayer imageryLayer = ImageryLayer.create(imageryInfo);
        Utils.instanceOfThen(imageryLayer, AbstractTileSourceLayer.class, abstractTileSourceLayer -> {
            Object object;
            abstractTileSourceLayer.getDisplaySettings().applyFromPropertiesMap(map);
            if (!abstractTileSourceLayer.getDisplaySettings().isAutoZoom() && (object = (String)map.get("zoom-level")) != null) {
                importSupport.addPostLayersTask(() -> ImagerySessionImporter.lambda$null$0(abstractTileSourceLayer, (String)object));
            }
            if ((object = ImagerySessionImporter.getFirstElementByTagName(element, "offset")) != null) {
                Map<String, String> map2 = ImagerySessionImporter.readProperties((Element)object);
                OffsetBookmark offsetBookmark = OffsetBookmark.fromPropertiesMap(map2);
                abstractTileSourceLayer.getDisplaySettings().setOffsetBookmark(offsetBookmark);
            }
        });
        Element element2 = ImagerySessionImporter.getFirstElementByTagName(element, "filters");
        if (element2 != null && (imageryFilterSettings = imageryLayer.getFilterSettings()) != null) {
            Map<String, String> map2 = ImagerySessionImporter.readProperties(element2);
            imageryFilterSettings.getProcessors().stream().flatMap(Utils.castToStream(SessionAwareReadApply.class)).forEach(sessionAwareReadApply -> sessionAwareReadApply.applyFromPropertiesMap(map2));
        }
        return imageryLayer;
    }

    private static Element getFirstElementByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    private static Map<String, String> readProperties(Element element) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || node.getChildNodes().getLength() > 1) continue;
            Element element2 = (Element)node;
            hashMap.put(element2.getTagName(), element2.getTextContent());
        }
        return hashMap;
    }

    private static /* synthetic */ void lambda$null$0(AbstractTileSourceLayer abstractTileSourceLayer, String string) {
        try {
            abstractTileSourceLayer.setZoomLevel(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            Logging.warn(numberFormatException);
        }
    }
}

