/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;

public final class GeoUrlToBounds {
    public static final Pattern PATTERN = Pattern.compile("geo:(?<lat>[+-]?[0-9.]+),(?<lon>[+-]?[0-9.]+)(\\?z=(?<zoom>[0-9]+))?");

    private GeoUrlToBounds() {
    }

    public static Bounds parse(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        Matcher matcher = PATTERN.matcher(string);
        if (matcher.matches()) {
            int n;
            double d;
            double d2;
            try {
                d2 = Double.parseDouble(matcher.group("lat"));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("latitude", new Object[0])), numberFormatException);
                return null;
            }
            try {
                d = Double.parseDouble(matcher.group("lon"));
            }
            catch (NumberFormatException numberFormatException) {
                Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("longitude", new Object[0])), numberFormatException);
                return null;
            }
            try {
                n = matcher.group("zoom") != null ? Integer.parseInt(matcher.group("zoom")) : 18;
            }
            catch (NumberFormatException numberFormatException) {
                Logging.warn(I18n.tr("URL does not contain valid {0}", I18n.tr("zoom", new Object[0])), numberFormatException);
                return null;
            }
            return OsmUrlToBounds.positionToBounds(d2, d, n);
        }
        return null;
    }
}

