/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;

public final class OpenBrowser {
    private OpenBrowser() {
    }

    private static void displayUrlFallback(URI uRI) throws IOException {
        if (Main.platform == null) {
            throw new IllegalStateException(I18n.tr("Failed to open URL. There is currently no platform set. Please set a platform first.", new Object[0]));
        }
        Main.platform.openUrl(uRI.toString());
    }

    public static String displayUrl(URI uRI) {
        CheckParameterUtil.ensureParameterNotNull(uRI, "uri");
        Logging.info(I18n.tr("Opening URL: {0}", uRI));
        if (Desktop.isDesktopSupported()) {
            try {
                if (Main.isPlatformWindows()) {
                    Desktop.getDesktop().browse(uRI);
                }
                if (Main.platform instanceof PlatformHookUnixoid || Main.platform instanceof PlatformHookOsx) {
                    Main.platform.openUrl(uRI.toString());
                }
                try {
                    Desktop.getDesktop().browse(uRI);
                }
                catch (IOException iOException) {
                    Logging.log(Logging.LEVEL_WARN, "Desktop class failed. Platform dependent fall back for open url in browser.", iOException);
                    OpenBrowser.displayUrlFallback(uRI);
                }
            }
            catch (IOException iOException) {
                Logging.warn(iOException);
                return iOException.getMessage();
            }
        } else {
            try {
                Logging.warn("Desktop class is not supported. Platform dependent fall back for open url in browser.");
                OpenBrowser.displayUrlFallback(uRI);
            }
            catch (IOException iOException) {
                Logging.debug(iOException);
                return iOException.getMessage();
            }
        }
        return null;
    }

    public static String displayUrl(String string) {
        try {
            return OpenBrowser.displayUrl(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.debug(uRISyntaxException);
            return uRISyntaxException.getMessage();
        }
    }
}

