/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public interface PlatformHook {
    default public void preStartupHook() {
    }

    default public void afterPrefStartupHook() {
    }

    default public void startupHook(JavaExpirationCallback javaExpirationCallback) {
    }

    public void openUrl(String var1) throws IOException;

    public void initSystemShortcuts();

    default public String makeTooltip(String string, Shortcut shortcut) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>").append(string);
        if (shortcut != null && !shortcut.getKeyText().isEmpty()) {
            stringBuilder.append(" <font size='-2'>(").append(shortcut.getKeyText()).append(")</font>");
        }
        return stringBuilder.append("&nbsp;</html>").toString();
    }

    public String getDefaultStyle();

    default public boolean canFullscreen() {
        return !GraphicsEnvironment.isHeadless() && GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
    }

    default public boolean rename(File file, File file2) {
        return file.renameTo(file2);
    }

    public String getOSDescription();

    default public String getOSBuildNumber() {
        return "";
    }

    default public boolean setupHttpsCertificate(String string, KeyStore.TrustedCertificateEntry trustedCertificateEntry) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return false;
    }

    default public X509Certificate getX509Certificate(CertificateAmendment.CertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return null;
    }

    default public String exec(String ... stringArray) throws IOException {
        Process process = Runtime.getRuntime().exec(stringArray);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String string = Utils.strip(bufferedReader.readLine());
            return string;
        }
    }

    public File getDefaultCacheDirectory();

    public File getDefaultPrefDirectory();

    public File getDefaultUserDataDirectory();

    public List<File> getDefaultProj4NadshiftDirectories();

    default public boolean isOpenJDK() {
        String string = System.getProperty("java.home");
        return string != null && string.contains("openjdk");
    }

    default public void checkExpiredJava(JavaExpirationCallback javaExpirationCallback) {
        Date date = Utils.getJavaExpirationDate();
        if (date != null && date.before(new Date())) {
            String string = Utils.getJavaLatestVersion();
            javaExpirationCallback.askUpdateJava(string != null ? string : "latest", Main.pref.get("java.update.url", "https://www.java.com/download"), DateUtils.getDateFormat(2).format(date), false);
        }
    }

    default public void setNativeOsCallback(NativeOsCallback nativeOsCallback) {
    }

    public static interface NativeOsCallback {
        public void openFiles(List<File> var1);

        public boolean handleQuitRequest();

        public void handleAbout();

        public void handlePreferences();
    }

    @FunctionalInterface
    public static interface JavaExpirationCallback {
        public void askUpdateJava(String var1, String var2, String var3, boolean var4);
    }
}

