/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.impl.CoreProgressManager");
    final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    private static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    private static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    private static volatile boolean shouldCheckCanceled;
    private static final Collection<ProgressIndicator> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture == null) {
            this.myCheckCancelledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        this.indicatorCanceled(indicator);
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook = ourCheckCanceledHook;
        return hook != null && hook.runHook(indicator);
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        if (!shouldCheckCanceled) {
            return;
        }
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null && ENABLED) {
            progress.checkCanceled();
        } else {
            CoreProgressManager.runCheckCanceledHooks(progress);
        }
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/impl/CoreProgressManager", "executeNonCancelableSection"));
        }
        if (this.isInNonCancelableSection()) {
            runnable.run();
        } else {
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                this.executeProcessUnderProgress(runnable, NonCancelableIndicator.INSTANCE);
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        block12: {
            boolean modal;
            if (process2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "executeProcessUnderProgress"));
            }
            boolean bl = modal = progress != null && progress.isModal();
            if (modal) {
                this.myCurrentModalProgressCount.incrementAndGet();
            }
            if (progress == null) {
                this.myCurrentUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set;
                ProgressIndicator oldIndicator = null;
                boolean bl2 = set = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set) {
                    Thread currentThread = Thread.currentThread();
                    CoreProgressManager.setCurrentIndicator(currentThread, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
                        break block12;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(currentThread, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress == null) {
                    this.myCurrentUnsafeProgressCount.decrementAndGet();
                }
                if (modal) {
                    this.myCurrentModalProgressCount.decrementAndGet();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/CoreProgressManager", "registerIndicatorAndRun"));
        }
        ArrayList<Set<Thread>> threadsUnderThisIndicator = new ArrayList<Set<Thread>>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Set<Thread> underIndicator = threadsUnderIndicator.get(thisIndicator);
                if (underIndicator == null) {
                    underIndicator = new SmartHashSet<Thread>();
                    threadsUnderIndicator.put(thisIndicator, underIndicator);
                }
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                if (thisIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                } else {
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateShouldCheckCanceled();
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard;
                    boolean removed2;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed2 = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed2 && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if (!(isStandard = thisIndicator2 instanceof StandardProgressIndicator)) {
                        nonStandardIndicators.remove(thisIndicator2);
                        if (nonStandardIndicators.isEmpty()) {
                            this.stopBackgroundNonStandardIndicatorsPing();
                        }
                    }
                    if (oldIndicator != null && oldIndicator.isCanceled()) {
                        threadsUnderCanceledIndicator.add(currentThread);
                        continue;
                    }
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                this.updateShouldCheckCanceled();
            }
            throw throwable;
        }
        synchronized (map2) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean isStandard;
                boolean removed3;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed3 = underIndicator != null && underIndicator.remove(currentThread);
                if (removed3 && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (!(isStandard = thisIndicator instanceof StandardProgressIndicator)) {
                    nonStandardIndicators.remove(thisIndicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.stopBackgroundNonStandardIndicatorsPing();
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                    continue;
                }
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateShouldCheckCanceled() {
        ourCheckCanceledHook = this.createCheckCanceledHook();
        if (ourCheckCanceledHook != null) {
            shouldCheckCanceled = true;
            return;
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            shouldCheckCanceled = !threadsUnderCanceledIndicator.isEmpty();
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager", "indicatorCanceled"));
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread2 : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread2);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread2);
                    shouldCheckCanceled = true;
                }
            }
        }
    }

    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    private static void setCurrentIndicator(@NotNull Thread currentThread, ProgressIndicator indicator) {
        if (currentThread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentThread", "com/intellij/openapi/progress/impl/CoreProgressManager", "setCurrentIndicator"));
        }
        long id = currentThread.getId();
        if (indicator == null) {
            currentIndicators.remove(id);
            threadTopLevelIndicators.remove(id);
        } else {
            currentIndicators.put(id, indicator);
            if (!threadTopLevelIndicators.containsKey(id)) {
                threadTopLevelIndicators.put(id, indicator);
            }
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread2) {
        if (thread2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/openapi/progress/impl/CoreProgressManager", "getCurrentIndicator"));
        }
        return currentIndicators.get(thread2.getId());
    }

    static {
        threadsUnderIndicator = new THashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new THashSet<Thread>();
        nonStandardIndicators = ConcurrentHashMultiset.create();
        isInNonCancelableSection = new ThreadLocal();
    }

    @FunctionalInterface
    protected static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }
}

