/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCodeErrorReporter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "Companion", "kotlin-compiler"})
public final class JsCallChecker
implements CallChecker {
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private static final DescriptorPredicate JS_PATTERN;
    public static final Companion Companion;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (context.isAnnotationContext() || !Companion.isJsCall(resolvedCall2)) {
            return;
        }
        KtElement expression2 = resolvedCall2.getCall().getCallElement();
        if (!(expression2 instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression2).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list2 = arguments2;
        if (list2 == null || (list2 = CollectionsKt.firstOrNull(list2)) == null || (list2 = ((KtValueArgument)((Object)list2)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument = list2;
        TemporaryBindingTrace trace = TemporaryBindingTrace.create(context.getTrace(), "JsCallChecker");
        List<KtValueArgument> list3 = argument;
        Intrinsics.checkExpressionValueIsNotNull(list3, "argument");
        TemporaryBindingTrace temporaryBindingTrace = trace;
        Intrinsics.checkExpressionValueIsNotNull(temporaryBindingTrace, "trace");
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)list3), temporaryBindingTrace, TypeUtils.NO_EXPECTED_TYPE);
        String code = Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument))));
            return;
        }
        trace.commit();
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter((KtExpression)((Object)argument), code, context.getTrace());
        try {
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram()), "<js fun>");
            ErrorReporter errorReporter2 = errorReporter;
            JsScope jsScope = parserScope;
            Object object = reportOn.getContainingFile();
            if (object == null || (object = object.getName()) == null) {
                object = "<unknown file>";
            }
            List<JsStatement> statements = ParserUtilsKt.parse(code, errorReporter2, jsScope, (String)object);
            if (statements == null || statements.isEmpty()) {
                context.getTrace().report(ErrorsJs.JSCODE_NO_JAVASCRIPT_PRODUCED.on((KtExpression)((PsiElement)((Object)argument))));
            }
        }
        catch (AbortParsingException abortParsingException) {
            // empty catch block
        }
        context.getTrace().record(BindingContextSlicesJsKt.LEXICAL_SCOPE_FOR_JS, resolvedCall2, context.getScope());
    }

    public JsCallChecker(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    static {
        Companion = new Companion(null);
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern("kotlin.js.js(String)");
        Intrinsics.checkExpressionValueIsNotNull(descriptorPredicate, "PatternBuilder.pattern(\"kotlin.js.js(String)\")");
        JS_PATTERN = descriptorPredicate;
    }

    @JvmStatic
    public static final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Companion.isJsCall($receiver);
    }

    @JvmStatic
    @Nullable
    public static final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
        return Companion.extractStringValue(compileTimeConstant);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0007J\u001e\u0010\u000b\u001a\u00020\f\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker$Companion;", "", "()V", "JS_PATTERN", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "getJS_PATTERN", "()Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "extractStringValue", "", "compileTimeConstant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "isJsCall", "", "F", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlin-compiler"})
    public static final class Companion {
        private final DescriptorPredicate getJS_PATTERN() {
            return JS_PATTERN;
        }

        @JvmStatic
        public final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
            F descriptor2 = $receiver.getResultingDescriptor();
            return descriptor2 instanceof SimpleFunctionDescriptor && this.getJS_PATTERN().test(descriptor2);
        }

        @JvmStatic
        @Nullable
        public final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (!(compileTimeConstant2 instanceof TypedCompileTimeConstant)) {
                compileTimeConstant2 = null;
            }
            TypedCompileTimeConstant typedCompileTimeConstant = (TypedCompileTimeConstant)compileTimeConstant2;
            ConstantValue constantValue = typedCompileTimeConstant != null ? typedCompileTimeConstant.getConstantValue() : null;
            if (!(constantValue instanceof StringValue)) {
                constantValue = null;
            }
            StringValue stringValue = (StringValue)constantValue;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

