/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.math.BigInteger;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractIBANCheckFilter
extends RuleFilter {
    protected abstract String getLengthMessage(int var1);

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, AnalyzedTokenReadings[] patternTokens) {
        String iban = args.get("iban");
        if (iban == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i <= 6; ++i) {
                String part = args.get("part" + i);
                if (part == null) {
                    throw new IllegalArgumentException("Missing key 'iban' or 'part1' to 'part6'");
                }
                sb.append(part);
            }
            iban = sb.toString();
        }
        if (iban.length() == 22) {
            return this.validIBAN(iban) ? null : match;
        }
        return new RuleMatch(match.getRule(), match.getFromPos(), match.getToPos(), this.getLengthMessage(iban.length()), match.getShortMessage());
    }

    boolean validIBAN(String iban) {
        String clean = iban.replace(" ", "");
        String reordered = clean.substring(4) + clean.substring(0, 2) + "00";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 21; ++i) {
            char ch = reordered.charAt(i);
            if (Character.isDigit(ch)) {
                sb.append(String.valueOf(ch));
                continue;
            }
            sb.append(reordered.charAt(i) - 55);
        }
        BigInteger sum = new BigInteger(sb.toString());
        int checksum = 98 - sum.mod(new BigInteger("97")).intValueExact();
        return String.valueOf(checksum).equals(iban.substring(2, 4));
    }
}

