/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationHelper;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.UsernamePasswordAuthenticationCredentials;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.NodeSelectDialog;
import org.zaproxy.zap.view.popup.PopupMenuItemContext;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContextMenuFactory;

public class FormBasedAuthenticationMethodType
extends AuthenticationMethodType {
    public static final String CONTEXT_CONFIG_AUTH_FORM = "context.authentication.form";
    public static final String CONTEXT_CONFIG_AUTH_FORM_LOGINURL = "context.authentication.form.loginurl";
    public static final String CONTEXT_CONFIG_AUTH_FORM_LOGINBODY = "context.authentication.form.loginbody";
    private static final int METHOD_IDENTIFIER = 2;
    private static final String METHOD_NAME = Constant.messages.getString("authentication.method.fb.name");
    private static final String API_METHOD_NAME = "formBasedAuthentication";
    private static final Logger log = Logger.getLogger(FormBasedAuthenticationMethodType.class);
    private static final String PARAM_LOGIN_URL = "loginUrl";
    private static final String PARAM_LOGIN_REQUEST_DATA = "loginRequestData";

    @Override
    public FormBasedAuthenticationMethod createAuthenticationMethod(int n) {
        return new FormBasedAuthenticationMethod();
    }

    @Override
    public String getName() {
        return METHOD_NAME;
    }

    @Override
    public AbstractAuthenticationMethodOptionsPanel buildOptionsPanel(Context context) {
        return new FormBasedAuthenticationMethodOptionsPanel(context);
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials authenticationCredentials, Context context) {
        return new UsernamePasswordAuthenticationCredentials.UsernamePasswordAuthenticationCredentialsOptionsPanel((UsernamePasswordAuthenticationCredentials)authenticationCredentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public boolean isTypeForMethod(AuthenticationMethod authenticationMethod) {
        return authenticationMethod instanceof FormBasedAuthenticationMethod;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoginRequestMenuFactory());
    }

    private PopupMenuItemSiteNodeContextMenuFactory getPopupFlagLoginRequestMenuFactory() {
        PopupMenuItemSiteNodeContextMenuFactory popupMenuItemSiteNodeContextMenuFactory = new PopupMenuItemSiteNodeContextMenuFactory(Constant.messages.getString("context.flag.popup")){
            private static final long serialVersionUID = 8927418764L;

            @Override
            public PopupMenuItemContext getContextMenu(Context context, String string) {
                return new PopupMenuItemContext(context, string, MessageFormat.format(Constant.messages.getString("authentication.method.fb.popup.login.request"), context.getName())){
                    private static final long serialVersionUID = 1967885623005183801L;
                    private ExtensionUserManagement usersExtension;
                    private Context uiSharedContext;

                    private boolean confirmUsersDeletion(Context context) {
                        int n;
                        this.usersExtension = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                        return this.usersExtension == null || this.usersExtension.getSharedContextUsers(context).size() <= 0 || (n = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2)) != 2;
                    }

                    @Override
                    public void performAction(SiteNode siteNode) {
                        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
                        sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
                        this.uiSharedContext = sessionDialog.getUISharedContext(this.getContext().getIndex());
                        if (this.getContext().getAuthenticationMethod() instanceof FormBasedAuthenticationMethod) {
                            log.info((Object)("Selected new login request via PopupMenu. Changing existing Form-Based Authentication instance for Context " + this.getContext().getIndex()));
                            FormBasedAuthenticationMethod formBasedAuthenticationMethod = (FormBasedAuthenticationMethod)this.uiSharedContext.getAuthenticationMethod();
                            try {
                                formBasedAuthenticationMethod.setLoginRequest(siteNode);
                            }
                            catch (Exception exception) {
                                log.error((Object)("Failed to set login request: " + exception.getMessage()), (Throwable)exception);
                                return;
                            }
                            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.getContext().getIndex()), false);
                        } else {
                            log.info((Object)("Selected new login request via PopupMenu. Creating new Form-Based Authentication instance for Context " + this.getContext().getIndex()));
                            FormBasedAuthenticationMethod formBasedAuthenticationMethod = new FormBasedAuthenticationMethod();
                            try {
                                formBasedAuthenticationMethod.setLoginRequest(siteNode);
                            }
                            catch (Exception exception) {
                                log.error((Object)("Failed to set login request: " + exception.getMessage()), (Throwable)exception);
                                return;
                            }
                            if (!this.confirmUsersDeletion(this.uiSharedContext)) {
                                log.debug((Object)"Cancelled change of authentication type.");
                                return;
                            }
                            this.uiSharedContext.setAuthenticationMethod(formBasedAuthenticationMethod);
                            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.getContext().getIndex()), false, new Runnable(){

                                @Override
                                public void run() {
                                    if (usersExtension != null) {
                                        usersExtension.removeSharedContextUsers(uiSharedContext);
                                    }
                                }
                            });
                        }
                    }
                };
            }

            @Override
            public int getParentMenuIndex() {
                return 3;
            }
        };
        return popupMenuItemSiteNodeContextMenuFactory;
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int n) throws DatabaseException {
        FormBasedAuthenticationMethod formBasedAuthenticationMethod = new FormBasedAuthenticationMethod();
        List<String> list = session.getContextDataStrings(n, 201);
        String string = "";
        if (list != null && list.size() > 0) {
            string = list.get(0);
        }
        List<String> list2 = session.getContextDataStrings(n, 202);
        String string2 = null;
        if (list2 != null && list2.size() > 0) {
            string2 = list2.get(0);
        }
        try {
            formBasedAuthenticationMethod.setLoginRequest(string, string2);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to load FormBasedAuthenticationMethod. ", (Throwable)exception);
        }
        return formBasedAuthenticationMethod;
    }

    @Override
    public void persistMethodToSession(Session session, int n, AuthenticationMethod authenticationMethod) throws DatabaseException {
        if (!(authenticationMethod instanceof FormBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Form based authentication type only supports: " + FormBasedAuthenticationMethod.class);
        }
        FormBasedAuthenticationMethod formBasedAuthenticationMethod = (FormBasedAuthenticationMethod)authenticationMethod;
        session.setContextData(n, 201, formBasedAuthenticationMethod.loginRequestURL);
        session.setContextData(n, 202, formBasedAuthenticationMethod.loginRequestBody);
    }

    @Override
    public int getUniqueIdentifier() {
        return 2;
    }

    @Override
    public UsernamePasswordAuthenticationCredentials createAuthenticationCredentials() {
        return new UsernamePasswordAuthenticationCredentials();
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        return new ApiDynamicActionImplementor(API_METHOD_NAME, new String[]{PARAM_LOGIN_URL}, new String[]{PARAM_LOGIN_REQUEST_DATA}){

            @Override
            public void handleAction(JSONObject jSONObject) throws ApiException {
                Context context = ApiUtils.getContextByParamId(jSONObject, "contextId");
                String string = ApiUtils.getNonEmptyStringParam(jSONObject, FormBasedAuthenticationMethodType.PARAM_LOGIN_URL);
                try {
                    new URL(string);
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, FormBasedAuthenticationMethodType.PARAM_LOGIN_URL);
                }
                String string2 = "";
                if (jSONObject.containsKey((Object)FormBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA)) {
                    string2 = jSONObject.getString(FormBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA);
                }
                FormBasedAuthenticationMethod formBasedAuthenticationMethod = FormBasedAuthenticationMethodType.this.createAuthenticationMethod(context.getIndex());
                try {
                    formBasedAuthenticationMethod.setLoginRequest(string, string2);
                }
                catch (Exception exception) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, exception.getMessage());
                }
                if (!context.getAuthenticationMethod().isSameType(formBasedAuthenticationMethod)) {
                    AuthenticationMethodType.apiChangedAuthenticationMethodForContext(context.getIndex());
                }
                context.setAuthenticationMethod(formBasedAuthenticationMethod);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return UsernamePasswordAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration configuration, AuthenticationMethod authenticationMethod) {
        if (!(authenticationMethod instanceof FormBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Form based authentication type only supports: " + FormBasedAuthenticationMethod.class.getName());
        }
        FormBasedAuthenticationMethod formBasedAuthenticationMethod = (FormBasedAuthenticationMethod)authenticationMethod;
        configuration.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINURL, (Object)formBasedAuthenticationMethod.loginRequestURL);
        configuration.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINBODY, (Object)formBasedAuthenticationMethod.loginRequestBody);
    }

    @Override
    public void importData(Configuration configuration, AuthenticationMethod authenticationMethod) throws ConfigurationException {
        if (!(authenticationMethod instanceof FormBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Form based authentication type only supports: " + FormBasedAuthenticationMethod.class.getName());
        }
        FormBasedAuthenticationMethod formBasedAuthenticationMethod = (FormBasedAuthenticationMethod)authenticationMethod;
        try {
            formBasedAuthenticationMethod.setLoginRequest(configuration.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINURL), configuration.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINBODY));
        }
        catch (Exception exception) {
            throw new ConfigurationException((Throwable)exception);
        }
    }

    private static class HtmlParameterRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);

        private HtmlParameterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                this.setBorder(BORDER);
                HtmlParameter htmlParameter = (HtmlParameter)object;
                this.setText(htmlParameter.getName());
            }
            return this;
        }
    }

    private static class FormBasedAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = -9010956260384814566L;
        private static final String POST_DATA_LABEL = Constant.messages.getString("authentication.method.fb.field.label.postData");
        private static final String USERNAME_PARAM_LABEL = Constant.messages.getString("authentication.method.fb.field.label.usernameParam");
        private static final String PASSWORD_PARAM_LABEL = Constant.messages.getString("authentication.method.fb.field.label.passwordParam");
        private static final String LOGIN_URL_LABEL = Constant.messages.getString("authentication.method.fb.field.label.loginUrl");
        private static final String AUTH_DESCRIPTION = Constant.messages.getString("authentication.method.fb.field.label.description");
        private ZapTextField loginUrlField;
        private ZapTextField postDataField;
        private JComboBox<HtmlParameter> usernameParameterCombo;
        private JComboBox<HtmlParameter> passwordParameterCombo;
        private FormBasedAuthenticationMethod authenticationMethod;
        private Context context;
        private ExtensionUserManagement userExt = null;

        public FormBasedAuthenticationMethodOptionsPanel(Context context) {
            this.initialize();
            this.context = context;
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(LOGIN_URL_LABEL), LayoutHelper.getGBC(0, 0, 2, 1.0, 0.0));
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.loginUrlField = new ZapTextField();
            this.postDataField = new ZapTextField();
            JButton jButton = new JButton(Constant.messages.getString("all.button.select"));
            jButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NodeSelectDialog nodeSelectDialog = new NodeSelectDialog((Window)View.getSingleton().getMainFrame());
                    SiteNode siteNode = null;
                    if (FormBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText().trim().length() > 0) {
                        try {
                            siteNode = FormBasedAuthenticationMethodOptionsPanel.this.postDataField.getText().trim().length() > 0 ? Model.getSingleton().getSession().getSiteTree().findNode(new URI(FormBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText(), false), "POST", FormBasedAuthenticationMethodOptionsPanel.this.postDataField.getText()) : Model.getSingleton().getSession().getSiteTree().findNode(new URI(FormBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText(), false));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((siteNode = nodeSelectDialog.showDialog(siteNode)) != null && siteNode.getHistoryReference() != null) {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Selected Form Based Auth Login URL via dialog: " + siteNode.getHistoryReference().getURI().toString()));
                            }
                            FormBasedAuthenticationMethodOptionsPanel.this.loginUrlField.setText(siteNode.getHistoryReference().getURI().toString());
                            FormBasedAuthenticationMethodOptionsPanel.this.postDataField.setText(siteNode.getHistoryReference().getHttpMessage().getRequestBody().toString());
                            FormBasedAuthenticationMethodOptionsPanel.this.updateParameters();
                        }
                        catch (Exception exception) {
                            log.error((Object)exception.getMessage(), (Throwable)exception);
                        }
                    }
                }
            });
            jPanel.add((Component)this.loginUrlField, LayoutHelper.getGBC(0, 0, 1, 1.0));
            jPanel.add((Component)jButton, LayoutHelper.getGBC(1, 0, 1, 0.0));
            this.add((Component)jPanel, LayoutHelper.getGBC(0, 1, 2, 1.0, 0.0));
            this.add((Component)new JLabel(POST_DATA_LABEL), LayoutHelper.getGBC(0, 2, 2, 1.0, 0.0));
            this.add((Component)this.postDataField, LayoutHelper.getGBC(0, 3, 2, 1.0, 0.0));
            this.add((Component)new JLabel(USERNAME_PARAM_LABEL), LayoutHelper.getGBC(0, 4, 1, 1.0, 0.0));
            this.usernameParameterCombo = new JComboBox();
            this.usernameParameterCombo.setRenderer(new HtmlParameterRenderer());
            this.add(this.usernameParameterCombo, LayoutHelper.getGBC(0, 5, 1, 1.0, 0.0));
            this.add((Component)new JLabel(PASSWORD_PARAM_LABEL), LayoutHelper.getGBC(1, 4, 1, 1.0, 0.0));
            this.passwordParameterCombo = new JComboBox();
            this.passwordParameterCombo.setRenderer(new HtmlParameterRenderer());
            this.add(this.passwordParameterCombo, LayoutHelper.getGBC(1, 5, 1, 1.0, 0.0));
            this.add((Component)new JLabel(AUTH_DESCRIPTION), LayoutHelper.getGBC(0, 8, 2, 1.0, 0.0));
            this.postDataField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    FormBasedAuthenticationMethodOptionsPanel.this.updateParameters();
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }
            });
        }

        @Override
        public void validateFields() {
            try {
                new URL(this.loginUrlField.getText());
            }
            catch (Exception exception) {
                this.loginUrlField.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.fb.dialog.error.url.text"));
            }
        }

        private String replaceParameterValue(String string, HtmlParameter htmlParameter, String string2) {
            String string3 = this.context.getPostParamParser().getDefaultKeyValueSeparator();
            String string4 = htmlParameter.getName() + string3;
            if (string.contains(string4)) {
                return string.replace(string4 + htmlParameter.getValue(), string4 + string2);
            }
            return string.replace(htmlParameter.getName(), string4 + string2);
        }

        private ExtensionUserManagement getUserExt() {
            if (this.userExt == null) {
                this.userExt = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
            }
            return this.userExt;
        }

        @Override
        public void saveMethod() {
            try {
                String string = this.postDataField.getText();
                if (!string.isEmpty()) {
                    HtmlParameter htmlParameter = (HtmlParameter)this.usernameParameterCombo.getSelectedItem();
                    HtmlParameter htmlParameter2 = (HtmlParameter)this.passwordParameterCombo.getSelectedItem();
                    ExtensionUserManagement extensionUserManagement = this.getUserExt();
                    if (extensionUserManagement != null && extensionUserManagement.getUIConfiguredUsers(this.context.getIndex()).size() == 0 && !htmlParameter.getValue().contains("{%username%}") && !htmlParameter2.getValue().contains("{%password%}")) {
                        String string2 = URLDecoder.decode(htmlParameter.getValue(), "UTF8");
                        String string3 = URLDecoder.decode(htmlParameter2.getValue(), "UTF8");
                        User user = new User(this.context.getIndex(), string2);
                        UsernamePasswordAuthenticationCredentials usernamePasswordAuthenticationCredentials = new UsernamePasswordAuthenticationCredentials(string2, string3);
                        user.setAuthenticationCredentials(usernamePasswordAuthenticationCredentials);
                        this.getUserExt().getContextUserAuthManager(this.context.getIndex()).addUser(user);
                    }
                    string = this.replaceParameterValue(string, htmlParameter, "{%username%}");
                    string = this.replaceParameterValue(string, htmlParameter2, "{%password%}");
                }
                this.getMethod().setLoginRequest(this.loginUrlField.getText(), string);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }

        @Override
        public void bindMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = (FormBasedAuthenticationMethod)authenticationMethod;
            this.loginUrlField.setText(this.authenticationMethod.loginRequestURL);
            this.postDataField.setText(this.authenticationMethod.loginRequestBody);
            this.updateParameters();
        }

        private int getIndexOfParamWithValue(HtmlParameter[] htmlParameterArray, String string) {
            for (int i = 0; i < htmlParameterArray.length; ++i) {
                if (!htmlParameterArray[i].getValue().equals(string)) continue;
                return i;
            }
            return -1;
        }

        private void updateParameters() {
            try {
                Map<String, String> map = this.context.getPostParamParser().parse(this.postDataField.getText());
                HtmlParameter[] htmlParameterArray = this.mapToParamArray(map);
                this.usernameParameterCombo.setModel(new DefaultComboBoxModel<HtmlParameter>(htmlParameterArray));
                this.passwordParameterCombo.setModel(new DefaultComboBoxModel<HtmlParameter>(htmlParameterArray));
                int n = this.getIndexOfParamWithValue(htmlParameterArray, "{%username%}");
                if (n >= 0) {
                    this.usernameParameterCombo.setSelectedIndex(n);
                }
                if ((n = this.getIndexOfParamWithValue(htmlParameterArray, "{%password%}")) >= 0) {
                    this.passwordParameterCombo.setSelectedIndex(n);
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }

        private HtmlParameter[] mapToParamArray(Map<String, String> map) {
            HtmlParameter[] htmlParameterArray = new HtmlParameter[map.size()];
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                htmlParameterArray[n++] = new HtmlParameter(HtmlParameter.Type.form, entry.getKey(), entry.getValue());
            }
            return htmlParameterArray;
        }

        @Override
        public FormBasedAuthenticationMethod getMethod() {
            return this.authenticationMethod;
        }
    }

    public static class FormBasedAuthenticationMethod
    extends AuthenticationMethod {
        private static final String ENCODING = "UTF-8";
        private static final String LOGIN_ICON_RESOURCE = "/resource/icon/fugue/door-open-green-arrow.png";
        public static final String MSG_USER_PATTERN = "{%username%}";
        public static final String MSG_PASS_PATTERN = "{%password%}";
        private HttpSender httpSender;
        private SiteNode markedLoginSiteNode;
        private SiteNode loginSiteNode = null;
        private String loginRequestURL;
        private String loginRequestBody;

        @Override
        public boolean isConfigured() {
            return this.loginRequestURL != null && !this.loginRequestURL.isEmpty();
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new UsernamePasswordAuthenticationCredentials();
        }

        @Override
        public AuthenticationMethodType getType() {
            return new FormBasedAuthenticationMethodType();
        }

        protected HttpSender getHttpSender() {
            if (this.httpSender == null) {
                this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 5);
            }
            return this.httpSender;
        }

        private HttpMessage prepareRequestMessage(UsernamePasswordAuthenticationCredentials usernamePasswordAuthenticationCredentials) throws URIException, HttpMalformedHeaderException, DatabaseException {
            HttpMessage httpMessage;
            String string = this.loginRequestURL.replace(MSG_USER_PATTERN, FormBasedAuthenticationMethod.encodeParameter(usernamePasswordAuthenticationCredentials.getUsername()));
            string = string.replace(MSG_PASS_PATTERN, FormBasedAuthenticationMethod.encodeParameter(usernamePasswordAuthenticationCredentials.getPassword()));
            URI uRI = new URI(string, false);
            String string2 = null;
            if (this.loginRequestBody != null && !this.loginRequestBody.isEmpty()) {
                string2 = this.loginRequestBody.replace(MSG_USER_PATTERN, FormBasedAuthenticationMethod.encodeParameter(usernamePasswordAuthenticationCredentials.getUsername()));
                string2 = string2.replace(MSG_PASS_PATTERN, FormBasedAuthenticationMethod.encodeParameter(usernamePasswordAuthenticationCredentials.getPassword()));
            }
            if (this.loginSiteNode != null) {
                httpMessage = this.loginSiteNode.getHistoryReference().getHttpMessage().cloneRequest();
                httpMessage.getRequestHeader().setURI(uRI);
                if (string2 != null) {
                    httpMessage.getRequestBody().setBody(string2);
                    httpMessage.getRequestHeader().setHeader("Content-Length", null);
                }
            } else {
                String string3 = string2 != null ? "POST" : "GET";
                httpMessage = new HttpMessage();
                httpMessage.setRequestHeader(new HttpRequestHeader(string3, uRI, "HTTP/1.0", Model.getSingleton().getOptionsParam().getConnectionParam()));
                if (string2 != null) {
                    httpMessage.getRequestBody().setBody(string2);
                }
            }
            return httpMessage;
        }

        private static String encodeParameter(String string) {
            try {
                return URLEncoder.encode(string, ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return "";
            }
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials authenticationCredentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            HttpMessage httpMessage;
            if (!(authenticationCredentials instanceof UsernamePasswordAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Form based authentication method only supports " + UsernamePasswordAuthenticationCredentials.class.getSimpleName() + ". Received: " + authenticationCredentials.getClass());
            }
            UsernamePasswordAuthenticationCredentials usernamePasswordAuthenticationCredentials = (UsernamePasswordAuthenticationCredentials)authenticationCredentials;
            if (!usernamePasswordAuthenticationCredentials.isConfigured()) {
                log.warn((Object)("No credentials to authenticate user: " + user.getName()));
                return null;
            }
            try {
                httpMessage = this.prepareRequestMessage(usernamePasswordAuthenticationCredentials);
            }
            catch (Exception exception) {
                log.error((Object)("Unable to prepare authentication message: " + exception.getMessage()), (Throwable)exception);
                return null;
            }
            if (user.getAuthenticatedSession() == null) {
                user.setAuthenticatedSession(sessionManagementMethod.createEmptyWebSession());
            }
            httpMessage.setRequestingUser(user);
            httpMessage.getRequestHeader().setHeader("Cookie", null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authentication request header: \n" + httpMessage.getRequestHeader()));
                if (!httpMessage.getRequestHeader().getMethod().equals("GET")) {
                    log.debug((Object)("Authentication request body: \n" + httpMessage.getRequestBody()));
                }
            }
            try {
                this.getHttpSender().sendAndReceive(httpMessage);
            }
            catch (IOException iOException) {
                log.error((Object)("Unable to send authentication message: " + iOException.getMessage()));
                return null;
            }
            if (this.isAuthenticated(httpMessage)) {
                AuthenticationHelper.notifyOutputAuthSuccessful(httpMessage);
            } else {
                AuthenticationHelper.notifyOutputAuthFailure(httpMessage);
            }
            AuthenticationHelper.addAuthMessageToHistory(httpMessage);
            return sessionManagementMethod.extractWebSession(httpMessage);
        }

        public void setLoginRequest(SiteNode siteNode) throws Exception {
            this.loginSiteNode = siteNode;
            HttpMessage httpMessage = siteNode.getHistoryReference().getHttpMessage();
            this.loginRequestURL = httpMessage.getRequestHeader().getURI().toString();
            this.loginRequestBody = !httpMessage.getRequestHeader().getMethod().equalsIgnoreCase("GET") ? httpMessage.getRequestBody().toString() : null;
        }

        public String getLoginRequestURL() {
            return this.loginRequestURL;
        }

        private void markLoginSiteNode(SiteNode siteNode) {
            if (this.markedLoginSiteNode == siteNode) {
                return;
            }
            if (this.markedLoginSiteNode != null) {
                this.markedLoginSiteNode.removeCustomIcon(LOGIN_ICON_RESOURCE);
            }
            this.markedLoginSiteNode = siteNode;
            if (siteNode == null) {
                return;
            }
            siteNode.addCustomIcon(LOGIN_ICON_RESOURCE, false);
        }

        protected void setLoginRequest(String string, String string2) throws Exception {
            if (string == null || string.length() == 0) {
                this.loginRequestURL = null;
                this.loginRequestBody = null;
                this.loginSiteNode = null;
            } else {
                String string3 = "GET";
                if (string2 != null && string2.length() > 0) {
                    string3 = "POST";
                }
                URI uRI = new URI(string, true);
                this.loginRequestURL = string;
                this.loginRequestBody = string2;
                this.loginSiteNode = Model.getSingleton().getSession().getSiteTree().findNode(uRI, string3, string2);
            }
        }

        public String toString() {
            return "FormBasedAuthenticationMethod [loginURI=" + this.loginRequestURL + "]";
        }

        @Override
        public FormBasedAuthenticationMethod duplicate() {
            FormBasedAuthenticationMethod formBasedAuthenticationMethod = new FormBasedAuthenticationMethod();
            formBasedAuthenticationMethod.loginRequestURL = this.loginRequestURL;
            formBasedAuthenticationMethod.loginRequestBody = this.loginRequestBody;
            formBasedAuthenticationMethod.loginSiteNode = this.loginSiteNode;
            formBasedAuthenticationMethod.markedLoginSiteNode = this.markedLoginSiteNode;
            return formBasedAuthenticationMethod;
        }

        @Override
        public void onMethodPersisted() {
            this.markLoginSiteNode(this.loginSiteNode);
        }

        @Override
        public void onMethodDiscarded() {
            this.markLoginSiteNode(null);
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("methodName", FormBasedAuthenticationMethodType.API_METHOD_NAME);
            hashMap.put(FormBasedAuthenticationMethodType.PARAM_LOGIN_URL, this.loginRequestURL);
            hashMap.put(FormBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA, this.loginRequestBody);
            return new ApiResponseSet("method", hashMap);
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.loginRequestBody == null ? 0 : this.loginRequestBody.hashCode());
            n = 31 * n + (this.loginRequestURL == null ? 0 : this.loginRequestURL.hashCode());
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FormBasedAuthenticationMethod formBasedAuthenticationMethod = (FormBasedAuthenticationMethod)object;
            if (this.loginRequestBody == null ? formBasedAuthenticationMethod.loginRequestBody != null : !this.loginRequestBody.equals(formBasedAuthenticationMethod.loginRequestBody)) {
                return false;
            }
            return !(this.loginRequestURL == null ? formBasedAuthenticationMethod.loginRequestURL != null : !this.loginRequestURL.equals(formBasedAuthenticationMethod.loginRequestURL));
        }
    }
}

