/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httpsessions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.Cookie;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;
import org.zaproxy.zap.extension.httpsessions.HttpSessionsSite;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.Pair;
import org.zaproxy.zap.utils.XMLStringUtil;

public class HttpSessionsAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(HttpSessionsAPI.class);
    private static final String PREFIX = "httpSessions";
    private static final String ACTION_CREATE_EMPTY_SESSION = "createEmptySession";
    private static final String ACTION_REMOVE_SESSION = "removeSession";
    private static final String ACTION_SET_ACTIVE_SESSION = "setActiveSession";
    private static final String ACTION_ADD_SESSION_TOKEN = "addSessionToken";
    private static final String ACTION_REMOVE_SESSION_TOKEN = "removeSessionToken";
    private static final String ACTION_UNSET_ACTIVE_SESSION = "unsetActiveSession";
    private static final String ACTION_SET_SESSION_TOKEN = "setSessionTokenValue";
    private static final String ACTION_RENAME_SESSION = "renameSession";
    private static final String ACTION_PARAM_SITE = "site";
    private static final String ACTION_PARAM_SESSION = "session";
    private static final String ACTION_PARAM_SESSION_OLD_NAME = "oldSessionName";
    private static final String ACTION_PARAM_SESSION_NEW_NAME = "newSessionName";
    private static final String ACTION_PARAM_TOKEN_NAME = "sessionToken";
    private static final String ACTION_PARAM_TOKEN_VALUE = "tokenValue";
    private static final String VIEW_SITES = "sites";
    private static final String VIEW_SESSIONS = "sessions";
    private static final String VIEW_ACTIVE_SESSION = "activeSession";
    private static final String VIEW_SESSION_TOKENS = "sessionTokens";
    private static final String VIEW_PARAM_SITE = "site";
    private static final String VIEW_PARAM_SESSION = "session";
    private ExtensionHttpSessions extension;

    public HttpSessionsAPI(ExtensionHttpSessions extensionHttpSessions) {
        this.extension = extensionHttpSessions;
        this.addApiAction(new ApiAction(ACTION_CREATE_EMPTY_SESSION, new String[]{"site"}, new String[]{"session"}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SESSION, new String[]{"site", "session"}));
        this.addApiAction(new ApiAction(ACTION_SET_ACTIVE_SESSION, new String[]{"site", "session"}));
        this.addApiAction(new ApiAction(ACTION_UNSET_ACTIVE_SESSION, new String[]{"site"}));
        this.addApiAction(new ApiAction(ACTION_ADD_SESSION_TOKEN, new String[]{"site", ACTION_PARAM_TOKEN_NAME}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SESSION_TOKEN, new String[]{"site", ACTION_PARAM_TOKEN_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SESSION_TOKEN, new String[]{"site", "session", ACTION_PARAM_TOKEN_NAME, ACTION_PARAM_TOKEN_VALUE}));
        this.addApiAction(new ApiAction(ACTION_RENAME_SESSION, new String[]{"site", ACTION_PARAM_SESSION_OLD_NAME, ACTION_PARAM_SESSION_NEW_NAME}));
        this.addApiView(new ApiView(VIEW_SITES));
        this.addApiView(new ApiView(VIEW_SESSIONS, new String[]{"site"}, new String[]{"session"}));
        this.addApiView(new ApiView(VIEW_ACTIVE_SESSION, new String[]{"site"}));
        this.addApiView(new ApiView(VIEW_SESSION_TOKENS, new String[]{"site"}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for handleApiAction: " + string + " (params: " + jSONObject.toString() + ")"));
        }
        switch (string) {
            case "createEmptySession": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), true);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                String string2 = this.getParam(jSONObject, "session", "");
                if ("".equals(string2)) {
                    httpSessionsSite.createEmptySession();
                } else {
                    httpSessionsSite.createEmptySession(string2);
                }
                return ApiResponseElement.OK;
            }
            case "removeSession": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                HttpSession httpSession = httpSessionsSite.getHttpSession(jSONObject.getString("session"));
                if (httpSession == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "session");
                }
                httpSessionsSite.removeHttpSession(httpSession);
                return ApiResponseElement.OK;
            }
            case "setActiveSession": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                String string3 = jSONObject.getString("session");
                for (HttpSession httpSession : httpSessionsSite.getHttpSessions()) {
                    if (!httpSession.getName().equals(string3)) continue;
                    httpSessionsSite.setActiveSession(httpSession);
                    return ApiResponseElement.OK;
                }
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "session");
            }
            case "unsetActiveSession": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                httpSessionsSite.unsetActiveSession();
                return ApiResponseElement.OK;
            }
            case "addSessionToken": {
                this.extension.addHttpSessionToken(ApiUtils.getAuthority(jSONObject.getString("site")), jSONObject.getString(ACTION_PARAM_TOKEN_NAME));
                return ApiResponseElement.OK;
            }
            case "removeSessionToken": {
                this.extension.removeHttpSessionToken(ApiUtils.getAuthority(jSONObject.getString("site")), jSONObject.getString(ACTION_PARAM_TOKEN_NAME));
                return ApiResponseElement.OK;
            }
            case "setSessionTokenValue": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                HttpSession httpSession = httpSessionsSite.getHttpSession(jSONObject.getString("session"));
                if (httpSession == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "session");
                }
                this.extension.addHttpSessionToken(ApiUtils.getAuthority(jSONObject.getString("site")), jSONObject.getString(ACTION_PARAM_TOKEN_NAME));
                httpSession.setTokenValue(jSONObject.getString(ACTION_PARAM_TOKEN_NAME), new Cookie(null, jSONObject.getString(ACTION_PARAM_TOKEN_NAME), jSONObject.getString(ACTION_PARAM_TOKEN_VALUE)));
                return ApiResponseElement.OK;
            }
            case "renameSession": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                if (!httpSessionsSite.renameHttpSession(jSONObject.getString(ACTION_PARAM_SESSION_OLD_NAME), jSONObject.getString(ACTION_PARAM_SESSION_NEW_NAME))) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, Constant.messages.getString("httpsessions.api.error.rename"));
                }
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for handleApiView: " + string + " (params: " + jSONObject.toString() + ")"));
        }
        switch (string) {
            case "sites": {
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (String string2 : this.extension.getSites()) {
                    apiResponseList.addItem(new ApiResponseElement("site", string2));
                }
                return apiResponseList;
            }
            case "sessions": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                ApiResponseList apiResponseList = new ApiResponseList(string);
                String string3 = this.getParam(jSONObject, "session", "");
                if (string3 == null || string3.isEmpty()) {
                    Set<HttpSession> set = httpSessionsSite.getHttpSessions();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("API View for sessions for " + ApiUtils.getAuthority(jSONObject.getString("site")) + ": " + httpSessionsSite));
                    }
                    for (HttpSession httpSession : set) {
                        if (httpSession.getTokenValuesUnmodifiableMap().size() <= 0) continue;
                        apiResponseList.addItem(this.createSessionResponse(httpSession));
                    }
                } else {
                    HttpSession httpSession = httpSessionsSite.getHttpSession(string3);
                    if (httpSession != null) {
                        apiResponseList.addItem(this.createSessionResponse(httpSession));
                    }
                }
                return apiResponseList;
            }
            case "activeSession": {
                HttpSessionsSite httpSessionsSite = this.extension.getHttpSessionsSite(ApiUtils.getAuthority(jSONObject.getString("site")), false);
                if (httpSessionsSite == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("API View for active session for " + ApiUtils.getAuthority(jSONObject.getString("site")) + ": " + httpSessionsSite));
                }
                if (httpSessionsSite.getActiveSession() != null) {
                    return new ApiResponseElement("active_session", httpSessionsSite.getActiveSession().getName());
                }
                return new ApiResponseElement("active_session", "");
            }
            case "sessionTokens": {
                Set<String> set;
                String string4 = ApiUtils.getAuthority(jSONObject.getString("site"));
                if (this.extension.getHttpSessionsSite(string4, false) == null) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "site");
                }
                HttpSessionTokensSet httpSessionTokensSet = this.extension.getHttpSessionTokensSet(string4);
                ApiResponseList apiResponseList = new ApiResponseList("session_tokens");
                if (httpSessionTokensSet != null && (set = httpSessionTokensSet.getTokensSet()) != null) {
                    for (String string5 : set) {
                        apiResponseList.addItem(new ApiResponseElement("token", string5));
                    }
                }
                return apiResponseList;
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private ApiResponseList createSessionResponse(HttpSession httpSession) {
        ApiResponseList apiResponseList = new ApiResponseList("session");
        apiResponseList.addItem(new ApiResponseElement("name", httpSession.getName()));
        apiResponseList.addItem(new TokenValuesResponseSet(httpSession.getTokenValuesUnmodifiableMap()));
        apiResponseList.addItem(new ApiResponseElement("messages_matched", Integer.toString(httpSession.getMessagesMatched())));
        return apiResponseList;
    }

    private static class TokenValuesResponseSet
    extends ApiResponseSet<Cookie> {
        private final List<List<Pair<String, String>>> xmlTokenElements;

        public TokenValuesResponseSet(Map<String, Cookie> map) {
            super("tokens", map);
            this.xmlTokenElements = TokenValuesResponseSet.convertTokenValues(map);
        }

        @Override
        public void toXML(Document document, Element element) {
            element.setAttribute("type", "set");
            for (List<Pair<String, String>> list : this.xmlTokenElements) {
                Element element2 = document.createElement("token");
                element2.setAttribute("type", "set");
                for (Pair<String, String> pair : list) {
                    Element element3 = document.createElement((String)pair.first);
                    element3.appendChild(document.createTextNode(XMLStringUtil.escapeControlChrs((String)pair.second)));
                    element2.appendChild(element3);
                }
                element.appendChild(element2);
            }
        }

        private static List<List<Pair<String, String>>> convertTokenValues(Map<String, Cookie> map) {
            ArrayList<List<Pair<String, String>>> arrayList = new ArrayList<List<Pair<String, String>>>();
            for (Map.Entry<String, Cookie> entry : map.entrySet()) {
                Cookie cookie = entry.getValue();
                ArrayList<Pair<String, String>> arrayList2 = new ArrayList<Pair<String, String>>();
                arrayList2.add(new Pair<String, String>("name", entry.getKey()));
                arrayList2.add(new Pair<String, String>("value", cookie.getValue()));
                arrayList2.add(new Pair<String, String>("domain", cookie.getDomain()));
                arrayList2.add(new Pair<String, String>("path", cookie.getPath()));
                arrayList2.add(new Pair<String, String>("secure", Boolean.toString(cookie.getSecure())));
                arrayList.add(arrayList2);
            }
            return arrayList;
        }
    }
}

