/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.ruleconfig.ExtensionRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;

public class RuleConfigAPI
extends ApiImplementor {
    private static final String PREFIX = "ruleConfig";
    private static final String ACTION_RESET_RULE_CONFIG_VALUE = "resetRuleConfigValue";
    private static final String ACTION_RESET_ALL_RULE_CONFIG_VALUES = "resetAllRuleConfigValues";
    private static final String ACTION_SET_RULE_CONFIG_VALUE = "setRuleConfigValue";
    private static final String VIEW_RULE_CONFIG_VALUE = "ruleConfigValue";
    private static final String VIEW_ALL_RULE_CONFIGS = "allRuleConfigs";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_VALUE = "value";
    private ExtensionRuleConfig extension;

    public RuleConfigAPI(ExtensionRuleConfig extensionRuleConfig) {
        this.extension = extensionRuleConfig;
        this.addApiAction(new ApiAction(ACTION_RESET_RULE_CONFIG_VALUE, new String[]{PARAM_KEY}));
        this.addApiAction(new ApiAction(ACTION_RESET_ALL_RULE_CONFIG_VALUES));
        this.addApiAction(new ApiAction(ACTION_SET_RULE_CONFIG_VALUE, new String[]{PARAM_KEY}, new String[]{PARAM_VALUE}));
        this.addApiView(new ApiView(VIEW_RULE_CONFIG_VALUE, new String[]{PARAM_KEY}));
        this.addApiView(new ApiView(VIEW_ALL_RULE_CONFIGS));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        switch (string) {
            case "setRuleConfigValue": {
                RuleConfig ruleConfig = this.extension.getRuleConfig(jSONObject.getString(PARAM_KEY));
                if (ruleConfig != null) {
                    if (jSONObject.containsKey((Object)PARAM_VALUE)) {
                        this.extension.setRuleConfigValue(ruleConfig.getKey(), jSONObject.getString(PARAM_VALUE));
                        break;
                    }
                    this.extension.setRuleConfigValue(ruleConfig.getKey(), "");
                    break;
                }
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_KEY);
            }
            case "resetRuleConfigValue": {
                RuleConfig ruleConfig = this.extension.getRuleConfig(jSONObject.getString(PARAM_KEY));
                if (ruleConfig != null) {
                    this.extension.resetRuleConfigValue(ruleConfig.getKey());
                    break;
                }
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_KEY);
            }
            case "resetAllRuleConfigValues": {
                this.extension.resetAllRuleConfigValues();
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        switch (string) {
            case "ruleConfigValue": {
                RuleConfig ruleConfig = this.extension.getRuleConfig(jSONObject.getString(PARAM_KEY));
                if (ruleConfig != null) {
                    apiResponse = new ApiResponseElement(string, ruleConfig.getValue());
                    break;
                }
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_KEY);
            }
            case "allRuleConfigs": {
                List<RuleConfig> list = this.extension.getAllRuleConfigs();
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (RuleConfig ruleConfig : list) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(PARAM_KEY, String.valueOf(ruleConfig.getKey()));
                    hashMap.put("defaultValue", ruleConfig.getDefaultValue());
                    hashMap.put(PARAM_VALUE, String.valueOf(ruleConfig.getValue()));
                    if (Constant.messages.containsKey(ruleConfig.getKey())) {
                        hashMap.put("description", Constant.messages.getString(ruleConfig.getKey()));
                    }
                    apiResponseList.addItem(new ApiResponseSet(PREFIX, hashMap));
                }
                apiResponse = apiResponseList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return apiResponse;
    }
}

