/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class ContextsSitesPanel
extends JPanel {
    private static final long serialVersionUID = -3325400144404304335L;

    public ContextsSitesPanel(JTree jTree, JTree jTree2) {
        this(jTree, jTree2, null);
    }

    public ContextsSitesPanel(JTree jTree, JTree jTree2, String string) {
        super(new BorderLayout());
        ContextsSitesPanel.validateNonNull(jTree, "contextsTree");
        ContextsSitesPanel.validateNonNull(jTree2, "sitesTree");
        JScrollPane jScrollPane = new JScrollPane();
        if (string != null) {
            jScrollPane.setName(string);
        }
        ScrollableTreesPanel scrollableTreesPanel = new ScrollableTreesPanel(jTree, jTree2);
        jScrollPane.setViewportView(scrollableTreesPanel);
        this.add(jScrollPane);
    }

    private static void validateNonNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("The " + string + " must not be null.");
        }
    }

    private static class ScrollableTreesPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 2709986817434976954L;
        private final JTree contextsTree;
        private final JTree sitesTree;

        public ScrollableTreesPanel(JTree jTree, JTree jTree2) {
            super(new BorderLayout());
            this.contextsTree = jTree;
            this.add((Component)jTree, "North");
            this.sitesTree = jTree2;
            this.add((Component)jTree2, "Center");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            Dimension dimension = this.contextsTree.getPreferredScrollableViewportSize();
            Dimension dimension2 = this.sitesTree.getPreferredScrollableViewportSize();
            dimension2.setSize(Math.max(dimension.getWidth(), dimension2.getWidth()), dimension.getHeight() + dimension2.getHeight());
            return dimension2;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            if (rectangle.getY() < this.sitesTree.getBounds().getY()) {
                return this.contextsTree.getScrollableUnitIncrement(rectangle, n, n2);
            }
            return this.sitesTree.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.sitesTree.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            int n = Math.max(this.sitesTree.getPreferredSize().width, this.contextsTree.getPreferredSize().width);
            return SwingUtilities.getUnwrappedParent(this).getWidth() > n;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return SwingUtilities.getUnwrappedParent(this).getHeight() > this.sitesTree.getPreferredSize().height + this.contextsTree.getPreferredSize().height;
        }
    }
}

