/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.PagingTableModel;
import org.zaproxy.zap.view.ZapTable;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;
import org.zaproxy.zap.view.renderer.DateFormatStringValue;
import org.zaproxy.zap.view.renderer.SizeBytesStringValue;
import org.zaproxy.zap.view.renderer.TimeDurationStringValue;
import org.zaproxy.zap.view.table.AlertRiskTableCellItem;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;
import org.zaproxy.zap.view.table.decorator.AlertRiskTableCellItemIconHighlighter;
import org.zaproxy.zap.view.table.decorator.NoteTableCellItemIconHighlighter;

public class HistoryReferencesTable
extends ZapTable {
    private static final long serialVersionUID = -6988769961088738602L;
    private static final Logger LOGGER = Logger.getLogger(HistoryReferencesTable.class);
    private static final int MAXIMUM_ROWS_FOR_TABLE_CONFIG = 75;
    private int maximumRowsForTableConfig = 75;

    public HistoryReferencesTable() {
        this(new DefaultHistoryReferencesTableModel());
    }

    public HistoryReferencesTable(HistoryReferencesTableModel.Column[] columnArray) {
        this(new DefaultHistoryReferencesTableModel(columnArray));
    }

    public HistoryReferencesTable(HistoryReferencesTableModel<?> historyReferencesTableModel) {
        this(historyReferencesTableModel, true);
    }

    public HistoryReferencesTable(HistoryReferencesTableModel<?> historyReferencesTableModel, boolean bl) {
        super(historyReferencesTableModel);
        this.setName("GenericHistoryReferenceTable");
        this.installColumnFactory();
        this.setSelectionMode(2);
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        if (bl) {
            this.getSelectionModel().addListSelectionListener(new DisplayMessageOnSelectionValueChange());
        }
        this.setComponentPopupMenu(new CustomPopupMenu());
    }

    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableRenderer((StringValue)new DateFormatStringValue()));
    }

    protected void installColumnFactory() {
        this.setColumnFactory(new HistoryReferencesTableColumnFactory());
        this.createDefaultColumnsFromModel();
        this.initializeColumnWidths();
    }

    protected void displayMessage(HttpMessage httpMessage) {
        View.getSingleton().displayMessage(httpMessage);
    }

    public HistoryReference getSelectedHistoryReference() {
        int n = this.getSelectedRow();
        if (n != -1) {
            return this.getHistoryReferenceAtViewRow(n);
        }
        return null;
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        int[] nArray = this.getSelectedRows();
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<HistoryReference> arrayList = new ArrayList<HistoryReference>(nArray.length);
        for (int n : nArray) {
            HistoryReference historyReference = this.getHistoryReferenceAtViewRow(n);
            if (historyReference == null) continue;
            arrayList.add(historyReference);
        }
        return arrayList;
    }

    protected HistoryReference getHistoryReferenceAtViewRow(int n) {
        Object t = this.getModel().getEntry(this.convertRowIndexToModel(n));
        if (t != null) {
            return t.getHistoryReference();
        }
        return null;
    }

    public void setModel(TableModel tableModel) {
        if (!(tableModel instanceof HistoryReferencesTableModel)) {
            throw new IllegalArgumentException("Parameter dataModel must be a subclass of HistoryReferencesTableModel.");
        }
        if (tableModel instanceof PagingTableModel) {
            this.setMaximumRowsForTableConfiguration(((PagingTableModel)tableModel).getMaxPageSize());
        }
        super.setModel(tableModel);
    }

    public HistoryReferencesTableModel<?> getModel() {
        return (HistoryReferencesTableModel)super.getModel();
    }

    public void setMaximumRowsForTableConfiguration(int n) {
        this.maximumRowsForTableConfig = n;
    }

    public int getMaximumRowsForTableConfiguration() {
        return this.maximumRowsForTableConfig;
    }

    public void selectHistoryReference(int n) {
        int n2 = this.getModel().getEntryRowIndex(n);
        if (n2 > -1) {
            int n3 = this.convertRowIndexToView(n2);
            this.getSelectionModel().setSelectionInterval(n3, n3);
            this.scrollRowToVisible(n3);
        }
    }

    protected static class ChangeByteUnitAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 5518182106427836717L;
        private final JXTable table;
        private final SizeBytesStringValue sizeBytesStringValue;

        public ChangeByteUnitAction(JXTable jXTable, SizeBytesStringValue sizeBytesStringValue) {
            super(Constant.messages.getString("view.table.useJustBytes.label"));
            this.putValue("ShortDescription", Constant.messages.getString("view.table.useJustBytes.tooltip"));
            this.table = jXTable;
            this.sizeBytesStringValue = sizeBytesStringValue;
            this.putValue("SwingSelectedKey", sizeBytesStringValue.isUseJustBytesUnit());
        }

        public ChangeByteUnitAction(String string, Icon icon, JXTable jXTable, SizeBytesStringValue sizeBytesStringValue) {
            super(string, icon);
            this.table = jXTable;
            this.sizeBytesStringValue = sizeBytesStringValue;
        }

        public boolean isStateAction() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.sizeBytesStringValue.setUseJustBytesUnit(!this.sizeBytesStringValue.isUseJustBytesUnit());
            this.table.repaint();
        }
    }

    protected class HistoryReferencesTableColumnFactory
    extends ColumnFactory {
        private SizeBytesStringValue sizeBytesStringValue;

        protected int getRowCount(JXTable jXTable) {
            int n = super.getRowCount(jXTable);
            int n2 = ((HistoryReferencesTable)jXTable).getMaximumRowsForTableConfiguration();
            if (n2 > 0 && n > n2) {
                return n2;
            }
            return n;
        }

        public void configureTableColumn(TableModel tableModel, TableColumnExt tableColumnExt) {
            int n;
            int n2;
            super.configureTableColumn(tableModel, tableColumnExt);
            HistoryReferencesTableModel historyReferencesTableModel = (HistoryReferencesTableModel)tableModel;
            tableColumnExt.setPrototypeValue(historyReferencesTableModel.getPrototypeValue(tableColumnExt.getModelIndex()));
            int n3 = historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.HIGHEST_ALERT);
            if (n3 != -1 && tableColumnExt.getModelIndex() == n3 && tableModel.getColumnClass(n3) == AlertRiskTableCellItem.class) {
                tableColumnExt.setHighlighters(new Highlighter[]{new AlertRiskTableCellItemIconHighlighter(n3)});
            }
            if ((n2 = historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.RTT)) != -1 && tableColumnExt.getModelIndex() == n2 && TimeDurationStringValue.isTargetClass(tableModel.getColumnClass(n2))) {
                tableColumnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new TimeDurationStringValue()));
            }
            if ((n = historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.NOTE)) != -1 && tableColumnExt.getModelIndex() == n && tableModel.getColumnClass(n) == Boolean.class) {
                tableColumnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
                tableColumnExt.setHighlighters(new Highlighter[]{new NoteTableCellItemIconHighlighter(n)});
            }
            this.installSizeBytesRenderer(tableColumnExt, historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_MESSAGE), tableModel);
            this.installSizeBytesRenderer(tableColumnExt, historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER), tableModel);
            this.installSizeBytesRenderer(tableColumnExt, historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY), tableModel);
            this.installSizeBytesRenderer(tableColumnExt, historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER), tableModel);
            this.installSizeBytesRenderer(tableColumnExt, historyReferencesTableModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY), tableModel);
        }

        protected void installSizeBytesRenderer(TableColumnExt tableColumnExt, int n, TableModel tableModel) {
            if (n != -1 && tableColumnExt.getModelIndex() == n && SizeBytesStringValue.isTargetClass(tableModel.getColumnClass(n))) {
                tableColumnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)this.getSizeBytesStringValue()));
            }
        }

        protected SizeBytesStringValue getSizeBytesStringValue() {
            if (this.sizeBytesStringValue == null) {
                this.sizeBytesStringValue = new SizeBytesStringValue();
                JComponent jComponent = HistoryReferencesTable.this.getColumnControl();
                if (jComponent instanceof ZapTable.ZapColumnControlButton) {
                    ZapTable.ZapColumnControlButton zapColumnControlButton = (ZapTable.ZapColumnControlButton)((Object)jComponent);
                    zapColumnControlButton.addAction((Action)((Object)new ChangeByteUnitAction(HistoryReferencesTable.this, this.sizeBytesStringValue)));
                    zapColumnControlButton.populatePopup();
                }
            }
            return this.sizeBytesStringValue;
        }
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component component, int n, int n2) {
            DefaultSelectableHistoryReferencesContainer defaultSelectableHistoryReferencesContainer = new DefaultSelectableHistoryReferencesContainer(HistoryReferencesTable.this.getName(), (Component)((Object)HistoryReferencesTable.this), Collections.emptyList(), this.getSelectedHistoryReferences());
            View.getSingleton().getPopupMenu().show(defaultSelectableHistoryReferencesContainer, n, n2);
        }

        protected List<HistoryReference> getSelectedHistoryReferences() {
            return HistoryReferencesTable.this.getSelectedHistoryReferences();
        }
    }

    protected class DisplayMessageOnSelectionValueChange
    implements ListSelectionListener {
        protected DisplayMessageOnSelectionValueChange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                HistoryReference historyReference = HistoryReferencesTable.this.getSelectedHistoryReference();
                if (historyReference == null) {
                    return;
                }
                boolean bl = HistoryReferencesTable.this.isFocusOwner();
                try {
                    HistoryReferencesTable.this.displayMessage(historyReference.getHttpMessage());
                }
                catch (DatabaseException | HttpMalformedHeaderException exception) {
                    LOGGER.error((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (bl) {
                        HistoryReferencesTable.this.requestFocusInWindow();
                    }
                }
            }
        }
    }
}

