/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.text;

import a_vcard.android.text.NoCopySpan;
import a_vcard.android.text.Spannable;
import a_vcard.android.text.Spanned;

public class Selection {
    public static final Object SELECTION_START = new START();
    public static final Object SELECTION_END = new END();

    private Selection() {
    }

    public static final int getSelectionStart(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_START);
        }
        return -1;
    }

    public static final int getSelectionEnd(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_END);
        }
        return -1;
    }

    public static void setSelection(Spannable text, int start, int stop) {
        int ostart = Selection.getSelectionStart(text);
        int oend = Selection.getSelectionEnd(text);
        if (ostart != start || oend != stop) {
            text.setSpan(SELECTION_START, start, start, 546);
            text.setSpan(SELECTION_END, stop, stop, 34);
        }
    }

    public static final void setSelection(Spannable text, int index) {
        Selection.setSelection(text, index, index);
    }

    public static final void selectAll(Spannable text) {
        Selection.setSelection(text, 0, text.length());
    }

    public static final void extendSelection(Spannable text, int index) {
        if (text.getSpanStart(SELECTION_END) != index) {
            text.setSpan(SELECTION_END, index, index, 34);
        }
    }

    public static final void removeSelection(Spannable text) {
        text.removeSpan(SELECTION_START);
        text.removeSpan(SELECTION_END);
    }

    private static final class END
    implements NoCopySpan {
        private END() {
        }
    }

    private static final class START
    implements NoCopySpan {
        private START() {
        }
    }
}

