/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.SMS;
import esmska.gui.GatewayMessageFrame;
import esmska.transfer.ImageCodeResolver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class GUIImageCodeResolver
implements ImageCodeResolver {
    private static final Logger logger = Logger.getLogger(GUIImageCodeResolver.class.getName());

    @Override
    public boolean resolveImageCode(final SMS sms) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Called from EDT");
        }
        Validate.notNull(sms);
        if (sms.getImage() == null && StringUtils.isEmpty(sms.getImageHint())) {
            sms.setImageCode(null);
            return false;
        }
        final Semaphore semaphore = new Semaphore(0);
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GatewayMessageFrame gmf = GatewayMessageFrame.getInstance();
                    gmf.addImageCodeMsg(sms, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            semaphore.release();
                        }
                    });
                }
            });
            semaphore.acquire();
            return StringUtils.isNotEmpty(sms.getImageCode());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Resolving image code interrupted", ex);
            return false;
        }
    }
}

