/*
 * Decompiled with CFR 0.152.
 */
package esmska.integration.mac.handler;

import com.apple.eawt.AppEvent;
import com.apple.eawt.SystemSleepListener;
import esmska.data.Queue;
import java.util.logging.Logger;

public class MacSystemSleepListener
implements SystemSleepListener {
    private static final Logger logger = Logger.getLogger(MacSystemSleepListener.class.getName());
    private transient boolean queuePausedBefore;

    public void systemAboutToSleep(AppEvent.SystemSleepEvent sse) {
        logger.fine("System is about to sleep.");
        this.queuePausedBefore = Queue.getInstance().isPaused();
        if (!this.queuePausedBefore) {
            Queue.getInstance().setPaused(true);
        }
    }

    public void systemAwoke(AppEvent.SystemSleepEvent sse) {
        logger.fine("System awoke.");
        if (!this.queuePausedBefore) {
            Queue.getInstance().setPaused(false);
        }
    }
}

