/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.pushingpixels.lafplugin.LafComponentPlugin;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;

public class SubstanceSwingxPlugin
implements LafComponentPlugin {
    public Object[] getDefaults(Object mSkin) {
        SubstanceSkin skin = (SubstanceSkin)mSkin;
        final SubstanceColorScheme mainActiveScheme = skin.getActiveColorScheme(DecorationAreaType.NONE);
        SubstanceColorScheme mainEnabledScheme = skin.getEnabledColorScheme(DecorationAreaType.NONE);
        SubstanceColorScheme mainDisabledScheme = skin.getDisabledColorScheme(DecorationAreaType.NONE);
        ColorUIResource foregroundColor = SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)mainEnabledScheme);
        ColorUIResource backgroundColor = new ColorUIResource(mainActiveScheme.getBackgroundFillColor());
        ColorUIResource disabledForegroundColor = SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)mainDisabledScheme);
        SubstanceColorScheme highlightColorScheme = skin.getColorScheme((Component)null, ColorSchemeAssociationKind.HIGHLIGHT, ComponentState.SELECTED);
        if (highlightColorScheme == null) {
            highlightColorScheme = skin.getColorScheme(null, ComponentState.ROLLOVER_SELECTED);
        }
        ColorUIResource selectionBackgroundColor = new ColorUIResource(highlightColorScheme.getSelectionBackgroundColor());
        ColorUIResource selectionForegroundColor = new ColorUIResource(highlightColorScheme.getSelectionForegroundColor());
        FontSet fontSet = SubstanceLookAndFeel.getFontPolicy().getFontSet("Substance", null);
        FontUIResource controlFont = fontSet.getControlFont();
        Painter titlePanelPainter = new Painter(){

            public void paint(Graphics2D g, Object jxTitledPanel, int width, int height) {
                JComponent titledPanel = (JComponent)jxTitledPanel;
                Graphics2D g2d = (Graphics2D)g.create();
                DecorationAreaType decorationType = SubstanceLookAndFeel.getDecorationType((Component)titledPanel);
                if (decorationType != null && SubstanceCoreUtilities.getSkin((Component)titledPanel).isRegisteredAsDecorationArea(decorationType)) {
                    DecorationPainterUtils.paintDecorationBackground((Graphics)g2d, (Component)titledPanel, (boolean)false);
                } else {
                    BackgroundPaintingUtils.fillAndWatermark((Graphics)g2d, (JComponent)titledPanel, (Color)SubstanceCoreUtilities.getSkin((Component)titledPanel).getBackgroundColorScheme(decorationType).getBackgroundFillColor(), (Rectangle)new Rectangle(0, 0, titledPanel.getWidth(), titledPanel.getHeight()));
                }
                g2d.dispose();
            }
        };
        SubstanceColorScheme headerDecorationTheme = skin.getEnabledColorScheme(DecorationAreaType.HEADER);
        ColorUIResource titlePaneForeground = new ColorUIResource(SubstanceColorUtilities.getForegroundColor((SubstanceColorScheme)headerDecorationTheme));
        Object[] defaults = new Object[]{"DatePickerUI", "org.pushingpixels.substance.swingx.SubstanceDatePickerUI", "MonthViewUI", "org.pushingpixels.substance.swingx.SubstanceMonthViewUI", "swingx/TaskPaneContainerUI", "org.pushingpixels.substance.swingx.SubstanceTaskPaneContainerUI", "swingx/TaskPaneUI", "org.pushingpixels.substance.swingx.SubstanceTaskPaneUI", "StatusBarUI", "org.pushingpixels.substance.swingx.SubstanceStatusBarUI", "HeaderUI", "org.pushingpixels.substance.swingx.SubstanceHeaderUI", "LoginPaneUI", "org.pushingpixels.substance.swingx.SubstanceLoginPaneUI", "swingx/TipOfTheDayUI", "org.pushingpixels.substance.swingx.SubstanceTipOfTheDayUI", "TitledPanelUI", "org.pushingpixels.substance.swingx.SubstanceTitledPanelUI", "ErrorPaneUI", "org.pushingpixels.substance.swingx.SubstanceErrorPaneUI", "HyperlinkUI", "org.pushingpixels.substance.swingx.SubstanceHyperlinkUI", "PanelUI", "org.pushingpixels.substance.swingx.SubstancePanelUI", "TableUI", "org.pushingpixels.substance.swingx.SubstanceTableUI", "ColumnHeaderRenderer.upIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getControlFontSize(), (int)1, (SubstanceColorScheme)mainActiveScheme));
            }
        }, "ColumnHeaderRenderer.downIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getControlFontSize(), (int)5, (SubstanceColorScheme)mainActiveScheme));
            }
        }, "JXDatePicker.arrowIcon", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new IconUIResource(SubstanceImageCreator.getArrowIcon((int)SubstanceSizeUtils.getControlFontSize(), (int)5, (SubstanceColorScheme)mainActiveScheme));
            }
        }, "JXLoginPane.bannerFont", new FontUIResource(controlFont.deriveFont(3.0f * (float)controlFont.getSize())), "JXLoginPane.bannerForeground", new ColorUIResource(SubstanceColorUtilities.getNegativeColor((Color)foregroundColor)), "JXLoginPane.bannerLightBackground", new ColorUIResource(mainActiveScheme.isDark() ? mainActiveScheme.getUltraLightColor() : mainActiveScheme.getLightColor()), "JXLoginPane.bannerDarkBackground", new ColorUIResource(mainActiveScheme.isDark() ? mainActiveScheme.getLightColor() : mainActiveScheme.getMidColor()), "JXMonthView.background", backgroundColor, "JXMonthView.foreground", foregroundColor, "JXMonthView.monthStringBackground", backgroundColor, "JXMonthView.monthStringForeground", foregroundColor, "JXMonthView.daysOfTheWeekForeground", foregroundColor, "JXMonthView.weekOfTheYearForeground", foregroundColor, "JXMonthView.unselectableDayForeground", new ColorUIResource(Color.RED), "JXMonthView.selectedBackground", selectionBackgroundColor, "JXMonthView.selectedForeground", selectionForegroundColor, "JXMonthView.flaggedDayForeground", new ColorUIResource(Color.RED), "JXMonthView.leadingDayForeground", disabledForegroundColor, "JXMonthView.trailingDayForeground", disabledForegroundColor, "TaskPane.titleForeground", foregroundColor, "TaskPane.titleOver", foregroundColor, "TaskPane.specialTitleForeground", foregroundColor, "TaskPane.specialTitleOver", foregroundColor, "TaskPaneContainer.background", backgroundColor, "TaskPaneContainer.backgroundPainter", null, "TaskPane.background", backgroundColor, "TaskPane.foreground", foregroundColor, "TaskPane.font", new FontUIResource(controlFont.deriveFont(1)), "TipOfTheDay.background", backgroundColor.darker(), "TipOfTheDay.foreground", foregroundColor, "TipOfTheDay.font", new FontUIResource(controlFont), "TipOfTheDay.tipFont", new FontUIResource(controlFont.deriveFont(4.0f + (float)controlFont.getSize())), "TipOfTheDay.border", new SubstanceBorder(), "TitledBorder.font", new FontUIResource(controlFont), "TitledBorder.titleColor", foregroundColor, "JXTitledPanel.titleForeground", titlePaneForeground, "JXTitledPanel.titleFont", new FontUIResource(controlFont.deriveFont(1)), "JXTitledPanel.titlePainter", new PainterUIResource(titlePanelPainter), "JXHeader.titleForeground", titlePaneForeground, "JXHeader.descriptionForeground", titlePaneForeground};
        return defaults;
    }

    public void initialize() {
    }

    public void uninitialize() {
    }
}

