/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MultifileClassCodegen;
import org.jetbrains.kotlin.codegen.PackageCodegen;
import org.jetbrains.kotlin.codegen.PackagePartRegistry;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;
import org.jetbrains.org.objectweb.asm.Type;

public class ClassFileFactory
implements OutputFileCollection {
    private final GenerationState state;
    private final ClassBuilderFactory builderFactory;
    private final Map<String, OutAndSourceFileList> generators;
    private boolean isDone;
    private final Set<File> packagePartSourceFiles;
    private final Map<String, PackageParts> partsGroupedByPackage;

    public ClassFileFactory(@NotNull GenerationState state2, @NotNull ClassBuilderFactory builderFactory) {
        if (state2 == null) {
            ClassFileFactory.$$$reportNull$$$0(0);
        }
        if (builderFactory == null) {
            ClassFileFactory.$$$reportNull$$$0(1);
        }
        this.generators = new LinkedHashMap<String, OutAndSourceFileList>();
        this.isDone = false;
        this.packagePartSourceFiles = new HashSet<File>();
        this.partsGroupedByPackage = new LinkedHashMap<String, PackageParts>();
        this.state = state2;
        this.builderFactory = builderFactory;
    }

    public GenerationState getGenerationState() {
        return this.state;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull PsiFile sourceFile) {
        if (origin == null) {
            ClassFileFactory.$$$reportNull$$$0(2);
        }
        if (asmType == null) {
            ClassFileFactory.$$$reportNull$$$0(3);
        }
        if (sourceFile == null) {
            ClassFileFactory.$$$reportNull$$$0(4);
        }
        ClassBuilder classBuilder2 = this.newVisitor(origin, asmType, Collections.singletonList(sourceFile));
        if (classBuilder2 == null) {
            ClassFileFactory.$$$reportNull$$$0(5);
        }
        return classBuilder2;
    }

    @NotNull
    public ClassBuilder newVisitor(@NotNull JvmDeclarationOrigin origin, @NotNull Type asmType, @NotNull Collection<? extends PsiFile> sourceFiles2) {
        if (origin == null) {
            ClassFileFactory.$$$reportNull$$$0(6);
        }
        if (asmType == null) {
            ClassFileFactory.$$$reportNull$$$0(7);
        }
        if (sourceFiles2 == null) {
            ClassFileFactory.$$$reportNull$$$0(8);
        }
        ClassBuilder answer = this.builderFactory.newClassBuilder(origin);
        this.generators.put(asmType.getInternalName() + ".class", new ClassBuilderAndSourceFileList(answer, ClassFileFactory.toIoFilesIgnoringNonPhysical(sourceFiles2)));
        ClassBuilder classBuilder2 = answer;
        if (classBuilder2 == null) {
            ClassFileFactory.$$$reportNull$$$0(9);
        }
        return classBuilder2;
    }

    public void done() {
        if (!this.isDone) {
            this.isDone = true;
            this.writeModuleMappings();
        }
    }

    public void releaseGeneratedOutput() {
        this.generators.clear();
    }

    private void writeModuleMappings() {
        final JvmPackageTable.PackageTable.Builder builder = JvmPackageTable.PackageTable.newBuilder();
        String outputFilePath = JvmCodegenUtil.getMappingFileName(this.state.getModuleName());
        for (PackageParts part : ClassFileUtilsKt.addCompiledPartsAndSort(this.partsGroupedByPackage.values(), this.state)) {
            part.addTo(builder);
        }
        if (builder.getPackagePartsCount() == 0) {
            return;
        }
        this.generators.put(outputFilePath, new OutAndSourceFileList(CollectionsKt.toList(this.packagePartSourceFiles)){

            @Override
            public byte[] asBytes(ClassBuilderFactory factory2) {
                return ClassFileUtilsKt.serializeToByteArray(builder);
            }

            @Override
            public String asText(ClassBuilderFactory factory2) {
                try {
                    return new String(this.asBytes(factory2), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    @NotNull
    public List<OutputFile> asList() {
        this.done();
        List<OutputFile> list2 = this.getCurrentOutput();
        if (list2 == null) {
            ClassFileFactory.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    public List<OutputFile> getCurrentOutput() {
        List<OutputFile> list2 = CollectionsKt.map(this.generators.keySet(), x$0 -> new OutputClassFile((String)x$0));
        if (list2 == null) {
            ClassFileFactory.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @Nullable
    public OutputFile get(@NotNull String relativePath) {
        if (relativePath == null) {
            ClassFileFactory.$$$reportNull$$$0(12);
        }
        return this.generators.containsKey(relativePath) ? new OutputClassFile(relativePath) : null;
    }

    @NotNull
    public String createText() {
        StringBuilder answer = new StringBuilder();
        for (OutputFile file : this.asList()) {
            answer.append("@").append(file.getRelativePath()).append('\n');
            answer.append(file.asText());
        }
        String string = answer.toString();
        if (string == null) {
            ClassFileFactory.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public Map<String, String> createTextForEachFile() {
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (OutputFile file : this.asList()) {
            answer.put(file.getRelativePath(), file.asText());
        }
        LinkedHashMap<String, String> linkedHashMap = answer;
        if (linkedHashMap == null) {
            ClassFileFactory.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    public PackageCodegen forPackage(@NotNull FqName fqName2, @NotNull Collection<KtFile> files2) {
        if (fqName2 == null) {
            ClassFileFactory.$$$reportNull$$$0(15);
        }
        if (files2 == null) {
            ClassFileFactory.$$$reportNull$$$0(16);
        }
        assert (!this.isDone) : "Already done!";
        this.registerPackagePartSourceFiles(files2);
        PackageCodegen packageCodegen = this.state.getCodegenFactory().createPackageCodegen(this.state, files2, fqName2, this.buildNewPackagePartRegistry(fqName2));
        if (packageCodegen == null) {
            ClassFileFactory.$$$reportNull$$$0(17);
        }
        return packageCodegen;
    }

    @NotNull
    public MultifileClassCodegen forMultifileClass(@NotNull FqName facadeFqName, @NotNull Collection<KtFile> files2) {
        if (facadeFqName == null) {
            ClassFileFactory.$$$reportNull$$$0(18);
        }
        if (files2 == null) {
            ClassFileFactory.$$$reportNull$$$0(19);
        }
        assert (!this.isDone) : "Already done!";
        this.registerPackagePartSourceFiles(files2);
        MultifileClassCodegen multifileClassCodegen = this.state.getCodegenFactory().createMultifileClassCodegen(this.state, files2, facadeFqName, this.buildNewPackagePartRegistry(facadeFqName.parent()));
        if (multifileClassCodegen == null) {
            ClassFileFactory.$$$reportNull$$$0(20);
        }
        return multifileClassCodegen;
    }

    private PackagePartRegistry buildNewPackagePartRegistry(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            ClassFileFactory.$$$reportNull$$$0(21);
        }
        String packageFqNameAsString = packageFqName.asString();
        return (partShortName, facadeShortName) -> {
            PackageParts packageParts = this.partsGroupedByPackage.computeIfAbsent(packageFqNameAsString, PackageParts::new);
            packageParts.addPart(partShortName, facadeShortName);
        };
    }

    private void registerPackagePartSourceFiles(Collection<KtFile> files2) {
        this.packagePartSourceFiles.addAll(ClassFileFactory.toIoFilesIgnoringNonPhysical(PackagePartClassUtils.getFilesWithCallables(files2)));
    }

    @NotNull
    private static List<File> toIoFilesIgnoringNonPhysical(@NotNull Collection<? extends PsiFile> psiFiles) {
        if (psiFiles == null) {
            ClassFileFactory.$$$reportNull$$$0(22);
        }
        ArrayList<File> result2 = new ArrayList<File>(psiFiles.size());
        for (PsiFile psiFile : psiFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) continue;
            result2.add(new File(virtualFile2.getPath()));
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ClassFileFactory.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    public void removeClasses(Set<String> classNamesToRemove) {
        for (String classInternalName : classNamesToRemove) {
            this.generators.remove(classInternalName + ".class");
        }
    }

    public List<KtFile> getInputFiles() {
        return this.state.getFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderFactory";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ClassFileFactory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facadeFqName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClassFileFactory";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextForEachFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "forPackage";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "forMultifileClass";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toIoFilesIgnoringNonPhysical";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newVisitor";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "forPackage";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forMultifileClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildNewPackagePartRegistry";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toIoFilesIgnoringNonPhysical";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class OutAndSourceFileList {
        protected final List<File> sourceFiles;

        private OutAndSourceFileList(List<File> sourceFiles2) {
            this.sourceFiles = sourceFiles2;
        }

        public abstract byte[] asBytes(ClassBuilderFactory var1);

        public abstract String asText(ClassBuilderFactory var1);
    }

    private static final class ClassBuilderAndSourceFileList
    extends OutAndSourceFileList {
        private final ClassBuilder classBuilder;

        private ClassBuilderAndSourceFileList(ClassBuilder classBuilder2, List<File> sourceFiles2) {
            super(sourceFiles2);
            this.classBuilder = classBuilder2;
        }

        @Override
        public byte[] asBytes(ClassBuilderFactory factory2) {
            return factory2.asBytes(this.classBuilder);
        }

        @Override
        public String asText(ClassBuilderFactory factory2) {
            return factory2.asText(this.classBuilder);
        }
    }

    private class OutputClassFile
    implements OutputFile {
        private final String relativeClassFilePath;

        public OutputClassFile(String relativeClassFilePath) {
            this.relativeClassFilePath = relativeClassFilePath;
        }

        @Override
        @NotNull
        public String getRelativePath() {
            String string = this.relativeClassFilePath;
            if (string == null) {
                OutputClassFile.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public List<File> getSourceFiles() {
            OutAndSourceFileList pair = (OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath);
            if (pair == null) {
                throw new IllegalStateException("No record for binary file " + this.relativeClassFilePath);
            }
            List<File> list2 = pair.sourceFiles;
            if (list2 == null) {
                OutputClassFile.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        @NotNull
        public byte[] asByteArray() {
            byte[] byArray;
            try {
                byArray = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asBytes(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (byArray == null) {
                OutputClassFile.$$$reportNull$$$0(2);
            }
            return byArray;
        }

        @Override
        @NotNull
        public String asText() {
            String string;
            try {
                string = ((OutAndSourceFileList)ClassFileFactory.this.generators.get(this.relativeClassFilePath)).asText(ClassFileFactory.this.builderFactory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error generating class file " + this.toString() + ": " + e.getMessage(), e);
            }
            if (string == null) {
                OutputClassFile.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string = this.getRelativePath() + " (compiled from " + this.getSourceFiles() + ")";
            if (string == null) {
                OutputClassFile.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/codegen/ClassFileFactory$OutputClassFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFiles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asByteArray";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

