/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.CachedSingletonsRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;

public class ApplicationManager {
    protected static Application ourApplication;

    public static Application getApplication() {
        return ourApplication;
    }

    private static void setApplication(@NotNull Application instance) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        ourApplication = instance;
        CachedSingletonsRegistry.cleanupCachedFields();
    }

    public static void setApplication(@NotNull Application instance, @NotNull Getter<FileTypeRegistry> fileTypeRegistryGetter, @NotNull Disposable parent2) {
        if (instance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (fileTypeRegistryGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeRegistryGetter", "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationManager", "setApplication"));
        }
        final Application old = ourApplication;
        final Getter<FileTypeRegistry> oldFileTypeRegistry = FileTypeRegistry.ourInstanceGetter;
        Disposer.register(parent2, new Disposable(){

            @Override
            public void dispose() {
                if (old != null) {
                    ApplicationManager.setApplication(old);
                    FileTypeRegistry.ourInstanceGetter = oldFileTypeRegistry;
                }
            }
        });
        ApplicationManager.setApplication(instance);
        FileTypeRegistry.ourInstanceGetter = fileTypeRegistryGetter;
    }
}

