/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"getScriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "psiFile", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "kotlin-compiler"})
public final class KotlinScriptDefinitionProviderKt {
    @Nullable
    public static final KotlinScriptDefinition getScriptDefinition(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(project, "project");
        KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = KotlinScriptDefinitionProvider.Companion.getInstance(project);
        return kotlinScriptDefinitionProvider != null ? kotlinScriptDefinitionProvider.findScriptDefinition(file) : null;
    }

    @Nullable
    public static final KotlinScriptDefinition getScriptDefinition(@NotNull PsiFile psiFile) {
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkParameterIsNotNull(psiFile, "psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "psiFile.project");
        KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = KotlinScriptDefinitionProvider.Companion.getInstance(project);
        if (kotlinScriptDefinitionProvider != null) {
            String string = psiFile.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "psiFile.name");
            kotlinScriptDefinition = kotlinScriptDefinitionProvider.findScriptDefinition(string);
        } else {
            kotlinScriptDefinition = null;
        }
        return kotlinScriptDefinition;
    }
}

