/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.caching.internal.BuildCacheHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumValueSnapshot
implements ValueSnapshot {
    private final String className;
    private final String name;

    public EnumValueSnapshot(Enum<?> value) {
        this.className = value.getClass().getName();
        this.name = value.name();
    }

    public EnumValueSnapshot(String className, String name) {
        this.className = className;
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        if (this.isEqualEnum(value)) {
            return this;
        }
        return snapshotter.snapshot(value);
    }

    @Override
    public ValueSnapshot isolatableSnapshot(Object value, ValueSnapshotter snapshotter) {
        if (this.isEqualEnum(value)) {
            if (this instanceof Isolatable) {
                return this;
            }
            return snapshotter.wrap(value, this);
        }
        return snapshotter.isolatableSnapshot(value);
    }

    private boolean isEqualEnum(Object value) {
        Enum enumValue;
        return value instanceof Enum && (enumValue = (Enum)value).name().equals(this.name) && enumValue.getClass().getName().equals(this.className);
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString((CharSequence)this.className);
        hasher.putString((CharSequence)this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EnumValueSnapshot other = (EnumValueSnapshot)obj;
        return this.className.equals(other.className) && this.name.equals(other.name);
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.name.hashCode();
    }
}

