/*
 * Decompiled with CFR 0.152.
 */
package org.grails.encoder;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.grails.charsequences.CharSequences;
import org.grails.encoder.DefaultEncodingStateRegistry;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.EncodedAppenderFactory;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncoderAware;
import org.grails.encoder.EncodesToWriter;
import org.grails.encoder.EncodesToWriterAdapter;
import org.grails.encoder.EncodingState;
import org.grails.encoder.EncodingStateRegistry;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.WriterEncodedAppender;

public class StreamingEncoderWriter
extends FilterWriter
implements EncodedAppenderFactory,
EncoderAware {
    private EncodesToWriter encodesToWriter;
    private StreamingEncoder encoder;
    private EncodingStateRegistry encodingStateRegistry;

    public StreamingEncoderWriter(Writer out, StreamingEncoder encoder, EncodingStateRegistry encodingStateRegistry) {
        super(out);
        this.encoder = encoder;
        this.encodesToWriter = encoder instanceof EncodesToWriter ? (EncodesToWriter)((Object)encoder) : new EncodesToWriterAdapter(encoder, true);
        this.encodingStateRegistry = encodingStateRegistry;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.encodesToWriter.encodeToWriter(cbuf, off, len, this.out, null);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        EncodingState encodingState = this.lookupEncodingState(str, off, len);
        if (this.shouldEncodeWith(this.encoder, encodingState)) {
            this.encodesToWriter.encodeToWriter(str, off, len, this.out, encodingState);
        } else {
            this.out.write(str, off, len);
        }
    }

    protected boolean shouldEncodeWith(Encoder encoderToApply, EncodingState encodingState) {
        return encodingState == null || DefaultEncodingStateRegistry.shouldEncodeWith(encoderToApply, encodingState);
    }

    protected EncodingState lookupEncodingState(String str, int off, int len) {
        if (this.encodingStateRegistry != null) {
            return this.encodingStateRegistry.getEncodingStateFor(str);
        }
        return null;
    }

    @Override
    public void write(int c) throws IOException {
        this.encodesToWriter.encodeToWriter(CharSequences.createSingleCharSequence(c), 0, 1, this.out, null);
    }

    @Override
    public EncodedAppender getEncodedAppender() {
        WriterEncodedAppender encodedAppender = new WriterEncodedAppender(this.out);
        encodedAppender.setIgnoreEncodingState(this.encodingStateRegistry == null);
        return encodedAppender;
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }
}

