/*
 * Decompiled with CFR 0.152.
 */
package org.grails.validation;

import grails.util.GrailsUtil;
import grails.validation.Constrained;
import grails.validation.ConstrainedProperty;
import grails.validation.Constraint;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.util.BuilderSupport;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.validation.DefaultConstraintEvaluator;
import org.springframework.beans.InvalidPropertyException;

@Deprecated
public class ConstrainedPropertyBuilder
extends BuilderSupport {
    private Map<String, Constrained> constrainedProperties = new LinkedHashMap<String, Constrained>();
    private Map<String, String> sharedConstraints = new HashMap<String, String>();
    private int order = 1;
    private Class<?> targetClass;
    private ClassPropertyFetcher classPropertyFetcher;
    private static final String SHARED_CONSTRAINT = "shared";
    private static final String IMPORT_FROM_CONSTRAINT = "importFrom";
    private MetaClass targetMetaClass;

    public ConstrainedPropertyBuilder(Object target) {
        this(target.getClass());
    }

    public ConstrainedPropertyBuilder(Class<?> targetClass) {
        this.targetClass = targetClass;
        this.classPropertyFetcher = ClassPropertyFetcher.forClass(targetClass);
        this.targetMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(targetClass);
    }

    public String getSharedConstraint(String propertyName) {
        return this.sharedConstraints.get(propertyName);
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        try {
            return super.doInvokeMethod(methodName, name, args);
        }
        catch (MissingMethodException e) {
            return this.targetMetaClass.invokeMethod(this.targetClass, methodName, args);
        }
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return this.targetMetaClass.getProperty(this.targetClass, property);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            super.setProperty(property, newValue);
        }
        catch (MissingPropertyException e) {
            this.targetMetaClass.setProperty(this.targetClass, property, newValue);
        }
    }

    protected Object createNode(Object name, Map attributes) {
        try {
            ConstrainedProperty cp;
            String property = (String)name;
            if (this.constrainedProperties.containsKey(property)) {
                cp = (ConstrainedProperty)this.constrainedProperties.get(property);
            } else {
                Class propertyType = this.classPropertyFetcher.getPropertyType(property, true);
                if (propertyType == null) {
                    throw new MissingMethodException(property, this.targetClass, new Object[]{attributes}, true);
                }
                cp = new ConstrainedProperty(this.targetClass, property, propertyType);
                cp.setOrder(this.order++);
                this.constrainedProperties.put(property, cp);
            }
            if (cp.getPropertyType() == null) {
                if (!IMPORT_FROM_CONSTRAINT.equals(name)) {
                    GrailsUtil.warn((String)("Property [" + cp.getPropertyName() + "] not found in domain class " + this.targetClass.getName() + "; cannot apply constraints: " + attributes));
                }
                return cp;
            }
            for (Object o : attributes.keySet()) {
                String constraintName = (String)o;
                Object value = attributes.get(constraintName);
                if (SHARED_CONSTRAINT.equals(constraintName)) {
                    if (value == null) continue;
                    this.sharedConstraints.put(property, value.toString());
                    continue;
                }
                if (cp.supportsContraint(constraintName)) {
                    cp.applyConstraint(constraintName, value);
                    continue;
                }
                if (ConstrainedProperty.hasRegisteredConstraint(constraintName)) {
                    GrailsUtil.warn((String)("Property [" + cp.getPropertyName() + "] of domain class " + this.targetClass.getName() + " has type [" + cp.getPropertyType().getName() + "] and doesn't support constraint [" + constraintName + "]. This constraint will not be checked during validation."));
                    continue;
                }
                cp.addMetaConstraint(constraintName, value);
            }
            return cp;
        }
        catch (InvalidPropertyException ipe) {
            throw new MissingMethodException((String)name, this.targetClass, new Object[]{attributes});
        }
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        if (IMPORT_FROM_CONSTRAINT.equals(name) && value instanceof Class) {
            return this.handleImportFrom(attributes, (Class)value);
        }
        throw new MissingMethodException((String)name, this.targetClass, new Object[]{attributes, value});
    }

    private Object handleImportFrom(Map attributes, Class importFromClazz) {
        Map<String, Constrained> importFromConstrainedProperties = new DefaultConstraintEvaluator().evaluate(importFromClazz);
        PropertyDescriptor[] targetPropertyDescriptorArray = this.classPropertyFetcher.getPropertyDescriptors();
        List toBeIncludedPropertyNamesParam = (List)attributes.get("include");
        List toBeExcludedPropertyNamesParam = (List)attributes.get("exclude");
        ArrayList<String> resultingPropertyNames = new ArrayList<String>();
        for (PropertyDescriptor targetPropertyDescriptor : targetPropertyDescriptorArray) {
            String targetPropertyName = targetPropertyDescriptor.getName();
            if (toBeIncludedPropertyNamesParam == null) {
                resultingPropertyNames.add(targetPropertyName);
            } else if (this.isListOfRegexpsContainsString(toBeIncludedPropertyNamesParam, targetPropertyName)) {
                resultingPropertyNames.add(targetPropertyName);
            }
            if (toBeExcludedPropertyNamesParam == null || !this.isListOfRegexpsContainsString(toBeExcludedPropertyNamesParam, targetPropertyName)) continue;
            resultingPropertyNames.remove(targetPropertyName);
        }
        resultingPropertyNames.remove("class");
        resultingPropertyNames.remove("metaClass");
        for (String targetPropertyName : resultingPropertyNames) {
            ConstrainedProperty importFromConstrainedProperty = (ConstrainedProperty)importFromConstrainedProperties.get(targetPropertyName);
            if (importFromConstrainedProperty == null) continue;
            HashMap<String, Object> importFromConstrainedPropertyAttributes = new HashMap<String, Object>();
            for (Constraint importFromAppliedConstraint : importFromConstrainedProperty.getAppliedConstraints()) {
                String importFromAppliedConstraintName = importFromAppliedConstraint.getName();
                Object importFromAppliedConstraintParameter = importFromAppliedConstraint.getParameter();
                importFromConstrainedPropertyAttributes.put(importFromAppliedConstraintName, importFromAppliedConstraintParameter);
            }
            this.createNode((Object)targetPropertyName, importFromConstrainedPropertyAttributes);
        }
        return null;
    }

    private boolean isListOfRegexpsContainsString(List<String> listOfStrings, String stringToMatch) {
        boolean result = false;
        for (String listElement : listOfStrings) {
            if (!stringToMatch.matches(listElement)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.emptyMap());
    }

    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.emptyMap(), value);
    }

    public Map<String, Constrained> getConstrainedProperties() {
        return this.constrainedProperties;
    }
}

