/*
 * Decompiled with CFR 0.152.
 */
package grails.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntry<V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheEntry.class);
    private final AtomicReference<V> valueRef = new AtomicReference<Object>(null);
    private long createdMillis;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private volatile boolean initialized = false;
    private static final Callable<CacheEntry> DEFAULT_CACHE_ENTRY_FACTORY = new Callable<CacheEntry>(){

        @Override
        public CacheEntry call() throws Exception {
            return new CacheEntry();
        }
    };

    public CacheEntry() {
        this.expire();
    }

    public CacheEntry(V value) {
        this.setValue(value);
    }

    public static <K, V> V getValue(ConcurrentMap<K, CacheEntry<V>> map, K key, long timeoutMillis, Callable<V> updater, Callable<? extends CacheEntry> cacheEntryFactory, boolean returnExpiredWhileUpdating, Object cacheRequestObject) {
        CacheEntry cacheEntry = (CacheEntry)map.get(key);
        if (cacheEntry == null) {
            try {
                cacheEntry = cacheEntryFactory.call();
            }
            catch (Exception e) {
                throw new UpdateException(e);
            }
            CacheEntry previousEntry = map.putIfAbsent(key, cacheEntry);
            if (previousEntry != null) {
                cacheEntry = previousEntry;
            }
        }
        try {
            return cacheEntry.getValue(timeoutMillis, updater, returnExpiredWhileUpdating, cacheRequestObject);
        }
        catch (UpdateException e) {
            e.rethrowRuntimeException();
            return null;
        }
    }

    public static <K, V> V getValue(ConcurrentMap<K, CacheEntry<V>> map, K key, long timeoutMillis, Callable<V> updater) {
        return CacheEntry.getValue(map, key, timeoutMillis, updater, DEFAULT_CACHE_ENTRY_FACTORY, true, null);
    }

    public static <K, V> V getValue(ConcurrentMap<K, CacheEntry<V>> map, K key, long timeoutMillis, Callable<V> updater, boolean returnExpiredWhileUpdating) {
        return CacheEntry.getValue(map, key, timeoutMillis, updater, DEFAULT_CACHE_ENTRY_FACTORY, returnExpiredWhileUpdating, null);
    }

    public V getValue(long timeout, Callable<V> updater) {
        return this.getValue(timeout, updater, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValue(long timeout, Callable<V> updater, boolean returnExpiredWhileUpdating, Object cacheRequestObject) {
        if (!this.isInitialized() || this.hasExpired(timeout, cacheRequestObject)) {
            boolean lockAcquired = false;
            try {
                V value;
                long beforeLockingCreatedMillis = this.createdMillis;
                if (returnExpiredWhileUpdating) {
                    if (!this.writeLock.tryLock()) {
                        if (this.isInitialized()) {
                            V v = this.getValueWhileUpdating(cacheRequestObject);
                            return v;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Locking cache for update");
                        }
                        this.writeLock.lock();
                    }
                } else {
                    LOG.debug("Locking cache for update");
                    this.writeLock.lock();
                }
                lockAcquired = true;
                if (!this.isInitialized() || this.shouldUpdate(beforeLockingCreatedMillis, cacheRequestObject)) {
                    try {
                        value = this.updateValue(this.getValue(), updater, cacheRequestObject);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Updating cache for value [{}]", value);
                        }
                        this.setValue(value);
                    }
                    catch (Exception e) {
                        throw new UpdateException(e);
                    }
                } else {
                    value = this.getValue();
                    this.resetTimestamp(false);
                }
                V v = value;
                return v;
            }
            finally {
                if (lockAcquired) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unlocking cache for update");
                    }
                    this.writeLock.unlock();
                }
            }
        }
        return this.getValue();
    }

    protected V getValueWhileUpdating(Object cacheRequestObject) {
        return this.valueRef.get();
    }

    protected V updateValue(V oldValue, Callable<V> updater, Object cacheRequestObject) throws Exception {
        return updater != null ? updater.call() : oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValue() {
        try {
            this.readLock.lock();
            V v = this.valueRef.get();
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(V val) {
        try {
            this.writeLock.lock();
            this.valueRef.set(val);
            this.setInitialized(true);
            this.resetTimestamp(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected boolean hasExpired(long timeout, Object cacheRequestObject) {
        return timeout >= 0L && System.currentTimeMillis() - timeout > this.createdMillis;
    }

    protected boolean shouldUpdate(long beforeLockingCreatedMillis, Object cacheRequestObject) {
        return beforeLockingCreatedMillis == this.createdMillis || this.createdMillis == 0L;
    }

    protected void resetTimestamp(boolean updated) {
        if (updated) {
            this.createdMillis = System.currentTimeMillis();
        }
    }

    public long getCreatedMillis() {
        return this.createdMillis;
    }

    public void expire() {
        this.createdMillis = 0L;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public static final class UpdateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UpdateException(String message, Throwable cause) {
            super(message, cause);
        }

        public UpdateException(Throwable cause) {
            super(cause);
        }

        public void rethrowCause() throws Exception {
            if (this.getCause() instanceof Exception) {
                throw (Exception)this.getCause();
            }
            throw this;
        }

        public void rethrowRuntimeException() {
            if (this.getCause() instanceof RuntimeException) {
                throw (RuntimeException)this.getCause();
            }
            throw this;
        }
    }
}

