/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Meterpreter;
import com.metasploit.meterpreter.TLVPacket;
import com.metasploit.stage.ConfigParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Transport {
    public static final long MS = 1000L;
    public static final int ENC_NONE = 0;
    private Transport prev;
    private Transport next;
    private Meterpreter meterpreter;
    protected String url;
    protected long commTimeout;
    protected long retryTotal;
    protected long retryWait;

    protected abstract boolean tryConnect(Meterpreter var1) throws IOException;

    public abstract int parseConfig(byte[] var1, int var2);

    public abstract void bind(DataInputStream var1, OutputStream var2);

    public abstract void disconnect();

    public abstract boolean dispatch(Meterpreter var1);

    public abstract void writePacket(TLVPacket var1, int var2) throws IOException;

    public abstract TLVPacket readPacket() throws IOException;

    public abstract boolean switchUri(String var1);

    protected Transport(Meterpreter meterpreter, String string) {
        this.meterpreter = meterpreter;
        this.url = string;
    }

    protected int parseTimeouts(byte[] byArray, int n) {
        this.commTimeout = 1000L * (long)ConfigParser.unpack32(byArray, n);
        this.retryTotal = 1000L * (long)ConfigParser.unpack32(byArray, n += 4);
        this.retryWait = 1000L * (long)ConfigParser.unpack32(byArray, n += 4);
        return n += 4;
    }

    protected void arrayCopy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray2[n2 + i] = byArray[n + i];
        }
    }

    protected void writeInt(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    protected int readInt(byte[] byArray, int n) {
        return (0xFF & byArray[n]) << 24 | (0xFF & byArray[1 + n]) << 16 | (0xFF & byArray[2 + n]) << 8 | 0xFF & byArray[3 + n];
    }

    protected TLVPacket readAndDecodePacket(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[32];
        dataInputStream.readFully(byArray);
        byte[] byArray2 = (byte[])byArray.clone();
        byte[] byArray3 = new byte[4];
        this.arrayCopy(byArray, 0, byArray3, 0, 4);
        this.xorBytes(byArray3, byArray);
        int n = this.readInt(byArray, 24) - 8;
        byte[] byArray4 = new byte[n];
        dataInputStream.readFully(byArray4);
        byte[] byArray5 = new byte[byArray2.length + byArray4.length];
        this.arrayCopy(byArray2, 0, byArray5, 0, byArray2.length);
        this.arrayCopy(byArray4, 0, byArray5, byArray2.length, byArray4.length);
        this.xorBytes(byArray3, byArray5);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray5, byArray2.length, byArray4.length);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
        TLVPacket tLVPacket = new TLVPacket(dataInputStream2, byArray4.length);
        dataInputStream2.close();
        return tLVPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodePacketAndWrite(TLVPacket tLVPacket, int n, DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = tLVPacket.toByteArray();
        byte[] byArray2 = new byte[32 + byArray.length];
        this.randXorKey(byArray2, 0);
        byte[] byArray3 = this.meterpreter.getSessionGUID();
        this.arrayCopy(byArray3, 0, byArray2, 4, byArray3.length);
        this.writeInt(byArray2, 20, 0);
        this.writeInt(byArray2, 24, byArray.length + 8);
        this.writeInt(byArray2, 28, n);
        this.arrayCopy(byArray, 0, byArray2, 32, byArray.length);
        this.xorBytes(byArray2, byArray2, 4);
        DataOutputStream dataOutputStream2 = dataOutputStream;
        synchronized (dataOutputStream2) {
            dataOutputStream.write(byArray2);
            dataOutputStream.flush();
        }
    }

    private void randXorKey(byte[] byArray, int n) {
        byArray[n] = this.randByte();
        byArray[n + 1] = this.randByte();
        byArray[n + 2] = this.randByte();
        byArray[n + 3] = this.randByte();
    }

    private byte randByte() {
        return (byte)(0xFF & (int)(Math.random() * 255.0 + 1.0));
    }

    private void xorBytes(byte[] byArray, byte[] byArray2) {
        this.xorBytes(byArray, byArray2, 0);
    }

    private void xorBytes(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray2.length - n; ++i) {
            int n2 = i + n;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray[i % 4]);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public long getCommTimeout() {
        return this.commTimeout / 1000L;
    }

    public void setCommTimeout(long l) {
        this.commTimeout = l * 1000L;
    }

    public long getRetryTotal() {
        return this.retryTotal / 1000L;
    }

    public void setRetryTotal(long l) {
        this.retryTotal = l * 1000L;
    }

    public long getRetryWait() {
        return this.retryWait / 1000L;
    }

    public void setRetryWait(long l) {
        this.retryWait = l * 1000L;
    }

    public boolean connect(Meterpreter meterpreter) {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() < l + this.retryTotal) {
            try {
                if (this.tryConnect(meterpreter)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            meterpreter.sleep(this.retryWait);
        }
        return false;
    }

    public void setPrev(Transport transport) {
        this.prev = transport;
    }

    public void setNext(Transport transport) {
        this.next = transport;
    }

    public Transport getPrev() {
        return this.prev;
    }

    public Transport getNext() {
        return this.next;
    }
}

