# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# flake8: noqa
# pylint: skip-file
try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        common,
        files,
        team_common,
        users_common,
    )
except (SystemError, ValueError):
    import common
    import files
    import team_common
    import users_common

class AccessMethodLogInfo(bb.Union):
    """
    Indicates the method in which the action was performed.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar SessionLogInfo end_user: End user session details.
    :ivar WebSessionLogInfo sign_in_as: Sign in as session details.
    :ivar WebSessionLogInfo content_manager: Content manager session details.
    :ivar WebSessionLogInfo admin_console: Admin console session details.
    :ivar ApiSessionLogInfo api: Api session details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def end_user(cls, val):
        """
        Create an instance of this class set to the ``end_user`` tag with value
        ``val``.

        :param SessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('end_user', val)

    @classmethod
    def sign_in_as(cls, val):
        """
        Create an instance of this class set to the ``sign_in_as`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('sign_in_as', val)

    @classmethod
    def content_manager(cls, val):
        """
        Create an instance of this class set to the ``content_manager`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('content_manager', val)

    @classmethod
    def admin_console(cls, val):
        """
        Create an instance of this class set to the ``admin_console`` tag with
        value ``val``.

        :param WebSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('admin_console', val)

    @classmethod
    def api(cls, val):
        """
        Create an instance of this class set to the ``api`` tag with value
        ``val``.

        :param ApiSessionLogInfo val:
        :rtype: AccessMethodLogInfo
        """
        return cls('api', val)

    def is_end_user(self):
        """
        Check if the union tag is ``end_user``.

        :rtype: bool
        """
        return self._tag == 'end_user'

    def is_sign_in_as(self):
        """
        Check if the union tag is ``sign_in_as``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as'

    def is_content_manager(self):
        """
        Check if the union tag is ``content_manager``.

        :rtype: bool
        """
        return self._tag == 'content_manager'

    def is_admin_console(self):
        """
        Check if the union tag is ``admin_console``.

        :rtype: bool
        """
        return self._tag == 'admin_console'

    def is_api(self):
        """
        Check if the union tag is ``api``.

        :rtype: bool
        """
        return self._tag == 'api'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_end_user(self):
        """
        End user session details.

        Only call this if :meth:`is_end_user` is true.

        :rtype: SessionLogInfo
        """
        if not self.is_end_user():
            raise AttributeError("tag 'end_user' not set")
        return self._value

    def get_sign_in_as(self):
        """
        Sign in as session details.

        Only call this if :meth:`is_sign_in_as` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_sign_in_as():
            raise AttributeError("tag 'sign_in_as' not set")
        return self._value

    def get_content_manager(self):
        """
        Content manager session details.

        Only call this if :meth:`is_content_manager` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_content_manager():
            raise AttributeError("tag 'content_manager' not set")
        return self._value

    def get_admin_console(self):
        """
        Admin console session details.

        Only call this if :meth:`is_admin_console` is true.

        :rtype: WebSessionLogInfo
        """
        if not self.is_admin_console():
            raise AttributeError("tag 'admin_console' not set")
        return self._value

    def get_api(self):
        """
        Api session details.

        Only call this if :meth:`is_api` is true.

        :rtype: ApiSessionLogInfo
        """
        if not self.is_api():
            raise AttributeError("tag 'api' not set")
        return self._value

    def __repr__(self):
        return 'AccessMethodLogInfo(%r, %r)' % (self._tag, self._value)

AccessMethodLogInfo_validator = bv.Union(AccessMethodLogInfo)

class AccountCaptureChangeAvailabilityDetails(object):
    """
    Granted or revoked the option to enable account capture on domains belonging
    to the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'AccountCaptureChangeAvailabilityDetails()'

AccountCaptureChangeAvailabilityDetails_validator = bv.Struct(AccountCaptureChangeAvailabilityDetails)

class AccountCaptureChangePolicyDetails(object):
    """
    Changed the account capture policy on a domain belonging to the team.

    :ivar new_value: New account capture policy.
    :ivar previous_value: Previous account capture policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New account capture policy.

        :rtype: AccountCapturePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous account capture policy. Might be missing due to historical data
        gap.

        :rtype: AccountCapturePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'AccountCaptureChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

AccountCaptureChangePolicyDetails_validator = bv.Struct(AccountCaptureChangePolicyDetails)

class AccountCaptureMigrateAccountDetails(object):
    """
    Account captured user migrated their account to the team.

    :ivar domain_name: Domain names.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = None
        self._domain_name_present = False
        if domain_name is not None:
            self.domain_name = domain_name

    @property
    def domain_name(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    def __repr__(self):
        return 'AccountCaptureMigrateAccountDetails(domain_name={!r})'.format(
            self._domain_name_value,
        )

AccountCaptureMigrateAccountDetails_validator = bv.Struct(AccountCaptureMigrateAccountDetails)

class AccountCapturePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    invited_users = None
    # Attribute is overwritten below the class definition
    all_users = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_invited_users(self):
        """
        Check if the union tag is ``invited_users``.

        :rtype: bool
        """
        return self._tag == 'invited_users'

    def is_all_users(self):
        """
        Check if the union tag is ``all_users``.

        :rtype: bool
        """
        return self._tag == 'all_users'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'AccountCapturePolicy(%r, %r)' % (self._tag, self._value)

AccountCapturePolicy_validator = bv.Union(AccountCapturePolicy)

class AccountCaptureRelinquishAccountDetails(object):
    """
    Account captured user relinquished their account by changing the email
    address associated with it.

    :ivar domain_name: Domain names.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None):
        self._domain_name_value = None
        self._domain_name_present = False
        if domain_name is not None:
            self.domain_name = domain_name

    @property
    def domain_name(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    def __repr__(self):
        return 'AccountCaptureRelinquishAccountDetails(domain_name={!r})'.format(
            self._domain_name_value,
        )

AccountCaptureRelinquishAccountDetails_validator = bv.Struct(AccountCaptureRelinquishAccountDetails)

class ActorLogInfo(bb.Union):
    """
    The entity who performed the action.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UserLogInfo user: The user who did the action.
    :ivar UserLogInfo admin: The admin who did the action.
    :ivar AppLogInfo app: The application who did the action.
    :ivar ResellerLogInfo reseller: Action done by reseller.
    :ivar dropbox: Action done by Dropbox.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    dropbox = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def user(cls, val):
        """
        Create an instance of this class set to the ``user`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('user', val)

    @classmethod
    def admin(cls, val):
        """
        Create an instance of this class set to the ``admin`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('admin', val)

    @classmethod
    def app(cls, val):
        """
        Create an instance of this class set to the ``app`` tag with value
        ``val``.

        :param AppLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('app', val)

    @classmethod
    def reseller(cls, val):
        """
        Create an instance of this class set to the ``reseller`` tag with value
        ``val``.

        :param ResellerLogInfo val:
        :rtype: ActorLogInfo
        """
        return cls('reseller', val)

    def is_user(self):
        """
        Check if the union tag is ``user``.

        :rtype: bool
        """
        return self._tag == 'user'

    def is_admin(self):
        """
        Check if the union tag is ``admin``.

        :rtype: bool
        """
        return self._tag == 'admin'

    def is_app(self):
        """
        Check if the union tag is ``app``.

        :rtype: bool
        """
        return self._tag == 'app'

    def is_reseller(self):
        """
        Check if the union tag is ``reseller``.

        :rtype: bool
        """
        return self._tag == 'reseller'

    def is_dropbox(self):
        """
        Check if the union tag is ``dropbox``.

        :rtype: bool
        """
        return self._tag == 'dropbox'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_user(self):
        """
        The user who did the action.

        Only call this if :meth:`is_user` is true.

        :rtype: UserLogInfo
        """
        if not self.is_user():
            raise AttributeError("tag 'user' not set")
        return self._value

    def get_admin(self):
        """
        The admin who did the action.

        Only call this if :meth:`is_admin` is true.

        :rtype: UserLogInfo
        """
        if not self.is_admin():
            raise AttributeError("tag 'admin' not set")
        return self._value

    def get_app(self):
        """
        The application who did the action.

        Only call this if :meth:`is_app` is true.

        :rtype: AppLogInfo
        """
        if not self.is_app():
            raise AttributeError("tag 'app' not set")
        return self._value

    def get_reseller(self):
        """
        Action done by reseller.

        Only call this if :meth:`is_reseller` is true.

        :rtype: ResellerLogInfo
        """
        if not self.is_reseller():
            raise AttributeError("tag 'reseller' not set")
        return self._value

    def __repr__(self):
        return 'ActorLogInfo(%r, %r)' % (self._tag, self._value)

ActorLogInfo_validator = bv.Union(ActorLogInfo)

class AllowDownloadDisabledDetails(object):
    """
    Disabled allow downloads.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'AllowDownloadDisabledDetails()'

AllowDownloadDisabledDetails_validator = bv.Struct(AllowDownloadDisabledDetails)

class AllowDownloadEnabledDetails(object):
    """
    Enabled allow downloads.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'AllowDownloadEnabledDetails()'

AllowDownloadEnabledDetails_validator = bv.Struct(AllowDownloadEnabledDetails)

class ApiSessionLogInfo(object):
    """
    Api session.

    :ivar request_id: Api request ID.
    """

    __slots__ = [
        '_request_id_value',
        '_request_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_id=None):
        self._request_id_value = None
        self._request_id_present = False
        if request_id is not None:
            self.request_id = request_id

    @property
    def request_id(self):
        """
        Api request ID.

        :rtype: str
        """
        if self._request_id_present:
            return self._request_id_value
        else:
            raise AttributeError("missing required field 'request_id'")

    @request_id.setter
    def request_id(self, val):
        val = self._request_id_validator.validate(val)
        self._request_id_value = val
        self._request_id_present = True

    @request_id.deleter
    def request_id(self):
        self._request_id_value = None
        self._request_id_present = False

    def __repr__(self):
        return 'ApiSessionLogInfo(request_id={!r})'.format(
            self._request_id_value,
        )

ApiSessionLogInfo_validator = bv.Struct(ApiSessionLogInfo)

class AppLinkTeamDetails(object):
    """
    Linked an app for team.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def __repr__(self):
        return 'AppLinkTeamDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppLinkTeamDetails_validator = bv.Struct(AppLinkTeamDetails)

class AppLinkUserDetails(object):
    """
    Linked an app for team member.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def __repr__(self):
        return 'AppLinkUserDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppLinkUserDetails_validator = bv.Struct(AppLinkUserDetails)

class AppLogInfo(object):
    """
    App's logged information.

    :ivar app_id: App unique ID. Might be missing due to historical data gap.
    :ivar display_name: App display name. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_app_id_value',
        '_app_id_present',
        '_display_name_value',
        '_display_name_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 app_id=None,
                 display_name=None):
        self._app_id_value = None
        self._app_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        if app_id is not None:
            self.app_id = app_id
        if display_name is not None:
            self.display_name = display_name

    @property
    def app_id(self):
        """
        App unique ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._app_id_present:
            return self._app_id_value
        else:
            return None

    @app_id.setter
    def app_id(self, val):
        if val is None:
            del self.app_id
            return
        val = self._app_id_validator.validate(val)
        self._app_id_value = val
        self._app_id_present = True

    @app_id.deleter
    def app_id(self):
        self._app_id_value = None
        self._app_id_present = False

    @property
    def display_name(self):
        """
        App display name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    def __repr__(self):
        return 'AppLogInfo(app_id={!r}, display_name={!r})'.format(
            self._app_id_value,
            self._display_name_value,
        )

AppLogInfo_validator = bv.StructTree(AppLogInfo)

class AppUnlinkTeamDetails(object):
    """
    Unlinked an app for team.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def __repr__(self):
        return 'AppUnlinkTeamDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppUnlinkTeamDetails_validator = bv.Struct(AppUnlinkTeamDetails)

class AppUnlinkUserDetails(object):
    """
    Unlinked an app for team member.

    :ivar app_info: Relevant application details.
    """

    __slots__ = [
        '_app_info_value',
        '_app_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 app_info=None):
        self._app_info_value = None
        self._app_info_present = False
        if app_info is not None:
            self.app_info = app_info

    @property
    def app_info(self):
        """
        Relevant application details.

        :rtype: AppLogInfo
        """
        if self._app_info_present:
            return self._app_info_value
        else:
            raise AttributeError("missing required field 'app_info'")

    @app_info.setter
    def app_info(self, val):
        self._app_info_validator.validate_type_only(val)
        self._app_info_value = val
        self._app_info_present = True

    @app_info.deleter
    def app_info(self):
        self._app_info_value = None
        self._app_info_present = False

    def __repr__(self):
        return 'AppUnlinkUserDetails(app_info={!r})'.format(
            self._app_info_value,
        )

AppUnlinkUserDetails_validator = bv.Struct(AppUnlinkUserDetails)

class AssetLogInfo(bb.Union):
    """
    Asset details.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar FileLogInfo file: File's details.
    :ivar FolderLogInfo folder: Folder's details.
    :ivar PaperDocumentLogInfo paper_document: Paper docuement's details.
    :ivar PaperFolderLogInfo paper_folder: Paper folder's details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def file(cls, val):
        """
        Create an instance of this class set to the ``file`` tag with value
        ``val``.

        :param FileLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('file', val)

    @classmethod
    def folder(cls, val):
        """
        Create an instance of this class set to the ``folder`` tag with value
        ``val``.

        :param FolderLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('folder', val)

    @classmethod
    def paper_document(cls, val):
        """
        Create an instance of this class set to the ``paper_document`` tag with
        value ``val``.

        :param PaperDocumentLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('paper_document', val)

    @classmethod
    def paper_folder(cls, val):
        """
        Create an instance of this class set to the ``paper_folder`` tag with
        value ``val``.

        :param PaperFolderLogInfo val:
        :rtype: AssetLogInfo
        """
        return cls('paper_folder', val)

    def is_file(self):
        """
        Check if the union tag is ``file``.

        :rtype: bool
        """
        return self._tag == 'file'

    def is_folder(self):
        """
        Check if the union tag is ``folder``.

        :rtype: bool
        """
        return self._tag == 'folder'

    def is_paper_document(self):
        """
        Check if the union tag is ``paper_document``.

        :rtype: bool
        """
        return self._tag == 'paper_document'

    def is_paper_folder(self):
        """
        Check if the union tag is ``paper_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_folder'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_file(self):
        """
        File's details.

        Only call this if :meth:`is_file` is true.

        :rtype: FileLogInfo
        """
        if not self.is_file():
            raise AttributeError("tag 'file' not set")
        return self._value

    def get_folder(self):
        """
        Folder's details.

        Only call this if :meth:`is_folder` is true.

        :rtype: FolderLogInfo
        """
        if not self.is_folder():
            raise AttributeError("tag 'folder' not set")
        return self._value

    def get_paper_document(self):
        """
        Paper docuement's details.

        Only call this if :meth:`is_paper_document` is true.

        :rtype: PaperDocumentLogInfo
        """
        if not self.is_paper_document():
            raise AttributeError("tag 'paper_document' not set")
        return self._value

    def get_paper_folder(self):
        """
        Paper folder's details.

        Only call this if :meth:`is_paper_folder` is true.

        :rtype: PaperFolderLogInfo
        """
        if not self.is_paper_folder():
            raise AttributeError("tag 'paper_folder' not set")
        return self._value

    def __repr__(self):
        return 'AssetLogInfo(%r, %r)' % (self._tag, self._value)

AssetLogInfo_validator = bv.Union(AssetLogInfo)

class CollectionShareDetails(object):
    """
    Shared an album.

    :ivar album_name: Album name.
    """

    __slots__ = [
        '_album_name_value',
        '_album_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 album_name=None):
        self._album_name_value = None
        self._album_name_present = False
        if album_name is not None:
            self.album_name = album_name

    @property
    def album_name(self):
        """
        Album name.

        :rtype: str
        """
        if self._album_name_present:
            return self._album_name_value
        else:
            raise AttributeError("missing required field 'album_name'")

    @album_name.setter
    def album_name(self, val):
        val = self._album_name_validator.validate(val)
        self._album_name_value = val
        self._album_name_present = True

    @album_name.deleter
    def album_name(self):
        self._album_name_value = None
        self._album_name_present = False

    def __repr__(self):
        return 'CollectionShareDetails(album_name={!r})'.format(
            self._album_name_value,
        )

CollectionShareDetails_validator = bv.Struct(CollectionShareDetails)

class Confidentiality(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    confidential = None
    # Attribute is overwritten below the class definition
    non_confidential = None
    # Attribute is overwritten below the class definition
    other = None

    def is_confidential(self):
        """
        Check if the union tag is ``confidential``.

        :rtype: bool
        """
        return self._tag == 'confidential'

    def is_non_confidential(self):
        """
        Check if the union tag is ``non_confidential``.

        :rtype: bool
        """
        return self._tag == 'non_confidential'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'Confidentiality(%r, %r)' % (self._tag, self._value)

Confidentiality_validator = bv.Union(Confidentiality)

class ContextLogInfo(bb.Union):
    """
    The primary entity on which the action was done.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar TeamMemberLogInfo team_member: Action was done on behalf of a team
        member.
    :ivar NonTeamMemberLogInfo non_team_member: Action was done on behalf of a
        non team member.
    :ivar team: Action was done on behalf of the team.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def team_member(cls, val):
        """
        Create an instance of this class set to the ``team_member`` tag with
        value ``val``.

        :param TeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('team_member', val)

    @classmethod
    def non_team_member(cls, val):
        """
        Create an instance of this class set to the ``non_team_member`` tag with
        value ``val``.

        :param NonTeamMemberLogInfo val:
        :rtype: ContextLogInfo
        """
        return cls('non_team_member', val)

    def is_team_member(self):
        """
        Check if the union tag is ``team_member``.

        :rtype: bool
        """
        return self._tag == 'team_member'

    def is_non_team_member(self):
        """
        Check if the union tag is ``non_team_member``.

        :rtype: bool
        """
        return self._tag == 'non_team_member'

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_team_member(self):
        """
        Action was done on behalf of a team member.

        Only call this if :meth:`is_team_member` is true.

        :rtype: TeamMemberLogInfo
        """
        if not self.is_team_member():
            raise AttributeError("tag 'team_member' not set")
        return self._value

    def get_non_team_member(self):
        """
        Action was done on behalf of a non team member.

        Only call this if :meth:`is_non_team_member` is true.

        :rtype: NonTeamMemberLogInfo
        """
        if not self.is_non_team_member():
            raise AttributeError("tag 'non_team_member' not set")
        return self._value

    def __repr__(self):
        return 'ContextLogInfo(%r, %r)' % (self._tag, self._value)

ContextLogInfo_validator = bv.Union(ContextLogInfo)

class CreateFolderDetails(object):
    """
    Created folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'CreateFolderDetails()'

CreateFolderDetails_validator = bv.Struct(CreateFolderDetails)

class DataPlacementRestrictionChangePolicyDetails(object):
    """
    Set a restriction policy regarding the location of data centers where team
    data resides.

    :ivar previous_value: Previous placement restriction.
    :ivar new_value: New placement restriction.
    """

    __slots__ = [
        '_previous_value_value',
        '_previous_value_present',
        '_new_value_value',
        '_new_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None):
        self._previous_value_value = None
        self._previous_value_present = False
        self._new_value_value = None
        self._new_value_present = False
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    @property
    def previous_value(self):
        """
        Previous placement restriction.

        :rtype: PlacementRestriction
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    @property
    def new_value(self):
        """
        New placement restriction.

        :rtype: PlacementRestriction
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    def __repr__(self):
        return 'DataPlacementRestrictionChangePolicyDetails(previous_value={!r}, new_value={!r})'.format(
            self._previous_value_value,
            self._new_value_value,
        )

DataPlacementRestrictionChangePolicyDetails_validator = bv.Struct(DataPlacementRestrictionChangePolicyDetails)

class DataPlacementRestrictionSatisfyPolicyDetails(object):
    """
    Satisfied a previously set restriction policy regarding the location of data
    centers where team data resides (i.e. all data have been migrated according
    to the restriction placed).

    :ivar placement_restriction: Placement restriction.
    """

    __slots__ = [
        '_placement_restriction_value',
        '_placement_restriction_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 placement_restriction=None):
        self._placement_restriction_value = None
        self._placement_restriction_present = False
        if placement_restriction is not None:
            self.placement_restriction = placement_restriction

    @property
    def placement_restriction(self):
        """
        Placement restriction.

        :rtype: PlacementRestriction
        """
        if self._placement_restriction_present:
            return self._placement_restriction_value
        else:
            raise AttributeError("missing required field 'placement_restriction'")

    @placement_restriction.setter
    def placement_restriction(self, val):
        self._placement_restriction_validator.validate_type_only(val)
        self._placement_restriction_value = val
        self._placement_restriction_present = True

    @placement_restriction.deleter
    def placement_restriction(self):
        self._placement_restriction_value = None
        self._placement_restriction_present = False

    def __repr__(self):
        return 'DataPlacementRestrictionSatisfyPolicyDetails(placement_restriction={!r})'.format(
            self._placement_restriction_value,
        )

DataPlacementRestrictionSatisfyPolicyDetails_validator = bv.Struct(DataPlacementRestrictionSatisfyPolicyDetails)

class SessionLogInfo(object):
    """
    Session's logged information.

    :ivar session_id: Session ID. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_session_id_value',
        '_session_id_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        self._session_id_value = None
        self._session_id_present = False
        if session_id is not None:
            self.session_id = session_id

    @property
    def session_id(self):
        """
        Session ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._session_id_present:
            return self._session_id_value
        else:
            return None

    @session_id.setter
    def session_id(self, val):
        if val is None:
            del self.session_id
            return
        val = self._session_id_validator.validate(val)
        self._session_id_value = val
        self._session_id_present = True

    @session_id.deleter
    def session_id(self):
        self._session_id_value = None
        self._session_id_present = False

    def __repr__(self):
        return 'SessionLogInfo(session_id={!r})'.format(
            self._session_id_value,
        )

SessionLogInfo_validator = bv.StructTree(SessionLogInfo)

class DesktopSessionLogInfo(SessionLogInfo):
    """
    Desktop session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        super(DesktopSessionLogInfo, self).__init__(session_id)

    def __repr__(self):
        return 'DesktopSessionLogInfo(session_id={!r})'.format(
            self._session_id_value,
        )

DesktopSessionLogInfo_validator = bv.Struct(DesktopSessionLogInfo)

class DeviceApprovalsChangeDesktopPolicyDetails(object):
    """
    Set or removed a limit on the number of computers each team member can link
    to their work Dropbox account.

    :ivar new_value: New desktop device approvals policy. Might be missing due
        to historical data gap.
    :ivar previous_value: Previous desktop device approvals policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New desktop device approvals policy. Might be missing due to historical
        data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous desktop device approvals policy. Might be missing due to
        historical data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'DeviceApprovalsChangeDesktopPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeDesktopPolicyDetails_validator = bv.Struct(DeviceApprovalsChangeDesktopPolicyDetails)

class DeviceApprovalsChangeMobilePolicyDetails(object):
    """
    Set or removed a limit on the number of mobiles devices each team member can
    link to their work Dropbox account.

    :ivar new_value: New mobile device approvals policy. Might be missing due to
        historical data gap.
    :ivar previous_value: Previous mobile device approvals policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New mobile device approvals policy. Might be missing due to historical
        data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous mobile device approvals policy. Might be missing due to
        historical data gap.

        :rtype: DeviceApprovalsPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'DeviceApprovalsChangeMobilePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeMobilePolicyDetails_validator = bv.Struct(DeviceApprovalsChangeMobilePolicyDetails)

class DeviceApprovalsChangeOverageActionDetails(object):
    """
    Changed the action taken when a team member is already over the limits (e.g
    when they join the team, an admin lowers limits, etc.).

    :ivar new_value: New over the limits policy. Might be missing due to
        historical data gap.
    :ivar previous_value: Previous over the limit policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New over the limits policy. Might be missing due to historical data gap.

        :rtype: DeviceApprovalsRolloutPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous over the limit policy. Might be missing due to historical data
        gap.

        :rtype: DeviceApprovalsRolloutPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'DeviceApprovalsChangeOverageActionDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeOverageActionDetails_validator = bv.Struct(DeviceApprovalsChangeOverageActionDetails)

class DeviceApprovalsChangeUnlinkActionDetails(object):
    """
    Changed the action taken with respect to approval limits when a team member
    unlinks an approved device.

    :ivar new_value: New device unlink policy. Might be missing due to
        historical data gap.
    :ivar previous_value: Previous device unlink policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New device unlink policy. Might be missing due to historical data gap.

        :rtype: DeviceUnlinkPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous device unlink policy. Might be missing due to historical data
        gap.

        :rtype: DeviceUnlinkPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'DeviceApprovalsChangeUnlinkActionDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

DeviceApprovalsChangeUnlinkActionDetails_validator = bv.Struct(DeviceApprovalsChangeUnlinkActionDetails)

class DeviceApprovalsPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    unlimited = None
    # Attribute is overwritten below the class definition
    zero = None
    # Attribute is overwritten below the class definition
    one = None
    # Attribute is overwritten below the class definition
    two = None
    # Attribute is overwritten below the class definition
    three = None
    # Attribute is overwritten below the class definition
    four = None
    # Attribute is overwritten below the class definition
    five = None
    # Attribute is overwritten below the class definition
    other = None

    def is_unlimited(self):
        """
        Check if the union tag is ``unlimited``.

        :rtype: bool
        """
        return self._tag == 'unlimited'

    def is_zero(self):
        """
        Check if the union tag is ``zero``.

        :rtype: bool
        """
        return self._tag == 'zero'

    def is_one(self):
        """
        Check if the union tag is ``one``.

        :rtype: bool
        """
        return self._tag == 'one'

    def is_two(self):
        """
        Check if the union tag is ``two``.

        :rtype: bool
        """
        return self._tag == 'two'

    def is_three(self):
        """
        Check if the union tag is ``three``.

        :rtype: bool
        """
        return self._tag == 'three'

    def is_four(self):
        """
        Check if the union tag is ``four``.

        :rtype: bool
        """
        return self._tag == 'four'

    def is_five(self):
        """
        Check if the union tag is ``five``.

        :rtype: bool
        """
        return self._tag == 'five'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'DeviceApprovalsPolicy(%r, %r)' % (self._tag, self._value)

DeviceApprovalsPolicy_validator = bv.Union(DeviceApprovalsPolicy)

class DeviceApprovalsRolloutPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    remove_oldest = None
    # Attribute is overwritten below the class definition
    remove_all = None
    # Attribute is overwritten below the class definition
    add_exception = None
    # Attribute is overwritten below the class definition
    other = None

    def is_remove_oldest(self):
        """
        Check if the union tag is ``remove_oldest``.

        :rtype: bool
        """
        return self._tag == 'remove_oldest'

    def is_remove_all(self):
        """
        Check if the union tag is ``remove_all``.

        :rtype: bool
        """
        return self._tag == 'remove_all'

    def is_add_exception(self):
        """
        Check if the union tag is ``add_exception``.

        :rtype: bool
        """
        return self._tag == 'add_exception'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'DeviceApprovalsRolloutPolicy(%r, %r)' % (self._tag, self._value)

DeviceApprovalsRolloutPolicy_validator = bv.Union(DeviceApprovalsRolloutPolicy)

class DeviceChangeIpDesktopDetails(object):
    """
    IP address associated with active desktop session changed.

    :ivar device_info: Device information.
    """

    __slots__ = [
        '_device_info_value',
        '_device_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_info=None):
        self._device_info_value = None
        self._device_info_present = False
        if device_info is not None:
            self.device_info = device_info

    @property
    def device_info(self):
        """
        Device information.

        :rtype: DeviceLogInfo
        """
        if self._device_info_present:
            return self._device_info_value
        else:
            raise AttributeError("missing required field 'device_info'")

    @device_info.setter
    def device_info(self, val):
        self._device_info_validator.validate_type_only(val)
        self._device_info_value = val
        self._device_info_present = True

    @device_info.deleter
    def device_info(self):
        self._device_info_value = None
        self._device_info_present = False

    def __repr__(self):
        return 'DeviceChangeIpDesktopDetails(device_info={!r})'.format(
            self._device_info_value,
        )

DeviceChangeIpDesktopDetails_validator = bv.Struct(DeviceChangeIpDesktopDetails)

class DeviceChangeIpMobileDetails(object):
    """
    IP address associated with active mobile session changed.

    :ivar device_info: Device information.
    """

    __slots__ = [
        '_device_info_value',
        '_device_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_info=None):
        self._device_info_value = None
        self._device_info_present = False
        if device_info is not None:
            self.device_info = device_info

    @property
    def device_info(self):
        """
        Device information.

        :rtype: DeviceLogInfo
        """
        if self._device_info_present:
            return self._device_info_value
        else:
            raise AttributeError("missing required field 'device_info'")

    @device_info.setter
    def device_info(self, val):
        self._device_info_validator.validate_type_only(val)
        self._device_info_value = val
        self._device_info_present = True

    @device_info.deleter
    def device_info(self):
        self._device_info_value = None
        self._device_info_present = False

    def __repr__(self):
        return 'DeviceChangeIpMobileDetails(device_info={!r})'.format(
            self._device_info_value,
        )

DeviceChangeIpMobileDetails_validator = bv.Struct(DeviceChangeIpMobileDetails)

class DeviceChangeIpWebDetails(object):
    """
    IP address associated with active Web session changed.

    :ivar user_agent: Web browser name.
    """

    __slots__ = [
        '_user_agent_value',
        '_user_agent_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 user_agent=None):
        self._user_agent_value = None
        self._user_agent_present = False
        if user_agent is not None:
            self.user_agent = user_agent

    @property
    def user_agent(self):
        """
        Web browser name.

        :rtype: str
        """
        if self._user_agent_present:
            return self._user_agent_value
        else:
            raise AttributeError("missing required field 'user_agent'")

    @user_agent.setter
    def user_agent(self, val):
        val = self._user_agent_validator.validate(val)
        self._user_agent_value = val
        self._user_agent_present = True

    @user_agent.deleter
    def user_agent(self):
        self._user_agent_value = None
        self._user_agent_present = False

    def __repr__(self):
        return 'DeviceChangeIpWebDetails(user_agent={!r})'.format(
            self._user_agent_value,
        )

DeviceChangeIpWebDetails_validator = bv.Struct(DeviceChangeIpWebDetails)

class DeviceDeleteOnUnlinkFailDetails(object):
    """
    Failed to delete all files from an unlinked device.

    :ivar device_info: Device information.
    :ivar num_failures: The number of times that remote file deletion failed.
    """

    __slots__ = [
        '_device_info_value',
        '_device_info_present',
        '_num_failures_value',
        '_num_failures_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_info=None,
                 num_failures=None):
        self._device_info_value = None
        self._device_info_present = False
        self._num_failures_value = None
        self._num_failures_present = False
        if device_info is not None:
            self.device_info = device_info
        if num_failures is not None:
            self.num_failures = num_failures

    @property
    def device_info(self):
        """
        Device information.

        :rtype: DeviceLogInfo
        """
        if self._device_info_present:
            return self._device_info_value
        else:
            raise AttributeError("missing required field 'device_info'")

    @device_info.setter
    def device_info(self, val):
        self._device_info_validator.validate_type_only(val)
        self._device_info_value = val
        self._device_info_present = True

    @device_info.deleter
    def device_info(self):
        self._device_info_value = None
        self._device_info_present = False

    @property
    def num_failures(self):
        """
        The number of times that remote file deletion failed.

        :rtype: long
        """
        if self._num_failures_present:
            return self._num_failures_value
        else:
            raise AttributeError("missing required field 'num_failures'")

    @num_failures.setter
    def num_failures(self, val):
        val = self._num_failures_validator.validate(val)
        self._num_failures_value = val
        self._num_failures_present = True

    @num_failures.deleter
    def num_failures(self):
        self._num_failures_value = None
        self._num_failures_present = False

    def __repr__(self):
        return 'DeviceDeleteOnUnlinkFailDetails(device_info={!r}, num_failures={!r})'.format(
            self._device_info_value,
            self._num_failures_value,
        )

DeviceDeleteOnUnlinkFailDetails_validator = bv.Struct(DeviceDeleteOnUnlinkFailDetails)

class DeviceDeleteOnUnlinkSuccessDetails(object):
    """
    Deleted all files from an unlinked device.

    :ivar device_info: Device information.
    """

    __slots__ = [
        '_device_info_value',
        '_device_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_info=None):
        self._device_info_value = None
        self._device_info_present = False
        if device_info is not None:
            self.device_info = device_info

    @property
    def device_info(self):
        """
        Device information.

        :rtype: DeviceLogInfo
        """
        if self._device_info_present:
            return self._device_info_value
        else:
            raise AttributeError("missing required field 'device_info'")

    @device_info.setter
    def device_info(self, val):
        self._device_info_validator.validate_type_only(val)
        self._device_info_value = val
        self._device_info_present = True

    @device_info.deleter
    def device_info(self):
        self._device_info_value = None
        self._device_info_present = False

    def __repr__(self):
        return 'DeviceDeleteOnUnlinkSuccessDetails(device_info={!r})'.format(
            self._device_info_value,
        )

DeviceDeleteOnUnlinkSuccessDetails_validator = bv.Struct(DeviceDeleteOnUnlinkSuccessDetails)

class DeviceLinkFailDetails(object):
    """
    Failed to link a device.

    :ivar device_type: A description of the device used while user approval
        blocked.
    """

    __slots__ = [
        '_device_type_value',
        '_device_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_type=None):
        self._device_type_value = None
        self._device_type_present = False
        if device_type is not None:
            self.device_type = device_type

    @property
    def device_type(self):
        """
        A description of the device used while user approval blocked.

        :rtype: DeviceType
        """
        if self._device_type_present:
            return self._device_type_value
        else:
            raise AttributeError("missing required field 'device_type'")

    @device_type.setter
    def device_type(self, val):
        self._device_type_validator.validate_type_only(val)
        self._device_type_value = val
        self._device_type_present = True

    @device_type.deleter
    def device_type(self):
        self._device_type_value = None
        self._device_type_present = False

    def __repr__(self):
        return 'DeviceLinkFailDetails(device_type={!r})'.format(
            self._device_type_value,
        )

DeviceLinkFailDetails_validator = bv.Struct(DeviceLinkFailDetails)

class DeviceLinkSuccessDetails(object):
    """
    Linked a device.

    :ivar device_info: Device information.
    :ivar app_version: Linking app version. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_device_info_value',
        '_device_info_present',
        '_app_version_value',
        '_app_version_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_info=None,
                 app_version=None):
        self._device_info_value = None
        self._device_info_present = False
        self._app_version_value = None
        self._app_version_present = False
        if device_info is not None:
            self.device_info = device_info
        if app_version is not None:
            self.app_version = app_version

    @property
    def device_info(self):
        """
        Device information.

        :rtype: DeviceLogInfo
        """
        if self._device_info_present:
            return self._device_info_value
        else:
            raise AttributeError("missing required field 'device_info'")

    @device_info.setter
    def device_info(self, val):
        self._device_info_validator.validate_type_only(val)
        self._device_info_value = val
        self._device_info_present = True

    @device_info.deleter
    def device_info(self):
        self._device_info_value = None
        self._device_info_present = False

    @property
    def app_version(self):
        """
        Linking app version. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._app_version_present:
            return self._app_version_value
        else:
            return None

    @app_version.setter
    def app_version(self, val):
        if val is None:
            del self.app_version
            return
        val = self._app_version_validator.validate(val)
        self._app_version_value = val
        self._app_version_present = True

    @app_version.deleter
    def app_version(self):
        self._app_version_value = None
        self._app_version_present = False

    def __repr__(self):
        return 'DeviceLinkSuccessDetails(device_info={!r}, app_version={!r})'.format(
            self._device_info_value,
            self._app_version_value,
        )

DeviceLinkSuccessDetails_validator = bv.Struct(DeviceLinkSuccessDetails)

class DeviceLogInfo(object):
    """
    Device's logged information.

    :ivar device_id: Device unique id. Might be missing due to historical data
        gap.
    :ivar display_name: Device display name. Might be missing due to historical
        data gap.
    :ivar is_emm_managed: True if this device is emm managed, false otherwise.
        Might be missing due to historical data gap.
    :ivar platform: Device platform name. Might be missing due to historical
        data gap.
    :ivar mac_address: Device mac address. Might be missing due to historical
        data gap.
    :ivar os_version: Device OS version. Might be missing due to historical data
        gap.
    :ivar device_type: Device type. Might be missing due to historical data gap.
    :ivar ip_address: IP address. Might be missing due to historical data gap.
    :ivar last_activity: Last activity. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_device_id_value',
        '_device_id_present',
        '_display_name_value',
        '_display_name_present',
        '_is_emm_managed_value',
        '_is_emm_managed_present',
        '_platform_value',
        '_platform_present',
        '_mac_address_value',
        '_mac_address_present',
        '_os_version_value',
        '_os_version_present',
        '_device_type_value',
        '_device_type_present',
        '_ip_address_value',
        '_ip_address_present',
        '_last_activity_value',
        '_last_activity_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 device_id=None,
                 display_name=None,
                 is_emm_managed=None,
                 platform=None,
                 mac_address=None,
                 os_version=None,
                 device_type=None,
                 ip_address=None,
                 last_activity=None):
        self._device_id_value = None
        self._device_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._is_emm_managed_value = None
        self._is_emm_managed_present = False
        self._platform_value = None
        self._platform_present = False
        self._mac_address_value = None
        self._mac_address_present = False
        self._os_version_value = None
        self._os_version_present = False
        self._device_type_value = None
        self._device_type_present = False
        self._ip_address_value = None
        self._ip_address_present = False
        self._last_activity_value = None
        self._last_activity_present = False
        if device_id is not None:
            self.device_id = device_id
        if display_name is not None:
            self.display_name = display_name
        if is_emm_managed is not None:
            self.is_emm_managed = is_emm_managed
        if platform is not None:
            self.platform = platform
        if mac_address is not None:
            self.mac_address = mac_address
        if os_version is not None:
            self.os_version = os_version
        if device_type is not None:
            self.device_type = device_type
        if ip_address is not None:
            self.ip_address = ip_address
        if last_activity is not None:
            self.last_activity = last_activity

    @property
    def device_id(self):
        """
        Device unique id. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._device_id_present:
            return self._device_id_value
        else:
            return None

    @device_id.setter
    def device_id(self, val):
        if val is None:
            del self.device_id
            return
        val = self._device_id_validator.validate(val)
        self._device_id_value = val
        self._device_id_present = True

    @device_id.deleter
    def device_id(self):
        self._device_id_value = None
        self._device_id_present = False

    @property
    def display_name(self):
        """
        Device display name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def is_emm_managed(self):
        """
        True if this device is emm managed, false otherwise. Might be missing
        due to historical data gap.

        :rtype: bool
        """
        if self._is_emm_managed_present:
            return self._is_emm_managed_value
        else:
            return None

    @is_emm_managed.setter
    def is_emm_managed(self, val):
        if val is None:
            del self.is_emm_managed
            return
        val = self._is_emm_managed_validator.validate(val)
        self._is_emm_managed_value = val
        self._is_emm_managed_present = True

    @is_emm_managed.deleter
    def is_emm_managed(self):
        self._is_emm_managed_value = None
        self._is_emm_managed_present = False

    @property
    def platform(self):
        """
        Device platform name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._platform_present:
            return self._platform_value
        else:
            return None

    @platform.setter
    def platform(self, val):
        if val is None:
            del self.platform
            return
        val = self._platform_validator.validate(val)
        self._platform_value = val
        self._platform_present = True

    @platform.deleter
    def platform(self):
        self._platform_value = None
        self._platform_present = False

    @property
    def mac_address(self):
        """
        Device mac address. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._mac_address_present:
            return self._mac_address_value
        else:
            return None

    @mac_address.setter
    def mac_address(self, val):
        if val is None:
            del self.mac_address
            return
        val = self._mac_address_validator.validate(val)
        self._mac_address_value = val
        self._mac_address_present = True

    @mac_address.deleter
    def mac_address(self):
        self._mac_address_value = None
        self._mac_address_present = False

    @property
    def os_version(self):
        """
        Device OS version. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._os_version_present:
            return self._os_version_value
        else:
            return None

    @os_version.setter
    def os_version(self, val):
        if val is None:
            del self.os_version
            return
        val = self._os_version_validator.validate(val)
        self._os_version_value = val
        self._os_version_present = True

    @os_version.deleter
    def os_version(self):
        self._os_version_value = None
        self._os_version_present = False

    @property
    def device_type(self):
        """
        Device type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._device_type_present:
            return self._device_type_value
        else:
            return None

    @device_type.setter
    def device_type(self, val):
        if val is None:
            del self.device_type
            return
        val = self._device_type_validator.validate(val)
        self._device_type_value = val
        self._device_type_present = True

    @device_type.deleter
    def device_type(self):
        self._device_type_value = None
        self._device_type_present = False

    @property
    def ip_address(self):
        """
        IP address. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._ip_address_present:
            return self._ip_address_value
        else:
            return None

    @ip_address.setter
    def ip_address(self, val):
        if val is None:
            del self.ip_address
            return
        val = self._ip_address_validator.validate(val)
        self._ip_address_value = val
        self._ip_address_present = True

    @ip_address.deleter
    def ip_address(self):
        self._ip_address_value = None
        self._ip_address_present = False

    @property
    def last_activity(self):
        """
        Last activity. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._last_activity_present:
            return self._last_activity_value
        else:
            return None

    @last_activity.setter
    def last_activity(self, val):
        if val is None:
            del self.last_activity
            return
        val = self._last_activity_validator.validate(val)
        self._last_activity_value = val
        self._last_activity_present = True

    @last_activity.deleter
    def last_activity(self):
        self._last_activity_value = None
        self._last_activity_present = False

    def __repr__(self):
        return 'DeviceLogInfo(device_id={!r}, display_name={!r}, is_emm_managed={!r}, platform={!r}, mac_address={!r}, os_version={!r}, device_type={!r}, ip_address={!r}, last_activity={!r})'.format(
            self._device_id_value,
            self._display_name_value,
            self._is_emm_managed_value,
            self._platform_value,
            self._mac_address_value,
            self._os_version_value,
            self._device_type_value,
            self._ip_address_value,
            self._last_activity_value,
        )

DeviceLogInfo_validator = bv.Struct(DeviceLogInfo)

class DeviceManagementDisabledDetails(object):
    """
    Disable Device Management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DeviceManagementDisabledDetails()'

DeviceManagementDisabledDetails_validator = bv.Struct(DeviceManagementDisabledDetails)

class DeviceManagementEnabledDetails(object):
    """
    Enable Device Management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DeviceManagementEnabledDetails()'

DeviceManagementEnabledDetails_validator = bv.Struct(DeviceManagementEnabledDetails)

class DeviceType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    mobile = None
    # Attribute is overwritten below the class definition
    desktop = None
    # Attribute is overwritten below the class definition
    other = None

    def is_mobile(self):
        """
        Check if the union tag is ``mobile``.

        :rtype: bool
        """
        return self._tag == 'mobile'

    def is_desktop(self):
        """
        Check if the union tag is ``desktop``.

        :rtype: bool
        """
        return self._tag == 'desktop'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'DeviceType(%r, %r)' % (self._tag, self._value)

DeviceType_validator = bv.Union(DeviceType)

class DeviceUnlinkDetails(object):
    """
    Disconnected a device.

    :ivar device_info: Device information.
    :ivar delete_data: True if the user requested to delete data after device
        unlink, false otherwise.
    """

    __slots__ = [
        '_device_info_value',
        '_device_info_present',
        '_delete_data_value',
        '_delete_data_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 device_info=None,
                 delete_data=None):
        self._device_info_value = None
        self._device_info_present = False
        self._delete_data_value = None
        self._delete_data_present = False
        if device_info is not None:
            self.device_info = device_info
        if delete_data is not None:
            self.delete_data = delete_data

    @property
    def device_info(self):
        """
        Device information.

        :rtype: DeviceLogInfo
        """
        if self._device_info_present:
            return self._device_info_value
        else:
            raise AttributeError("missing required field 'device_info'")

    @device_info.setter
    def device_info(self, val):
        self._device_info_validator.validate_type_only(val)
        self._device_info_value = val
        self._device_info_present = True

    @device_info.deleter
    def device_info(self):
        self._device_info_value = None
        self._device_info_present = False

    @property
    def delete_data(self):
        """
        True if the user requested to delete data after device unlink, false
        otherwise.

        :rtype: bool
        """
        if self._delete_data_present:
            return self._delete_data_value
        else:
            raise AttributeError("missing required field 'delete_data'")

    @delete_data.setter
    def delete_data(self, val):
        val = self._delete_data_validator.validate(val)
        self._delete_data_value = val
        self._delete_data_present = True

    @delete_data.deleter
    def delete_data(self):
        self._delete_data_value = None
        self._delete_data_present = False

    def __repr__(self):
        return 'DeviceUnlinkDetails(device_info={!r}, delete_data={!r})'.format(
            self._device_info_value,
            self._delete_data_value,
        )

DeviceUnlinkDetails_validator = bv.Struct(DeviceUnlinkDetails)

class DeviceUnlinkPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    remove = None
    # Attribute is overwritten below the class definition
    keep = None
    # Attribute is overwritten below the class definition
    other = None

    def is_remove(self):
        """
        Check if the union tag is ``remove``.

        :rtype: bool
        """
        return self._tag == 'remove'

    def is_keep(self):
        """
        Check if the union tag is ``keep``.

        :rtype: bool
        """
        return self._tag == 'keep'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'DeviceUnlinkPolicy(%r, %r)' % (self._tag, self._value)

DeviceUnlinkPolicy_validator = bv.Union(DeviceUnlinkPolicy)

class DisabledDomainInvitesDetails(object):
    """
    Disabled domain invites.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DisabledDomainInvitesDetails()'

DisabledDomainInvitesDetails_validator = bv.Struct(DisabledDomainInvitesDetails)

class DomainInvitesApproveRequestToJoinTeamDetails(object):
    """
    Approved a member's request to join the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DomainInvitesApproveRequestToJoinTeamDetails()'

DomainInvitesApproveRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesApproveRequestToJoinTeamDetails)

class DomainInvitesDeclineRequestToJoinTeamDetails(object):
    """
    Declined a user's request to join the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DomainInvitesDeclineRequestToJoinTeamDetails()'

DomainInvitesDeclineRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesDeclineRequestToJoinTeamDetails)

class DomainInvitesEmailExistingUsersDetails(object):
    """
    Sent domain invites to existing domain accounts.

    :ivar domain_name: Domain names.
    :ivar num_recipients: Number of recipients.
    """

    __slots__ = [
        '_domain_name_value',
        '_domain_name_present',
        '_num_recipients_value',
        '_num_recipients_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_name=None,
                 num_recipients=None):
        self._domain_name_value = None
        self._domain_name_present = False
        self._num_recipients_value = None
        self._num_recipients_present = False
        if domain_name is not None:
            self.domain_name = domain_name
        if num_recipients is not None:
            self.num_recipients = num_recipients

    @property
    def domain_name(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_name_present:
            return self._domain_name_value
        else:
            raise AttributeError("missing required field 'domain_name'")

    @domain_name.setter
    def domain_name(self, val):
        val = self._domain_name_validator.validate(val)
        self._domain_name_value = val
        self._domain_name_present = True

    @domain_name.deleter
    def domain_name(self):
        self._domain_name_value = None
        self._domain_name_present = False

    @property
    def num_recipients(self):
        """
        Number of recipients.

        :rtype: long
        """
        if self._num_recipients_present:
            return self._num_recipients_value
        else:
            raise AttributeError("missing required field 'num_recipients'")

    @num_recipients.setter
    def num_recipients(self, val):
        val = self._num_recipients_validator.validate(val)
        self._num_recipients_value = val
        self._num_recipients_present = True

    @num_recipients.deleter
    def num_recipients(self):
        self._num_recipients_value = None
        self._num_recipients_present = False

    def __repr__(self):
        return 'DomainInvitesEmailExistingUsersDetails(domain_name={!r}, num_recipients={!r})'.format(
            self._domain_name_value,
            self._num_recipients_value,
        )

DomainInvitesEmailExistingUsersDetails_validator = bv.Struct(DomainInvitesEmailExistingUsersDetails)

class DomainInvitesRequestToJoinTeamDetails(object):
    """
    Asked to join the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DomainInvitesRequestToJoinTeamDetails()'

DomainInvitesRequestToJoinTeamDetails_validator = bv.Struct(DomainInvitesRequestToJoinTeamDetails)

class DomainInvitesSetInviteNewUserPrefToNoDetails(object):
    """
    Turned off u201cAutomatically invite new usersu201d.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DomainInvitesSetInviteNewUserPrefToNoDetails()'

DomainInvitesSetInviteNewUserPrefToNoDetails_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToNoDetails)

class DomainInvitesSetInviteNewUserPrefToYesDetails(object):
    """
    Turned on u201cAutomatically invite new usersu201d.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'DomainInvitesSetInviteNewUserPrefToYesDetails()'

DomainInvitesSetInviteNewUserPrefToYesDetails_validator = bv.Struct(DomainInvitesSetInviteNewUserPrefToYesDetails)

class DomainVerificationAddDomainFailDetails(object):
    """
    Failed to verify a domain belonging to the team.

    :ivar domain_names: Domain names.
    :ivar verification_method: Domain name verification method.
    """

    __slots__ = [
        '_domain_names_value',
        '_domain_names_present',
        '_verification_method_value',
        '_verification_method_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None,
                 verification_method=None):
        self._domain_names_value = None
        self._domain_names_present = False
        self._verification_method_value = None
        self._verification_method_present = False
        if domain_names is not None:
            self.domain_names = domain_names
        if verification_method is not None:
            self.verification_method = verification_method

    @property
    def domain_names(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_names_present:
            return self._domain_names_value
        else:
            raise AttributeError("missing required field 'domain_names'")

    @domain_names.setter
    def domain_names(self, val):
        val = self._domain_names_validator.validate(val)
        self._domain_names_value = val
        self._domain_names_present = True

    @domain_names.deleter
    def domain_names(self):
        self._domain_names_value = None
        self._domain_names_present = False

    @property
    def verification_method(self):
        """
        Domain name verification method.

        :rtype: str
        """
        if self._verification_method_present:
            return self._verification_method_value
        else:
            return None

    @verification_method.setter
    def verification_method(self, val):
        if val is None:
            del self.verification_method
            return
        val = self._verification_method_validator.validate(val)
        self._verification_method_value = val
        self._verification_method_present = True

    @verification_method.deleter
    def verification_method(self):
        self._verification_method_value = None
        self._verification_method_present = False

    def __repr__(self):
        return 'DomainVerificationAddDomainFailDetails(domain_names={!r}, verification_method={!r})'.format(
            self._domain_names_value,
            self._verification_method_value,
        )

DomainVerificationAddDomainFailDetails_validator = bv.Struct(DomainVerificationAddDomainFailDetails)

class DomainVerificationAddDomainSuccessDetails(object):
    """
    Verified a domain belonging to the team.

    :ivar domain_names: Domain names.
    :ivar verification_method: Domain name verification method.
    """

    __slots__ = [
        '_domain_names_value',
        '_domain_names_present',
        '_verification_method_value',
        '_verification_method_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None,
                 verification_method=None):
        self._domain_names_value = None
        self._domain_names_present = False
        self._verification_method_value = None
        self._verification_method_present = False
        if domain_names is not None:
            self.domain_names = domain_names
        if verification_method is not None:
            self.verification_method = verification_method

    @property
    def domain_names(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_names_present:
            return self._domain_names_value
        else:
            raise AttributeError("missing required field 'domain_names'")

    @domain_names.setter
    def domain_names(self, val):
        val = self._domain_names_validator.validate(val)
        self._domain_names_value = val
        self._domain_names_present = True

    @domain_names.deleter
    def domain_names(self):
        self._domain_names_value = None
        self._domain_names_present = False

    @property
    def verification_method(self):
        """
        Domain name verification method.

        :rtype: str
        """
        if self._verification_method_present:
            return self._verification_method_value
        else:
            return None

    @verification_method.setter
    def verification_method(self, val):
        if val is None:
            del self.verification_method
            return
        val = self._verification_method_validator.validate(val)
        self._verification_method_value = val
        self._verification_method_present = True

    @verification_method.deleter
    def verification_method(self):
        self._verification_method_value = None
        self._verification_method_present = False

    def __repr__(self):
        return 'DomainVerificationAddDomainSuccessDetails(domain_names={!r}, verification_method={!r})'.format(
            self._domain_names_value,
            self._verification_method_value,
        )

DomainVerificationAddDomainSuccessDetails_validator = bv.Struct(DomainVerificationAddDomainSuccessDetails)

class DomainVerificationRemoveDomainDetails(object):
    """
    Removed a domain from the list of verified domains belonging to the team.

    :ivar domain_names: Domain names.
    """

    __slots__ = [
        '_domain_names_value',
        '_domain_names_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 domain_names=None):
        self._domain_names_value = None
        self._domain_names_present = False
        if domain_names is not None:
            self.domain_names = domain_names

    @property
    def domain_names(self):
        """
        Domain names.

        :rtype: list of [str]
        """
        if self._domain_names_present:
            return self._domain_names_value
        else:
            raise AttributeError("missing required field 'domain_names'")

    @domain_names.setter
    def domain_names(self, val):
        val = self._domain_names_validator.validate(val)
        self._domain_names_value = val
        self._domain_names_present = True

    @domain_names.deleter
    def domain_names(self):
        self._domain_names_value = None
        self._domain_names_present = False

    def __repr__(self):
        return 'DomainVerificationRemoveDomainDetails(domain_names={!r})'.format(
            self._domain_names_value,
        )

DomainVerificationRemoveDomainDetails_validator = bv.Struct(DomainVerificationRemoveDomainDetails)

class EmmAddExceptionDetails(object):
    """
    Added an exception for one or more team members to optionally use the
    regular Dropbox app when EMM is enabled.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EmmAddExceptionDetails()'

EmmAddExceptionDetails_validator = bv.Struct(EmmAddExceptionDetails)

class EmmChangePolicyDetails(object):
    """
    Enabled or disabled enterprise mobility management for team members.

    :ivar new_value: New enterprise mobility management policy.
    :ivar previous_value: Previous enterprise mobility management policy. Might
        be missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New enterprise mobility management policy.

        :rtype: OptionalChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous enterprise mobility management policy. Might be missing due to
        historical data gap.

        :rtype: OptionalChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'EmmChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

EmmChangePolicyDetails_validator = bv.Struct(EmmChangePolicyDetails)

class EmmCreateExceptionsReportDetails(object):
    """
    EMM excluded users report created.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EmmCreateExceptionsReportDetails()'

EmmCreateExceptionsReportDetails_validator = bv.Struct(EmmCreateExceptionsReportDetails)

class EmmCreateUsageReportDetails(object):
    """
    EMM mobile app usage report created.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EmmCreateUsageReportDetails()'

EmmCreateUsageReportDetails_validator = bv.Struct(EmmCreateUsageReportDetails)

class EmmLoginSuccessDetails(object):
    """
    Signed in using the Dropbox EMM app.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EmmLoginSuccessDetails()'

EmmLoginSuccessDetails_validator = bv.Struct(EmmLoginSuccessDetails)

class EmmRefreshAuthTokenDetails(object):
    """
    Refreshed the auth token used for setting up enterprise mobility management.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EmmRefreshAuthTokenDetails()'

EmmRefreshAuthTokenDetails_validator = bv.Struct(EmmRefreshAuthTokenDetails)

class EmmRemoveExceptionDetails(object):
    """
    Removed an exception for one or more team members to optionally use the
    regular Dropbox app when EMM is enabled.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EmmRemoveExceptionDetails()'

EmmRemoveExceptionDetails_validator = bv.Struct(EmmRemoveExceptionDetails)

class EnableDisableChangePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    enabled = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_enabled(self):
        """
        Check if the union tag is ``enabled``.

        :rtype: bool
        """
        return self._tag == 'enabled'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'EnableDisableChangePolicy(%r, %r)' % (self._tag, self._value)

EnableDisableChangePolicy_validator = bv.Union(EnableDisableChangePolicy)

class EnabledDomainInvitesDetails(object):
    """
    Enabled domain invites.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'EnabledDomainInvitesDetails()'

EnabledDomainInvitesDetails_validator = bv.Struct(EnabledDomainInvitesDetails)

class EventCategory(bb.Union):
    """
    Category of events in event audit log.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar account_capture: Events that have to do with account capture and
        invite enforcement on team-owned domains.
    :ivar administration: Events that relate to team and team member account
        administration or team administration. Note that these actions are not
        necessarily performed by team admins. They might also be performed by
        Dropbox Support or System or by team members on their own accounts.
    :ivar apps: Events that apply to management of linked apps.
    :ivar authentication: Events that apply to user authentication in some way.
    :ivar comments: Events that have to do with comments on files and Paper
        documents.
    :ivar content_access: Events that apply to changes how people can access
        content on Dropbox as well as actions that represent actually accessing
        content.
    :ivar devices: Events that apply to linked devices on mobile, desktop and
        Web platforms.
    :ivar device_approvals: Events that concern device approvals and device
        management.
    :ivar domains: Events that involve domain management feature: domain
        verification, invite enforcement and account capture.
    :ivar emm: Events that involve enterprise mobility management and the
        Dropbox EMM app.
    :ivar errors: Events that mark some type of unexpected outcome.
    :ivar files: Events that mark a user's interaction with files and folders on
        Dropbox.
    :ivar file_operations: Events that have to do with filesystem operations on
        files and folders: copy, move, delete, etc.
    :ivar file_requests: Events that apply to the file requests feature.
    :ivar groups: Events that involve group management.
    :ivar logins: Events that involve users signing in to or out of Dropbox.
    :ivar members: Events that involve team member management.
    :ivar paper: Events that apply to Dropbox Paper.
    :ivar passwords: Events that involve using, changing or resetting passwords.
    :ivar reports: Events that concern generation of admin reports, including
        team activity and device usage.
    :ivar sessions: Events that mark the beginning or end of sessions as well as
        those that apply to an ongoing session.
    :ivar shared_files: Events that specifically apply to shared files.
    :ivar shared_folders: Events that specifically apply to shared folders.
    :ivar shared_links: Events that specifically apply to link sharing.
    :ivar sharing: Events that apply to all types of sharing and collaboration.
    :ivar sharing_policies: Events that concern policies that affect sharing -
        both at the team level and at the folder level.
    :ivar sso: Events that involve using or configuring single sign-on as well
        as administrative policies concerning single sign-on.
    :ivar team_folders: Events that involve team folder management.
    :ivar team_policies: Events that involve a change in team-wide policies.
    :ivar team_profile: Events that involve a change in the team profile.
    :ivar tfa: Events that involve using or configuring two factor
        authentication as well as administrative policies concerning two factor
        authentication.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    account_capture = None
    # Attribute is overwritten below the class definition
    administration = None
    # Attribute is overwritten below the class definition
    apps = None
    # Attribute is overwritten below the class definition
    authentication = None
    # Attribute is overwritten below the class definition
    comments = None
    # Attribute is overwritten below the class definition
    content_access = None
    # Attribute is overwritten below the class definition
    devices = None
    # Attribute is overwritten below the class definition
    device_approvals = None
    # Attribute is overwritten below the class definition
    domains = None
    # Attribute is overwritten below the class definition
    emm = None
    # Attribute is overwritten below the class definition
    errors = None
    # Attribute is overwritten below the class definition
    files = None
    # Attribute is overwritten below the class definition
    file_operations = None
    # Attribute is overwritten below the class definition
    file_requests = None
    # Attribute is overwritten below the class definition
    groups = None
    # Attribute is overwritten below the class definition
    logins = None
    # Attribute is overwritten below the class definition
    members = None
    # Attribute is overwritten below the class definition
    paper = None
    # Attribute is overwritten below the class definition
    passwords = None
    # Attribute is overwritten below the class definition
    reports = None
    # Attribute is overwritten below the class definition
    sessions = None
    # Attribute is overwritten below the class definition
    shared_files = None
    # Attribute is overwritten below the class definition
    shared_folders = None
    # Attribute is overwritten below the class definition
    shared_links = None
    # Attribute is overwritten below the class definition
    sharing = None
    # Attribute is overwritten below the class definition
    sharing_policies = None
    # Attribute is overwritten below the class definition
    sso = None
    # Attribute is overwritten below the class definition
    team_folders = None
    # Attribute is overwritten below the class definition
    team_policies = None
    # Attribute is overwritten below the class definition
    team_profile = None
    # Attribute is overwritten below the class definition
    tfa = None
    # Attribute is overwritten below the class definition
    other = None

    def is_account_capture(self):
        """
        Check if the union tag is ``account_capture``.

        :rtype: bool
        """
        return self._tag == 'account_capture'

    def is_administration(self):
        """
        Check if the union tag is ``administration``.

        :rtype: bool
        """
        return self._tag == 'administration'

    def is_apps(self):
        """
        Check if the union tag is ``apps``.

        :rtype: bool
        """
        return self._tag == 'apps'

    def is_authentication(self):
        """
        Check if the union tag is ``authentication``.

        :rtype: bool
        """
        return self._tag == 'authentication'

    def is_comments(self):
        """
        Check if the union tag is ``comments``.

        :rtype: bool
        """
        return self._tag == 'comments'

    def is_content_access(self):
        """
        Check if the union tag is ``content_access``.

        :rtype: bool
        """
        return self._tag == 'content_access'

    def is_devices(self):
        """
        Check if the union tag is ``devices``.

        :rtype: bool
        """
        return self._tag == 'devices'

    def is_device_approvals(self):
        """
        Check if the union tag is ``device_approvals``.

        :rtype: bool
        """
        return self._tag == 'device_approvals'

    def is_domains(self):
        """
        Check if the union tag is ``domains``.

        :rtype: bool
        """
        return self._tag == 'domains'

    def is_emm(self):
        """
        Check if the union tag is ``emm``.

        :rtype: bool
        """
        return self._tag == 'emm'

    def is_errors(self):
        """
        Check if the union tag is ``errors``.

        :rtype: bool
        """
        return self._tag == 'errors'

    def is_files(self):
        """
        Check if the union tag is ``files``.

        :rtype: bool
        """
        return self._tag == 'files'

    def is_file_operations(self):
        """
        Check if the union tag is ``file_operations``.

        :rtype: bool
        """
        return self._tag == 'file_operations'

    def is_file_requests(self):
        """
        Check if the union tag is ``file_requests``.

        :rtype: bool
        """
        return self._tag == 'file_requests'

    def is_groups(self):
        """
        Check if the union tag is ``groups``.

        :rtype: bool
        """
        return self._tag == 'groups'

    def is_logins(self):
        """
        Check if the union tag is ``logins``.

        :rtype: bool
        """
        return self._tag == 'logins'

    def is_members(self):
        """
        Check if the union tag is ``members``.

        :rtype: bool
        """
        return self._tag == 'members'

    def is_paper(self):
        """
        Check if the union tag is ``paper``.

        :rtype: bool
        """
        return self._tag == 'paper'

    def is_passwords(self):
        """
        Check if the union tag is ``passwords``.

        :rtype: bool
        """
        return self._tag == 'passwords'

    def is_reports(self):
        """
        Check if the union tag is ``reports``.

        :rtype: bool
        """
        return self._tag == 'reports'

    def is_sessions(self):
        """
        Check if the union tag is ``sessions``.

        :rtype: bool
        """
        return self._tag == 'sessions'

    def is_shared_files(self):
        """
        Check if the union tag is ``shared_files``.

        :rtype: bool
        """
        return self._tag == 'shared_files'

    def is_shared_folders(self):
        """
        Check if the union tag is ``shared_folders``.

        :rtype: bool
        """
        return self._tag == 'shared_folders'

    def is_shared_links(self):
        """
        Check if the union tag is ``shared_links``.

        :rtype: bool
        """
        return self._tag == 'shared_links'

    def is_sharing(self):
        """
        Check if the union tag is ``sharing``.

        :rtype: bool
        """
        return self._tag == 'sharing'

    def is_sharing_policies(self):
        """
        Check if the union tag is ``sharing_policies``.

        :rtype: bool
        """
        return self._tag == 'sharing_policies'

    def is_sso(self):
        """
        Check if the union tag is ``sso``.

        :rtype: bool
        """
        return self._tag == 'sso'

    def is_team_folders(self):
        """
        Check if the union tag is ``team_folders``.

        :rtype: bool
        """
        return self._tag == 'team_folders'

    def is_team_policies(self):
        """
        Check if the union tag is ``team_policies``.

        :rtype: bool
        """
        return self._tag == 'team_policies'

    def is_team_profile(self):
        """
        Check if the union tag is ``team_profile``.

        :rtype: bool
        """
        return self._tag == 'team_profile'

    def is_tfa(self):
        """
        Check if the union tag is ``tfa``.

        :rtype: bool
        """
        return self._tag == 'tfa'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'EventCategory(%r, %r)' % (self._tag, self._value)

EventCategory_validator = bv.Union(EventCategory)

class EventDetails(bb.Union):
    """
    Additional fields depending on the event type.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar MemberChangeMembershipTypeDetails
        member_change_membership_type_details: Changed the membership type
        (limited vs full) for team member.
    :ivar MemberPermanentlyDeleteAccountContentsDetails
        member_permanently_delete_account_contents_details: Permanently deleted
        contents of a removed team member account.
    :ivar MemberSpaceLimitsChangeStatusDetails
        member_space_limits_change_status_details: Changed the status with
        respect to whether the team member is under or over storage quota
        specified by policy.
    :ivar MemberTransferAccountContentsDetails
        member_transfer_account_contents_details: Transferred contents of a
        removed team member account to another member.
    :ivar PaperEnabledUsersGroupAdditionDetails
        paper_enabled_users_group_addition_details: Users added to Paper enabled
        users list.
    :ivar PaperEnabledUsersGroupRemovalDetails
        paper_enabled_users_group_removal_details: Users removed from Paper
        enabled users list.
    :ivar PaperExternalViewAllowDetails paper_external_view_allow_details: Paper
        external sharing policy changed: anyone.
    :ivar PaperExternalViewDefaultTeamDetails
        paper_external_view_default_team_details: Paper external sharing policy
        changed: default team.
    :ivar PaperExternalViewForbidDetails paper_external_view_forbid_details:
        Paper external sharing policy changed: team-only.
    :ivar SfExternalInviteWarnDetails sf_external_invite_warn_details: Admin
        settings: team members see a warning before sharing folders outside the
        team (DEPRECATED FEATURE).
    :ivar TeamMergeDetails team_merge_details: Merged the team into another
        team.
    :ivar AppLinkTeamDetails app_link_team_details: Linked an app for team.
    :ivar AppLinkUserDetails app_link_user_details: Linked an app for team
        member.
    :ivar AppUnlinkTeamDetails app_unlink_team_details: Unlinked an app for
        team.
    :ivar AppUnlinkUserDetails app_unlink_user_details: Unlinked an app for team
        member.
    :ivar DeviceChangeIpDesktopDetails device_change_ip_desktop_details: IP
        address associated with active desktop session changed.
    :ivar DeviceChangeIpMobileDetails device_change_ip_mobile_details: IP
        address associated with active mobile session changed.
    :ivar DeviceChangeIpWebDetails device_change_ip_web_details: IP address
        associated with active Web session changed.
    :ivar DeviceDeleteOnUnlinkFailDetails device_delete_on_unlink_fail_details:
        Failed to delete all files from an unlinked device.
    :ivar DeviceDeleteOnUnlinkSuccessDetails
        device_delete_on_unlink_success_details: Deleted all files from an
        unlinked device.
    :ivar DeviceLinkFailDetails device_link_fail_details: Failed to link a
        device.
    :ivar DeviceLinkSuccessDetails device_link_success_details: Linked a device.
    :ivar DeviceManagementDisabledDetails device_management_disabled_details:
        Disable Device Management.
    :ivar DeviceManagementEnabledDetails device_management_enabled_details:
        Enable Device Management.
    :ivar DeviceUnlinkDetails device_unlink_details: Disconnected a device.
    :ivar EmmRefreshAuthTokenDetails emm_refresh_auth_token_details: Refreshed
        the auth token used for setting up enterprise mobility management.
    :ivar AccountCaptureChangeAvailabilityDetails
        account_capture_change_availability_details: Granted or revoked the
        option to enable account capture on domains belonging to the team.
    :ivar AccountCaptureMigrateAccountDetails
        account_capture_migrate_account_details: Account captured user migrated
        their account to the team.
    :ivar AccountCaptureRelinquishAccountDetails
        account_capture_relinquish_account_details: Account captured user
        relinquished their account by changing the email address associated with
        it.
    :ivar DisabledDomainInvitesDetails disabled_domain_invites_details: Disabled
        domain invites.
    :ivar DomainInvitesApproveRequestToJoinTeamDetails
        domain_invites_approve_request_to_join_team_details: Approved a member's
        request to join the team.
    :ivar DomainInvitesDeclineRequestToJoinTeamDetails
        domain_invites_decline_request_to_join_team_details: Declined a user's
        request to join the team.
    :ivar DomainInvitesEmailExistingUsersDetails
        domain_invites_email_existing_users_details: Sent domain invites to
        existing domain accounts.
    :ivar DomainInvitesRequestToJoinTeamDetails
        domain_invites_request_to_join_team_details: Asked to join the team.
    :ivar DomainInvitesSetInviteNewUserPrefToNoDetails
        domain_invites_set_invite_new_user_pref_to_no_details: Turned off
        u201cAutomatically invite new usersu201d.
    :ivar DomainInvitesSetInviteNewUserPrefToYesDetails
        domain_invites_set_invite_new_user_pref_to_yes_details: Turned on
        u201cAutomatically invite new usersu201d.
    :ivar DomainVerificationAddDomainFailDetails
        domain_verification_add_domain_fail_details: Failed to verify a domain
        belonging to the team.
    :ivar DomainVerificationAddDomainSuccessDetails
        domain_verification_add_domain_success_details: Verified a domain
        belonging to the team.
    :ivar DomainVerificationRemoveDomainDetails
        domain_verification_remove_domain_details: Removed a domain from the
        list of verified domains belonging to the team.
    :ivar EnabledDomainInvitesDetails enabled_domain_invites_details: Enabled
        domain invites.
    :ivar CreateFolderDetails create_folder_details: Created folders.
    :ivar FileAddDetails file_add_details: Added files and/or folders.
    :ivar FileCopyDetails file_copy_details: Copied files and/or folders.
    :ivar FileDeleteDetails file_delete_details: Deleted files and/or folders.
    :ivar FileDownloadDetails file_download_details: Downloaded files and/or
        folders.
    :ivar FileEditDetails file_edit_details: Edited files.
    :ivar FileGetCopyReferenceDetails file_get_copy_reference_details: Create a
        copy reference to a file or folder.
    :ivar FileMoveDetails file_move_details: Moved files and/or folders.
    :ivar FilePermanentlyDeleteDetails file_permanently_delete_details:
        Permanently deleted files and/or folders.
    :ivar FilePreviewDetails file_preview_details: Previewed files and/or
        folders.
    :ivar FileRenameDetails file_rename_details: Renamed files and/or folders.
    :ivar FileRestoreDetails file_restore_details: Restored deleted files and/or
        folders.
    :ivar FileRevertDetails file_revert_details: Reverted files to a previous
        version.
    :ivar FileRollbackChangesDetails file_rollback_changes_details: Rolled back
        file change location changes.
    :ivar FileSaveCopyReferenceDetails file_save_copy_reference_details: Save a
        file or folder using a copy reference.
    :ivar FileRequestAddDeadlineDetails file_request_add_deadline_details: Added
        a deadline to a file request.
    :ivar FileRequestChangeFolderDetails file_request_change_folder_details:
        Changed the file request folder.
    :ivar FileRequestChangeTitleDetails file_request_change_title_details:
        Change the file request title.
    :ivar FileRequestCloseDetails file_request_close_details: Closed a file
        request.
    :ivar FileRequestCreateDetails file_request_create_details: Created a file
        request.
    :ivar FileRequestReceiveFileDetails file_request_receive_file_details:
        Received files for a file request.
    :ivar FileRequestRemoveDeadlineDetails file_request_remove_deadline_details:
        Removed the file request deadline.
    :ivar FileRequestSendDetails file_request_send_details: Sent file request to
        users via email.
    :ivar GroupAddExternalIdDetails group_add_external_id_details: Added an
        external ID for group.
    :ivar GroupAddMemberDetails group_add_member_details: Added team members to
        a group.
    :ivar GroupChangeExternalIdDetails group_change_external_id_details: Changed
        the external ID for group.
    :ivar GroupChangeManagementTypeDetails group_change_management_type_details:
        Changed group management type.
    :ivar GroupChangeMemberRoleDetails group_change_member_role_details: Changed
        the manager permissions belonging to a group member.
    :ivar GroupCreateDetails group_create_details: Created a group.
    :ivar GroupDeleteDetails group_delete_details: Deleted a group.
    :ivar GroupDescriptionUpdatedDetails group_description_updated_details:
        Updated a group.
    :ivar GroupJoinPolicyUpdatedDetails group_join_policy_updated_details:
        Updated a group join policy.
    :ivar GroupMovedDetails group_moved_details: Moved a group.
    :ivar GroupRemoveExternalIdDetails group_remove_external_id_details: Removed
        the external ID for group.
    :ivar GroupRemoveMemberDetails group_remove_member_details: Removed team
        members from a group.
    :ivar GroupRenameDetails group_rename_details: Renamed a group.
    :ivar EmmLoginSuccessDetails emm_login_success_details: Signed in using the
        Dropbox EMM app.
    :ivar LogoutDetails logout_details: Signed out.
    :ivar PasswordLoginFailDetails password_login_fail_details: Failed to sign
        in using a password.
    :ivar PasswordLoginSuccessDetails password_login_success_details: Signed in
        using a password.
    :ivar ResellerSupportSessionEndDetails reseller_support_session_end_details:
        Ended reseller support session.
    :ivar ResellerSupportSessionStartDetails
        reseller_support_session_start_details: Started reseller support
        session.
    :ivar SignInAsSessionEndDetails sign_in_as_session_end_details: Ended admin
        sign-in-as session.
    :ivar SignInAsSessionStartDetails sign_in_as_session_start_details: Started
        admin sign-in-as session.
    :ivar SsoLoginFailDetails sso_login_fail_details: Failed to sign in using
        SSO.
    :ivar MemberAddNameDetails member_add_name_details: Set team member name
        when joining team.
    :ivar MemberChangeEmailDetails member_change_email_details: Changed team
        member email address.
    :ivar MemberChangeNameDetails member_change_name_details: Changed team
        member name.
    :ivar MemberChangeRoleDetails member_change_role_details: Change the admin
        permissions belonging to team member.
    :ivar MemberInviteDetails member_invite_details: Invited a user to join the
        team.
    :ivar MemberJoinDetails member_join_details: Joined the team.
    :ivar MemberLeaveDetails member_leave_details: Removed a team member.
    :ivar MemberRecoverDetails member_recover_details: Recovered a removed
        member.
    :ivar MemberSuggestDetails member_suggest_details: Suggested a new team
        member to be added to the team.
    :ivar MemberSuspendDetails member_suspend_details: Suspended a team member.
    :ivar MemberUnsuspendDetails member_unsuspend_details: Unsuspended a team
        member.
    :ivar PaperContentAddMemberDetails paper_content_add_member_details: Added
        users to the membership of a Paper doc or folder.
    :ivar PaperContentAddToFolderDetails paper_content_add_to_folder_details:
        Added Paper doc or folder to a folder.
    :ivar PaperContentArchiveDetails paper_content_archive_details: Archived
        Paper doc or folder.
    :ivar PaperContentChangeSubscriptionDetails
        paper_content_change_subscription_details: Followed or unfollowed a
        Paper doc or folder.
    :ivar PaperContentCreateDetails paper_content_create_details: Created a
        Paper doc or folder.
    :ivar PaperContentPermanentlyDeleteDetails
        paper_content_permanently_delete_details: Permanently deleted a Paper
        doc or folder.
    :ivar PaperContentRemoveFromFolderDetails
        paper_content_remove_from_folder_details: Removed Paper doc or folder
        from a folder.
    :ivar PaperContentRemoveMemberDetails paper_content_remove_member_details:
        Removed a user from the membership of a Paper doc or folder.
    :ivar PaperContentRenameDetails paper_content_rename_details: Renamed Paper
        doc or folder.
    :ivar PaperContentRestoreDetails paper_content_restore_details: Restored an
        archived Paper doc or folder.
    :ivar PaperDocAddCommentDetails paper_doc_add_comment_details: Added a Paper
        doc comment.
    :ivar PaperDocChangeMemberRoleDetails paper_doc_change_member_role_details:
        Changed the access type of a Paper doc member.
    :ivar PaperDocChangeSharingPolicyDetails
        paper_doc_change_sharing_policy_details: Changed the sharing policy for
        Paper doc.
    :ivar PaperDocDeletedDetails paper_doc_deleted_details: Paper doc archived.
    :ivar PaperDocDeleteCommentDetails paper_doc_delete_comment_details: Deleted
        a Paper doc comment.
    :ivar PaperDocDownloadDetails paper_doc_download_details: Downloaded a Paper
        doc in a particular output format.
    :ivar PaperDocEditDetails paper_doc_edit_details: Edited a Paper doc.
    :ivar PaperDocEditCommentDetails paper_doc_edit_comment_details: Edited a
        Paper doc comment.
    :ivar PaperDocFollowedDetails paper_doc_followed_details: Followed a Paper
        doc.
    :ivar PaperDocMentionDetails paper_doc_mention_details: Mentioned a member
        in a Paper doc.
    :ivar PaperDocRequestAccessDetails paper_doc_request_access_details:
        Requested to be a member on a Paper doc.
    :ivar PaperDocResolveCommentDetails paper_doc_resolve_comment_details: Paper
        doc comment resolved.
    :ivar PaperDocRevertDetails paper_doc_revert_details: Restored a Paper doc
        to previous revision.
    :ivar PaperDocSlackShareDetails paper_doc_slack_share_details: Paper doc
        link shared via slack.
    :ivar PaperDocTeamInviteDetails paper_doc_team_invite_details: Paper doc
        shared with team member.
    :ivar PaperDocUnresolveCommentDetails paper_doc_unresolve_comment_details:
        Unresolved a Paper doc comment.
    :ivar PaperDocViewDetails paper_doc_view_details: Viewed Paper doc.
    :ivar PaperFolderDeletedDetails paper_folder_deleted_details: Paper folder
        archived.
    :ivar PaperFolderFollowedDetails paper_folder_followed_details: Followed a
        Paper folder.
    :ivar PaperFolderTeamInviteDetails paper_folder_team_invite_details: Paper
        folder shared with team member.
    :ivar PasswordChangeDetails password_change_details: Changed password.
    :ivar PasswordResetDetails password_reset_details: Reset password.
    :ivar PasswordResetAllDetails password_reset_all_details: Reset all team
        member passwords.
    :ivar EmmCreateExceptionsReportDetails emm_create_exceptions_report_details:
        EMM excluded users report created.
    :ivar EmmCreateUsageReportDetails emm_create_usage_report_details: EMM
        mobile app usage report created.
    :ivar SmartSyncCreateAdminPrivilegeReportDetails
        smart_sync_create_admin_privilege_report_details: Smart Sync non-admin
        devices report created.
    :ivar TeamActivityCreateReportDetails team_activity_create_report_details:
        Created a team activity report.
    :ivar CollectionShareDetails collection_share_details: Shared an album.
    :ivar FileAddCommentDetails file_add_comment_details: Added a file comment.
    :ivar FileLikeCommentDetails file_like_comment_details: Liked a file
        comment.
    :ivar FileUnlikeCommentDetails file_unlike_comment_details: Unliked a file
        comment.
    :ivar NoteAclInviteOnlyDetails note_acl_invite_only_details: Changed a Paper
        document to be invite-only.
    :ivar NoteAclLinkDetails note_acl_link_details: Changed a Paper document to
        be link accessible.
    :ivar NoteAclTeamLinkDetails note_acl_team_link_details: Changed a Paper
        document to be link accessible for the team.
    :ivar NoteSharedDetails note_shared_details: Shared a Paper doc.
    :ivar NoteShareReceiveDetails note_share_receive_details: Shared Paper
        document received.
    :ivar OpenNoteSharedDetails open_note_shared_details: Opened a shared Paper
        doc.
    :ivar SfAddGroupDetails sf_add_group_details: Added the team to a shared
        folder.
    :ivar SfAllowNonMembersToViewSharedLinksDetails
        sf_allow_non_members_to_view_shared_links_details: Allowed non
        collaborators to view links to files in a shared folder.
    :ivar SfInviteGroupDetails sf_invite_group_details: Invited a group to a
        shared folder.
    :ivar SfNestDetails sf_nest_details: Changed parent of shared folder.
    :ivar SfTeamDeclineDetails sf_team_decline_details: Declined a team member's
        invitation to a shared folder.
    :ivar SfTeamGrantAccessDetails sf_team_grant_access_details: Granted access
        to a shared folder.
    :ivar SfTeamInviteDetails sf_team_invite_details: Invited team members to a
        shared folder.
    :ivar SfTeamInviteChangeRoleDetails sf_team_invite_change_role_details:
        Changed a team member's role in a shared folder.
    :ivar SfTeamJoinDetails sf_team_join_details: Joined a team member's shared
        folder.
    :ivar SfTeamJoinFromOobLinkDetails sf_team_join_from_oob_link_details:
        Joined a team member's shared folder from a link.
    :ivar SfTeamUninviteDetails sf_team_uninvite_details: Unshared a folder with
        a team member.
    :ivar SharedContentAddInviteesDetails shared_content_add_invitees_details:
        Sent an email invitation to the membership of a shared file or folder.
    :ivar SharedContentAddLinkExpiryDetails
        shared_content_add_link_expiry_details: Added an expiry to the link for
        the shared file or folder.
    :ivar SharedContentAddLinkPasswordDetails
        shared_content_add_link_password_details: Added a password to the link
        for the shared file or folder.
    :ivar SharedContentAddMemberDetails shared_content_add_member_details: Added
        users and/or groups to the membership of a shared file or folder.
    :ivar SharedContentChangeDownloadsPolicyDetails
        shared_content_change_downloads_policy_details: Changed whether members
        can download the shared file or folder.
    :ivar SharedContentChangeInviteeRoleDetails
        shared_content_change_invitee_role_details: Changed the access type of
        an invitee to a shared file or folder before the invitation was claimed.
    :ivar SharedContentChangeLinkAudienceDetails
        shared_content_change_link_audience_details: Changed the audience of the
        link for a shared file or folder.
    :ivar SharedContentChangeLinkExpiryDetails
        shared_content_change_link_expiry_details: Changed the expiry of the
        link for the shared file or folder.
    :ivar SharedContentChangeLinkPasswordDetails
        shared_content_change_link_password_details: Changed the password on the
        link for the shared file or folder.
    :ivar SharedContentChangeMemberRoleDetails
        shared_content_change_member_role_details: Changed the access type of a
        shared file or folder member.
    :ivar SharedContentChangeViewerInfoPolicyDetails
        shared_content_change_viewer_info_policy_details: Changed whether
        members can see who viewed the shared file or folder.
    :ivar SharedContentClaimInvitationDetails
        shared_content_claim_invitation_details: Claimed membership to a team
        member's shared folder.
    :ivar SharedContentCopyDetails shared_content_copy_details: Copied the
        shared file or folder to own Dropbox.
    :ivar SharedContentDownloadDetails shared_content_download_details:
        Downloaded the shared file or folder.
    :ivar SharedContentRelinquishMembershipDetails
        shared_content_relinquish_membership_details: Left the membership of a
        shared file or folder.
    :ivar SharedContentRemoveInviteeDetails
        shared_content_remove_invitee_details: Removed an invitee from the
        membership of a shared file or folder before it was claimed.
    :ivar SharedContentRemoveLinkExpiryDetails
        shared_content_remove_link_expiry_details: Removed the expiry of the
        link for the shared file or folder.
    :ivar SharedContentRemoveLinkPasswordDetails
        shared_content_remove_link_password_details: Removed the password on the
        link for the shared file or folder.
    :ivar SharedContentRemoveMemberDetails shared_content_remove_member_details:
        Removed a user or a group from the membership of a shared file or
        folder.
    :ivar SharedContentRequestAccessDetails
        shared_content_request_access_details: Requested to be on the membership
        of a shared file or folder.
    :ivar SharedContentUnshareDetails shared_content_unshare_details: Unshared a
        shared file or folder by clearing its membership and turning off its
        link.
    :ivar SharedContentViewDetails shared_content_view_details: Previewed the
        shared file or folder.
    :ivar SharedFolderChangeConfidentialityDetails
        shared_folder_change_confidentiality_details: Set or unset the
        confidential flag on a shared folder.
    :ivar SharedFolderChangeLinkPolicyDetails
        shared_folder_change_link_policy_details: Changed who can access the
        shared folder via a link.
    :ivar SharedFolderChangeMemberManagementPolicyDetails
        shared_folder_change_member_management_policy_details: Changed who can
        manage the membership of a shared folder.
    :ivar SharedFolderChangeMemberPolicyDetails
        shared_folder_change_member_policy_details: Changed who can become a
        member of the shared folder.
    :ivar SharedFolderCreateDetails shared_folder_create_details: Created a
        shared folder.
    :ivar SharedFolderMountDetails shared_folder_mount_details: Added a shared
        folder to own Dropbox.
    :ivar SharedFolderTransferOwnershipDetails
        shared_folder_transfer_ownership_details: Transferred the ownership of a
        shared folder to another member.
    :ivar SharedFolderUnmountDetails shared_folder_unmount_details: Deleted a
        shared folder from Dropbox.
    :ivar SharedNoteOpenedDetails shared_note_opened_details: Shared Paper
        document was opened.
    :ivar ShmodelAppCreateDetails shmodel_app_create_details: Created a link to
        a file using an app.
    :ivar ShmodelCreateDetails shmodel_create_details: Created a new link.
    :ivar ShmodelDisableDetails shmodel_disable_details: Removed a link.
    :ivar ShmodelFbShareDetails shmodel_fb_share_details: Shared a link with
        Facebook users.
    :ivar ShmodelGroupShareDetails shmodel_group_share_details: Shared a link
        with a group.
    :ivar ShmodelRemoveExpirationDetails shmodel_remove_expiration_details:
        Removed the expiration date from a link.
    :ivar ShmodelSetExpirationDetails shmodel_set_expiration_details: Added an
        expiration date to a link.
    :ivar ShmodelTeamCopyDetails shmodel_team_copy_details: Added a team
        member's file/folder to their Dropbox from a link.
    :ivar ShmodelTeamDownloadDetails shmodel_team_download_details: Downloaded a
        team member's file/folder from a link.
    :ivar ShmodelTeamShareDetails shmodel_team_share_details: Shared a link with
        team members.
    :ivar ShmodelTeamViewDetails shmodel_team_view_details: Opened a team
        member's link.
    :ivar ShmodelVisibilityPasswordDetails shmodel_visibility_password_details:
        Password-protected a link.
    :ivar ShmodelVisibilityPublicDetails shmodel_visibility_public_details: Made
        a file/folder visible to anyone with the link.
    :ivar ShmodelVisibilityTeamOnlyDetails shmodel_visibility_team_only_details:
        Made a file/folder visible only to team members with the link.
    :ivar RemoveLogoutUrlDetails remove_logout_url_details: Removed single
        sign-on logout URL.
    :ivar RemoveSsoUrlDetails remove_sso_url_details: Changed the sign-out URL
        for SSO.
    :ivar SsoChangeCertDetails sso_change_cert_details: Changed the X.509
        certificate for SSO.
    :ivar SsoChangeLoginUrlDetails sso_change_login_url_details: Changed the
        sign-in URL for SSO.
    :ivar SsoChangeLogoutUrlDetails sso_change_logout_url_details: Changed the
        sign-out URL for SSO.
    :ivar SsoChangeSamlIdentityModeDetails
        sso_change_saml_identity_mode_details: Changed the SAML identity mode
        for SSO.
    :ivar TeamFolderChangeStatusDetails team_folder_change_status_details:
        Changed the archival status of a team folder.
    :ivar TeamFolderCreateDetails team_folder_create_details: Created a new team
        folder in active status.
    :ivar TeamFolderDowngradeDetails team_folder_downgrade_details: Downgraded a
        team folder to a regular shared folder.
    :ivar TeamFolderPermanentlyDeleteDetails
        team_folder_permanently_delete_details: Permanently deleted an archived
        team folder.
    :ivar TeamFolderRenameDetails team_folder_rename_details: Renamed an active
        or archived team folder.
    :ivar AccountCaptureChangePolicyDetails
        account_capture_change_policy_details: Changed the account capture
        policy on a domain belonging to the team.
    :ivar AllowDownloadDisabledDetails allow_download_disabled_details: Disabled
        allow downloads.
    :ivar AllowDownloadEnabledDetails allow_download_enabled_details: Enabled
        allow downloads.
    :ivar DataPlacementRestrictionChangePolicyDetails
        data_placement_restriction_change_policy_details: Set a restriction
        policy regarding the location of data centers where team data resides.
    :ivar DataPlacementRestrictionSatisfyPolicyDetails
        data_placement_restriction_satisfy_policy_details: Satisfied a
        previously set restriction policy regarding the location of data centers
        where team data resides (i.e. all data have been migrated according to
        the restriction placed).
    :ivar DeviceApprovalsChangeDesktopPolicyDetails
        device_approvals_change_desktop_policy_details: Set or removed a limit
        on the number of computers each team member can link to their work
        Dropbox account.
    :ivar DeviceApprovalsChangeMobilePolicyDetails
        device_approvals_change_mobile_policy_details: Set or removed a limit on
        the number of mobiles devices each team member can link to their work
        Dropbox account.
    :ivar DeviceApprovalsChangeOverageActionDetails
        device_approvals_change_overage_action_details: Changed the action taken
        when a team member is already over the limits (e.g when they join the
        team, an admin lowers limits, etc.).
    :ivar DeviceApprovalsChangeUnlinkActionDetails
        device_approvals_change_unlink_action_details: Changed the action taken
        with respect to approval limits when a team member unlinks an approved
        device.
    :ivar EmmAddExceptionDetails emm_add_exception_details: Added an exception
        for one or more team members to optionally use the regular Dropbox app
        when EMM is enabled.
    :ivar EmmChangePolicyDetails emm_change_policy_details: Enabled or disabled
        enterprise mobility management for team members.
    :ivar EmmRemoveExceptionDetails emm_remove_exception_details: Removed an
        exception for one or more team members to optionally use the regular
        Dropbox app when EMM is enabled.
    :ivar ExtendedVersionHistoryChangePolicyDetails
        extended_version_history_change_policy_details: Accepted or opted out of
        extended version history.
    :ivar FileCommentsChangePolicyDetails file_comments_change_policy_details:
        Enabled or disabled commenting on team files.
    :ivar FileRequestsChangePolicyDetails file_requests_change_policy_details:
        Enabled or disabled file requests.
    :ivar FileRequestsEmailsEnabledDetails file_requests_emails_enabled_details:
        Enabled file request emails for everyone.
    :ivar FileRequestsEmailsRestrictedToTeamOnlyDetails
        file_requests_emails_restricted_to_team_only_details: Allowed file
        request emails for the team.
    :ivar GoogleSsoChangePolicyDetails google_sso_change_policy_details: Enabled
        or disabled Google single sign-on for the team.
    :ivar GroupUserManagementChangePolicyDetails
        group_user_management_change_policy_details: Changed who can create
        groups.
    :ivar MemberRequestsChangePolicyDetails
        member_requests_change_policy_details: Changed whether users can find
        the team when not invited.
    :ivar MemberSpaceLimitsAddExceptionDetails
        member_space_limits_add_exception_details: Added an exception for one or
        more team members to bypass space limits imposed by policy.
    :ivar MemberSpaceLimitsChangePolicyDetails
        member_space_limits_change_policy_details: Changed the storage limits
        applied to team members by policy.
    :ivar MemberSpaceLimitsRemoveExceptionDetails
        member_space_limits_remove_exception_details: Removed an exception for
        one or more team members to bypass space limits imposed by policy.
    :ivar MemberSuggestionsChangePolicyDetails
        member_suggestions_change_policy_details: Enabled or disabled the option
        for team members to suggest new members to add to the team.
    :ivar MicrosoftOfficeAddinChangePolicyDetails
        microsoft_office_addin_change_policy_details: Enabled or disabled the
        Microsoft Office add-in, which lets team members save files to Dropbox
        directly from Microsoft Office.
    :ivar NetworkControlChangePolicyDetails
        network_control_change_policy_details: Enabled or disabled network
        control.
    :ivar PaperChangeDeploymentPolicyDetails
        paper_change_deployment_policy_details: Changed whether Dropbox Paper,
        when enabled, is deployed to all teams or to specific members of the
        team.
    :ivar PaperChangeMemberPolicyDetails paper_change_member_policy_details:
        Changed whether team members can share Paper documents externally (i.e.
        outside the team), and if so, whether they should be accessible only by
        team members or anyone by default.
    :ivar PaperChangePolicyDetails paper_change_policy_details: Enabled or
        disabled Dropbox Paper for the team.
    :ivar PermanentDeleteChangePolicyDetails
        permanent_delete_change_policy_details: Enabled or disabled the ability
        of team members to permanently delete content.
    :ivar SharingChangeFolderJoinPolicyDetails
        sharing_change_folder_join_policy_details: Changed whether team members
        can join shared folders owned externally (i.e. outside the team).
    :ivar SharingChangeLinkPolicyDetails sharing_change_link_policy_details:
        Changed whether team members can share links externally (i.e. outside
        the team), and if so, whether links should be accessible only by team
        members or anyone by default.
    :ivar SharingChangeMemberPolicyDetails sharing_change_member_policy_details:
        Changed whether team members can share files and folders externally
        (i.e. outside the team).
    :ivar SmartSyncChangePolicyDetails smart_sync_change_policy_details: Changed
        the default Smart Sync policy for team members.
    :ivar SsoChangePolicyDetails sso_change_policy_details: Change the single
        sign-on policy for the team.
    :ivar TfaChangePolicyDetails tfa_change_policy_details: Change two-step
        verification policy for the team.
    :ivar TwoAccountChangePolicyDetails two_account_change_policy_details:
        Enabled or disabled the option for team members to link a personal
        Dropbox account in addition to their work account to the same computer.
    :ivar WebSessionsChangeFixedLengthPolicyDetails
        web_sessions_change_fixed_length_policy_details: Changed how long team
        members can stay signed in to Dropbox on the web.
    :ivar WebSessionsChangeIdleLengthPolicyDetails
        web_sessions_change_idle_length_policy_details: Changed how long team
        members can be idle while signed in to Dropbox on the web.
    :ivar TeamProfileAddLogoDetails team_profile_add_logo_details: Added a team
        logo to be displayed on shared link headers.
    :ivar TeamProfileChangeLogoDetails team_profile_change_logo_details: Changed
        the team logo to be displayed on shared link headers.
    :ivar TeamProfileChangeNameDetails team_profile_change_name_details: Changed
        the team name.
    :ivar TeamProfileRemoveLogoDetails team_profile_remove_logo_details: Removed
        the team logo to be displayed on shared link headers.
    :ivar TfaAddBackupPhoneDetails tfa_add_backup_phone_details: Added a backup
        phone for two-step verification.
    :ivar TfaAddSecurityKeyDetails tfa_add_security_key_details: Added a
        security key for two-step verification.
    :ivar TfaChangeBackupPhoneDetails tfa_change_backup_phone_details: Changed
        the backup phone for two-step verification.
    :ivar TfaChangeStatusDetails tfa_change_status_details: Enabled, disabled or
        changed the configuration for two-step verification.
    :ivar TfaRemoveBackupPhoneDetails tfa_remove_backup_phone_details: Removed
        the backup phone for two-step verification.
    :ivar TfaRemoveSecurityKeyDetails tfa_remove_security_key_details: Removed a
        security key for two-step verification.
    :ivar TfaResetDetails tfa_reset_details: Reset two-step verification for
        team member.
    :ivar MissingDetails missing_details: Hints that this event was returned
        with missing details due to an internal error.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def member_change_membership_type_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_membership_type_details`` tag with value ``val``.

        :param MemberChangeMembershipTypeDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_membership_type_details', val)

    @classmethod
    def member_permanently_delete_account_contents_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_permanently_delete_account_contents_details`` tag with value
        ``val``.

        :param MemberPermanentlyDeleteAccountContentsDetails val:
        :rtype: EventDetails
        """
        return cls('member_permanently_delete_account_contents_details', val)

    @classmethod
    def member_space_limits_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_status_details`` tag with value ``val``.

        :param MemberSpaceLimitsChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_status_details', val)

    @classmethod
    def member_transfer_account_contents_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_transfer_account_contents_details`` tag with value ``val``.

        :param MemberTransferAccountContentsDetails val:
        :rtype: EventDetails
        """
        return cls('member_transfer_account_contents_details', val)

    @classmethod
    def paper_enabled_users_group_addition_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_addition_details`` tag with value ``val``.

        :param PaperEnabledUsersGroupAdditionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_enabled_users_group_addition_details', val)

    @classmethod
    def paper_enabled_users_group_removal_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_enabled_users_group_removal_details`` tag with value ``val``.

        :param PaperEnabledUsersGroupRemovalDetails val:
        :rtype: EventDetails
        """
        return cls('paper_enabled_users_group_removal_details', val)

    @classmethod
    def paper_external_view_allow_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_allow_details`` tag with value ``val``.

        :param PaperExternalViewAllowDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_allow_details', val)

    @classmethod
    def paper_external_view_default_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_default_team_details`` tag with value ``val``.

        :param PaperExternalViewDefaultTeamDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_default_team_details', val)

    @classmethod
    def paper_external_view_forbid_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_external_view_forbid_details`` tag with value ``val``.

        :param PaperExternalViewForbidDetails val:
        :rtype: EventDetails
        """
        return cls('paper_external_view_forbid_details', val)

    @classmethod
    def sf_external_invite_warn_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_external_invite_warn_details`` tag with value ``val``.

        :param SfExternalInviteWarnDetails val:
        :rtype: EventDetails
        """
        return cls('sf_external_invite_warn_details', val)

    @classmethod
    def team_merge_details(cls, val):
        """
        Create an instance of this class set to the ``team_merge_details`` tag
        with value ``val``.

        :param TeamMergeDetails val:
        :rtype: EventDetails
        """
        return cls('team_merge_details', val)

    @classmethod
    def app_link_team_details(cls, val):
        """
        Create an instance of this class set to the ``app_link_team_details``
        tag with value ``val``.

        :param AppLinkTeamDetails val:
        :rtype: EventDetails
        """
        return cls('app_link_team_details', val)

    @classmethod
    def app_link_user_details(cls, val):
        """
        Create an instance of this class set to the ``app_link_user_details``
        tag with value ``val``.

        :param AppLinkUserDetails val:
        :rtype: EventDetails
        """
        return cls('app_link_user_details', val)

    @classmethod
    def app_unlink_team_details(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_team_details``
        tag with value ``val``.

        :param AppUnlinkTeamDetails val:
        :rtype: EventDetails
        """
        return cls('app_unlink_team_details', val)

    @classmethod
    def app_unlink_user_details(cls, val):
        """
        Create an instance of this class set to the ``app_unlink_user_details``
        tag with value ``val``.

        :param AppUnlinkUserDetails val:
        :rtype: EventDetails
        """
        return cls('app_unlink_user_details', val)

    @classmethod
    def device_change_ip_desktop_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_desktop_details`` tag with value ``val``.

        :param DeviceChangeIpDesktopDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_desktop_details', val)

    @classmethod
    def device_change_ip_mobile_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_mobile_details`` tag with value ``val``.

        :param DeviceChangeIpMobileDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_mobile_details', val)

    @classmethod
    def device_change_ip_web_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_change_ip_web_details`` tag with value ``val``.

        :param DeviceChangeIpWebDetails val:
        :rtype: EventDetails
        """
        return cls('device_change_ip_web_details', val)

    @classmethod
    def device_delete_on_unlink_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_fail_details`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkFailDetails val:
        :rtype: EventDetails
        """
        return cls('device_delete_on_unlink_fail_details', val)

    @classmethod
    def device_delete_on_unlink_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_delete_on_unlink_success_details`` tag with value ``val``.

        :param DeviceDeleteOnUnlinkSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('device_delete_on_unlink_success_details', val)

    @classmethod
    def device_link_fail_details(cls, val):
        """
        Create an instance of this class set to the ``device_link_fail_details``
        tag with value ``val``.

        :param DeviceLinkFailDetails val:
        :rtype: EventDetails
        """
        return cls('device_link_fail_details', val)

    @classmethod
    def device_link_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_link_success_details`` tag with value ``val``.

        :param DeviceLinkSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('device_link_success_details', val)

    @classmethod
    def device_management_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_disabled_details`` tag with value ``val``.

        :param DeviceManagementDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('device_management_disabled_details', val)

    @classmethod
    def device_management_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_management_enabled_details`` tag with value ``val``.

        :param DeviceManagementEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('device_management_enabled_details', val)

    @classmethod
    def device_unlink_details(cls, val):
        """
        Create an instance of this class set to the ``device_unlink_details``
        tag with value ``val``.

        :param DeviceUnlinkDetails val:
        :rtype: EventDetails
        """
        return cls('device_unlink_details', val)

    @classmethod
    def emm_refresh_auth_token_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_refresh_auth_token_details`` tag with value ``val``.

        :param EmmRefreshAuthTokenDetails val:
        :rtype: EventDetails
        """
        return cls('emm_refresh_auth_token_details', val)

    @classmethod
    def account_capture_change_availability_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_availability_details`` tag with value ``val``.

        :param AccountCaptureChangeAvailabilityDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_change_availability_details', val)

    @classmethod
    def account_capture_migrate_account_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_migrate_account_details`` tag with value ``val``.

        :param AccountCaptureMigrateAccountDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_migrate_account_details', val)

    @classmethod
    def account_capture_relinquish_account_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_relinquish_account_details`` tag with value ``val``.

        :param AccountCaptureRelinquishAccountDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_relinquish_account_details', val)

    @classmethod
    def disabled_domain_invites_details(cls, val):
        """
        Create an instance of this class set to the
        ``disabled_domain_invites_details`` tag with value ``val``.

        :param DisabledDomainInvitesDetails val:
        :rtype: EventDetails
        """
        return cls('disabled_domain_invites_details', val)

    @classmethod
    def domain_invites_approve_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_approve_request_to_join_team_details`` tag with value
        ``val``.

        :param DomainInvitesApproveRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_approve_request_to_join_team_details', val)

    @classmethod
    def domain_invites_decline_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_decline_request_to_join_team_details`` tag with value
        ``val``.

        :param DomainInvitesDeclineRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_decline_request_to_join_team_details', val)

    @classmethod
    def domain_invites_email_existing_users_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_email_existing_users_details`` tag with value ``val``.

        :param DomainInvitesEmailExistingUsersDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_email_existing_users_details', val)

    @classmethod
    def domain_invites_request_to_join_team_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_request_to_join_team_details`` tag with value ``val``.

        :param DomainInvitesRequestToJoinTeamDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_request_to_join_team_details', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_no_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_no_details`` tag with value
        ``val``.

        :param DomainInvitesSetInviteNewUserPrefToNoDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_set_invite_new_user_pref_to_no_details', val)

    @classmethod
    def domain_invites_set_invite_new_user_pref_to_yes_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_invites_set_invite_new_user_pref_to_yes_details`` tag with
        value ``val``.

        :param DomainInvitesSetInviteNewUserPrefToYesDetails val:
        :rtype: EventDetails
        """
        return cls('domain_invites_set_invite_new_user_pref_to_yes_details', val)

    @classmethod
    def domain_verification_add_domain_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_fail_details`` tag with value ``val``.

        :param DomainVerificationAddDomainFailDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_add_domain_fail_details', val)

    @classmethod
    def domain_verification_add_domain_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_add_domain_success_details`` tag with value
        ``val``.

        :param DomainVerificationAddDomainSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_add_domain_success_details', val)

    @classmethod
    def domain_verification_remove_domain_details(cls, val):
        """
        Create an instance of this class set to the
        ``domain_verification_remove_domain_details`` tag with value ``val``.

        :param DomainVerificationRemoveDomainDetails val:
        :rtype: EventDetails
        """
        return cls('domain_verification_remove_domain_details', val)

    @classmethod
    def enabled_domain_invites_details(cls, val):
        """
        Create an instance of this class set to the
        ``enabled_domain_invites_details`` tag with value ``val``.

        :param EnabledDomainInvitesDetails val:
        :rtype: EventDetails
        """
        return cls('enabled_domain_invites_details', val)

    @classmethod
    def create_folder_details(cls, val):
        """
        Create an instance of this class set to the ``create_folder_details``
        tag with value ``val``.

        :param CreateFolderDetails val:
        :rtype: EventDetails
        """
        return cls('create_folder_details', val)

    @classmethod
    def file_add_details(cls, val):
        """
        Create an instance of this class set to the ``file_add_details`` tag
        with value ``val``.

        :param FileAddDetails val:
        :rtype: EventDetails
        """
        return cls('file_add_details', val)

    @classmethod
    def file_copy_details(cls, val):
        """
        Create an instance of this class set to the ``file_copy_details`` tag
        with value ``val``.

        :param FileCopyDetails val:
        :rtype: EventDetails
        """
        return cls('file_copy_details', val)

    @classmethod
    def file_delete_details(cls, val):
        """
        Create an instance of this class set to the ``file_delete_details`` tag
        with value ``val``.

        :param FileDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_delete_details', val)

    @classmethod
    def file_download_details(cls, val):
        """
        Create an instance of this class set to the ``file_download_details``
        tag with value ``val``.

        :param FileDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('file_download_details', val)

    @classmethod
    def file_edit_details(cls, val):
        """
        Create an instance of this class set to the ``file_edit_details`` tag
        with value ``val``.

        :param FileEditDetails val:
        :rtype: EventDetails
        """
        return cls('file_edit_details', val)

    @classmethod
    def file_get_copy_reference_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_get_copy_reference_details`` tag with value ``val``.

        :param FileGetCopyReferenceDetails val:
        :rtype: EventDetails
        """
        return cls('file_get_copy_reference_details', val)

    @classmethod
    def file_move_details(cls, val):
        """
        Create an instance of this class set to the ``file_move_details`` tag
        with value ``val``.

        :param FileMoveDetails val:
        :rtype: EventDetails
        """
        return cls('file_move_details', val)

    @classmethod
    def file_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_permanently_delete_details`` tag with value ``val``.

        :param FilePermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('file_permanently_delete_details', val)

    @classmethod
    def file_preview_details(cls, val):
        """
        Create an instance of this class set to the ``file_preview_details`` tag
        with value ``val``.

        :param FilePreviewDetails val:
        :rtype: EventDetails
        """
        return cls('file_preview_details', val)

    @classmethod
    def file_rename_details(cls, val):
        """
        Create an instance of this class set to the ``file_rename_details`` tag
        with value ``val``.

        :param FileRenameDetails val:
        :rtype: EventDetails
        """
        return cls('file_rename_details', val)

    @classmethod
    def file_restore_details(cls, val):
        """
        Create an instance of this class set to the ``file_restore_details`` tag
        with value ``val``.

        :param FileRestoreDetails val:
        :rtype: EventDetails
        """
        return cls('file_restore_details', val)

    @classmethod
    def file_revert_details(cls, val):
        """
        Create an instance of this class set to the ``file_revert_details`` tag
        with value ``val``.

        :param FileRevertDetails val:
        :rtype: EventDetails
        """
        return cls('file_revert_details', val)

    @classmethod
    def file_rollback_changes_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_rollback_changes_details`` tag with value ``val``.

        :param FileRollbackChangesDetails val:
        :rtype: EventDetails
        """
        return cls('file_rollback_changes_details', val)

    @classmethod
    def file_save_copy_reference_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_save_copy_reference_details`` tag with value ``val``.

        :param FileSaveCopyReferenceDetails val:
        :rtype: EventDetails
        """
        return cls('file_save_copy_reference_details', val)

    @classmethod
    def file_request_add_deadline_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_add_deadline_details`` tag with value ``val``.

        :param FileRequestAddDeadlineDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_add_deadline_details', val)

    @classmethod
    def file_request_change_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_change_folder_details`` tag with value ``val``.

        :param FileRequestChangeFolderDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_change_folder_details', val)

    @classmethod
    def file_request_change_title_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_change_title_details`` tag with value ``val``.

        :param FileRequestChangeTitleDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_change_title_details', val)

    @classmethod
    def file_request_close_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_close_details`` tag with value ``val``.

        :param FileRequestCloseDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_close_details', val)

    @classmethod
    def file_request_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_create_details`` tag with value ``val``.

        :param FileRequestCreateDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_create_details', val)

    @classmethod
    def file_request_receive_file_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_receive_file_details`` tag with value ``val``.

        :param FileRequestReceiveFileDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_receive_file_details', val)

    @classmethod
    def file_request_remove_deadline_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_remove_deadline_details`` tag with value ``val``.

        :param FileRequestRemoveDeadlineDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_remove_deadline_details', val)

    @classmethod
    def file_request_send_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_request_send_details`` tag with value ``val``.

        :param FileRequestSendDetails val:
        :rtype: EventDetails
        """
        return cls('file_request_send_details', val)

    @classmethod
    def group_add_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_add_external_id_details`` tag with value ``val``.

        :param GroupAddExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_add_external_id_details', val)

    @classmethod
    def group_add_member_details(cls, val):
        """
        Create an instance of this class set to the ``group_add_member_details``
        tag with value ``val``.

        :param GroupAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('group_add_member_details', val)

    @classmethod
    def group_change_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_external_id_details`` tag with value ``val``.

        :param GroupChangeExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_external_id_details', val)

    @classmethod
    def group_change_management_type_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_management_type_details`` tag with value ``val``.

        :param GroupChangeManagementTypeDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_management_type_details', val)

    @classmethod
    def group_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_change_member_role_details`` tag with value ``val``.

        :param GroupChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('group_change_member_role_details', val)

    @classmethod
    def group_create_details(cls, val):
        """
        Create an instance of this class set to the ``group_create_details`` tag
        with value ``val``.

        :param GroupCreateDetails val:
        :rtype: EventDetails
        """
        return cls('group_create_details', val)

    @classmethod
    def group_delete_details(cls, val):
        """
        Create an instance of this class set to the ``group_delete_details`` tag
        with value ``val``.

        :param GroupDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('group_delete_details', val)

    @classmethod
    def group_description_updated_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_description_updated_details`` tag with value ``val``.

        :param GroupDescriptionUpdatedDetails val:
        :rtype: EventDetails
        """
        return cls('group_description_updated_details', val)

    @classmethod
    def group_join_policy_updated_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_join_policy_updated_details`` tag with value ``val``.

        :param GroupJoinPolicyUpdatedDetails val:
        :rtype: EventDetails
        """
        return cls('group_join_policy_updated_details', val)

    @classmethod
    def group_moved_details(cls, val):
        """
        Create an instance of this class set to the ``group_moved_details`` tag
        with value ``val``.

        :param GroupMovedDetails val:
        :rtype: EventDetails
        """
        return cls('group_moved_details', val)

    @classmethod
    def group_remove_external_id_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_remove_external_id_details`` tag with value ``val``.

        :param GroupRemoveExternalIdDetails val:
        :rtype: EventDetails
        """
        return cls('group_remove_external_id_details', val)

    @classmethod
    def group_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_remove_member_details`` tag with value ``val``.

        :param GroupRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('group_remove_member_details', val)

    @classmethod
    def group_rename_details(cls, val):
        """
        Create an instance of this class set to the ``group_rename_details`` tag
        with value ``val``.

        :param GroupRenameDetails val:
        :rtype: EventDetails
        """
        return cls('group_rename_details', val)

    @classmethod
    def emm_login_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_login_success_details`` tag with value ``val``.

        :param EmmLoginSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('emm_login_success_details', val)

    @classmethod
    def logout_details(cls, val):
        """
        Create an instance of this class set to the ``logout_details`` tag with
        value ``val``.

        :param LogoutDetails val:
        :rtype: EventDetails
        """
        return cls('logout_details', val)

    @classmethod
    def password_login_fail_details(cls, val):
        """
        Create an instance of this class set to the
        ``password_login_fail_details`` tag with value ``val``.

        :param PasswordLoginFailDetails val:
        :rtype: EventDetails
        """
        return cls('password_login_fail_details', val)

    @classmethod
    def password_login_success_details(cls, val):
        """
        Create an instance of this class set to the
        ``password_login_success_details`` tag with value ``val``.

        :param PasswordLoginSuccessDetails val:
        :rtype: EventDetails
        """
        return cls('password_login_success_details', val)

    @classmethod
    def reseller_support_session_end_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_end_details`` tag with value ``val``.

        :param ResellerSupportSessionEndDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_session_end_details', val)

    @classmethod
    def reseller_support_session_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``reseller_support_session_start_details`` tag with value ``val``.

        :param ResellerSupportSessionStartDetails val:
        :rtype: EventDetails
        """
        return cls('reseller_support_session_start_details', val)

    @classmethod
    def sign_in_as_session_end_details(cls, val):
        """
        Create an instance of this class set to the
        ``sign_in_as_session_end_details`` tag with value ``val``.

        :param SignInAsSessionEndDetails val:
        :rtype: EventDetails
        """
        return cls('sign_in_as_session_end_details', val)

    @classmethod
    def sign_in_as_session_start_details(cls, val):
        """
        Create an instance of this class set to the
        ``sign_in_as_session_start_details`` tag with value ``val``.

        :param SignInAsSessionStartDetails val:
        :rtype: EventDetails
        """
        return cls('sign_in_as_session_start_details', val)

    @classmethod
    def sso_login_fail_details(cls, val):
        """
        Create an instance of this class set to the ``sso_login_fail_details``
        tag with value ``val``.

        :param SsoLoginFailDetails val:
        :rtype: EventDetails
        """
        return cls('sso_login_fail_details', val)

    @classmethod
    def member_add_name_details(cls, val):
        """
        Create an instance of this class set to the ``member_add_name_details``
        tag with value ``val``.

        :param MemberAddNameDetails val:
        :rtype: EventDetails
        """
        return cls('member_add_name_details', val)

    @classmethod
    def member_change_email_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_email_details`` tag with value ``val``.

        :param MemberChangeEmailDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_email_details', val)

    @classmethod
    def member_change_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_name_details`` tag with value ``val``.

        :param MemberChangeNameDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_name_details', val)

    @classmethod
    def member_change_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_change_role_details`` tag with value ``val``.

        :param MemberChangeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('member_change_role_details', val)

    @classmethod
    def member_invite_details(cls, val):
        """
        Create an instance of this class set to the ``member_invite_details``
        tag with value ``val``.

        :param MemberInviteDetails val:
        :rtype: EventDetails
        """
        return cls('member_invite_details', val)

    @classmethod
    def member_join_details(cls, val):
        """
        Create an instance of this class set to the ``member_join_details`` tag
        with value ``val``.

        :param MemberJoinDetails val:
        :rtype: EventDetails
        """
        return cls('member_join_details', val)

    @classmethod
    def member_leave_details(cls, val):
        """
        Create an instance of this class set to the ``member_leave_details`` tag
        with value ``val``.

        :param MemberLeaveDetails val:
        :rtype: EventDetails
        """
        return cls('member_leave_details', val)

    @classmethod
    def member_recover_details(cls, val):
        """
        Create an instance of this class set to the ``member_recover_details``
        tag with value ``val``.

        :param MemberRecoverDetails val:
        :rtype: EventDetails
        """
        return cls('member_recover_details', val)

    @classmethod
    def member_suggest_details(cls, val):
        """
        Create an instance of this class set to the ``member_suggest_details``
        tag with value ``val``.

        :param MemberSuggestDetails val:
        :rtype: EventDetails
        """
        return cls('member_suggest_details', val)

    @classmethod
    def member_suspend_details(cls, val):
        """
        Create an instance of this class set to the ``member_suspend_details``
        tag with value ``val``.

        :param MemberSuspendDetails val:
        :rtype: EventDetails
        """
        return cls('member_suspend_details', val)

    @classmethod
    def member_unsuspend_details(cls, val):
        """
        Create an instance of this class set to the ``member_unsuspend_details``
        tag with value ``val``.

        :param MemberUnsuspendDetails val:
        :rtype: EventDetails
        """
        return cls('member_unsuspend_details', val)

    @classmethod
    def paper_content_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_member_details`` tag with value ``val``.

        :param PaperContentAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_add_member_details', val)

    @classmethod
    def paper_content_add_to_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_add_to_folder_details`` tag with value ``val``.

        :param PaperContentAddToFolderDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_add_to_folder_details', val)

    @classmethod
    def paper_content_archive_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_archive_details`` tag with value ``val``.

        :param PaperContentArchiveDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_archive_details', val)

    @classmethod
    def paper_content_change_subscription_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_change_subscription_details`` tag with value ``val``.

        :param PaperContentChangeSubscriptionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_change_subscription_details', val)

    @classmethod
    def paper_content_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_create_details`` tag with value ``val``.

        :param PaperContentCreateDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_create_details', val)

    @classmethod
    def paper_content_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_permanently_delete_details`` tag with value ``val``.

        :param PaperContentPermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_permanently_delete_details', val)

    @classmethod
    def paper_content_remove_from_folder_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_from_folder_details`` tag with value ``val``.

        :param PaperContentRemoveFromFolderDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_remove_from_folder_details', val)

    @classmethod
    def paper_content_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_remove_member_details`` tag with value ``val``.

        :param PaperContentRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_remove_member_details', val)

    @classmethod
    def paper_content_rename_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_rename_details`` tag with value ``val``.

        :param PaperContentRenameDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_rename_details', val)

    @classmethod
    def paper_content_restore_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_content_restore_details`` tag with value ``val``.

        :param PaperContentRestoreDetails val:
        :rtype: EventDetails
        """
        return cls('paper_content_restore_details', val)

    @classmethod
    def paper_doc_add_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_add_comment_details`` tag with value ``val``.

        :param PaperDocAddCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_add_comment_details', val)

    @classmethod
    def paper_doc_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_member_role_details`` tag with value ``val``.

        :param PaperDocChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_member_role_details', val)

    @classmethod
    def paper_doc_change_sharing_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_change_sharing_policy_details`` tag with value ``val``.

        :param PaperDocChangeSharingPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_change_sharing_policy_details', val)

    @classmethod
    def paper_doc_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_deleted_details`` tag with value ``val``.

        :param PaperDocDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_deleted_details', val)

    @classmethod
    def paper_doc_delete_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_delete_comment_details`` tag with value ``val``.

        :param PaperDocDeleteCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_delete_comment_details', val)

    @classmethod
    def paper_doc_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_download_details`` tag with value ``val``.

        :param PaperDocDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_download_details', val)

    @classmethod
    def paper_doc_edit_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_edit_details``
        tag with value ``val``.

        :param PaperDocEditDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_edit_details', val)

    @classmethod
    def paper_doc_edit_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_edit_comment_details`` tag with value ``val``.

        :param PaperDocEditCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_edit_comment_details', val)

    @classmethod
    def paper_doc_followed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_followed_details`` tag with value ``val``.

        :param PaperDocFollowedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_followed_details', val)

    @classmethod
    def paper_doc_mention_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_mention_details`` tag with value ``val``.

        :param PaperDocMentionDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_mention_details', val)

    @classmethod
    def paper_doc_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_request_access_details`` tag with value ``val``.

        :param PaperDocRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_request_access_details', val)

    @classmethod
    def paper_doc_resolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_resolve_comment_details`` tag with value ``val``.

        :param PaperDocResolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_resolve_comment_details', val)

    @classmethod
    def paper_doc_revert_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_revert_details``
        tag with value ``val``.

        :param PaperDocRevertDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_revert_details', val)

    @classmethod
    def paper_doc_slack_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_slack_share_details`` tag with value ``val``.

        :param PaperDocSlackShareDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_slack_share_details', val)

    @classmethod
    def paper_doc_team_invite_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_team_invite_details`` tag with value ``val``.

        :param PaperDocTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_team_invite_details', val)

    @classmethod
    def paper_doc_unresolve_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_doc_unresolve_comment_details`` tag with value ``val``.

        :param PaperDocUnresolveCommentDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_unresolve_comment_details', val)

    @classmethod
    def paper_doc_view_details(cls, val):
        """
        Create an instance of this class set to the ``paper_doc_view_details``
        tag with value ``val``.

        :param PaperDocViewDetails val:
        :rtype: EventDetails
        """
        return cls('paper_doc_view_details', val)

    @classmethod
    def paper_folder_deleted_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_deleted_details`` tag with value ``val``.

        :param PaperFolderDeletedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_deleted_details', val)

    @classmethod
    def paper_folder_followed_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_followed_details`` tag with value ``val``.

        :param PaperFolderFollowedDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_followed_details', val)

    @classmethod
    def paper_folder_team_invite_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_folder_team_invite_details`` tag with value ``val``.

        :param PaperFolderTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('paper_folder_team_invite_details', val)

    @classmethod
    def password_change_details(cls, val):
        """
        Create an instance of this class set to the ``password_change_details``
        tag with value ``val``.

        :param PasswordChangeDetails val:
        :rtype: EventDetails
        """
        return cls('password_change_details', val)

    @classmethod
    def password_reset_details(cls, val):
        """
        Create an instance of this class set to the ``password_reset_details``
        tag with value ``val``.

        :param PasswordResetDetails val:
        :rtype: EventDetails
        """
        return cls('password_reset_details', val)

    @classmethod
    def password_reset_all_details(cls, val):
        """
        Create an instance of this class set to the
        ``password_reset_all_details`` tag with value ``val``.

        :param PasswordResetAllDetails val:
        :rtype: EventDetails
        """
        return cls('password_reset_all_details', val)

    @classmethod
    def emm_create_exceptions_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_exceptions_report_details`` tag with value ``val``.

        :param EmmCreateExceptionsReportDetails val:
        :rtype: EventDetails
        """
        return cls('emm_create_exceptions_report_details', val)

    @classmethod
    def emm_create_usage_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_create_usage_report_details`` tag with value ``val``.

        :param EmmCreateUsageReportDetails val:
        :rtype: EventDetails
        """
        return cls('emm_create_usage_report_details', val)

    @classmethod
    def smart_sync_create_admin_privilege_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_create_admin_privilege_report_details`` tag with value
        ``val``.

        :param SmartSyncCreateAdminPrivilegeReportDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_create_admin_privilege_report_details', val)

    @classmethod
    def team_activity_create_report_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_activity_create_report_details`` tag with value ``val``.

        :param TeamActivityCreateReportDetails val:
        :rtype: EventDetails
        """
        return cls('team_activity_create_report_details', val)

    @classmethod
    def collection_share_details(cls, val):
        """
        Create an instance of this class set to the ``collection_share_details``
        tag with value ``val``.

        :param CollectionShareDetails val:
        :rtype: EventDetails
        """
        return cls('collection_share_details', val)

    @classmethod
    def file_add_comment_details(cls, val):
        """
        Create an instance of this class set to the ``file_add_comment_details``
        tag with value ``val``.

        :param FileAddCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_add_comment_details', val)

    @classmethod
    def file_like_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_like_comment_details`` tag with value ``val``.

        :param FileLikeCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_like_comment_details', val)

    @classmethod
    def file_unlike_comment_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_unlike_comment_details`` tag with value ``val``.

        :param FileUnlikeCommentDetails val:
        :rtype: EventDetails
        """
        return cls('file_unlike_comment_details', val)

    @classmethod
    def note_acl_invite_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_acl_invite_only_details`` tag with value ``val``.

        :param NoteAclInviteOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_invite_only_details', val)

    @classmethod
    def note_acl_link_details(cls, val):
        """
        Create an instance of this class set to the ``note_acl_link_details``
        tag with value ``val``.

        :param NoteAclLinkDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_link_details', val)

    @classmethod
    def note_acl_team_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_acl_team_link_details`` tag with value ``val``.

        :param NoteAclTeamLinkDetails val:
        :rtype: EventDetails
        """
        return cls('note_acl_team_link_details', val)

    @classmethod
    def note_shared_details(cls, val):
        """
        Create an instance of this class set to the ``note_shared_details`` tag
        with value ``val``.

        :param NoteSharedDetails val:
        :rtype: EventDetails
        """
        return cls('note_shared_details', val)

    @classmethod
    def note_share_receive_details(cls, val):
        """
        Create an instance of this class set to the
        ``note_share_receive_details`` tag with value ``val``.

        :param NoteShareReceiveDetails val:
        :rtype: EventDetails
        """
        return cls('note_share_receive_details', val)

    @classmethod
    def open_note_shared_details(cls, val):
        """
        Create an instance of this class set to the ``open_note_shared_details``
        tag with value ``val``.

        :param OpenNoteSharedDetails val:
        :rtype: EventDetails
        """
        return cls('open_note_shared_details', val)

    @classmethod
    def sf_add_group_details(cls, val):
        """
        Create an instance of this class set to the ``sf_add_group_details`` tag
        with value ``val``.

        :param SfAddGroupDetails val:
        :rtype: EventDetails
        """
        return cls('sf_add_group_details', val)

    @classmethod
    def sf_allow_non_members_to_view_shared_links_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_allow_non_members_to_view_shared_links_details`` tag with value
        ``val``.

        :param SfAllowNonMembersToViewSharedLinksDetails val:
        :rtype: EventDetails
        """
        return cls('sf_allow_non_members_to_view_shared_links_details', val)

    @classmethod
    def sf_invite_group_details(cls, val):
        """
        Create an instance of this class set to the ``sf_invite_group_details``
        tag with value ``val``.

        :param SfInviteGroupDetails val:
        :rtype: EventDetails
        """
        return cls('sf_invite_group_details', val)

    @classmethod
    def sf_nest_details(cls, val):
        """
        Create an instance of this class set to the ``sf_nest_details`` tag with
        value ``val``.

        :param SfNestDetails val:
        :rtype: EventDetails
        """
        return cls('sf_nest_details', val)

    @classmethod
    def sf_team_decline_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_decline_details``
        tag with value ``val``.

        :param SfTeamDeclineDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_decline_details', val)

    @classmethod
    def sf_team_grant_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_grant_access_details`` tag with value ``val``.

        :param SfTeamGrantAccessDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_grant_access_details', val)

    @classmethod
    def sf_team_invite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_invite_details``
        tag with value ``val``.

        :param SfTeamInviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_invite_details', val)

    @classmethod
    def sf_team_invite_change_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_invite_change_role_details`` tag with value ``val``.

        :param SfTeamInviteChangeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_invite_change_role_details', val)

    @classmethod
    def sf_team_join_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_join_details`` tag
        with value ``val``.

        :param SfTeamJoinDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_join_details', val)

    @classmethod
    def sf_team_join_from_oob_link_details(cls, val):
        """
        Create an instance of this class set to the
        ``sf_team_join_from_oob_link_details`` tag with value ``val``.

        :param SfTeamJoinFromOobLinkDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_join_from_oob_link_details', val)

    @classmethod
    def sf_team_uninvite_details(cls, val):
        """
        Create an instance of this class set to the ``sf_team_uninvite_details``
        tag with value ``val``.

        :param SfTeamUninviteDetails val:
        :rtype: EventDetails
        """
        return cls('sf_team_uninvite_details', val)

    @classmethod
    def shared_content_add_invitees_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_invitees_details`` tag with value ``val``.

        :param SharedContentAddInviteesDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_invitees_details', val)

    @classmethod
    def shared_content_add_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_expiry_details`` tag with value ``val``.

        :param SharedContentAddLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_link_expiry_details', val)

    @classmethod
    def shared_content_add_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_link_password_details`` tag with value ``val``.

        :param SharedContentAddLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_link_password_details', val)

    @classmethod
    def shared_content_add_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_add_member_details`` tag with value ``val``.

        :param SharedContentAddMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_add_member_details', val)

    @classmethod
    def shared_content_change_downloads_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_downloads_policy_details`` tag with value
        ``val``.

        :param SharedContentChangeDownloadsPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_downloads_policy_details', val)

    @classmethod
    def shared_content_change_invitee_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_invitee_role_details`` tag with value ``val``.

        :param SharedContentChangeInviteeRoleDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_invitee_role_details', val)

    @classmethod
    def shared_content_change_link_audience_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_audience_details`` tag with value ``val``.

        :param SharedContentChangeLinkAudienceDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_audience_details', val)

    @classmethod
    def shared_content_change_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_expiry_details`` tag with value ``val``.

        :param SharedContentChangeLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_expiry_details', val)

    @classmethod
    def shared_content_change_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_link_password_details`` tag with value ``val``.

        :param SharedContentChangeLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_link_password_details', val)

    @classmethod
    def shared_content_change_member_role_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_member_role_details`` tag with value ``val``.

        :param SharedContentChangeMemberRoleDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_member_role_details', val)

    @classmethod
    def shared_content_change_viewer_info_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_change_viewer_info_policy_details`` tag with value
        ``val``.

        :param SharedContentChangeViewerInfoPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_change_viewer_info_policy_details', val)

    @classmethod
    def shared_content_claim_invitation_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_claim_invitation_details`` tag with value ``val``.

        :param SharedContentClaimInvitationDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_claim_invitation_details', val)

    @classmethod
    def shared_content_copy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_copy_details`` tag with value ``val``.

        :param SharedContentCopyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_copy_details', val)

    @classmethod
    def shared_content_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_download_details`` tag with value ``val``.

        :param SharedContentDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_download_details', val)

    @classmethod
    def shared_content_relinquish_membership_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_relinquish_membership_details`` tag with value ``val``.

        :param SharedContentRelinquishMembershipDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_relinquish_membership_details', val)

    @classmethod
    def shared_content_remove_invitee_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_invitee_details`` tag with value ``val``.

        :param SharedContentRemoveInviteeDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_invitee_details', val)

    @classmethod
    def shared_content_remove_link_expiry_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_expiry_details`` tag with value ``val``.

        :param SharedContentRemoveLinkExpiryDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_link_expiry_details', val)

    @classmethod
    def shared_content_remove_link_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_link_password_details`` tag with value ``val``.

        :param SharedContentRemoveLinkPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_link_password_details', val)

    @classmethod
    def shared_content_remove_member_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_remove_member_details`` tag with value ``val``.

        :param SharedContentRemoveMemberDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_remove_member_details', val)

    @classmethod
    def shared_content_request_access_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_request_access_details`` tag with value ``val``.

        :param SharedContentRequestAccessDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_request_access_details', val)

    @classmethod
    def shared_content_unshare_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_unshare_details`` tag with value ``val``.

        :param SharedContentUnshareDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_unshare_details', val)

    @classmethod
    def shared_content_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_content_view_details`` tag with value ``val``.

        :param SharedContentViewDetails val:
        :rtype: EventDetails
        """
        return cls('shared_content_view_details', val)

    @classmethod
    def shared_folder_change_confidentiality_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_confidentiality_details`` tag with value ``val``.

        :param SharedFolderChangeConfidentialityDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_confidentiality_details', val)

    @classmethod
    def shared_folder_change_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_link_policy_details`` tag with value ``val``.

        :param SharedFolderChangeLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_link_policy_details', val)

    @classmethod
    def shared_folder_change_member_management_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_member_management_policy_details`` tag with value
        ``val``.

        :param SharedFolderChangeMemberManagementPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_member_management_policy_details', val)

    @classmethod
    def shared_folder_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_change_member_policy_details`` tag with value ``val``.

        :param SharedFolderChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_change_member_policy_details', val)

    @classmethod
    def shared_folder_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_create_details`` tag with value ``val``.

        :param SharedFolderCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_create_details', val)

    @classmethod
    def shared_folder_mount_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_mount_details`` tag with value ``val``.

        :param SharedFolderMountDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_mount_details', val)

    @classmethod
    def shared_folder_transfer_ownership_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_transfer_ownership_details`` tag with value ``val``.

        :param SharedFolderTransferOwnershipDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_transfer_ownership_details', val)

    @classmethod
    def shared_folder_unmount_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_folder_unmount_details`` tag with value ``val``.

        :param SharedFolderUnmountDetails val:
        :rtype: EventDetails
        """
        return cls('shared_folder_unmount_details', val)

    @classmethod
    def shared_note_opened_details(cls, val):
        """
        Create an instance of this class set to the
        ``shared_note_opened_details`` tag with value ``val``.

        :param SharedNoteOpenedDetails val:
        :rtype: EventDetails
        """
        return cls('shared_note_opened_details', val)

    @classmethod
    def shmodel_app_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_app_create_details`` tag with value ``val``.

        :param ShmodelAppCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_app_create_details', val)

    @classmethod
    def shmodel_create_details(cls, val):
        """
        Create an instance of this class set to the ``shmodel_create_details``
        tag with value ``val``.

        :param ShmodelCreateDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_create_details', val)

    @classmethod
    def shmodel_disable_details(cls, val):
        """
        Create an instance of this class set to the ``shmodel_disable_details``
        tag with value ``val``.

        :param ShmodelDisableDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_disable_details', val)

    @classmethod
    def shmodel_fb_share_details(cls, val):
        """
        Create an instance of this class set to the ``shmodel_fb_share_details``
        tag with value ``val``.

        :param ShmodelFbShareDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_fb_share_details', val)

    @classmethod
    def shmodel_group_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_group_share_details`` tag with value ``val``.

        :param ShmodelGroupShareDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_group_share_details', val)

    @classmethod
    def shmodel_remove_expiration_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_remove_expiration_details`` tag with value ``val``.

        :param ShmodelRemoveExpirationDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_remove_expiration_details', val)

    @classmethod
    def shmodel_set_expiration_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_set_expiration_details`` tag with value ``val``.

        :param ShmodelSetExpirationDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_set_expiration_details', val)

    @classmethod
    def shmodel_team_copy_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_team_copy_details`` tag with value ``val``.

        :param ShmodelTeamCopyDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_team_copy_details', val)

    @classmethod
    def shmodel_team_download_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_team_download_details`` tag with value ``val``.

        :param ShmodelTeamDownloadDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_team_download_details', val)

    @classmethod
    def shmodel_team_share_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_team_share_details`` tag with value ``val``.

        :param ShmodelTeamShareDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_team_share_details', val)

    @classmethod
    def shmodel_team_view_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_team_view_details`` tag with value ``val``.

        :param ShmodelTeamViewDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_team_view_details', val)

    @classmethod
    def shmodel_visibility_password_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_visibility_password_details`` tag with value ``val``.

        :param ShmodelVisibilityPasswordDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_visibility_password_details', val)

    @classmethod
    def shmodel_visibility_public_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_visibility_public_details`` tag with value ``val``.

        :param ShmodelVisibilityPublicDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_visibility_public_details', val)

    @classmethod
    def shmodel_visibility_team_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``shmodel_visibility_team_only_details`` tag with value ``val``.

        :param ShmodelVisibilityTeamOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('shmodel_visibility_team_only_details', val)

    @classmethod
    def remove_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``remove_logout_url_details`` tag with value ``val``.

        :param RemoveLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('remove_logout_url_details', val)

    @classmethod
    def remove_sso_url_details(cls, val):
        """
        Create an instance of this class set to the ``remove_sso_url_details``
        tag with value ``val``.

        :param RemoveSsoUrlDetails val:
        :rtype: EventDetails
        """
        return cls('remove_sso_url_details', val)

    @classmethod
    def sso_change_cert_details(cls, val):
        """
        Create an instance of this class set to the ``sso_change_cert_details``
        tag with value ``val``.

        :param SsoChangeCertDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_cert_details', val)

    @classmethod
    def sso_change_login_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_login_url_details`` tag with value ``val``.

        :param SsoChangeLoginUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_login_url_details', val)

    @classmethod
    def sso_change_logout_url_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_logout_url_details`` tag with value ``val``.

        :param SsoChangeLogoutUrlDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_logout_url_details', val)

    @classmethod
    def sso_change_saml_identity_mode_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_saml_identity_mode_details`` tag with value ``val``.

        :param SsoChangeSamlIdentityModeDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_saml_identity_mode_details', val)

    @classmethod
    def team_folder_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_change_status_details`` tag with value ``val``.

        :param TeamFolderChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_change_status_details', val)

    @classmethod
    def team_folder_create_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_create_details`` tag with value ``val``.

        :param TeamFolderCreateDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_create_details', val)

    @classmethod
    def team_folder_downgrade_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_downgrade_details`` tag with value ``val``.

        :param TeamFolderDowngradeDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_downgrade_details', val)

    @classmethod
    def team_folder_permanently_delete_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_permanently_delete_details`` tag with value ``val``.

        :param TeamFolderPermanentlyDeleteDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_permanently_delete_details', val)

    @classmethod
    def team_folder_rename_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_folder_rename_details`` tag with value ``val``.

        :param TeamFolderRenameDetails val:
        :rtype: EventDetails
        """
        return cls('team_folder_rename_details', val)

    @classmethod
    def account_capture_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``account_capture_change_policy_details`` tag with value ``val``.

        :param AccountCaptureChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('account_capture_change_policy_details', val)

    @classmethod
    def allow_download_disabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``allow_download_disabled_details`` tag with value ``val``.

        :param AllowDownloadDisabledDetails val:
        :rtype: EventDetails
        """
        return cls('allow_download_disabled_details', val)

    @classmethod
    def allow_download_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``allow_download_enabled_details`` tag with value ``val``.

        :param AllowDownloadEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('allow_download_enabled_details', val)

    @classmethod
    def data_placement_restriction_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_change_policy_details`` tag with value
        ``val``.

        :param DataPlacementRestrictionChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('data_placement_restriction_change_policy_details', val)

    @classmethod
    def data_placement_restriction_satisfy_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``data_placement_restriction_satisfy_policy_details`` tag with value
        ``val``.

        :param DataPlacementRestrictionSatisfyPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('data_placement_restriction_satisfy_policy_details', val)

    @classmethod
    def device_approvals_change_desktop_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_desktop_policy_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeDesktopPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_desktop_policy_details', val)

    @classmethod
    def device_approvals_change_mobile_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_mobile_policy_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeMobilePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_mobile_policy_details', val)

    @classmethod
    def device_approvals_change_overage_action_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_overage_action_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeOverageActionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_overage_action_details', val)

    @classmethod
    def device_approvals_change_unlink_action_details(cls, val):
        """
        Create an instance of this class set to the
        ``device_approvals_change_unlink_action_details`` tag with value
        ``val``.

        :param DeviceApprovalsChangeUnlinkActionDetails val:
        :rtype: EventDetails
        """
        return cls('device_approvals_change_unlink_action_details', val)

    @classmethod
    def emm_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_add_exception_details`` tag with value ``val``.

        :param EmmAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('emm_add_exception_details', val)

    @classmethod
    def emm_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_change_policy_details`` tag with value ``val``.

        :param EmmChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('emm_change_policy_details', val)

    @classmethod
    def emm_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``emm_remove_exception_details`` tag with value ``val``.

        :param EmmRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('emm_remove_exception_details', val)

    @classmethod
    def extended_version_history_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``extended_version_history_change_policy_details`` tag with value
        ``val``.

        :param ExtendedVersionHistoryChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('extended_version_history_change_policy_details', val)

    @classmethod
    def file_comments_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_comments_change_policy_details`` tag with value ``val``.

        :param FileCommentsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('file_comments_change_policy_details', val)

    @classmethod
    def file_requests_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_change_policy_details`` tag with value ``val``.

        :param FileRequestsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_change_policy_details', val)

    @classmethod
    def file_requests_emails_enabled_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_enabled_details`` tag with value ``val``.

        :param FileRequestsEmailsEnabledDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_emails_enabled_details', val)

    @classmethod
    def file_requests_emails_restricted_to_team_only_details(cls, val):
        """
        Create an instance of this class set to the
        ``file_requests_emails_restricted_to_team_only_details`` tag with value
        ``val``.

        :param FileRequestsEmailsRestrictedToTeamOnlyDetails val:
        :rtype: EventDetails
        """
        return cls('file_requests_emails_restricted_to_team_only_details', val)

    @classmethod
    def google_sso_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``google_sso_change_policy_details`` tag with value ``val``.

        :param GoogleSsoChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('google_sso_change_policy_details', val)

    @classmethod
    def group_user_management_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``group_user_management_change_policy_details`` tag with value ``val``.

        :param GroupUserManagementChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('group_user_management_change_policy_details', val)

    @classmethod
    def member_requests_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_requests_change_policy_details`` tag with value ``val``.

        :param MemberRequestsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_requests_change_policy_details', val)

    @classmethod
    def member_space_limits_add_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_add_exception_details`` tag with value ``val``.

        :param MemberSpaceLimitsAddExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_add_exception_details', val)

    @classmethod
    def member_space_limits_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_change_policy_details`` tag with value ``val``.

        :param MemberSpaceLimitsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_change_policy_details', val)

    @classmethod
    def member_space_limits_remove_exception_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_space_limits_remove_exception_details`` tag with value ``val``.

        :param MemberSpaceLimitsRemoveExceptionDetails val:
        :rtype: EventDetails
        """
        return cls('member_space_limits_remove_exception_details', val)

    @classmethod
    def member_suggestions_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``member_suggestions_change_policy_details`` tag with value ``val``.

        :param MemberSuggestionsChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('member_suggestions_change_policy_details', val)

    @classmethod
    def microsoft_office_addin_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``microsoft_office_addin_change_policy_details`` tag with value ``val``.

        :param MicrosoftOfficeAddinChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('microsoft_office_addin_change_policy_details', val)

    @classmethod
    def network_control_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``network_control_change_policy_details`` tag with value ``val``.

        :param NetworkControlChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('network_control_change_policy_details', val)

    @classmethod
    def paper_change_deployment_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_deployment_policy_details`` tag with value ``val``.

        :param PaperChangeDeploymentPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_deployment_policy_details', val)

    @classmethod
    def paper_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_member_policy_details`` tag with value ``val``.

        :param PaperChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_member_policy_details', val)

    @classmethod
    def paper_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``paper_change_policy_details`` tag with value ``val``.

        :param PaperChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('paper_change_policy_details', val)

    @classmethod
    def permanent_delete_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``permanent_delete_change_policy_details`` tag with value ``val``.

        :param PermanentDeleteChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('permanent_delete_change_policy_details', val)

    @classmethod
    def sharing_change_folder_join_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_folder_join_policy_details`` tag with value ``val``.

        :param SharingChangeFolderJoinPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_folder_join_policy_details', val)

    @classmethod
    def sharing_change_link_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_link_policy_details`` tag with value ``val``.

        :param SharingChangeLinkPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_link_policy_details', val)

    @classmethod
    def sharing_change_member_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sharing_change_member_policy_details`` tag with value ``val``.

        :param SharingChangeMemberPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sharing_change_member_policy_details', val)

    @classmethod
    def smart_sync_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``smart_sync_change_policy_details`` tag with value ``val``.

        :param SmartSyncChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('smart_sync_change_policy_details', val)

    @classmethod
    def sso_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``sso_change_policy_details`` tag with value ``val``.

        :param SsoChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('sso_change_policy_details', val)

    @classmethod
    def tfa_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_policy_details`` tag with value ``val``.

        :param TfaChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_policy_details', val)

    @classmethod
    def two_account_change_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``two_account_change_policy_details`` tag with value ``val``.

        :param TwoAccountChangePolicyDetails val:
        :rtype: EventDetails
        """
        return cls('two_account_change_policy_details', val)

    @classmethod
    def web_sessions_change_fixed_length_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_fixed_length_policy_details`` tag with value
        ``val``.

        :param WebSessionsChangeFixedLengthPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_fixed_length_policy_details', val)

    @classmethod
    def web_sessions_change_idle_length_policy_details(cls, val):
        """
        Create an instance of this class set to the
        ``web_sessions_change_idle_length_policy_details`` tag with value
        ``val``.

        :param WebSessionsChangeIdleLengthPolicyDetails val:
        :rtype: EventDetails
        """
        return cls('web_sessions_change_idle_length_policy_details', val)

    @classmethod
    def team_profile_add_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_add_logo_details`` tag with value ``val``.

        :param TeamProfileAddLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_add_logo_details', val)

    @classmethod
    def team_profile_change_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_logo_details`` tag with value ``val``.

        :param TeamProfileChangeLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_logo_details', val)

    @classmethod
    def team_profile_change_name_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_change_name_details`` tag with value ``val``.

        :param TeamProfileChangeNameDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_change_name_details', val)

    @classmethod
    def team_profile_remove_logo_details(cls, val):
        """
        Create an instance of this class set to the
        ``team_profile_remove_logo_details`` tag with value ``val``.

        :param TeamProfileRemoveLogoDetails val:
        :rtype: EventDetails
        """
        return cls('team_profile_remove_logo_details', val)

    @classmethod
    def tfa_add_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_backup_phone_details`` tag with value ``val``.

        :param TfaAddBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_backup_phone_details', val)

    @classmethod
    def tfa_add_security_key_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_add_security_key_details`` tag with value ``val``.

        :param TfaAddSecurityKeyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_add_security_key_details', val)

    @classmethod
    def tfa_change_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_backup_phone_details`` tag with value ``val``.

        :param TfaChangeBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_backup_phone_details', val)

    @classmethod
    def tfa_change_status_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_change_status_details`` tag with value ``val``.

        :param TfaChangeStatusDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_change_status_details', val)

    @classmethod
    def tfa_remove_backup_phone_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_backup_phone_details`` tag with value ``val``.

        :param TfaRemoveBackupPhoneDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_backup_phone_details', val)

    @classmethod
    def tfa_remove_security_key_details(cls, val):
        """
        Create an instance of this class set to the
        ``tfa_remove_security_key_details`` tag with value ``val``.

        :param TfaRemoveSecurityKeyDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_remove_security_key_details', val)

    @classmethod
    def tfa_reset_details(cls, val):
        """
        Create an instance of this class set to the ``tfa_reset_details`` tag
        with value ``val``.

        :param TfaResetDetails val:
        :rtype: EventDetails
        """
        return cls('tfa_reset_details', val)

    @classmethod
    def missing_details(cls, val):
        """
        Create an instance of this class set to the ``missing_details`` tag with
        value ``val``.

        :param MissingDetails val:
        :rtype: EventDetails
        """
        return cls('missing_details', val)

    def is_member_change_membership_type_details(self):
        """
        Check if the union tag is ``member_change_membership_type_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_membership_type_details'

    def is_member_permanently_delete_account_contents_details(self):
        """
        Check if the union tag is ``member_permanently_delete_account_contents_details``.

        :rtype: bool
        """
        return self._tag == 'member_permanently_delete_account_contents_details'

    def is_member_space_limits_change_status_details(self):
        """
        Check if the union tag is ``member_space_limits_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_status_details'

    def is_member_transfer_account_contents_details(self):
        """
        Check if the union tag is ``member_transfer_account_contents_details``.

        :rtype: bool
        """
        return self._tag == 'member_transfer_account_contents_details'

    def is_paper_enabled_users_group_addition_details(self):
        """
        Check if the union tag is ``paper_enabled_users_group_addition_details``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_addition_details'

    def is_paper_enabled_users_group_removal_details(self):
        """
        Check if the union tag is ``paper_enabled_users_group_removal_details``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_removal_details'

    def is_paper_external_view_allow_details(self):
        """
        Check if the union tag is ``paper_external_view_allow_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_allow_details'

    def is_paper_external_view_default_team_details(self):
        """
        Check if the union tag is ``paper_external_view_default_team_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_default_team_details'

    def is_paper_external_view_forbid_details(self):
        """
        Check if the union tag is ``paper_external_view_forbid_details``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_forbid_details'

    def is_sf_external_invite_warn_details(self):
        """
        Check if the union tag is ``sf_external_invite_warn_details``.

        :rtype: bool
        """
        return self._tag == 'sf_external_invite_warn_details'

    def is_team_merge_details(self):
        """
        Check if the union tag is ``team_merge_details``.

        :rtype: bool
        """
        return self._tag == 'team_merge_details'

    def is_app_link_team_details(self):
        """
        Check if the union tag is ``app_link_team_details``.

        :rtype: bool
        """
        return self._tag == 'app_link_team_details'

    def is_app_link_user_details(self):
        """
        Check if the union tag is ``app_link_user_details``.

        :rtype: bool
        """
        return self._tag == 'app_link_user_details'

    def is_app_unlink_team_details(self):
        """
        Check if the union tag is ``app_unlink_team_details``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_team_details'

    def is_app_unlink_user_details(self):
        """
        Check if the union tag is ``app_unlink_user_details``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_user_details'

    def is_device_change_ip_desktop_details(self):
        """
        Check if the union tag is ``device_change_ip_desktop_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_desktop_details'

    def is_device_change_ip_mobile_details(self):
        """
        Check if the union tag is ``device_change_ip_mobile_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_mobile_details'

    def is_device_change_ip_web_details(self):
        """
        Check if the union tag is ``device_change_ip_web_details``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_web_details'

    def is_device_delete_on_unlink_fail_details(self):
        """
        Check if the union tag is ``device_delete_on_unlink_fail_details``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_fail_details'

    def is_device_delete_on_unlink_success_details(self):
        """
        Check if the union tag is ``device_delete_on_unlink_success_details``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_success_details'

    def is_device_link_fail_details(self):
        """
        Check if the union tag is ``device_link_fail_details``.

        :rtype: bool
        """
        return self._tag == 'device_link_fail_details'

    def is_device_link_success_details(self):
        """
        Check if the union tag is ``device_link_success_details``.

        :rtype: bool
        """
        return self._tag == 'device_link_success_details'

    def is_device_management_disabled_details(self):
        """
        Check if the union tag is ``device_management_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'device_management_disabled_details'

    def is_device_management_enabled_details(self):
        """
        Check if the union tag is ``device_management_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'device_management_enabled_details'

    def is_device_unlink_details(self):
        """
        Check if the union tag is ``device_unlink_details``.

        :rtype: bool
        """
        return self._tag == 'device_unlink_details'

    def is_emm_refresh_auth_token_details(self):
        """
        Check if the union tag is ``emm_refresh_auth_token_details``.

        :rtype: bool
        """
        return self._tag == 'emm_refresh_auth_token_details'

    def is_account_capture_change_availability_details(self):
        """
        Check if the union tag is ``account_capture_change_availability_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_availability_details'

    def is_account_capture_migrate_account_details(self):
        """
        Check if the union tag is ``account_capture_migrate_account_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_migrate_account_details'

    def is_account_capture_relinquish_account_details(self):
        """
        Check if the union tag is ``account_capture_relinquish_account_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_relinquish_account_details'

    def is_disabled_domain_invites_details(self):
        """
        Check if the union tag is ``disabled_domain_invites_details``.

        :rtype: bool
        """
        return self._tag == 'disabled_domain_invites_details'

    def is_domain_invites_approve_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_approve_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_approve_request_to_join_team_details'

    def is_domain_invites_decline_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_decline_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_decline_request_to_join_team_details'

    def is_domain_invites_email_existing_users_details(self):
        """
        Check if the union tag is ``domain_invites_email_existing_users_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_email_existing_users_details'

    def is_domain_invites_request_to_join_team_details(self):
        """
        Check if the union tag is ``domain_invites_request_to_join_team_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_request_to_join_team_details'

    def is_domain_invites_set_invite_new_user_pref_to_no_details(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_no_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_no_details'

    def is_domain_invites_set_invite_new_user_pref_to_yes_details(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_yes_details``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_yes_details'

    def is_domain_verification_add_domain_fail_details(self):
        """
        Check if the union tag is ``domain_verification_add_domain_fail_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_fail_details'

    def is_domain_verification_add_domain_success_details(self):
        """
        Check if the union tag is ``domain_verification_add_domain_success_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_success_details'

    def is_domain_verification_remove_domain_details(self):
        """
        Check if the union tag is ``domain_verification_remove_domain_details``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_remove_domain_details'

    def is_enabled_domain_invites_details(self):
        """
        Check if the union tag is ``enabled_domain_invites_details``.

        :rtype: bool
        """
        return self._tag == 'enabled_domain_invites_details'

    def is_create_folder_details(self):
        """
        Check if the union tag is ``create_folder_details``.

        :rtype: bool
        """
        return self._tag == 'create_folder_details'

    def is_file_add_details(self):
        """
        Check if the union tag is ``file_add_details``.

        :rtype: bool
        """
        return self._tag == 'file_add_details'

    def is_file_copy_details(self):
        """
        Check if the union tag is ``file_copy_details``.

        :rtype: bool
        """
        return self._tag == 'file_copy_details'

    def is_file_delete_details(self):
        """
        Check if the union tag is ``file_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_delete_details'

    def is_file_download_details(self):
        """
        Check if the union tag is ``file_download_details``.

        :rtype: bool
        """
        return self._tag == 'file_download_details'

    def is_file_edit_details(self):
        """
        Check if the union tag is ``file_edit_details``.

        :rtype: bool
        """
        return self._tag == 'file_edit_details'

    def is_file_get_copy_reference_details(self):
        """
        Check if the union tag is ``file_get_copy_reference_details``.

        :rtype: bool
        """
        return self._tag == 'file_get_copy_reference_details'

    def is_file_move_details(self):
        """
        Check if the union tag is ``file_move_details``.

        :rtype: bool
        """
        return self._tag == 'file_move_details'

    def is_file_permanently_delete_details(self):
        """
        Check if the union tag is ``file_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'file_permanently_delete_details'

    def is_file_preview_details(self):
        """
        Check if the union tag is ``file_preview_details``.

        :rtype: bool
        """
        return self._tag == 'file_preview_details'

    def is_file_rename_details(self):
        """
        Check if the union tag is ``file_rename_details``.

        :rtype: bool
        """
        return self._tag == 'file_rename_details'

    def is_file_restore_details(self):
        """
        Check if the union tag is ``file_restore_details``.

        :rtype: bool
        """
        return self._tag == 'file_restore_details'

    def is_file_revert_details(self):
        """
        Check if the union tag is ``file_revert_details``.

        :rtype: bool
        """
        return self._tag == 'file_revert_details'

    def is_file_rollback_changes_details(self):
        """
        Check if the union tag is ``file_rollback_changes_details``.

        :rtype: bool
        """
        return self._tag == 'file_rollback_changes_details'

    def is_file_save_copy_reference_details(self):
        """
        Check if the union tag is ``file_save_copy_reference_details``.

        :rtype: bool
        """
        return self._tag == 'file_save_copy_reference_details'

    def is_file_request_add_deadline_details(self):
        """
        Check if the union tag is ``file_request_add_deadline_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_add_deadline_details'

    def is_file_request_change_folder_details(self):
        """
        Check if the union tag is ``file_request_change_folder_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_change_folder_details'

    def is_file_request_change_title_details(self):
        """
        Check if the union tag is ``file_request_change_title_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_change_title_details'

    def is_file_request_close_details(self):
        """
        Check if the union tag is ``file_request_close_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_close_details'

    def is_file_request_create_details(self):
        """
        Check if the union tag is ``file_request_create_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_create_details'

    def is_file_request_receive_file_details(self):
        """
        Check if the union tag is ``file_request_receive_file_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_receive_file_details'

    def is_file_request_remove_deadline_details(self):
        """
        Check if the union tag is ``file_request_remove_deadline_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_remove_deadline_details'

    def is_file_request_send_details(self):
        """
        Check if the union tag is ``file_request_send_details``.

        :rtype: bool
        """
        return self._tag == 'file_request_send_details'

    def is_group_add_external_id_details(self):
        """
        Check if the union tag is ``group_add_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_add_external_id_details'

    def is_group_add_member_details(self):
        """
        Check if the union tag is ``group_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'group_add_member_details'

    def is_group_change_external_id_details(self):
        """
        Check if the union tag is ``group_change_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_external_id_details'

    def is_group_change_management_type_details(self):
        """
        Check if the union tag is ``group_change_management_type_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_management_type_details'

    def is_group_change_member_role_details(self):
        """
        Check if the union tag is ``group_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'group_change_member_role_details'

    def is_group_create_details(self):
        """
        Check if the union tag is ``group_create_details``.

        :rtype: bool
        """
        return self._tag == 'group_create_details'

    def is_group_delete_details(self):
        """
        Check if the union tag is ``group_delete_details``.

        :rtype: bool
        """
        return self._tag == 'group_delete_details'

    def is_group_description_updated_details(self):
        """
        Check if the union tag is ``group_description_updated_details``.

        :rtype: bool
        """
        return self._tag == 'group_description_updated_details'

    def is_group_join_policy_updated_details(self):
        """
        Check if the union tag is ``group_join_policy_updated_details``.

        :rtype: bool
        """
        return self._tag == 'group_join_policy_updated_details'

    def is_group_moved_details(self):
        """
        Check if the union tag is ``group_moved_details``.

        :rtype: bool
        """
        return self._tag == 'group_moved_details'

    def is_group_remove_external_id_details(self):
        """
        Check if the union tag is ``group_remove_external_id_details``.

        :rtype: bool
        """
        return self._tag == 'group_remove_external_id_details'

    def is_group_remove_member_details(self):
        """
        Check if the union tag is ``group_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'group_remove_member_details'

    def is_group_rename_details(self):
        """
        Check if the union tag is ``group_rename_details``.

        :rtype: bool
        """
        return self._tag == 'group_rename_details'

    def is_emm_login_success_details(self):
        """
        Check if the union tag is ``emm_login_success_details``.

        :rtype: bool
        """
        return self._tag == 'emm_login_success_details'

    def is_logout_details(self):
        """
        Check if the union tag is ``logout_details``.

        :rtype: bool
        """
        return self._tag == 'logout_details'

    def is_password_login_fail_details(self):
        """
        Check if the union tag is ``password_login_fail_details``.

        :rtype: bool
        """
        return self._tag == 'password_login_fail_details'

    def is_password_login_success_details(self):
        """
        Check if the union tag is ``password_login_success_details``.

        :rtype: bool
        """
        return self._tag == 'password_login_success_details'

    def is_reseller_support_session_end_details(self):
        """
        Check if the union tag is ``reseller_support_session_end_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_end_details'

    def is_reseller_support_session_start_details(self):
        """
        Check if the union tag is ``reseller_support_session_start_details``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_start_details'

    def is_sign_in_as_session_end_details(self):
        """
        Check if the union tag is ``sign_in_as_session_end_details``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_end_details'

    def is_sign_in_as_session_start_details(self):
        """
        Check if the union tag is ``sign_in_as_session_start_details``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_start_details'

    def is_sso_login_fail_details(self):
        """
        Check if the union tag is ``sso_login_fail_details``.

        :rtype: bool
        """
        return self._tag == 'sso_login_fail_details'

    def is_member_add_name_details(self):
        """
        Check if the union tag is ``member_add_name_details``.

        :rtype: bool
        """
        return self._tag == 'member_add_name_details'

    def is_member_change_email_details(self):
        """
        Check if the union tag is ``member_change_email_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_email_details'

    def is_member_change_name_details(self):
        """
        Check if the union tag is ``member_change_name_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_name_details'

    def is_member_change_role_details(self):
        """
        Check if the union tag is ``member_change_role_details``.

        :rtype: bool
        """
        return self._tag == 'member_change_role_details'

    def is_member_invite_details(self):
        """
        Check if the union tag is ``member_invite_details``.

        :rtype: bool
        """
        return self._tag == 'member_invite_details'

    def is_member_join_details(self):
        """
        Check if the union tag is ``member_join_details``.

        :rtype: bool
        """
        return self._tag == 'member_join_details'

    def is_member_leave_details(self):
        """
        Check if the union tag is ``member_leave_details``.

        :rtype: bool
        """
        return self._tag == 'member_leave_details'

    def is_member_recover_details(self):
        """
        Check if the union tag is ``member_recover_details``.

        :rtype: bool
        """
        return self._tag == 'member_recover_details'

    def is_member_suggest_details(self):
        """
        Check if the union tag is ``member_suggest_details``.

        :rtype: bool
        """
        return self._tag == 'member_suggest_details'

    def is_member_suspend_details(self):
        """
        Check if the union tag is ``member_suspend_details``.

        :rtype: bool
        """
        return self._tag == 'member_suspend_details'

    def is_member_unsuspend_details(self):
        """
        Check if the union tag is ``member_unsuspend_details``.

        :rtype: bool
        """
        return self._tag == 'member_unsuspend_details'

    def is_paper_content_add_member_details(self):
        """
        Check if the union tag is ``paper_content_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_member_details'

    def is_paper_content_add_to_folder_details(self):
        """
        Check if the union tag is ``paper_content_add_to_folder_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_to_folder_details'

    def is_paper_content_archive_details(self):
        """
        Check if the union tag is ``paper_content_archive_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_archive_details'

    def is_paper_content_change_subscription_details(self):
        """
        Check if the union tag is ``paper_content_change_subscription_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_change_subscription_details'

    def is_paper_content_create_details(self):
        """
        Check if the union tag is ``paper_content_create_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_create_details'

    def is_paper_content_permanently_delete_details(self):
        """
        Check if the union tag is ``paper_content_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_permanently_delete_details'

    def is_paper_content_remove_from_folder_details(self):
        """
        Check if the union tag is ``paper_content_remove_from_folder_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_from_folder_details'

    def is_paper_content_remove_member_details(self):
        """
        Check if the union tag is ``paper_content_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_member_details'

    def is_paper_content_rename_details(self):
        """
        Check if the union tag is ``paper_content_rename_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_rename_details'

    def is_paper_content_restore_details(self):
        """
        Check if the union tag is ``paper_content_restore_details``.

        :rtype: bool
        """
        return self._tag == 'paper_content_restore_details'

    def is_paper_doc_add_comment_details(self):
        """
        Check if the union tag is ``paper_doc_add_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_add_comment_details'

    def is_paper_doc_change_member_role_details(self):
        """
        Check if the union tag is ``paper_doc_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_member_role_details'

    def is_paper_doc_change_sharing_policy_details(self):
        """
        Check if the union tag is ``paper_doc_change_sharing_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_sharing_policy_details'

    def is_paper_doc_deleted_details(self):
        """
        Check if the union tag is ``paper_doc_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_deleted_details'

    def is_paper_doc_delete_comment_details(self):
        """
        Check if the union tag is ``paper_doc_delete_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_delete_comment_details'

    def is_paper_doc_download_details(self):
        """
        Check if the union tag is ``paper_doc_download_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_download_details'

    def is_paper_doc_edit_details(self):
        """
        Check if the union tag is ``paper_doc_edit_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_details'

    def is_paper_doc_edit_comment_details(self):
        """
        Check if the union tag is ``paper_doc_edit_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_comment_details'

    def is_paper_doc_followed_details(self):
        """
        Check if the union tag is ``paper_doc_followed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_followed_details'

    def is_paper_doc_mention_details(self):
        """
        Check if the union tag is ``paper_doc_mention_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_mention_details'

    def is_paper_doc_request_access_details(self):
        """
        Check if the union tag is ``paper_doc_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_request_access_details'

    def is_paper_doc_resolve_comment_details(self):
        """
        Check if the union tag is ``paper_doc_resolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_resolve_comment_details'

    def is_paper_doc_revert_details(self):
        """
        Check if the union tag is ``paper_doc_revert_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_revert_details'

    def is_paper_doc_slack_share_details(self):
        """
        Check if the union tag is ``paper_doc_slack_share_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_slack_share_details'

    def is_paper_doc_team_invite_details(self):
        """
        Check if the union tag is ``paper_doc_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_team_invite_details'

    def is_paper_doc_unresolve_comment_details(self):
        """
        Check if the union tag is ``paper_doc_unresolve_comment_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_unresolve_comment_details'

    def is_paper_doc_view_details(self):
        """
        Check if the union tag is ``paper_doc_view_details``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_view_details'

    def is_paper_folder_deleted_details(self):
        """
        Check if the union tag is ``paper_folder_deleted_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_deleted_details'

    def is_paper_folder_followed_details(self):
        """
        Check if the union tag is ``paper_folder_followed_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_followed_details'

    def is_paper_folder_team_invite_details(self):
        """
        Check if the union tag is ``paper_folder_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_team_invite_details'

    def is_password_change_details(self):
        """
        Check if the union tag is ``password_change_details``.

        :rtype: bool
        """
        return self._tag == 'password_change_details'

    def is_password_reset_details(self):
        """
        Check if the union tag is ``password_reset_details``.

        :rtype: bool
        """
        return self._tag == 'password_reset_details'

    def is_password_reset_all_details(self):
        """
        Check if the union tag is ``password_reset_all_details``.

        :rtype: bool
        """
        return self._tag == 'password_reset_all_details'

    def is_emm_create_exceptions_report_details(self):
        """
        Check if the union tag is ``emm_create_exceptions_report_details``.

        :rtype: bool
        """
        return self._tag == 'emm_create_exceptions_report_details'

    def is_emm_create_usage_report_details(self):
        """
        Check if the union tag is ``emm_create_usage_report_details``.

        :rtype: bool
        """
        return self._tag == 'emm_create_usage_report_details'

    def is_smart_sync_create_admin_privilege_report_details(self):
        """
        Check if the union tag is ``smart_sync_create_admin_privilege_report_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_create_admin_privilege_report_details'

    def is_team_activity_create_report_details(self):
        """
        Check if the union tag is ``team_activity_create_report_details``.

        :rtype: bool
        """
        return self._tag == 'team_activity_create_report_details'

    def is_collection_share_details(self):
        """
        Check if the union tag is ``collection_share_details``.

        :rtype: bool
        """
        return self._tag == 'collection_share_details'

    def is_file_add_comment_details(self):
        """
        Check if the union tag is ``file_add_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_add_comment_details'

    def is_file_like_comment_details(self):
        """
        Check if the union tag is ``file_like_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_like_comment_details'

    def is_file_unlike_comment_details(self):
        """
        Check if the union tag is ``file_unlike_comment_details``.

        :rtype: bool
        """
        return self._tag == 'file_unlike_comment_details'

    def is_note_acl_invite_only_details(self):
        """
        Check if the union tag is ``note_acl_invite_only_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_invite_only_details'

    def is_note_acl_link_details(self):
        """
        Check if the union tag is ``note_acl_link_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_link_details'

    def is_note_acl_team_link_details(self):
        """
        Check if the union tag is ``note_acl_team_link_details``.

        :rtype: bool
        """
        return self._tag == 'note_acl_team_link_details'

    def is_note_shared_details(self):
        """
        Check if the union tag is ``note_shared_details``.

        :rtype: bool
        """
        return self._tag == 'note_shared_details'

    def is_note_share_receive_details(self):
        """
        Check if the union tag is ``note_share_receive_details``.

        :rtype: bool
        """
        return self._tag == 'note_share_receive_details'

    def is_open_note_shared_details(self):
        """
        Check if the union tag is ``open_note_shared_details``.

        :rtype: bool
        """
        return self._tag == 'open_note_shared_details'

    def is_sf_add_group_details(self):
        """
        Check if the union tag is ``sf_add_group_details``.

        :rtype: bool
        """
        return self._tag == 'sf_add_group_details'

    def is_sf_allow_non_members_to_view_shared_links_details(self):
        """
        Check if the union tag is ``sf_allow_non_members_to_view_shared_links_details``.

        :rtype: bool
        """
        return self._tag == 'sf_allow_non_members_to_view_shared_links_details'

    def is_sf_invite_group_details(self):
        """
        Check if the union tag is ``sf_invite_group_details``.

        :rtype: bool
        """
        return self._tag == 'sf_invite_group_details'

    def is_sf_nest_details(self):
        """
        Check if the union tag is ``sf_nest_details``.

        :rtype: bool
        """
        return self._tag == 'sf_nest_details'

    def is_sf_team_decline_details(self):
        """
        Check if the union tag is ``sf_team_decline_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_decline_details'

    def is_sf_team_grant_access_details(self):
        """
        Check if the union tag is ``sf_team_grant_access_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_grant_access_details'

    def is_sf_team_invite_details(self):
        """
        Check if the union tag is ``sf_team_invite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_details'

    def is_sf_team_invite_change_role_details(self):
        """
        Check if the union tag is ``sf_team_invite_change_role_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_change_role_details'

    def is_sf_team_join_details(self):
        """
        Check if the union tag is ``sf_team_join_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_details'

    def is_sf_team_join_from_oob_link_details(self):
        """
        Check if the union tag is ``sf_team_join_from_oob_link_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_from_oob_link_details'

    def is_sf_team_uninvite_details(self):
        """
        Check if the union tag is ``sf_team_uninvite_details``.

        :rtype: bool
        """
        return self._tag == 'sf_team_uninvite_details'

    def is_shared_content_add_invitees_details(self):
        """
        Check if the union tag is ``shared_content_add_invitees_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_invitees_details'

    def is_shared_content_add_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_add_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_expiry_details'

    def is_shared_content_add_link_password_details(self):
        """
        Check if the union tag is ``shared_content_add_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_password_details'

    def is_shared_content_add_member_details(self):
        """
        Check if the union tag is ``shared_content_add_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_member_details'

    def is_shared_content_change_downloads_policy_details(self):
        """
        Check if the union tag is ``shared_content_change_downloads_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_downloads_policy_details'

    def is_shared_content_change_invitee_role_details(self):
        """
        Check if the union tag is ``shared_content_change_invitee_role_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_invitee_role_details'

    def is_shared_content_change_link_audience_details(self):
        """
        Check if the union tag is ``shared_content_change_link_audience_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_audience_details'

    def is_shared_content_change_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_change_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_expiry_details'

    def is_shared_content_change_link_password_details(self):
        """
        Check if the union tag is ``shared_content_change_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_password_details'

    def is_shared_content_change_member_role_details(self):
        """
        Check if the union tag is ``shared_content_change_member_role_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_member_role_details'

    def is_shared_content_change_viewer_info_policy_details(self):
        """
        Check if the union tag is ``shared_content_change_viewer_info_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_viewer_info_policy_details'

    def is_shared_content_claim_invitation_details(self):
        """
        Check if the union tag is ``shared_content_claim_invitation_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_claim_invitation_details'

    def is_shared_content_copy_details(self):
        """
        Check if the union tag is ``shared_content_copy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_copy_details'

    def is_shared_content_download_details(self):
        """
        Check if the union tag is ``shared_content_download_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_download_details'

    def is_shared_content_relinquish_membership_details(self):
        """
        Check if the union tag is ``shared_content_relinquish_membership_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_relinquish_membership_details'

    def is_shared_content_remove_invitee_details(self):
        """
        Check if the union tag is ``shared_content_remove_invitee_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_invitee_details'

    def is_shared_content_remove_link_expiry_details(self):
        """
        Check if the union tag is ``shared_content_remove_link_expiry_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_expiry_details'

    def is_shared_content_remove_link_password_details(self):
        """
        Check if the union tag is ``shared_content_remove_link_password_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_password_details'

    def is_shared_content_remove_member_details(self):
        """
        Check if the union tag is ``shared_content_remove_member_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_member_details'

    def is_shared_content_request_access_details(self):
        """
        Check if the union tag is ``shared_content_request_access_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_request_access_details'

    def is_shared_content_unshare_details(self):
        """
        Check if the union tag is ``shared_content_unshare_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_unshare_details'

    def is_shared_content_view_details(self):
        """
        Check if the union tag is ``shared_content_view_details``.

        :rtype: bool
        """
        return self._tag == 'shared_content_view_details'

    def is_shared_folder_change_confidentiality_details(self):
        """
        Check if the union tag is ``shared_folder_change_confidentiality_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_confidentiality_details'

    def is_shared_folder_change_link_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_link_policy_details'

    def is_shared_folder_change_member_management_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_member_management_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_member_management_policy_details'

    def is_shared_folder_change_member_policy_details(self):
        """
        Check if the union tag is ``shared_folder_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_member_policy_details'

    def is_shared_folder_create_details(self):
        """
        Check if the union tag is ``shared_folder_create_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_create_details'

    def is_shared_folder_mount_details(self):
        """
        Check if the union tag is ``shared_folder_mount_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_mount_details'

    def is_shared_folder_transfer_ownership_details(self):
        """
        Check if the union tag is ``shared_folder_transfer_ownership_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_transfer_ownership_details'

    def is_shared_folder_unmount_details(self):
        """
        Check if the union tag is ``shared_folder_unmount_details``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_unmount_details'

    def is_shared_note_opened_details(self):
        """
        Check if the union tag is ``shared_note_opened_details``.

        :rtype: bool
        """
        return self._tag == 'shared_note_opened_details'

    def is_shmodel_app_create_details(self):
        """
        Check if the union tag is ``shmodel_app_create_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_app_create_details'

    def is_shmodel_create_details(self):
        """
        Check if the union tag is ``shmodel_create_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_create_details'

    def is_shmodel_disable_details(self):
        """
        Check if the union tag is ``shmodel_disable_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_disable_details'

    def is_shmodel_fb_share_details(self):
        """
        Check if the union tag is ``shmodel_fb_share_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_fb_share_details'

    def is_shmodel_group_share_details(self):
        """
        Check if the union tag is ``shmodel_group_share_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_group_share_details'

    def is_shmodel_remove_expiration_details(self):
        """
        Check if the union tag is ``shmodel_remove_expiration_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_remove_expiration_details'

    def is_shmodel_set_expiration_details(self):
        """
        Check if the union tag is ``shmodel_set_expiration_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_set_expiration_details'

    def is_shmodel_team_copy_details(self):
        """
        Check if the union tag is ``shmodel_team_copy_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_copy_details'

    def is_shmodel_team_download_details(self):
        """
        Check if the union tag is ``shmodel_team_download_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_download_details'

    def is_shmodel_team_share_details(self):
        """
        Check if the union tag is ``shmodel_team_share_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_share_details'

    def is_shmodel_team_view_details(self):
        """
        Check if the union tag is ``shmodel_team_view_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_view_details'

    def is_shmodel_visibility_password_details(self):
        """
        Check if the union tag is ``shmodel_visibility_password_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_visibility_password_details'

    def is_shmodel_visibility_public_details(self):
        """
        Check if the union tag is ``shmodel_visibility_public_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_visibility_public_details'

    def is_shmodel_visibility_team_only_details(self):
        """
        Check if the union tag is ``shmodel_visibility_team_only_details``.

        :rtype: bool
        """
        return self._tag == 'shmodel_visibility_team_only_details'

    def is_remove_logout_url_details(self):
        """
        Check if the union tag is ``remove_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'remove_logout_url_details'

    def is_remove_sso_url_details(self):
        """
        Check if the union tag is ``remove_sso_url_details``.

        :rtype: bool
        """
        return self._tag == 'remove_sso_url_details'

    def is_sso_change_cert_details(self):
        """
        Check if the union tag is ``sso_change_cert_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_cert_details'

    def is_sso_change_login_url_details(self):
        """
        Check if the union tag is ``sso_change_login_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_login_url_details'

    def is_sso_change_logout_url_details(self):
        """
        Check if the union tag is ``sso_change_logout_url_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_logout_url_details'

    def is_sso_change_saml_identity_mode_details(self):
        """
        Check if the union tag is ``sso_change_saml_identity_mode_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_saml_identity_mode_details'

    def is_team_folder_change_status_details(self):
        """
        Check if the union tag is ``team_folder_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_change_status_details'

    def is_team_folder_create_details(self):
        """
        Check if the union tag is ``team_folder_create_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_create_details'

    def is_team_folder_downgrade_details(self):
        """
        Check if the union tag is ``team_folder_downgrade_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_downgrade_details'

    def is_team_folder_permanently_delete_details(self):
        """
        Check if the union tag is ``team_folder_permanently_delete_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_permanently_delete_details'

    def is_team_folder_rename_details(self):
        """
        Check if the union tag is ``team_folder_rename_details``.

        :rtype: bool
        """
        return self._tag == 'team_folder_rename_details'

    def is_account_capture_change_policy_details(self):
        """
        Check if the union tag is ``account_capture_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_policy_details'

    def is_allow_download_disabled_details(self):
        """
        Check if the union tag is ``allow_download_disabled_details``.

        :rtype: bool
        """
        return self._tag == 'allow_download_disabled_details'

    def is_allow_download_enabled_details(self):
        """
        Check if the union tag is ``allow_download_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'allow_download_enabled_details'

    def is_data_placement_restriction_change_policy_details(self):
        """
        Check if the union tag is ``data_placement_restriction_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_change_policy_details'

    def is_data_placement_restriction_satisfy_policy_details(self):
        """
        Check if the union tag is ``data_placement_restriction_satisfy_policy_details``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_satisfy_policy_details'

    def is_device_approvals_change_desktop_policy_details(self):
        """
        Check if the union tag is ``device_approvals_change_desktop_policy_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_desktop_policy_details'

    def is_device_approvals_change_mobile_policy_details(self):
        """
        Check if the union tag is ``device_approvals_change_mobile_policy_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_mobile_policy_details'

    def is_device_approvals_change_overage_action_details(self):
        """
        Check if the union tag is ``device_approvals_change_overage_action_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_overage_action_details'

    def is_device_approvals_change_unlink_action_details(self):
        """
        Check if the union tag is ``device_approvals_change_unlink_action_details``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_unlink_action_details'

    def is_emm_add_exception_details(self):
        """
        Check if the union tag is ``emm_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'emm_add_exception_details'

    def is_emm_change_policy_details(self):
        """
        Check if the union tag is ``emm_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'emm_change_policy_details'

    def is_emm_remove_exception_details(self):
        """
        Check if the union tag is ``emm_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'emm_remove_exception_details'

    def is_extended_version_history_change_policy_details(self):
        """
        Check if the union tag is ``extended_version_history_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'extended_version_history_change_policy_details'

    def is_file_comments_change_policy_details(self):
        """
        Check if the union tag is ``file_comments_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'file_comments_change_policy_details'

    def is_file_requests_change_policy_details(self):
        """
        Check if the union tag is ``file_requests_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_change_policy_details'

    def is_file_requests_emails_enabled_details(self):
        """
        Check if the union tag is ``file_requests_emails_enabled_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_enabled_details'

    def is_file_requests_emails_restricted_to_team_only_details(self):
        """
        Check if the union tag is ``file_requests_emails_restricted_to_team_only_details``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_restricted_to_team_only_details'

    def is_google_sso_change_policy_details(self):
        """
        Check if the union tag is ``google_sso_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'google_sso_change_policy_details'

    def is_group_user_management_change_policy_details(self):
        """
        Check if the union tag is ``group_user_management_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'group_user_management_change_policy_details'

    def is_member_requests_change_policy_details(self):
        """
        Check if the union tag is ``member_requests_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_requests_change_policy_details'

    def is_member_space_limits_add_exception_details(self):
        """
        Check if the union tag is ``member_space_limits_add_exception_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_exception_details'

    def is_member_space_limits_change_policy_details(self):
        """
        Check if the union tag is ``member_space_limits_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_policy_details'

    def is_member_space_limits_remove_exception_details(self):
        """
        Check if the union tag is ``member_space_limits_remove_exception_details``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_exception_details'

    def is_member_suggestions_change_policy_details(self):
        """
        Check if the union tag is ``member_suggestions_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'member_suggestions_change_policy_details'

    def is_microsoft_office_addin_change_policy_details(self):
        """
        Check if the union tag is ``microsoft_office_addin_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'microsoft_office_addin_change_policy_details'

    def is_network_control_change_policy_details(self):
        """
        Check if the union tag is ``network_control_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'network_control_change_policy_details'

    def is_paper_change_deployment_policy_details(self):
        """
        Check if the union tag is ``paper_change_deployment_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_deployment_policy_details'

    def is_paper_change_member_policy_details(self):
        """
        Check if the union tag is ``paper_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_policy_details'

    def is_paper_change_policy_details(self):
        """
        Check if the union tag is ``paper_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'paper_change_policy_details'

    def is_permanent_delete_change_policy_details(self):
        """
        Check if the union tag is ``permanent_delete_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'permanent_delete_change_policy_details'

    def is_sharing_change_folder_join_policy_details(self):
        """
        Check if the union tag is ``sharing_change_folder_join_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_folder_join_policy_details'

    def is_sharing_change_link_policy_details(self):
        """
        Check if the union tag is ``sharing_change_link_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_policy_details'

    def is_sharing_change_member_policy_details(self):
        """
        Check if the union tag is ``sharing_change_member_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_member_policy_details'

    def is_smart_sync_change_policy_details(self):
        """
        Check if the union tag is ``smart_sync_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_change_policy_details'

    def is_sso_change_policy_details(self):
        """
        Check if the union tag is ``sso_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'sso_change_policy_details'

    def is_tfa_change_policy_details(self):
        """
        Check if the union tag is ``tfa_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_policy_details'

    def is_two_account_change_policy_details(self):
        """
        Check if the union tag is ``two_account_change_policy_details``.

        :rtype: bool
        """
        return self._tag == 'two_account_change_policy_details'

    def is_web_sessions_change_fixed_length_policy_details(self):
        """
        Check if the union tag is ``web_sessions_change_fixed_length_policy_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_fixed_length_policy_details'

    def is_web_sessions_change_idle_length_policy_details(self):
        """
        Check if the union tag is ``web_sessions_change_idle_length_policy_details``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_idle_length_policy_details'

    def is_team_profile_add_logo_details(self):
        """
        Check if the union tag is ``team_profile_add_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_add_logo_details'

    def is_team_profile_change_logo_details(self):
        """
        Check if the union tag is ``team_profile_change_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_logo_details'

    def is_team_profile_change_name_details(self):
        """
        Check if the union tag is ``team_profile_change_name_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_name_details'

    def is_team_profile_remove_logo_details(self):
        """
        Check if the union tag is ``team_profile_remove_logo_details``.

        :rtype: bool
        """
        return self._tag == 'team_profile_remove_logo_details'

    def is_tfa_add_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_add_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_backup_phone_details'

    def is_tfa_add_security_key_details(self):
        """
        Check if the union tag is ``tfa_add_security_key_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_security_key_details'

    def is_tfa_change_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_change_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_backup_phone_details'

    def is_tfa_change_status_details(self):
        """
        Check if the union tag is ``tfa_change_status_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_status_details'

    def is_tfa_remove_backup_phone_details(self):
        """
        Check if the union tag is ``tfa_remove_backup_phone_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_backup_phone_details'

    def is_tfa_remove_security_key_details(self):
        """
        Check if the union tag is ``tfa_remove_security_key_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_security_key_details'

    def is_tfa_reset_details(self):
        """
        Check if the union tag is ``tfa_reset_details``.

        :rtype: bool
        """
        return self._tag == 'tfa_reset_details'

    def is_missing_details(self):
        """
        Check if the union tag is ``missing_details``.

        :rtype: bool
        """
        return self._tag == 'missing_details'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_member_change_membership_type_details(self):
        """
        Changed the membership type (limited vs full) for team member.

        Only call this if :meth:`is_member_change_membership_type_details` is true.

        :rtype: MemberChangeMembershipTypeDetails
        """
        if not self.is_member_change_membership_type_details():
            raise AttributeError("tag 'member_change_membership_type_details' not set")
        return self._value

    def get_member_permanently_delete_account_contents_details(self):
        """
        Permanently deleted contents of a removed team member account.

        Only call this if :meth:`is_member_permanently_delete_account_contents_details` is true.

        :rtype: MemberPermanentlyDeleteAccountContentsDetails
        """
        if not self.is_member_permanently_delete_account_contents_details():
            raise AttributeError("tag 'member_permanently_delete_account_contents_details' not set")
        return self._value

    def get_member_space_limits_change_status_details(self):
        """
        Changed the status with respect to whether the team member is under or
        over storage quota specified by policy.

        Only call this if :meth:`is_member_space_limits_change_status_details` is true.

        :rtype: MemberSpaceLimitsChangeStatusDetails
        """
        if not self.is_member_space_limits_change_status_details():
            raise AttributeError("tag 'member_space_limits_change_status_details' not set")
        return self._value

    def get_member_transfer_account_contents_details(self):
        """
        Transferred contents of a removed team member account to another member.

        Only call this if :meth:`is_member_transfer_account_contents_details` is true.

        :rtype: MemberTransferAccountContentsDetails
        """
        if not self.is_member_transfer_account_contents_details():
            raise AttributeError("tag 'member_transfer_account_contents_details' not set")
        return self._value

    def get_paper_enabled_users_group_addition_details(self):
        """
        Users added to Paper enabled users list.

        Only call this if :meth:`is_paper_enabled_users_group_addition_details` is true.

        :rtype: PaperEnabledUsersGroupAdditionDetails
        """
        if not self.is_paper_enabled_users_group_addition_details():
            raise AttributeError("tag 'paper_enabled_users_group_addition_details' not set")
        return self._value

    def get_paper_enabled_users_group_removal_details(self):
        """
        Users removed from Paper enabled users list.

        Only call this if :meth:`is_paper_enabled_users_group_removal_details` is true.

        :rtype: PaperEnabledUsersGroupRemovalDetails
        """
        if not self.is_paper_enabled_users_group_removal_details():
            raise AttributeError("tag 'paper_enabled_users_group_removal_details' not set")
        return self._value

    def get_paper_external_view_allow_details(self):
        """
        Paper external sharing policy changed: anyone.

        Only call this if :meth:`is_paper_external_view_allow_details` is true.

        :rtype: PaperExternalViewAllowDetails
        """
        if not self.is_paper_external_view_allow_details():
            raise AttributeError("tag 'paper_external_view_allow_details' not set")
        return self._value

    def get_paper_external_view_default_team_details(self):
        """
        Paper external sharing policy changed: default team.

        Only call this if :meth:`is_paper_external_view_default_team_details` is true.

        :rtype: PaperExternalViewDefaultTeamDetails
        """
        if not self.is_paper_external_view_default_team_details():
            raise AttributeError("tag 'paper_external_view_default_team_details' not set")
        return self._value

    def get_paper_external_view_forbid_details(self):
        """
        Paper external sharing policy changed: team-only.

        Only call this if :meth:`is_paper_external_view_forbid_details` is true.

        :rtype: PaperExternalViewForbidDetails
        """
        if not self.is_paper_external_view_forbid_details():
            raise AttributeError("tag 'paper_external_view_forbid_details' not set")
        return self._value

    def get_sf_external_invite_warn_details(self):
        """
        Admin settings: team members see a warning before sharing folders
        outside the team (DEPRECATED FEATURE).

        Only call this if :meth:`is_sf_external_invite_warn_details` is true.

        :rtype: SfExternalInviteWarnDetails
        """
        if not self.is_sf_external_invite_warn_details():
            raise AttributeError("tag 'sf_external_invite_warn_details' not set")
        return self._value

    def get_team_merge_details(self):
        """
        Merged the team into another team.

        Only call this if :meth:`is_team_merge_details` is true.

        :rtype: TeamMergeDetails
        """
        if not self.is_team_merge_details():
            raise AttributeError("tag 'team_merge_details' not set")
        return self._value

    def get_app_link_team_details(self):
        """
        Linked an app for team.

        Only call this if :meth:`is_app_link_team_details` is true.

        :rtype: AppLinkTeamDetails
        """
        if not self.is_app_link_team_details():
            raise AttributeError("tag 'app_link_team_details' not set")
        return self._value

    def get_app_link_user_details(self):
        """
        Linked an app for team member.

        Only call this if :meth:`is_app_link_user_details` is true.

        :rtype: AppLinkUserDetails
        """
        if not self.is_app_link_user_details():
            raise AttributeError("tag 'app_link_user_details' not set")
        return self._value

    def get_app_unlink_team_details(self):
        """
        Unlinked an app for team.

        Only call this if :meth:`is_app_unlink_team_details` is true.

        :rtype: AppUnlinkTeamDetails
        """
        if not self.is_app_unlink_team_details():
            raise AttributeError("tag 'app_unlink_team_details' not set")
        return self._value

    def get_app_unlink_user_details(self):
        """
        Unlinked an app for team member.

        Only call this if :meth:`is_app_unlink_user_details` is true.

        :rtype: AppUnlinkUserDetails
        """
        if not self.is_app_unlink_user_details():
            raise AttributeError("tag 'app_unlink_user_details' not set")
        return self._value

    def get_device_change_ip_desktop_details(self):
        """
        IP address associated with active desktop session changed.

        Only call this if :meth:`is_device_change_ip_desktop_details` is true.

        :rtype: DeviceChangeIpDesktopDetails
        """
        if not self.is_device_change_ip_desktop_details():
            raise AttributeError("tag 'device_change_ip_desktop_details' not set")
        return self._value

    def get_device_change_ip_mobile_details(self):
        """
        IP address associated with active mobile session changed.

        Only call this if :meth:`is_device_change_ip_mobile_details` is true.

        :rtype: DeviceChangeIpMobileDetails
        """
        if not self.is_device_change_ip_mobile_details():
            raise AttributeError("tag 'device_change_ip_mobile_details' not set")
        return self._value

    def get_device_change_ip_web_details(self):
        """
        IP address associated with active Web session changed.

        Only call this if :meth:`is_device_change_ip_web_details` is true.

        :rtype: DeviceChangeIpWebDetails
        """
        if not self.is_device_change_ip_web_details():
            raise AttributeError("tag 'device_change_ip_web_details' not set")
        return self._value

    def get_device_delete_on_unlink_fail_details(self):
        """
        Failed to delete all files from an unlinked device.

        Only call this if :meth:`is_device_delete_on_unlink_fail_details` is true.

        :rtype: DeviceDeleteOnUnlinkFailDetails
        """
        if not self.is_device_delete_on_unlink_fail_details():
            raise AttributeError("tag 'device_delete_on_unlink_fail_details' not set")
        return self._value

    def get_device_delete_on_unlink_success_details(self):
        """
        Deleted all files from an unlinked device.

        Only call this if :meth:`is_device_delete_on_unlink_success_details` is true.

        :rtype: DeviceDeleteOnUnlinkSuccessDetails
        """
        if not self.is_device_delete_on_unlink_success_details():
            raise AttributeError("tag 'device_delete_on_unlink_success_details' not set")
        return self._value

    def get_device_link_fail_details(self):
        """
        Failed to link a device.

        Only call this if :meth:`is_device_link_fail_details` is true.

        :rtype: DeviceLinkFailDetails
        """
        if not self.is_device_link_fail_details():
            raise AttributeError("tag 'device_link_fail_details' not set")
        return self._value

    def get_device_link_success_details(self):
        """
        Linked a device.

        Only call this if :meth:`is_device_link_success_details` is true.

        :rtype: DeviceLinkSuccessDetails
        """
        if not self.is_device_link_success_details():
            raise AttributeError("tag 'device_link_success_details' not set")
        return self._value

    def get_device_management_disabled_details(self):
        """
        Disable Device Management.

        Only call this if :meth:`is_device_management_disabled_details` is true.

        :rtype: DeviceManagementDisabledDetails
        """
        if not self.is_device_management_disabled_details():
            raise AttributeError("tag 'device_management_disabled_details' not set")
        return self._value

    def get_device_management_enabled_details(self):
        """
        Enable Device Management.

        Only call this if :meth:`is_device_management_enabled_details` is true.

        :rtype: DeviceManagementEnabledDetails
        """
        if not self.is_device_management_enabled_details():
            raise AttributeError("tag 'device_management_enabled_details' not set")
        return self._value

    def get_device_unlink_details(self):
        """
        Disconnected a device.

        Only call this if :meth:`is_device_unlink_details` is true.

        :rtype: DeviceUnlinkDetails
        """
        if not self.is_device_unlink_details():
            raise AttributeError("tag 'device_unlink_details' not set")
        return self._value

    def get_emm_refresh_auth_token_details(self):
        """
        Refreshed the auth token used for setting up enterprise mobility
        management.

        Only call this if :meth:`is_emm_refresh_auth_token_details` is true.

        :rtype: EmmRefreshAuthTokenDetails
        """
        if not self.is_emm_refresh_auth_token_details():
            raise AttributeError("tag 'emm_refresh_auth_token_details' not set")
        return self._value

    def get_account_capture_change_availability_details(self):
        """
        Granted or revoked the option to enable account capture on domains
        belonging to the team.

        Only call this if :meth:`is_account_capture_change_availability_details` is true.

        :rtype: AccountCaptureChangeAvailabilityDetails
        """
        if not self.is_account_capture_change_availability_details():
            raise AttributeError("tag 'account_capture_change_availability_details' not set")
        return self._value

    def get_account_capture_migrate_account_details(self):
        """
        Account captured user migrated their account to the team.

        Only call this if :meth:`is_account_capture_migrate_account_details` is true.

        :rtype: AccountCaptureMigrateAccountDetails
        """
        if not self.is_account_capture_migrate_account_details():
            raise AttributeError("tag 'account_capture_migrate_account_details' not set")
        return self._value

    def get_account_capture_relinquish_account_details(self):
        """
        Account captured user relinquished their account by changing the email
        address associated with it.

        Only call this if :meth:`is_account_capture_relinquish_account_details` is true.

        :rtype: AccountCaptureRelinquishAccountDetails
        """
        if not self.is_account_capture_relinquish_account_details():
            raise AttributeError("tag 'account_capture_relinquish_account_details' not set")
        return self._value

    def get_disabled_domain_invites_details(self):
        """
        Disabled domain invites.

        Only call this if :meth:`is_disabled_domain_invites_details` is true.

        :rtype: DisabledDomainInvitesDetails
        """
        if not self.is_disabled_domain_invites_details():
            raise AttributeError("tag 'disabled_domain_invites_details' not set")
        return self._value

    def get_domain_invites_approve_request_to_join_team_details(self):
        """
        Approved a member's request to join the team.

        Only call this if :meth:`is_domain_invites_approve_request_to_join_team_details` is true.

        :rtype: DomainInvitesApproveRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_approve_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_approve_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_decline_request_to_join_team_details(self):
        """
        Declined a user's request to join the team.

        Only call this if :meth:`is_domain_invites_decline_request_to_join_team_details` is true.

        :rtype: DomainInvitesDeclineRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_decline_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_decline_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_email_existing_users_details(self):
        """
        Sent domain invites to existing domain accounts.

        Only call this if :meth:`is_domain_invites_email_existing_users_details` is true.

        :rtype: DomainInvitesEmailExistingUsersDetails
        """
        if not self.is_domain_invites_email_existing_users_details():
            raise AttributeError("tag 'domain_invites_email_existing_users_details' not set")
        return self._value

    def get_domain_invites_request_to_join_team_details(self):
        """
        Asked to join the team.

        Only call this if :meth:`is_domain_invites_request_to_join_team_details` is true.

        :rtype: DomainInvitesRequestToJoinTeamDetails
        """
        if not self.is_domain_invites_request_to_join_team_details():
            raise AttributeError("tag 'domain_invites_request_to_join_team_details' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_no_details(self):
        """
        Turned off u201cAutomatically invite new usersu201d.

        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_no_details` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToNoDetails
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_no_details():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_no_details' not set")
        return self._value

    def get_domain_invites_set_invite_new_user_pref_to_yes_details(self):
        """
        Turned on u201cAutomatically invite new usersu201d.

        Only call this if :meth:`is_domain_invites_set_invite_new_user_pref_to_yes_details` is true.

        :rtype: DomainInvitesSetInviteNewUserPrefToYesDetails
        """
        if not self.is_domain_invites_set_invite_new_user_pref_to_yes_details():
            raise AttributeError("tag 'domain_invites_set_invite_new_user_pref_to_yes_details' not set")
        return self._value

    def get_domain_verification_add_domain_fail_details(self):
        """
        Failed to verify a domain belonging to the team.

        Only call this if :meth:`is_domain_verification_add_domain_fail_details` is true.

        :rtype: DomainVerificationAddDomainFailDetails
        """
        if not self.is_domain_verification_add_domain_fail_details():
            raise AttributeError("tag 'domain_verification_add_domain_fail_details' not set")
        return self._value

    def get_domain_verification_add_domain_success_details(self):
        """
        Verified a domain belonging to the team.

        Only call this if :meth:`is_domain_verification_add_domain_success_details` is true.

        :rtype: DomainVerificationAddDomainSuccessDetails
        """
        if not self.is_domain_verification_add_domain_success_details():
            raise AttributeError("tag 'domain_verification_add_domain_success_details' not set")
        return self._value

    def get_domain_verification_remove_domain_details(self):
        """
        Removed a domain from the list of verified domains belonging to the
        team.

        Only call this if :meth:`is_domain_verification_remove_domain_details` is true.

        :rtype: DomainVerificationRemoveDomainDetails
        """
        if not self.is_domain_verification_remove_domain_details():
            raise AttributeError("tag 'domain_verification_remove_domain_details' not set")
        return self._value

    def get_enabled_domain_invites_details(self):
        """
        Enabled domain invites.

        Only call this if :meth:`is_enabled_domain_invites_details` is true.

        :rtype: EnabledDomainInvitesDetails
        """
        if not self.is_enabled_domain_invites_details():
            raise AttributeError("tag 'enabled_domain_invites_details' not set")
        return self._value

    def get_create_folder_details(self):
        """
        Created folders.

        Only call this if :meth:`is_create_folder_details` is true.

        :rtype: CreateFolderDetails
        """
        if not self.is_create_folder_details():
            raise AttributeError("tag 'create_folder_details' not set")
        return self._value

    def get_file_add_details(self):
        """
        Added files and/or folders.

        Only call this if :meth:`is_file_add_details` is true.

        :rtype: FileAddDetails
        """
        if not self.is_file_add_details():
            raise AttributeError("tag 'file_add_details' not set")
        return self._value

    def get_file_copy_details(self):
        """
        Copied files and/or folders.

        Only call this if :meth:`is_file_copy_details` is true.

        :rtype: FileCopyDetails
        """
        if not self.is_file_copy_details():
            raise AttributeError("tag 'file_copy_details' not set")
        return self._value

    def get_file_delete_details(self):
        """
        Deleted files and/or folders.

        Only call this if :meth:`is_file_delete_details` is true.

        :rtype: FileDeleteDetails
        """
        if not self.is_file_delete_details():
            raise AttributeError("tag 'file_delete_details' not set")
        return self._value

    def get_file_download_details(self):
        """
        Downloaded files and/or folders.

        Only call this if :meth:`is_file_download_details` is true.

        :rtype: FileDownloadDetails
        """
        if not self.is_file_download_details():
            raise AttributeError("tag 'file_download_details' not set")
        return self._value

    def get_file_edit_details(self):
        """
        Edited files.

        Only call this if :meth:`is_file_edit_details` is true.

        :rtype: FileEditDetails
        """
        if not self.is_file_edit_details():
            raise AttributeError("tag 'file_edit_details' not set")
        return self._value

    def get_file_get_copy_reference_details(self):
        """
        Create a copy reference to a file or folder.

        Only call this if :meth:`is_file_get_copy_reference_details` is true.

        :rtype: FileGetCopyReferenceDetails
        """
        if not self.is_file_get_copy_reference_details():
            raise AttributeError("tag 'file_get_copy_reference_details' not set")
        return self._value

    def get_file_move_details(self):
        """
        Moved files and/or folders.

        Only call this if :meth:`is_file_move_details` is true.

        :rtype: FileMoveDetails
        """
        if not self.is_file_move_details():
            raise AttributeError("tag 'file_move_details' not set")
        return self._value

    def get_file_permanently_delete_details(self):
        """
        Permanently deleted files and/or folders.

        Only call this if :meth:`is_file_permanently_delete_details` is true.

        :rtype: FilePermanentlyDeleteDetails
        """
        if not self.is_file_permanently_delete_details():
            raise AttributeError("tag 'file_permanently_delete_details' not set")
        return self._value

    def get_file_preview_details(self):
        """
        Previewed files and/or folders.

        Only call this if :meth:`is_file_preview_details` is true.

        :rtype: FilePreviewDetails
        """
        if not self.is_file_preview_details():
            raise AttributeError("tag 'file_preview_details' not set")
        return self._value

    def get_file_rename_details(self):
        """
        Renamed files and/or folders.

        Only call this if :meth:`is_file_rename_details` is true.

        :rtype: FileRenameDetails
        """
        if not self.is_file_rename_details():
            raise AttributeError("tag 'file_rename_details' not set")
        return self._value

    def get_file_restore_details(self):
        """
        Restored deleted files and/or folders.

        Only call this if :meth:`is_file_restore_details` is true.

        :rtype: FileRestoreDetails
        """
        if not self.is_file_restore_details():
            raise AttributeError("tag 'file_restore_details' not set")
        return self._value

    def get_file_revert_details(self):
        """
        Reverted files to a previous version.

        Only call this if :meth:`is_file_revert_details` is true.

        :rtype: FileRevertDetails
        """
        if not self.is_file_revert_details():
            raise AttributeError("tag 'file_revert_details' not set")
        return self._value

    def get_file_rollback_changes_details(self):
        """
        Rolled back file change location changes.

        Only call this if :meth:`is_file_rollback_changes_details` is true.

        :rtype: FileRollbackChangesDetails
        """
        if not self.is_file_rollback_changes_details():
            raise AttributeError("tag 'file_rollback_changes_details' not set")
        return self._value

    def get_file_save_copy_reference_details(self):
        """
        Save a file or folder using a copy reference.

        Only call this if :meth:`is_file_save_copy_reference_details` is true.

        :rtype: FileSaveCopyReferenceDetails
        """
        if not self.is_file_save_copy_reference_details():
            raise AttributeError("tag 'file_save_copy_reference_details' not set")
        return self._value

    def get_file_request_add_deadline_details(self):
        """
        Added a deadline to a file request.

        Only call this if :meth:`is_file_request_add_deadline_details` is true.

        :rtype: FileRequestAddDeadlineDetails
        """
        if not self.is_file_request_add_deadline_details():
            raise AttributeError("tag 'file_request_add_deadline_details' not set")
        return self._value

    def get_file_request_change_folder_details(self):
        """
        Changed the file request folder.

        Only call this if :meth:`is_file_request_change_folder_details` is true.

        :rtype: FileRequestChangeFolderDetails
        """
        if not self.is_file_request_change_folder_details():
            raise AttributeError("tag 'file_request_change_folder_details' not set")
        return self._value

    def get_file_request_change_title_details(self):
        """
        Change the file request title.

        Only call this if :meth:`is_file_request_change_title_details` is true.

        :rtype: FileRequestChangeTitleDetails
        """
        if not self.is_file_request_change_title_details():
            raise AttributeError("tag 'file_request_change_title_details' not set")
        return self._value

    def get_file_request_close_details(self):
        """
        Closed a file request.

        Only call this if :meth:`is_file_request_close_details` is true.

        :rtype: FileRequestCloseDetails
        """
        if not self.is_file_request_close_details():
            raise AttributeError("tag 'file_request_close_details' not set")
        return self._value

    def get_file_request_create_details(self):
        """
        Created a file request.

        Only call this if :meth:`is_file_request_create_details` is true.

        :rtype: FileRequestCreateDetails
        """
        if not self.is_file_request_create_details():
            raise AttributeError("tag 'file_request_create_details' not set")
        return self._value

    def get_file_request_receive_file_details(self):
        """
        Received files for a file request.

        Only call this if :meth:`is_file_request_receive_file_details` is true.

        :rtype: FileRequestReceiveFileDetails
        """
        if not self.is_file_request_receive_file_details():
            raise AttributeError("tag 'file_request_receive_file_details' not set")
        return self._value

    def get_file_request_remove_deadline_details(self):
        """
        Removed the file request deadline.

        Only call this if :meth:`is_file_request_remove_deadline_details` is true.

        :rtype: FileRequestRemoveDeadlineDetails
        """
        if not self.is_file_request_remove_deadline_details():
            raise AttributeError("tag 'file_request_remove_deadline_details' not set")
        return self._value

    def get_file_request_send_details(self):
        """
        Sent file request to users via email.

        Only call this if :meth:`is_file_request_send_details` is true.

        :rtype: FileRequestSendDetails
        """
        if not self.is_file_request_send_details():
            raise AttributeError("tag 'file_request_send_details' not set")
        return self._value

    def get_group_add_external_id_details(self):
        """
        Added an external ID for group.

        Only call this if :meth:`is_group_add_external_id_details` is true.

        :rtype: GroupAddExternalIdDetails
        """
        if not self.is_group_add_external_id_details():
            raise AttributeError("tag 'group_add_external_id_details' not set")
        return self._value

    def get_group_add_member_details(self):
        """
        Added team members to a group.

        Only call this if :meth:`is_group_add_member_details` is true.

        :rtype: GroupAddMemberDetails
        """
        if not self.is_group_add_member_details():
            raise AttributeError("tag 'group_add_member_details' not set")
        return self._value

    def get_group_change_external_id_details(self):
        """
        Changed the external ID for group.

        Only call this if :meth:`is_group_change_external_id_details` is true.

        :rtype: GroupChangeExternalIdDetails
        """
        if not self.is_group_change_external_id_details():
            raise AttributeError("tag 'group_change_external_id_details' not set")
        return self._value

    def get_group_change_management_type_details(self):
        """
        Changed group management type.

        Only call this if :meth:`is_group_change_management_type_details` is true.

        :rtype: GroupChangeManagementTypeDetails
        """
        if not self.is_group_change_management_type_details():
            raise AttributeError("tag 'group_change_management_type_details' not set")
        return self._value

    def get_group_change_member_role_details(self):
        """
        Changed the manager permissions belonging to a group member.

        Only call this if :meth:`is_group_change_member_role_details` is true.

        :rtype: GroupChangeMemberRoleDetails
        """
        if not self.is_group_change_member_role_details():
            raise AttributeError("tag 'group_change_member_role_details' not set")
        return self._value

    def get_group_create_details(self):
        """
        Created a group.

        Only call this if :meth:`is_group_create_details` is true.

        :rtype: GroupCreateDetails
        """
        if not self.is_group_create_details():
            raise AttributeError("tag 'group_create_details' not set")
        return self._value

    def get_group_delete_details(self):
        """
        Deleted a group.

        Only call this if :meth:`is_group_delete_details` is true.

        :rtype: GroupDeleteDetails
        """
        if not self.is_group_delete_details():
            raise AttributeError("tag 'group_delete_details' not set")
        return self._value

    def get_group_description_updated_details(self):
        """
        Updated a group.

        Only call this if :meth:`is_group_description_updated_details` is true.

        :rtype: GroupDescriptionUpdatedDetails
        """
        if not self.is_group_description_updated_details():
            raise AttributeError("tag 'group_description_updated_details' not set")
        return self._value

    def get_group_join_policy_updated_details(self):
        """
        Updated a group join policy.

        Only call this if :meth:`is_group_join_policy_updated_details` is true.

        :rtype: GroupJoinPolicyUpdatedDetails
        """
        if not self.is_group_join_policy_updated_details():
            raise AttributeError("tag 'group_join_policy_updated_details' not set")
        return self._value

    def get_group_moved_details(self):
        """
        Moved a group.

        Only call this if :meth:`is_group_moved_details` is true.

        :rtype: GroupMovedDetails
        """
        if not self.is_group_moved_details():
            raise AttributeError("tag 'group_moved_details' not set")
        return self._value

    def get_group_remove_external_id_details(self):
        """
        Removed the external ID for group.

        Only call this if :meth:`is_group_remove_external_id_details` is true.

        :rtype: GroupRemoveExternalIdDetails
        """
        if not self.is_group_remove_external_id_details():
            raise AttributeError("tag 'group_remove_external_id_details' not set")
        return self._value

    def get_group_remove_member_details(self):
        """
        Removed team members from a group.

        Only call this if :meth:`is_group_remove_member_details` is true.

        :rtype: GroupRemoveMemberDetails
        """
        if not self.is_group_remove_member_details():
            raise AttributeError("tag 'group_remove_member_details' not set")
        return self._value

    def get_group_rename_details(self):
        """
        Renamed a group.

        Only call this if :meth:`is_group_rename_details` is true.

        :rtype: GroupRenameDetails
        """
        if not self.is_group_rename_details():
            raise AttributeError("tag 'group_rename_details' not set")
        return self._value

    def get_emm_login_success_details(self):
        """
        Signed in using the Dropbox EMM app.

        Only call this if :meth:`is_emm_login_success_details` is true.

        :rtype: EmmLoginSuccessDetails
        """
        if not self.is_emm_login_success_details():
            raise AttributeError("tag 'emm_login_success_details' not set")
        return self._value

    def get_logout_details(self):
        """
        Signed out.

        Only call this if :meth:`is_logout_details` is true.

        :rtype: LogoutDetails
        """
        if not self.is_logout_details():
            raise AttributeError("tag 'logout_details' not set")
        return self._value

    def get_password_login_fail_details(self):
        """
        Failed to sign in using a password.

        Only call this if :meth:`is_password_login_fail_details` is true.

        :rtype: PasswordLoginFailDetails
        """
        if not self.is_password_login_fail_details():
            raise AttributeError("tag 'password_login_fail_details' not set")
        return self._value

    def get_password_login_success_details(self):
        """
        Signed in using a password.

        Only call this if :meth:`is_password_login_success_details` is true.

        :rtype: PasswordLoginSuccessDetails
        """
        if not self.is_password_login_success_details():
            raise AttributeError("tag 'password_login_success_details' not set")
        return self._value

    def get_reseller_support_session_end_details(self):
        """
        Ended reseller support session.

        Only call this if :meth:`is_reseller_support_session_end_details` is true.

        :rtype: ResellerSupportSessionEndDetails
        """
        if not self.is_reseller_support_session_end_details():
            raise AttributeError("tag 'reseller_support_session_end_details' not set")
        return self._value

    def get_reseller_support_session_start_details(self):
        """
        Started reseller support session.

        Only call this if :meth:`is_reseller_support_session_start_details` is true.

        :rtype: ResellerSupportSessionStartDetails
        """
        if not self.is_reseller_support_session_start_details():
            raise AttributeError("tag 'reseller_support_session_start_details' not set")
        return self._value

    def get_sign_in_as_session_end_details(self):
        """
        Ended admin sign-in-as session.

        Only call this if :meth:`is_sign_in_as_session_end_details` is true.

        :rtype: SignInAsSessionEndDetails
        """
        if not self.is_sign_in_as_session_end_details():
            raise AttributeError("tag 'sign_in_as_session_end_details' not set")
        return self._value

    def get_sign_in_as_session_start_details(self):
        """
        Started admin sign-in-as session.

        Only call this if :meth:`is_sign_in_as_session_start_details` is true.

        :rtype: SignInAsSessionStartDetails
        """
        if not self.is_sign_in_as_session_start_details():
            raise AttributeError("tag 'sign_in_as_session_start_details' not set")
        return self._value

    def get_sso_login_fail_details(self):
        """
        Failed to sign in using SSO.

        Only call this if :meth:`is_sso_login_fail_details` is true.

        :rtype: SsoLoginFailDetails
        """
        if not self.is_sso_login_fail_details():
            raise AttributeError("tag 'sso_login_fail_details' not set")
        return self._value

    def get_member_add_name_details(self):
        """
        Set team member name when joining team.

        Only call this if :meth:`is_member_add_name_details` is true.

        :rtype: MemberAddNameDetails
        """
        if not self.is_member_add_name_details():
            raise AttributeError("tag 'member_add_name_details' not set")
        return self._value

    def get_member_change_email_details(self):
        """
        Changed team member email address.

        Only call this if :meth:`is_member_change_email_details` is true.

        :rtype: MemberChangeEmailDetails
        """
        if not self.is_member_change_email_details():
            raise AttributeError("tag 'member_change_email_details' not set")
        return self._value

    def get_member_change_name_details(self):
        """
        Changed team member name.

        Only call this if :meth:`is_member_change_name_details` is true.

        :rtype: MemberChangeNameDetails
        """
        if not self.is_member_change_name_details():
            raise AttributeError("tag 'member_change_name_details' not set")
        return self._value

    def get_member_change_role_details(self):
        """
        Change the admin permissions belonging to team member.

        Only call this if :meth:`is_member_change_role_details` is true.

        :rtype: MemberChangeRoleDetails
        """
        if not self.is_member_change_role_details():
            raise AttributeError("tag 'member_change_role_details' not set")
        return self._value

    def get_member_invite_details(self):
        """
        Invited a user to join the team.

        Only call this if :meth:`is_member_invite_details` is true.

        :rtype: MemberInviteDetails
        """
        if not self.is_member_invite_details():
            raise AttributeError("tag 'member_invite_details' not set")
        return self._value

    def get_member_join_details(self):
        """
        Joined the team.

        Only call this if :meth:`is_member_join_details` is true.

        :rtype: MemberJoinDetails
        """
        if not self.is_member_join_details():
            raise AttributeError("tag 'member_join_details' not set")
        return self._value

    def get_member_leave_details(self):
        """
        Removed a team member.

        Only call this if :meth:`is_member_leave_details` is true.

        :rtype: MemberLeaveDetails
        """
        if not self.is_member_leave_details():
            raise AttributeError("tag 'member_leave_details' not set")
        return self._value

    def get_member_recover_details(self):
        """
        Recovered a removed member.

        Only call this if :meth:`is_member_recover_details` is true.

        :rtype: MemberRecoverDetails
        """
        if not self.is_member_recover_details():
            raise AttributeError("tag 'member_recover_details' not set")
        return self._value

    def get_member_suggest_details(self):
        """
        Suggested a new team member to be added to the team.

        Only call this if :meth:`is_member_suggest_details` is true.

        :rtype: MemberSuggestDetails
        """
        if not self.is_member_suggest_details():
            raise AttributeError("tag 'member_suggest_details' not set")
        return self._value

    def get_member_suspend_details(self):
        """
        Suspended a team member.

        Only call this if :meth:`is_member_suspend_details` is true.

        :rtype: MemberSuspendDetails
        """
        if not self.is_member_suspend_details():
            raise AttributeError("tag 'member_suspend_details' not set")
        return self._value

    def get_member_unsuspend_details(self):
        """
        Unsuspended a team member.

        Only call this if :meth:`is_member_unsuspend_details` is true.

        :rtype: MemberUnsuspendDetails
        """
        if not self.is_member_unsuspend_details():
            raise AttributeError("tag 'member_unsuspend_details' not set")
        return self._value

    def get_paper_content_add_member_details(self):
        """
        Added users to the membership of a Paper doc or folder.

        Only call this if :meth:`is_paper_content_add_member_details` is true.

        :rtype: PaperContentAddMemberDetails
        """
        if not self.is_paper_content_add_member_details():
            raise AttributeError("tag 'paper_content_add_member_details' not set")
        return self._value

    def get_paper_content_add_to_folder_details(self):
        """
        Added Paper doc or folder to a folder.

        Only call this if :meth:`is_paper_content_add_to_folder_details` is true.

        :rtype: PaperContentAddToFolderDetails
        """
        if not self.is_paper_content_add_to_folder_details():
            raise AttributeError("tag 'paper_content_add_to_folder_details' not set")
        return self._value

    def get_paper_content_archive_details(self):
        """
        Archived Paper doc or folder.

        Only call this if :meth:`is_paper_content_archive_details` is true.

        :rtype: PaperContentArchiveDetails
        """
        if not self.is_paper_content_archive_details():
            raise AttributeError("tag 'paper_content_archive_details' not set")
        return self._value

    def get_paper_content_change_subscription_details(self):
        """
        Followed or unfollowed a Paper doc or folder.

        Only call this if :meth:`is_paper_content_change_subscription_details` is true.

        :rtype: PaperContentChangeSubscriptionDetails
        """
        if not self.is_paper_content_change_subscription_details():
            raise AttributeError("tag 'paper_content_change_subscription_details' not set")
        return self._value

    def get_paper_content_create_details(self):
        """
        Created a Paper doc or folder.

        Only call this if :meth:`is_paper_content_create_details` is true.

        :rtype: PaperContentCreateDetails
        """
        if not self.is_paper_content_create_details():
            raise AttributeError("tag 'paper_content_create_details' not set")
        return self._value

    def get_paper_content_permanently_delete_details(self):
        """
        Permanently deleted a Paper doc or folder.

        Only call this if :meth:`is_paper_content_permanently_delete_details` is true.

        :rtype: PaperContentPermanentlyDeleteDetails
        """
        if not self.is_paper_content_permanently_delete_details():
            raise AttributeError("tag 'paper_content_permanently_delete_details' not set")
        return self._value

    def get_paper_content_remove_from_folder_details(self):
        """
        Removed Paper doc or folder from a folder.

        Only call this if :meth:`is_paper_content_remove_from_folder_details` is true.

        :rtype: PaperContentRemoveFromFolderDetails
        """
        if not self.is_paper_content_remove_from_folder_details():
            raise AttributeError("tag 'paper_content_remove_from_folder_details' not set")
        return self._value

    def get_paper_content_remove_member_details(self):
        """
        Removed a user from the membership of a Paper doc or folder.

        Only call this if :meth:`is_paper_content_remove_member_details` is true.

        :rtype: PaperContentRemoveMemberDetails
        """
        if not self.is_paper_content_remove_member_details():
            raise AttributeError("tag 'paper_content_remove_member_details' not set")
        return self._value

    def get_paper_content_rename_details(self):
        """
        Renamed Paper doc or folder.

        Only call this if :meth:`is_paper_content_rename_details` is true.

        :rtype: PaperContentRenameDetails
        """
        if not self.is_paper_content_rename_details():
            raise AttributeError("tag 'paper_content_rename_details' not set")
        return self._value

    def get_paper_content_restore_details(self):
        """
        Restored an archived Paper doc or folder.

        Only call this if :meth:`is_paper_content_restore_details` is true.

        :rtype: PaperContentRestoreDetails
        """
        if not self.is_paper_content_restore_details():
            raise AttributeError("tag 'paper_content_restore_details' not set")
        return self._value

    def get_paper_doc_add_comment_details(self):
        """
        Added a Paper doc comment.

        Only call this if :meth:`is_paper_doc_add_comment_details` is true.

        :rtype: PaperDocAddCommentDetails
        """
        if not self.is_paper_doc_add_comment_details():
            raise AttributeError("tag 'paper_doc_add_comment_details' not set")
        return self._value

    def get_paper_doc_change_member_role_details(self):
        """
        Changed the access type of a Paper doc member.

        Only call this if :meth:`is_paper_doc_change_member_role_details` is true.

        :rtype: PaperDocChangeMemberRoleDetails
        """
        if not self.is_paper_doc_change_member_role_details():
            raise AttributeError("tag 'paper_doc_change_member_role_details' not set")
        return self._value

    def get_paper_doc_change_sharing_policy_details(self):
        """
        Changed the sharing policy for Paper doc.

        Only call this if :meth:`is_paper_doc_change_sharing_policy_details` is true.

        :rtype: PaperDocChangeSharingPolicyDetails
        """
        if not self.is_paper_doc_change_sharing_policy_details():
            raise AttributeError("tag 'paper_doc_change_sharing_policy_details' not set")
        return self._value

    def get_paper_doc_deleted_details(self):
        """
        Paper doc archived.

        Only call this if :meth:`is_paper_doc_deleted_details` is true.

        :rtype: PaperDocDeletedDetails
        """
        if not self.is_paper_doc_deleted_details():
            raise AttributeError("tag 'paper_doc_deleted_details' not set")
        return self._value

    def get_paper_doc_delete_comment_details(self):
        """
        Deleted a Paper doc comment.

        Only call this if :meth:`is_paper_doc_delete_comment_details` is true.

        :rtype: PaperDocDeleteCommentDetails
        """
        if not self.is_paper_doc_delete_comment_details():
            raise AttributeError("tag 'paper_doc_delete_comment_details' not set")
        return self._value

    def get_paper_doc_download_details(self):
        """
        Downloaded a Paper doc in a particular output format.

        Only call this if :meth:`is_paper_doc_download_details` is true.

        :rtype: PaperDocDownloadDetails
        """
        if not self.is_paper_doc_download_details():
            raise AttributeError("tag 'paper_doc_download_details' not set")
        return self._value

    def get_paper_doc_edit_details(self):
        """
        Edited a Paper doc.

        Only call this if :meth:`is_paper_doc_edit_details` is true.

        :rtype: PaperDocEditDetails
        """
        if not self.is_paper_doc_edit_details():
            raise AttributeError("tag 'paper_doc_edit_details' not set")
        return self._value

    def get_paper_doc_edit_comment_details(self):
        """
        Edited a Paper doc comment.

        Only call this if :meth:`is_paper_doc_edit_comment_details` is true.

        :rtype: PaperDocEditCommentDetails
        """
        if not self.is_paper_doc_edit_comment_details():
            raise AttributeError("tag 'paper_doc_edit_comment_details' not set")
        return self._value

    def get_paper_doc_followed_details(self):
        """
        Followed a Paper doc.

        Only call this if :meth:`is_paper_doc_followed_details` is true.

        :rtype: PaperDocFollowedDetails
        """
        if not self.is_paper_doc_followed_details():
            raise AttributeError("tag 'paper_doc_followed_details' not set")
        return self._value

    def get_paper_doc_mention_details(self):
        """
        Mentioned a member in a Paper doc.

        Only call this if :meth:`is_paper_doc_mention_details` is true.

        :rtype: PaperDocMentionDetails
        """
        if not self.is_paper_doc_mention_details():
            raise AttributeError("tag 'paper_doc_mention_details' not set")
        return self._value

    def get_paper_doc_request_access_details(self):
        """
        Requested to be a member on a Paper doc.

        Only call this if :meth:`is_paper_doc_request_access_details` is true.

        :rtype: PaperDocRequestAccessDetails
        """
        if not self.is_paper_doc_request_access_details():
            raise AttributeError("tag 'paper_doc_request_access_details' not set")
        return self._value

    def get_paper_doc_resolve_comment_details(self):
        """
        Paper doc comment resolved.

        Only call this if :meth:`is_paper_doc_resolve_comment_details` is true.

        :rtype: PaperDocResolveCommentDetails
        """
        if not self.is_paper_doc_resolve_comment_details():
            raise AttributeError("tag 'paper_doc_resolve_comment_details' not set")
        return self._value

    def get_paper_doc_revert_details(self):
        """
        Restored a Paper doc to previous revision.

        Only call this if :meth:`is_paper_doc_revert_details` is true.

        :rtype: PaperDocRevertDetails
        """
        if not self.is_paper_doc_revert_details():
            raise AttributeError("tag 'paper_doc_revert_details' not set")
        return self._value

    def get_paper_doc_slack_share_details(self):
        """
        Paper doc link shared via slack.

        Only call this if :meth:`is_paper_doc_slack_share_details` is true.

        :rtype: PaperDocSlackShareDetails
        """
        if not self.is_paper_doc_slack_share_details():
            raise AttributeError("tag 'paper_doc_slack_share_details' not set")
        return self._value

    def get_paper_doc_team_invite_details(self):
        """
        Paper doc shared with team member.

        Only call this if :meth:`is_paper_doc_team_invite_details` is true.

        :rtype: PaperDocTeamInviteDetails
        """
        if not self.is_paper_doc_team_invite_details():
            raise AttributeError("tag 'paper_doc_team_invite_details' not set")
        return self._value

    def get_paper_doc_unresolve_comment_details(self):
        """
        Unresolved a Paper doc comment.

        Only call this if :meth:`is_paper_doc_unresolve_comment_details` is true.

        :rtype: PaperDocUnresolveCommentDetails
        """
        if not self.is_paper_doc_unresolve_comment_details():
            raise AttributeError("tag 'paper_doc_unresolve_comment_details' not set")
        return self._value

    def get_paper_doc_view_details(self):
        """
        Viewed Paper doc.

        Only call this if :meth:`is_paper_doc_view_details` is true.

        :rtype: PaperDocViewDetails
        """
        if not self.is_paper_doc_view_details():
            raise AttributeError("tag 'paper_doc_view_details' not set")
        return self._value

    def get_paper_folder_deleted_details(self):
        """
        Paper folder archived.

        Only call this if :meth:`is_paper_folder_deleted_details` is true.

        :rtype: PaperFolderDeletedDetails
        """
        if not self.is_paper_folder_deleted_details():
            raise AttributeError("tag 'paper_folder_deleted_details' not set")
        return self._value

    def get_paper_folder_followed_details(self):
        """
        Followed a Paper folder.

        Only call this if :meth:`is_paper_folder_followed_details` is true.

        :rtype: PaperFolderFollowedDetails
        """
        if not self.is_paper_folder_followed_details():
            raise AttributeError("tag 'paper_folder_followed_details' not set")
        return self._value

    def get_paper_folder_team_invite_details(self):
        """
        Paper folder shared with team member.

        Only call this if :meth:`is_paper_folder_team_invite_details` is true.

        :rtype: PaperFolderTeamInviteDetails
        """
        if not self.is_paper_folder_team_invite_details():
            raise AttributeError("tag 'paper_folder_team_invite_details' not set")
        return self._value

    def get_password_change_details(self):
        """
        Changed password.

        Only call this if :meth:`is_password_change_details` is true.

        :rtype: PasswordChangeDetails
        """
        if not self.is_password_change_details():
            raise AttributeError("tag 'password_change_details' not set")
        return self._value

    def get_password_reset_details(self):
        """
        Reset password.

        Only call this if :meth:`is_password_reset_details` is true.

        :rtype: PasswordResetDetails
        """
        if not self.is_password_reset_details():
            raise AttributeError("tag 'password_reset_details' not set")
        return self._value

    def get_password_reset_all_details(self):
        """
        Reset all team member passwords.

        Only call this if :meth:`is_password_reset_all_details` is true.

        :rtype: PasswordResetAllDetails
        """
        if not self.is_password_reset_all_details():
            raise AttributeError("tag 'password_reset_all_details' not set")
        return self._value

    def get_emm_create_exceptions_report_details(self):
        """
        EMM excluded users report created.

        Only call this if :meth:`is_emm_create_exceptions_report_details` is true.

        :rtype: EmmCreateExceptionsReportDetails
        """
        if not self.is_emm_create_exceptions_report_details():
            raise AttributeError("tag 'emm_create_exceptions_report_details' not set")
        return self._value

    def get_emm_create_usage_report_details(self):
        """
        EMM mobile app usage report created.

        Only call this if :meth:`is_emm_create_usage_report_details` is true.

        :rtype: EmmCreateUsageReportDetails
        """
        if not self.is_emm_create_usage_report_details():
            raise AttributeError("tag 'emm_create_usage_report_details' not set")
        return self._value

    def get_smart_sync_create_admin_privilege_report_details(self):
        """
        Smart Sync non-admin devices report created.

        Only call this if :meth:`is_smart_sync_create_admin_privilege_report_details` is true.

        :rtype: SmartSyncCreateAdminPrivilegeReportDetails
        """
        if not self.is_smart_sync_create_admin_privilege_report_details():
            raise AttributeError("tag 'smart_sync_create_admin_privilege_report_details' not set")
        return self._value

    def get_team_activity_create_report_details(self):
        """
        Created a team activity report.

        Only call this if :meth:`is_team_activity_create_report_details` is true.

        :rtype: TeamActivityCreateReportDetails
        """
        if not self.is_team_activity_create_report_details():
            raise AttributeError("tag 'team_activity_create_report_details' not set")
        return self._value

    def get_collection_share_details(self):
        """
        Shared an album.

        Only call this if :meth:`is_collection_share_details` is true.

        :rtype: CollectionShareDetails
        """
        if not self.is_collection_share_details():
            raise AttributeError("tag 'collection_share_details' not set")
        return self._value

    def get_file_add_comment_details(self):
        """
        Added a file comment.

        Only call this if :meth:`is_file_add_comment_details` is true.

        :rtype: FileAddCommentDetails
        """
        if not self.is_file_add_comment_details():
            raise AttributeError("tag 'file_add_comment_details' not set")
        return self._value

    def get_file_like_comment_details(self):
        """
        Liked a file comment.

        Only call this if :meth:`is_file_like_comment_details` is true.

        :rtype: FileLikeCommentDetails
        """
        if not self.is_file_like_comment_details():
            raise AttributeError("tag 'file_like_comment_details' not set")
        return self._value

    def get_file_unlike_comment_details(self):
        """
        Unliked a file comment.

        Only call this if :meth:`is_file_unlike_comment_details` is true.

        :rtype: FileUnlikeCommentDetails
        """
        if not self.is_file_unlike_comment_details():
            raise AttributeError("tag 'file_unlike_comment_details' not set")
        return self._value

    def get_note_acl_invite_only_details(self):
        """
        Changed a Paper document to be invite-only.

        Only call this if :meth:`is_note_acl_invite_only_details` is true.

        :rtype: NoteAclInviteOnlyDetails
        """
        if not self.is_note_acl_invite_only_details():
            raise AttributeError("tag 'note_acl_invite_only_details' not set")
        return self._value

    def get_note_acl_link_details(self):
        """
        Changed a Paper document to be link accessible.

        Only call this if :meth:`is_note_acl_link_details` is true.

        :rtype: NoteAclLinkDetails
        """
        if not self.is_note_acl_link_details():
            raise AttributeError("tag 'note_acl_link_details' not set")
        return self._value

    def get_note_acl_team_link_details(self):
        """
        Changed a Paper document to be link accessible for the team.

        Only call this if :meth:`is_note_acl_team_link_details` is true.

        :rtype: NoteAclTeamLinkDetails
        """
        if not self.is_note_acl_team_link_details():
            raise AttributeError("tag 'note_acl_team_link_details' not set")
        return self._value

    def get_note_shared_details(self):
        """
        Shared a Paper doc.

        Only call this if :meth:`is_note_shared_details` is true.

        :rtype: NoteSharedDetails
        """
        if not self.is_note_shared_details():
            raise AttributeError("tag 'note_shared_details' not set")
        return self._value

    def get_note_share_receive_details(self):
        """
        Shared Paper document received.

        Only call this if :meth:`is_note_share_receive_details` is true.

        :rtype: NoteShareReceiveDetails
        """
        if not self.is_note_share_receive_details():
            raise AttributeError("tag 'note_share_receive_details' not set")
        return self._value

    def get_open_note_shared_details(self):
        """
        Opened a shared Paper doc.

        Only call this if :meth:`is_open_note_shared_details` is true.

        :rtype: OpenNoteSharedDetails
        """
        if not self.is_open_note_shared_details():
            raise AttributeError("tag 'open_note_shared_details' not set")
        return self._value

    def get_sf_add_group_details(self):
        """
        Added the team to a shared folder.

        Only call this if :meth:`is_sf_add_group_details` is true.

        :rtype: SfAddGroupDetails
        """
        if not self.is_sf_add_group_details():
            raise AttributeError("tag 'sf_add_group_details' not set")
        return self._value

    def get_sf_allow_non_members_to_view_shared_links_details(self):
        """
        Allowed non collaborators to view links to files in a shared folder.

        Only call this if :meth:`is_sf_allow_non_members_to_view_shared_links_details` is true.

        :rtype: SfAllowNonMembersToViewSharedLinksDetails
        """
        if not self.is_sf_allow_non_members_to_view_shared_links_details():
            raise AttributeError("tag 'sf_allow_non_members_to_view_shared_links_details' not set")
        return self._value

    def get_sf_invite_group_details(self):
        """
        Invited a group to a shared folder.

        Only call this if :meth:`is_sf_invite_group_details` is true.

        :rtype: SfInviteGroupDetails
        """
        if not self.is_sf_invite_group_details():
            raise AttributeError("tag 'sf_invite_group_details' not set")
        return self._value

    def get_sf_nest_details(self):
        """
        Changed parent of shared folder.

        Only call this if :meth:`is_sf_nest_details` is true.

        :rtype: SfNestDetails
        """
        if not self.is_sf_nest_details():
            raise AttributeError("tag 'sf_nest_details' not set")
        return self._value

    def get_sf_team_decline_details(self):
        """
        Declined a team member's invitation to a shared folder.

        Only call this if :meth:`is_sf_team_decline_details` is true.

        :rtype: SfTeamDeclineDetails
        """
        if not self.is_sf_team_decline_details():
            raise AttributeError("tag 'sf_team_decline_details' not set")
        return self._value

    def get_sf_team_grant_access_details(self):
        """
        Granted access to a shared folder.

        Only call this if :meth:`is_sf_team_grant_access_details` is true.

        :rtype: SfTeamGrantAccessDetails
        """
        if not self.is_sf_team_grant_access_details():
            raise AttributeError("tag 'sf_team_grant_access_details' not set")
        return self._value

    def get_sf_team_invite_details(self):
        """
        Invited team members to a shared folder.

        Only call this if :meth:`is_sf_team_invite_details` is true.

        :rtype: SfTeamInviteDetails
        """
        if not self.is_sf_team_invite_details():
            raise AttributeError("tag 'sf_team_invite_details' not set")
        return self._value

    def get_sf_team_invite_change_role_details(self):
        """
        Changed a team member's role in a shared folder.

        Only call this if :meth:`is_sf_team_invite_change_role_details` is true.

        :rtype: SfTeamInviteChangeRoleDetails
        """
        if not self.is_sf_team_invite_change_role_details():
            raise AttributeError("tag 'sf_team_invite_change_role_details' not set")
        return self._value

    def get_sf_team_join_details(self):
        """
        Joined a team member's shared folder.

        Only call this if :meth:`is_sf_team_join_details` is true.

        :rtype: SfTeamJoinDetails
        """
        if not self.is_sf_team_join_details():
            raise AttributeError("tag 'sf_team_join_details' not set")
        return self._value

    def get_sf_team_join_from_oob_link_details(self):
        """
        Joined a team member's shared folder from a link.

        Only call this if :meth:`is_sf_team_join_from_oob_link_details` is true.

        :rtype: SfTeamJoinFromOobLinkDetails
        """
        if not self.is_sf_team_join_from_oob_link_details():
            raise AttributeError("tag 'sf_team_join_from_oob_link_details' not set")
        return self._value

    def get_sf_team_uninvite_details(self):
        """
        Unshared a folder with a team member.

        Only call this if :meth:`is_sf_team_uninvite_details` is true.

        :rtype: SfTeamUninviteDetails
        """
        if not self.is_sf_team_uninvite_details():
            raise AttributeError("tag 'sf_team_uninvite_details' not set")
        return self._value

    def get_shared_content_add_invitees_details(self):
        """
        Sent an email invitation to the membership of a shared file or folder.

        Only call this if :meth:`is_shared_content_add_invitees_details` is true.

        :rtype: SharedContentAddInviteesDetails
        """
        if not self.is_shared_content_add_invitees_details():
            raise AttributeError("tag 'shared_content_add_invitees_details' not set")
        return self._value

    def get_shared_content_add_link_expiry_details(self):
        """
        Added an expiry to the link for the shared file or folder.

        Only call this if :meth:`is_shared_content_add_link_expiry_details` is true.

        :rtype: SharedContentAddLinkExpiryDetails
        """
        if not self.is_shared_content_add_link_expiry_details():
            raise AttributeError("tag 'shared_content_add_link_expiry_details' not set")
        return self._value

    def get_shared_content_add_link_password_details(self):
        """
        Added a password to the link for the shared file or folder.

        Only call this if :meth:`is_shared_content_add_link_password_details` is true.

        :rtype: SharedContentAddLinkPasswordDetails
        """
        if not self.is_shared_content_add_link_password_details():
            raise AttributeError("tag 'shared_content_add_link_password_details' not set")
        return self._value

    def get_shared_content_add_member_details(self):
        """
        Added users and/or groups to the membership of a shared file or folder.

        Only call this if :meth:`is_shared_content_add_member_details` is true.

        :rtype: SharedContentAddMemberDetails
        """
        if not self.is_shared_content_add_member_details():
            raise AttributeError("tag 'shared_content_add_member_details' not set")
        return self._value

    def get_shared_content_change_downloads_policy_details(self):
        """
        Changed whether members can download the shared file or folder.

        Only call this if :meth:`is_shared_content_change_downloads_policy_details` is true.

        :rtype: SharedContentChangeDownloadsPolicyDetails
        """
        if not self.is_shared_content_change_downloads_policy_details():
            raise AttributeError("tag 'shared_content_change_downloads_policy_details' not set")
        return self._value

    def get_shared_content_change_invitee_role_details(self):
        """
        Changed the access type of an invitee to a shared file or folder before
        the invitation was claimed.

        Only call this if :meth:`is_shared_content_change_invitee_role_details` is true.

        :rtype: SharedContentChangeInviteeRoleDetails
        """
        if not self.is_shared_content_change_invitee_role_details():
            raise AttributeError("tag 'shared_content_change_invitee_role_details' not set")
        return self._value

    def get_shared_content_change_link_audience_details(self):
        """
        Changed the audience of the link for a shared file or folder.

        Only call this if :meth:`is_shared_content_change_link_audience_details` is true.

        :rtype: SharedContentChangeLinkAudienceDetails
        """
        if not self.is_shared_content_change_link_audience_details():
            raise AttributeError("tag 'shared_content_change_link_audience_details' not set")
        return self._value

    def get_shared_content_change_link_expiry_details(self):
        """
        Changed the expiry of the link for the shared file or folder.

        Only call this if :meth:`is_shared_content_change_link_expiry_details` is true.

        :rtype: SharedContentChangeLinkExpiryDetails
        """
        if not self.is_shared_content_change_link_expiry_details():
            raise AttributeError("tag 'shared_content_change_link_expiry_details' not set")
        return self._value

    def get_shared_content_change_link_password_details(self):
        """
        Changed the password on the link for the shared file or folder.

        Only call this if :meth:`is_shared_content_change_link_password_details` is true.

        :rtype: SharedContentChangeLinkPasswordDetails
        """
        if not self.is_shared_content_change_link_password_details():
            raise AttributeError("tag 'shared_content_change_link_password_details' not set")
        return self._value

    def get_shared_content_change_member_role_details(self):
        """
        Changed the access type of a shared file or folder member.

        Only call this if :meth:`is_shared_content_change_member_role_details` is true.

        :rtype: SharedContentChangeMemberRoleDetails
        """
        if not self.is_shared_content_change_member_role_details():
            raise AttributeError("tag 'shared_content_change_member_role_details' not set")
        return self._value

    def get_shared_content_change_viewer_info_policy_details(self):
        """
        Changed whether members can see who viewed the shared file or folder.

        Only call this if :meth:`is_shared_content_change_viewer_info_policy_details` is true.

        :rtype: SharedContentChangeViewerInfoPolicyDetails
        """
        if not self.is_shared_content_change_viewer_info_policy_details():
            raise AttributeError("tag 'shared_content_change_viewer_info_policy_details' not set")
        return self._value

    def get_shared_content_claim_invitation_details(self):
        """
        Claimed membership to a team member's shared folder.

        Only call this if :meth:`is_shared_content_claim_invitation_details` is true.

        :rtype: SharedContentClaimInvitationDetails
        """
        if not self.is_shared_content_claim_invitation_details():
            raise AttributeError("tag 'shared_content_claim_invitation_details' not set")
        return self._value

    def get_shared_content_copy_details(self):
        """
        Copied the shared file or folder to own Dropbox.

        Only call this if :meth:`is_shared_content_copy_details` is true.

        :rtype: SharedContentCopyDetails
        """
        if not self.is_shared_content_copy_details():
            raise AttributeError("tag 'shared_content_copy_details' not set")
        return self._value

    def get_shared_content_download_details(self):
        """
        Downloaded the shared file or folder.

        Only call this if :meth:`is_shared_content_download_details` is true.

        :rtype: SharedContentDownloadDetails
        """
        if not self.is_shared_content_download_details():
            raise AttributeError("tag 'shared_content_download_details' not set")
        return self._value

    def get_shared_content_relinquish_membership_details(self):
        """
        Left the membership of a shared file or folder.

        Only call this if :meth:`is_shared_content_relinquish_membership_details` is true.

        :rtype: SharedContentRelinquishMembershipDetails
        """
        if not self.is_shared_content_relinquish_membership_details():
            raise AttributeError("tag 'shared_content_relinquish_membership_details' not set")
        return self._value

    def get_shared_content_remove_invitee_details(self):
        """
        Removed an invitee from the membership of a shared file or folder before
        it was claimed.

        Only call this if :meth:`is_shared_content_remove_invitee_details` is true.

        :rtype: SharedContentRemoveInviteeDetails
        """
        if not self.is_shared_content_remove_invitee_details():
            raise AttributeError("tag 'shared_content_remove_invitee_details' not set")
        return self._value

    def get_shared_content_remove_link_expiry_details(self):
        """
        Removed the expiry of the link for the shared file or folder.

        Only call this if :meth:`is_shared_content_remove_link_expiry_details` is true.

        :rtype: SharedContentRemoveLinkExpiryDetails
        """
        if not self.is_shared_content_remove_link_expiry_details():
            raise AttributeError("tag 'shared_content_remove_link_expiry_details' not set")
        return self._value

    def get_shared_content_remove_link_password_details(self):
        """
        Removed the password on the link for the shared file or folder.

        Only call this if :meth:`is_shared_content_remove_link_password_details` is true.

        :rtype: SharedContentRemoveLinkPasswordDetails
        """
        if not self.is_shared_content_remove_link_password_details():
            raise AttributeError("tag 'shared_content_remove_link_password_details' not set")
        return self._value

    def get_shared_content_remove_member_details(self):
        """
        Removed a user or a group from the membership of a shared file or
        folder.

        Only call this if :meth:`is_shared_content_remove_member_details` is true.

        :rtype: SharedContentRemoveMemberDetails
        """
        if not self.is_shared_content_remove_member_details():
            raise AttributeError("tag 'shared_content_remove_member_details' not set")
        return self._value

    def get_shared_content_request_access_details(self):
        """
        Requested to be on the membership of a shared file or folder.

        Only call this if :meth:`is_shared_content_request_access_details` is true.

        :rtype: SharedContentRequestAccessDetails
        """
        if not self.is_shared_content_request_access_details():
            raise AttributeError("tag 'shared_content_request_access_details' not set")
        return self._value

    def get_shared_content_unshare_details(self):
        """
        Unshared a shared file or folder by clearing its membership and turning
        off its link.

        Only call this if :meth:`is_shared_content_unshare_details` is true.

        :rtype: SharedContentUnshareDetails
        """
        if not self.is_shared_content_unshare_details():
            raise AttributeError("tag 'shared_content_unshare_details' not set")
        return self._value

    def get_shared_content_view_details(self):
        """
        Previewed the shared file or folder.

        Only call this if :meth:`is_shared_content_view_details` is true.

        :rtype: SharedContentViewDetails
        """
        if not self.is_shared_content_view_details():
            raise AttributeError("tag 'shared_content_view_details' not set")
        return self._value

    def get_shared_folder_change_confidentiality_details(self):
        """
        Set or unset the confidential flag on a shared folder.

        Only call this if :meth:`is_shared_folder_change_confidentiality_details` is true.

        :rtype: SharedFolderChangeConfidentialityDetails
        """
        if not self.is_shared_folder_change_confidentiality_details():
            raise AttributeError("tag 'shared_folder_change_confidentiality_details' not set")
        return self._value

    def get_shared_folder_change_link_policy_details(self):
        """
        Changed who can access the shared folder via a link.

        Only call this if :meth:`is_shared_folder_change_link_policy_details` is true.

        :rtype: SharedFolderChangeLinkPolicyDetails
        """
        if not self.is_shared_folder_change_link_policy_details():
            raise AttributeError("tag 'shared_folder_change_link_policy_details' not set")
        return self._value

    def get_shared_folder_change_member_management_policy_details(self):
        """
        Changed who can manage the membership of a shared folder.

        Only call this if :meth:`is_shared_folder_change_member_management_policy_details` is true.

        :rtype: SharedFolderChangeMemberManagementPolicyDetails
        """
        if not self.is_shared_folder_change_member_management_policy_details():
            raise AttributeError("tag 'shared_folder_change_member_management_policy_details' not set")
        return self._value

    def get_shared_folder_change_member_policy_details(self):
        """
        Changed who can become a member of the shared folder.

        Only call this if :meth:`is_shared_folder_change_member_policy_details` is true.

        :rtype: SharedFolderChangeMemberPolicyDetails
        """
        if not self.is_shared_folder_change_member_policy_details():
            raise AttributeError("tag 'shared_folder_change_member_policy_details' not set")
        return self._value

    def get_shared_folder_create_details(self):
        """
        Created a shared folder.

        Only call this if :meth:`is_shared_folder_create_details` is true.

        :rtype: SharedFolderCreateDetails
        """
        if not self.is_shared_folder_create_details():
            raise AttributeError("tag 'shared_folder_create_details' not set")
        return self._value

    def get_shared_folder_mount_details(self):
        """
        Added a shared folder to own Dropbox.

        Only call this if :meth:`is_shared_folder_mount_details` is true.

        :rtype: SharedFolderMountDetails
        """
        if not self.is_shared_folder_mount_details():
            raise AttributeError("tag 'shared_folder_mount_details' not set")
        return self._value

    def get_shared_folder_transfer_ownership_details(self):
        """
        Transferred the ownership of a shared folder to another member.

        Only call this if :meth:`is_shared_folder_transfer_ownership_details` is true.

        :rtype: SharedFolderTransferOwnershipDetails
        """
        if not self.is_shared_folder_transfer_ownership_details():
            raise AttributeError("tag 'shared_folder_transfer_ownership_details' not set")
        return self._value

    def get_shared_folder_unmount_details(self):
        """
        Deleted a shared folder from Dropbox.

        Only call this if :meth:`is_shared_folder_unmount_details` is true.

        :rtype: SharedFolderUnmountDetails
        """
        if not self.is_shared_folder_unmount_details():
            raise AttributeError("tag 'shared_folder_unmount_details' not set")
        return self._value

    def get_shared_note_opened_details(self):
        """
        Shared Paper document was opened.

        Only call this if :meth:`is_shared_note_opened_details` is true.

        :rtype: SharedNoteOpenedDetails
        """
        if not self.is_shared_note_opened_details():
            raise AttributeError("tag 'shared_note_opened_details' not set")
        return self._value

    def get_shmodel_app_create_details(self):
        """
        Created a link to a file using an app.

        Only call this if :meth:`is_shmodel_app_create_details` is true.

        :rtype: ShmodelAppCreateDetails
        """
        if not self.is_shmodel_app_create_details():
            raise AttributeError("tag 'shmodel_app_create_details' not set")
        return self._value

    def get_shmodel_create_details(self):
        """
        Created a new link.

        Only call this if :meth:`is_shmodel_create_details` is true.

        :rtype: ShmodelCreateDetails
        """
        if not self.is_shmodel_create_details():
            raise AttributeError("tag 'shmodel_create_details' not set")
        return self._value

    def get_shmodel_disable_details(self):
        """
        Removed a link.

        Only call this if :meth:`is_shmodel_disable_details` is true.

        :rtype: ShmodelDisableDetails
        """
        if not self.is_shmodel_disable_details():
            raise AttributeError("tag 'shmodel_disable_details' not set")
        return self._value

    def get_shmodel_fb_share_details(self):
        """
        Shared a link with Facebook users.

        Only call this if :meth:`is_shmodel_fb_share_details` is true.

        :rtype: ShmodelFbShareDetails
        """
        if not self.is_shmodel_fb_share_details():
            raise AttributeError("tag 'shmodel_fb_share_details' not set")
        return self._value

    def get_shmodel_group_share_details(self):
        """
        Shared a link with a group.

        Only call this if :meth:`is_shmodel_group_share_details` is true.

        :rtype: ShmodelGroupShareDetails
        """
        if not self.is_shmodel_group_share_details():
            raise AttributeError("tag 'shmodel_group_share_details' not set")
        return self._value

    def get_shmodel_remove_expiration_details(self):
        """
        Removed the expiration date from a link.

        Only call this if :meth:`is_shmodel_remove_expiration_details` is true.

        :rtype: ShmodelRemoveExpirationDetails
        """
        if not self.is_shmodel_remove_expiration_details():
            raise AttributeError("tag 'shmodel_remove_expiration_details' not set")
        return self._value

    def get_shmodel_set_expiration_details(self):
        """
        Added an expiration date to a link.

        Only call this if :meth:`is_shmodel_set_expiration_details` is true.

        :rtype: ShmodelSetExpirationDetails
        """
        if not self.is_shmodel_set_expiration_details():
            raise AttributeError("tag 'shmodel_set_expiration_details' not set")
        return self._value

    def get_shmodel_team_copy_details(self):
        """
        Added a team member's file/folder to their Dropbox from a link.

        Only call this if :meth:`is_shmodel_team_copy_details` is true.

        :rtype: ShmodelTeamCopyDetails
        """
        if not self.is_shmodel_team_copy_details():
            raise AttributeError("tag 'shmodel_team_copy_details' not set")
        return self._value

    def get_shmodel_team_download_details(self):
        """
        Downloaded a team member's file/folder from a link.

        Only call this if :meth:`is_shmodel_team_download_details` is true.

        :rtype: ShmodelTeamDownloadDetails
        """
        if not self.is_shmodel_team_download_details():
            raise AttributeError("tag 'shmodel_team_download_details' not set")
        return self._value

    def get_shmodel_team_share_details(self):
        """
        Shared a link with team members.

        Only call this if :meth:`is_shmodel_team_share_details` is true.

        :rtype: ShmodelTeamShareDetails
        """
        if not self.is_shmodel_team_share_details():
            raise AttributeError("tag 'shmodel_team_share_details' not set")
        return self._value

    def get_shmodel_team_view_details(self):
        """
        Opened a team member's link.

        Only call this if :meth:`is_shmodel_team_view_details` is true.

        :rtype: ShmodelTeamViewDetails
        """
        if not self.is_shmodel_team_view_details():
            raise AttributeError("tag 'shmodel_team_view_details' not set")
        return self._value

    def get_shmodel_visibility_password_details(self):
        """
        Password-protected a link.

        Only call this if :meth:`is_shmodel_visibility_password_details` is true.

        :rtype: ShmodelVisibilityPasswordDetails
        """
        if not self.is_shmodel_visibility_password_details():
            raise AttributeError("tag 'shmodel_visibility_password_details' not set")
        return self._value

    def get_shmodel_visibility_public_details(self):
        """
        Made a file/folder visible to anyone with the link.

        Only call this if :meth:`is_shmodel_visibility_public_details` is true.

        :rtype: ShmodelVisibilityPublicDetails
        """
        if not self.is_shmodel_visibility_public_details():
            raise AttributeError("tag 'shmodel_visibility_public_details' not set")
        return self._value

    def get_shmodel_visibility_team_only_details(self):
        """
        Made a file/folder visible only to team members with the link.

        Only call this if :meth:`is_shmodel_visibility_team_only_details` is true.

        :rtype: ShmodelVisibilityTeamOnlyDetails
        """
        if not self.is_shmodel_visibility_team_only_details():
            raise AttributeError("tag 'shmodel_visibility_team_only_details' not set")
        return self._value

    def get_remove_logout_url_details(self):
        """
        Removed single sign-on logout URL.

        Only call this if :meth:`is_remove_logout_url_details` is true.

        :rtype: RemoveLogoutUrlDetails
        """
        if not self.is_remove_logout_url_details():
            raise AttributeError("tag 'remove_logout_url_details' not set")
        return self._value

    def get_remove_sso_url_details(self):
        """
        Changed the sign-out URL for SSO.

        Only call this if :meth:`is_remove_sso_url_details` is true.

        :rtype: RemoveSsoUrlDetails
        """
        if not self.is_remove_sso_url_details():
            raise AttributeError("tag 'remove_sso_url_details' not set")
        return self._value

    def get_sso_change_cert_details(self):
        """
        Changed the X.509 certificate for SSO.

        Only call this if :meth:`is_sso_change_cert_details` is true.

        :rtype: SsoChangeCertDetails
        """
        if not self.is_sso_change_cert_details():
            raise AttributeError("tag 'sso_change_cert_details' not set")
        return self._value

    def get_sso_change_login_url_details(self):
        """
        Changed the sign-in URL for SSO.

        Only call this if :meth:`is_sso_change_login_url_details` is true.

        :rtype: SsoChangeLoginUrlDetails
        """
        if not self.is_sso_change_login_url_details():
            raise AttributeError("tag 'sso_change_login_url_details' not set")
        return self._value

    def get_sso_change_logout_url_details(self):
        """
        Changed the sign-out URL for SSO.

        Only call this if :meth:`is_sso_change_logout_url_details` is true.

        :rtype: SsoChangeLogoutUrlDetails
        """
        if not self.is_sso_change_logout_url_details():
            raise AttributeError("tag 'sso_change_logout_url_details' not set")
        return self._value

    def get_sso_change_saml_identity_mode_details(self):
        """
        Changed the SAML identity mode for SSO.

        Only call this if :meth:`is_sso_change_saml_identity_mode_details` is true.

        :rtype: SsoChangeSamlIdentityModeDetails
        """
        if not self.is_sso_change_saml_identity_mode_details():
            raise AttributeError("tag 'sso_change_saml_identity_mode_details' not set")
        return self._value

    def get_team_folder_change_status_details(self):
        """
        Changed the archival status of a team folder.

        Only call this if :meth:`is_team_folder_change_status_details` is true.

        :rtype: TeamFolderChangeStatusDetails
        """
        if not self.is_team_folder_change_status_details():
            raise AttributeError("tag 'team_folder_change_status_details' not set")
        return self._value

    def get_team_folder_create_details(self):
        """
        Created a new team folder in active status.

        Only call this if :meth:`is_team_folder_create_details` is true.

        :rtype: TeamFolderCreateDetails
        """
        if not self.is_team_folder_create_details():
            raise AttributeError("tag 'team_folder_create_details' not set")
        return self._value

    def get_team_folder_downgrade_details(self):
        """
        Downgraded a team folder to a regular shared folder.

        Only call this if :meth:`is_team_folder_downgrade_details` is true.

        :rtype: TeamFolderDowngradeDetails
        """
        if not self.is_team_folder_downgrade_details():
            raise AttributeError("tag 'team_folder_downgrade_details' not set")
        return self._value

    def get_team_folder_permanently_delete_details(self):
        """
        Permanently deleted an archived team folder.

        Only call this if :meth:`is_team_folder_permanently_delete_details` is true.

        :rtype: TeamFolderPermanentlyDeleteDetails
        """
        if not self.is_team_folder_permanently_delete_details():
            raise AttributeError("tag 'team_folder_permanently_delete_details' not set")
        return self._value

    def get_team_folder_rename_details(self):
        """
        Renamed an active or archived team folder.

        Only call this if :meth:`is_team_folder_rename_details` is true.

        :rtype: TeamFolderRenameDetails
        """
        if not self.is_team_folder_rename_details():
            raise AttributeError("tag 'team_folder_rename_details' not set")
        return self._value

    def get_account_capture_change_policy_details(self):
        """
        Changed the account capture policy on a domain belonging to the team.

        Only call this if :meth:`is_account_capture_change_policy_details` is true.

        :rtype: AccountCaptureChangePolicyDetails
        """
        if not self.is_account_capture_change_policy_details():
            raise AttributeError("tag 'account_capture_change_policy_details' not set")
        return self._value

    def get_allow_download_disabled_details(self):
        """
        Disabled allow downloads.

        Only call this if :meth:`is_allow_download_disabled_details` is true.

        :rtype: AllowDownloadDisabledDetails
        """
        if not self.is_allow_download_disabled_details():
            raise AttributeError("tag 'allow_download_disabled_details' not set")
        return self._value

    def get_allow_download_enabled_details(self):
        """
        Enabled allow downloads.

        Only call this if :meth:`is_allow_download_enabled_details` is true.

        :rtype: AllowDownloadEnabledDetails
        """
        if not self.is_allow_download_enabled_details():
            raise AttributeError("tag 'allow_download_enabled_details' not set")
        return self._value

    def get_data_placement_restriction_change_policy_details(self):
        """
        Set a restriction policy regarding the location of data centers where
        team data resides.

        Only call this if :meth:`is_data_placement_restriction_change_policy_details` is true.

        :rtype: DataPlacementRestrictionChangePolicyDetails
        """
        if not self.is_data_placement_restriction_change_policy_details():
            raise AttributeError("tag 'data_placement_restriction_change_policy_details' not set")
        return self._value

    def get_data_placement_restriction_satisfy_policy_details(self):
        """
        Satisfied a previously set restriction policy regarding the location of
        data centers where team data resides (i.e. all data have been migrated
        according to the restriction placed).

        Only call this if :meth:`is_data_placement_restriction_satisfy_policy_details` is true.

        :rtype: DataPlacementRestrictionSatisfyPolicyDetails
        """
        if not self.is_data_placement_restriction_satisfy_policy_details():
            raise AttributeError("tag 'data_placement_restriction_satisfy_policy_details' not set")
        return self._value

    def get_device_approvals_change_desktop_policy_details(self):
        """
        Set or removed a limit on the number of computers each team member can
        link to their work Dropbox account.

        Only call this if :meth:`is_device_approvals_change_desktop_policy_details` is true.

        :rtype: DeviceApprovalsChangeDesktopPolicyDetails
        """
        if not self.is_device_approvals_change_desktop_policy_details():
            raise AttributeError("tag 'device_approvals_change_desktop_policy_details' not set")
        return self._value

    def get_device_approvals_change_mobile_policy_details(self):
        """
        Set or removed a limit on the number of mobiles devices each team member
        can link to their work Dropbox account.

        Only call this if :meth:`is_device_approvals_change_mobile_policy_details` is true.

        :rtype: DeviceApprovalsChangeMobilePolicyDetails
        """
        if not self.is_device_approvals_change_mobile_policy_details():
            raise AttributeError("tag 'device_approvals_change_mobile_policy_details' not set")
        return self._value

    def get_device_approvals_change_overage_action_details(self):
        """
        Changed the action taken when a team member is already over the limits
        (e.g when they join the team, an admin lowers limits, etc.).

        Only call this if :meth:`is_device_approvals_change_overage_action_details` is true.

        :rtype: DeviceApprovalsChangeOverageActionDetails
        """
        if not self.is_device_approvals_change_overage_action_details():
            raise AttributeError("tag 'device_approvals_change_overage_action_details' not set")
        return self._value

    def get_device_approvals_change_unlink_action_details(self):
        """
        Changed the action taken with respect to approval limits when a team
        member unlinks an approved device.

        Only call this if :meth:`is_device_approvals_change_unlink_action_details` is true.

        :rtype: DeviceApprovalsChangeUnlinkActionDetails
        """
        if not self.is_device_approvals_change_unlink_action_details():
            raise AttributeError("tag 'device_approvals_change_unlink_action_details' not set")
        return self._value

    def get_emm_add_exception_details(self):
        """
        Added an exception for one or more team members to optionally use the
        regular Dropbox app when EMM is enabled.

        Only call this if :meth:`is_emm_add_exception_details` is true.

        :rtype: EmmAddExceptionDetails
        """
        if not self.is_emm_add_exception_details():
            raise AttributeError("tag 'emm_add_exception_details' not set")
        return self._value

    def get_emm_change_policy_details(self):
        """
        Enabled or disabled enterprise mobility management for team members.

        Only call this if :meth:`is_emm_change_policy_details` is true.

        :rtype: EmmChangePolicyDetails
        """
        if not self.is_emm_change_policy_details():
            raise AttributeError("tag 'emm_change_policy_details' not set")
        return self._value

    def get_emm_remove_exception_details(self):
        """
        Removed an exception for one or more team members to optionally use the
        regular Dropbox app when EMM is enabled.

        Only call this if :meth:`is_emm_remove_exception_details` is true.

        :rtype: EmmRemoveExceptionDetails
        """
        if not self.is_emm_remove_exception_details():
            raise AttributeError("tag 'emm_remove_exception_details' not set")
        return self._value

    def get_extended_version_history_change_policy_details(self):
        """
        Accepted or opted out of extended version history.

        Only call this if :meth:`is_extended_version_history_change_policy_details` is true.

        :rtype: ExtendedVersionHistoryChangePolicyDetails
        """
        if not self.is_extended_version_history_change_policy_details():
            raise AttributeError("tag 'extended_version_history_change_policy_details' not set")
        return self._value

    def get_file_comments_change_policy_details(self):
        """
        Enabled or disabled commenting on team files.

        Only call this if :meth:`is_file_comments_change_policy_details` is true.

        :rtype: FileCommentsChangePolicyDetails
        """
        if not self.is_file_comments_change_policy_details():
            raise AttributeError("tag 'file_comments_change_policy_details' not set")
        return self._value

    def get_file_requests_change_policy_details(self):
        """
        Enabled or disabled file requests.

        Only call this if :meth:`is_file_requests_change_policy_details` is true.

        :rtype: FileRequestsChangePolicyDetails
        """
        if not self.is_file_requests_change_policy_details():
            raise AttributeError("tag 'file_requests_change_policy_details' not set")
        return self._value

    def get_file_requests_emails_enabled_details(self):
        """
        Enabled file request emails for everyone.

        Only call this if :meth:`is_file_requests_emails_enabled_details` is true.

        :rtype: FileRequestsEmailsEnabledDetails
        """
        if not self.is_file_requests_emails_enabled_details():
            raise AttributeError("tag 'file_requests_emails_enabled_details' not set")
        return self._value

    def get_file_requests_emails_restricted_to_team_only_details(self):
        """
        Allowed file request emails for the team.

        Only call this if :meth:`is_file_requests_emails_restricted_to_team_only_details` is true.

        :rtype: FileRequestsEmailsRestrictedToTeamOnlyDetails
        """
        if not self.is_file_requests_emails_restricted_to_team_only_details():
            raise AttributeError("tag 'file_requests_emails_restricted_to_team_only_details' not set")
        return self._value

    def get_google_sso_change_policy_details(self):
        """
        Enabled or disabled Google single sign-on for the team.

        Only call this if :meth:`is_google_sso_change_policy_details` is true.

        :rtype: GoogleSsoChangePolicyDetails
        """
        if not self.is_google_sso_change_policy_details():
            raise AttributeError("tag 'google_sso_change_policy_details' not set")
        return self._value

    def get_group_user_management_change_policy_details(self):
        """
        Changed who can create groups.

        Only call this if :meth:`is_group_user_management_change_policy_details` is true.

        :rtype: GroupUserManagementChangePolicyDetails
        """
        if not self.is_group_user_management_change_policy_details():
            raise AttributeError("tag 'group_user_management_change_policy_details' not set")
        return self._value

    def get_member_requests_change_policy_details(self):
        """
        Changed whether users can find the team when not invited.

        Only call this if :meth:`is_member_requests_change_policy_details` is true.

        :rtype: MemberRequestsChangePolicyDetails
        """
        if not self.is_member_requests_change_policy_details():
            raise AttributeError("tag 'member_requests_change_policy_details' not set")
        return self._value

    def get_member_space_limits_add_exception_details(self):
        """
        Added an exception for one or more team members to bypass space limits
        imposed by policy.

        Only call this if :meth:`is_member_space_limits_add_exception_details` is true.

        :rtype: MemberSpaceLimitsAddExceptionDetails
        """
        if not self.is_member_space_limits_add_exception_details():
            raise AttributeError("tag 'member_space_limits_add_exception_details' not set")
        return self._value

    def get_member_space_limits_change_policy_details(self):
        """
        Changed the storage limits applied to team members by policy.

        Only call this if :meth:`is_member_space_limits_change_policy_details` is true.

        :rtype: MemberSpaceLimitsChangePolicyDetails
        """
        if not self.is_member_space_limits_change_policy_details():
            raise AttributeError("tag 'member_space_limits_change_policy_details' not set")
        return self._value

    def get_member_space_limits_remove_exception_details(self):
        """
        Removed an exception for one or more team members to bypass space limits
        imposed by policy.

        Only call this if :meth:`is_member_space_limits_remove_exception_details` is true.

        :rtype: MemberSpaceLimitsRemoveExceptionDetails
        """
        if not self.is_member_space_limits_remove_exception_details():
            raise AttributeError("tag 'member_space_limits_remove_exception_details' not set")
        return self._value

    def get_member_suggestions_change_policy_details(self):
        """
        Enabled or disabled the option for team members to suggest new members
        to add to the team.

        Only call this if :meth:`is_member_suggestions_change_policy_details` is true.

        :rtype: MemberSuggestionsChangePolicyDetails
        """
        if not self.is_member_suggestions_change_policy_details():
            raise AttributeError("tag 'member_suggestions_change_policy_details' not set")
        return self._value

    def get_microsoft_office_addin_change_policy_details(self):
        """
        Enabled or disabled the Microsoft Office add-in, which lets team members
        save files to Dropbox directly from Microsoft Office.

        Only call this if :meth:`is_microsoft_office_addin_change_policy_details` is true.

        :rtype: MicrosoftOfficeAddinChangePolicyDetails
        """
        if not self.is_microsoft_office_addin_change_policy_details():
            raise AttributeError("tag 'microsoft_office_addin_change_policy_details' not set")
        return self._value

    def get_network_control_change_policy_details(self):
        """
        Enabled or disabled network control.

        Only call this if :meth:`is_network_control_change_policy_details` is true.

        :rtype: NetworkControlChangePolicyDetails
        """
        if not self.is_network_control_change_policy_details():
            raise AttributeError("tag 'network_control_change_policy_details' not set")
        return self._value

    def get_paper_change_deployment_policy_details(self):
        """
        Changed whether Dropbox Paper, when enabled, is deployed to all teams or
        to specific members of the team.

        Only call this if :meth:`is_paper_change_deployment_policy_details` is true.

        :rtype: PaperChangeDeploymentPolicyDetails
        """
        if not self.is_paper_change_deployment_policy_details():
            raise AttributeError("tag 'paper_change_deployment_policy_details' not set")
        return self._value

    def get_paper_change_member_policy_details(self):
        """
        Changed whether team members can share Paper documents externally (i.e.
        outside the team), and if so, whether they should be accessible only by
        team members or anyone by default.

        Only call this if :meth:`is_paper_change_member_policy_details` is true.

        :rtype: PaperChangeMemberPolicyDetails
        """
        if not self.is_paper_change_member_policy_details():
            raise AttributeError("tag 'paper_change_member_policy_details' not set")
        return self._value

    def get_paper_change_policy_details(self):
        """
        Enabled or disabled Dropbox Paper for the team.

        Only call this if :meth:`is_paper_change_policy_details` is true.

        :rtype: PaperChangePolicyDetails
        """
        if not self.is_paper_change_policy_details():
            raise AttributeError("tag 'paper_change_policy_details' not set")
        return self._value

    def get_permanent_delete_change_policy_details(self):
        """
        Enabled or disabled the ability of team members to permanently delete
        content.

        Only call this if :meth:`is_permanent_delete_change_policy_details` is true.

        :rtype: PermanentDeleteChangePolicyDetails
        """
        if not self.is_permanent_delete_change_policy_details():
            raise AttributeError("tag 'permanent_delete_change_policy_details' not set")
        return self._value

    def get_sharing_change_folder_join_policy_details(self):
        """
        Changed whether team members can join shared folders owned externally
        (i.e. outside the team).

        Only call this if :meth:`is_sharing_change_folder_join_policy_details` is true.

        :rtype: SharingChangeFolderJoinPolicyDetails
        """
        if not self.is_sharing_change_folder_join_policy_details():
            raise AttributeError("tag 'sharing_change_folder_join_policy_details' not set")
        return self._value

    def get_sharing_change_link_policy_details(self):
        """
        Changed whether team members can share links externally (i.e. outside
        the team), and if so, whether links should be accessible only by team
        members or anyone by default.

        Only call this if :meth:`is_sharing_change_link_policy_details` is true.

        :rtype: SharingChangeLinkPolicyDetails
        """
        if not self.is_sharing_change_link_policy_details():
            raise AttributeError("tag 'sharing_change_link_policy_details' not set")
        return self._value

    def get_sharing_change_member_policy_details(self):
        """
        Changed whether team members can share files and folders externally
        (i.e. outside the team).

        Only call this if :meth:`is_sharing_change_member_policy_details` is true.

        :rtype: SharingChangeMemberPolicyDetails
        """
        if not self.is_sharing_change_member_policy_details():
            raise AttributeError("tag 'sharing_change_member_policy_details' not set")
        return self._value

    def get_smart_sync_change_policy_details(self):
        """
        Changed the default Smart Sync policy for team members.

        Only call this if :meth:`is_smart_sync_change_policy_details` is true.

        :rtype: SmartSyncChangePolicyDetails
        """
        if not self.is_smart_sync_change_policy_details():
            raise AttributeError("tag 'smart_sync_change_policy_details' not set")
        return self._value

    def get_sso_change_policy_details(self):
        """
        Change the single sign-on policy for the team.

        Only call this if :meth:`is_sso_change_policy_details` is true.

        :rtype: SsoChangePolicyDetails
        """
        if not self.is_sso_change_policy_details():
            raise AttributeError("tag 'sso_change_policy_details' not set")
        return self._value

    def get_tfa_change_policy_details(self):
        """
        Change two-step verification policy for the team.

        Only call this if :meth:`is_tfa_change_policy_details` is true.

        :rtype: TfaChangePolicyDetails
        """
        if not self.is_tfa_change_policy_details():
            raise AttributeError("tag 'tfa_change_policy_details' not set")
        return self._value

    def get_two_account_change_policy_details(self):
        """
        Enabled or disabled the option for team members to link a personal
        Dropbox account in addition to their work account to the same computer.

        Only call this if :meth:`is_two_account_change_policy_details` is true.

        :rtype: TwoAccountChangePolicyDetails
        """
        if not self.is_two_account_change_policy_details():
            raise AttributeError("tag 'two_account_change_policy_details' not set")
        return self._value

    def get_web_sessions_change_fixed_length_policy_details(self):
        """
        Changed how long team members can stay signed in to Dropbox on the web.

        Only call this if :meth:`is_web_sessions_change_fixed_length_policy_details` is true.

        :rtype: WebSessionsChangeFixedLengthPolicyDetails
        """
        if not self.is_web_sessions_change_fixed_length_policy_details():
            raise AttributeError("tag 'web_sessions_change_fixed_length_policy_details' not set")
        return self._value

    def get_web_sessions_change_idle_length_policy_details(self):
        """
        Changed how long team members can be idle while signed in to Dropbox on
        the web.

        Only call this if :meth:`is_web_sessions_change_idle_length_policy_details` is true.

        :rtype: WebSessionsChangeIdleLengthPolicyDetails
        """
        if not self.is_web_sessions_change_idle_length_policy_details():
            raise AttributeError("tag 'web_sessions_change_idle_length_policy_details' not set")
        return self._value

    def get_team_profile_add_logo_details(self):
        """
        Added a team logo to be displayed on shared link headers.

        Only call this if :meth:`is_team_profile_add_logo_details` is true.

        :rtype: TeamProfileAddLogoDetails
        """
        if not self.is_team_profile_add_logo_details():
            raise AttributeError("tag 'team_profile_add_logo_details' not set")
        return self._value

    def get_team_profile_change_logo_details(self):
        """
        Changed the team logo to be displayed on shared link headers.

        Only call this if :meth:`is_team_profile_change_logo_details` is true.

        :rtype: TeamProfileChangeLogoDetails
        """
        if not self.is_team_profile_change_logo_details():
            raise AttributeError("tag 'team_profile_change_logo_details' not set")
        return self._value

    def get_team_profile_change_name_details(self):
        """
        Changed the team name.

        Only call this if :meth:`is_team_profile_change_name_details` is true.

        :rtype: TeamProfileChangeNameDetails
        """
        if not self.is_team_profile_change_name_details():
            raise AttributeError("tag 'team_profile_change_name_details' not set")
        return self._value

    def get_team_profile_remove_logo_details(self):
        """
        Removed the team logo to be displayed on shared link headers.

        Only call this if :meth:`is_team_profile_remove_logo_details` is true.

        :rtype: TeamProfileRemoveLogoDetails
        """
        if not self.is_team_profile_remove_logo_details():
            raise AttributeError("tag 'team_profile_remove_logo_details' not set")
        return self._value

    def get_tfa_add_backup_phone_details(self):
        """
        Added a backup phone for two-step verification.

        Only call this if :meth:`is_tfa_add_backup_phone_details` is true.

        :rtype: TfaAddBackupPhoneDetails
        """
        if not self.is_tfa_add_backup_phone_details():
            raise AttributeError("tag 'tfa_add_backup_phone_details' not set")
        return self._value

    def get_tfa_add_security_key_details(self):
        """
        Added a security key for two-step verification.

        Only call this if :meth:`is_tfa_add_security_key_details` is true.

        :rtype: TfaAddSecurityKeyDetails
        """
        if not self.is_tfa_add_security_key_details():
            raise AttributeError("tag 'tfa_add_security_key_details' not set")
        return self._value

    def get_tfa_change_backup_phone_details(self):
        """
        Changed the backup phone for two-step verification.

        Only call this if :meth:`is_tfa_change_backup_phone_details` is true.

        :rtype: TfaChangeBackupPhoneDetails
        """
        if not self.is_tfa_change_backup_phone_details():
            raise AttributeError("tag 'tfa_change_backup_phone_details' not set")
        return self._value

    def get_tfa_change_status_details(self):
        """
        Enabled, disabled or changed the configuration for two-step
        verification.

        Only call this if :meth:`is_tfa_change_status_details` is true.

        :rtype: TfaChangeStatusDetails
        """
        if not self.is_tfa_change_status_details():
            raise AttributeError("tag 'tfa_change_status_details' not set")
        return self._value

    def get_tfa_remove_backup_phone_details(self):
        """
        Removed the backup phone for two-step verification.

        Only call this if :meth:`is_tfa_remove_backup_phone_details` is true.

        :rtype: TfaRemoveBackupPhoneDetails
        """
        if not self.is_tfa_remove_backup_phone_details():
            raise AttributeError("tag 'tfa_remove_backup_phone_details' not set")
        return self._value

    def get_tfa_remove_security_key_details(self):
        """
        Removed a security key for two-step verification.

        Only call this if :meth:`is_tfa_remove_security_key_details` is true.

        :rtype: TfaRemoveSecurityKeyDetails
        """
        if not self.is_tfa_remove_security_key_details():
            raise AttributeError("tag 'tfa_remove_security_key_details' not set")
        return self._value

    def get_tfa_reset_details(self):
        """
        Reset two-step verification for team member.

        Only call this if :meth:`is_tfa_reset_details` is true.

        :rtype: TfaResetDetails
        """
        if not self.is_tfa_reset_details():
            raise AttributeError("tag 'tfa_reset_details' not set")
        return self._value

    def get_missing_details(self):
        """
        Hints that this event was returned with missing details due to an
        internal error.

        Only call this if :meth:`is_missing_details` is true.

        :rtype: MissingDetails
        """
        if not self.is_missing_details():
            raise AttributeError("tag 'missing_details' not set")
        return self._value

    def __repr__(self):
        return 'EventDetails(%r, %r)' % (self._tag, self._value)

EventDetails_validator = bv.Union(EventDetails)

class EventType(bb.Union):
    """
    The type of the event.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar member_change_membership_type: Changed the membership type (limited vs
        full) for team member.
    :ivar member_permanently_delete_account_contents: Permanently deleted
        contents of a removed team member account.
    :ivar member_space_limits_change_status: Changed the status with respect to
        whether the team member is under or over storage quota specified by
        policy.
    :ivar member_transfer_account_contents: Transferred contents of a removed
        team member account to another member.
    :ivar paper_enabled_users_group_addition: Users added to Paper enabled users
        list.
    :ivar paper_enabled_users_group_removal: Users removed from Paper enabled
        users list.
    :ivar paper_external_view_allow: Paper external sharing policy changed:
        anyone. This event is deprecated and will not be logged going forward as
        the associated product functionality no longer exists.
    :ivar paper_external_view_default_team: Paper external sharing policy
        changed: default team. This event is deprecated and will not be logged
        going forward as the associated product functionality no longer exists.
    :ivar paper_external_view_forbid: Paper external sharing policy changed:
        team-only. This event is deprecated and will not be logged going forward
        as the associated product functionality no longer exists.
    :ivar sf_external_invite_warn: Admin settings: team members see a warning
        before sharing folders outside the team (DEPRECATED FEATURE). This event
        is deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar team_merge: Merged the team into another team.
    :ivar app_link_team: Linked an app for team.
    :ivar app_link_user: Linked an app for team member.
    :ivar app_unlink_team: Unlinked an app for team.
    :ivar app_unlink_user: Unlinked an app for team member.
    :ivar device_change_ip_desktop: IP address associated with active desktop
        session changed.
    :ivar device_change_ip_mobile: IP address associated with active mobile
        session changed.
    :ivar device_change_ip_web: IP address associated with active Web session
        changed.
    :ivar device_delete_on_unlink_fail: Failed to delete all files from an
        unlinked device.
    :ivar device_delete_on_unlink_success: Deleted all files from an unlinked
        device.
    :ivar device_link_fail: Failed to link a device.
    :ivar device_link_success: Linked a device.
    :ivar device_management_disabled: Disable Device Management. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar device_management_enabled: Enable Device Management. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar device_unlink: Disconnected a device.
    :ivar emm_refresh_auth_token: Refreshed the auth token used for setting up
        enterprise mobility management.
    :ivar account_capture_change_availability: Granted or revoked the option to
        enable account capture on domains belonging to the team.
    :ivar account_capture_migrate_account: Account captured user migrated their
        account to the team.
    :ivar account_capture_relinquish_account: Account captured user relinquished
        their account by changing the email address associated with it.
    :ivar disabled_domain_invites: Disabled domain invites. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar domain_invites_approve_request_to_join_team: Approved a member's
        request to join the team.
    :ivar domain_invites_decline_request_to_join_team: Declined a user's request
        to join the team.
    :ivar domain_invites_email_existing_users: Sent domain invites to existing
        domain accounts.
    :ivar domain_invites_request_to_join_team: Asked to join the team.
    :ivar domain_invites_set_invite_new_user_pref_to_no: Turned off
        u201cAutomatically invite new usersu201d. This event is deprecated and
        will not be logged going forward as the associated product functionality
        no longer exists.
    :ivar domain_invites_set_invite_new_user_pref_to_yes: Turned on
        u201cAutomatically invite new usersu201d. This event is deprecated and
        will not be logged going forward as the associated product functionality
        no longer exists.
    :ivar domain_verification_add_domain_fail: Failed to verify a domain
        belonging to the team.
    :ivar domain_verification_add_domain_success: Verified a domain belonging to
        the team.
    :ivar domain_verification_remove_domain: Removed a domain from the list of
        verified domains belonging to the team.
    :ivar enabled_domain_invites: Enabled domain invites. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar create_folder: Created folders. This event is deprecated and will not
        be logged going forward as the associated product functionality no
        longer exists.
    :ivar file_add: Added files and/or folders.
    :ivar file_copy: Copied files and/or folders.
    :ivar file_delete: Deleted files and/or folders.
    :ivar file_download: Downloaded files and/or folders.
    :ivar file_edit: Edited files.
    :ivar file_get_copy_reference: Create a copy reference to a file or folder.
    :ivar file_move: Moved files and/or folders.
    :ivar file_permanently_delete: Permanently deleted files and/or folders.
    :ivar file_preview: Previewed files and/or folders.
    :ivar file_rename: Renamed files and/or folders.
    :ivar file_restore: Restored deleted files and/or folders.
    :ivar file_revert: Reverted files to a previous version.
    :ivar file_rollback_changes: Rolled back file change location changes.
    :ivar file_save_copy_reference: Save a file or folder using a copy
        reference.
    :ivar file_request_add_deadline: Added a deadline to a file request.
    :ivar file_request_change_folder: Changed the file request folder.
    :ivar file_request_change_title: Change the file request title.
    :ivar file_request_close: Closed a file request.
    :ivar file_request_create: Created a file request.
    :ivar file_request_receive_file: Received files for a file request.
    :ivar file_request_remove_deadline: Removed the file request deadline.
    :ivar file_request_send: Sent file request to users via email.
    :ivar group_add_external_id: Added an external ID for group.
    :ivar group_add_member: Added team members to a group.
    :ivar group_change_external_id: Changed the external ID for group.
    :ivar group_change_management_type: Changed group management type.
    :ivar group_change_member_role: Changed the manager permissions belonging to
        a group member.
    :ivar group_create: Created a group.
    :ivar group_delete: Deleted a group.
    :ivar group_description_updated: Updated a group.
    :ivar group_join_policy_updated: Updated a group join policy.
    :ivar group_moved: Moved a group. This event is deprecated and will not be
        logged going forward as the associated product functionality no longer
        exists.
    :ivar group_remove_external_id: Removed the external ID for group.
    :ivar group_remove_member: Removed team members from a group.
    :ivar group_rename: Renamed a group.
    :ivar emm_login_success: Signed in using the Dropbox EMM app.
    :ivar logout: Signed out.
    :ivar password_login_fail: Failed to sign in using a password.
    :ivar password_login_success: Signed in using a password.
    :ivar reseller_support_session_end: Ended reseller support session.
    :ivar reseller_support_session_start: Started reseller support session.
    :ivar sign_in_as_session_end: Ended admin sign-in-as session.
    :ivar sign_in_as_session_start: Started admin sign-in-as session.
    :ivar sso_login_fail: Failed to sign in using SSO.
    :ivar member_add_name: Set team member name when joining team.
    :ivar member_change_email: Changed team member email address.
    :ivar member_change_name: Changed team member name.
    :ivar member_change_role: Change the admin permissions belonging to team
        member.
    :ivar member_invite: Invited a user to join the team.
    :ivar member_join: Joined the team.
    :ivar member_leave: Removed a team member.
    :ivar member_recover: Recovered a removed member.
    :ivar member_suggest: Suggested a new team member to be added to the team.
    :ivar member_suspend: Suspended a team member.
    :ivar member_unsuspend: Unsuspended a team member.
    :ivar paper_content_add_member: Added users to the membership of a Paper doc
        or folder.
    :ivar paper_content_add_to_folder: Added Paper doc or folder to a folder.
    :ivar paper_content_archive: Archived Paper doc or folder.
    :ivar paper_content_change_subscription: Followed or unfollowed a Paper doc
        or folder.
    :ivar paper_content_create: Created a Paper doc or folder.
    :ivar paper_content_permanently_delete: Permanently deleted a Paper doc or
        folder.
    :ivar paper_content_remove_from_folder: Removed Paper doc or folder from a
        folder.
    :ivar paper_content_remove_member: Removed a user from the membership of a
        Paper doc or folder.
    :ivar paper_content_rename: Renamed Paper doc or folder.
    :ivar paper_content_restore: Restored an archived Paper doc or folder.
    :ivar paper_doc_add_comment: Added a Paper doc comment.
    :ivar paper_doc_change_member_role: Changed the access type of a Paper doc
        member.
    :ivar paper_doc_change_sharing_policy: Changed the sharing policy for Paper
        doc.
    :ivar paper_doc_deleted: Paper doc archived. This event is deprecated and
        will not be logged going forward as the associated product functionality
        no longer exists.
    :ivar paper_doc_delete_comment: Deleted a Paper doc comment.
    :ivar paper_doc_download: Downloaded a Paper doc in a particular output
        format.
    :ivar paper_doc_edit: Edited a Paper doc.
    :ivar paper_doc_edit_comment: Edited a Paper doc comment.
    :ivar paper_doc_followed: Followed a Paper doc. This event is replaced by
        paper_content_change_subscription and will not be logged going forward.
    :ivar paper_doc_mention: Mentioned a member in a Paper doc.
    :ivar paper_doc_request_access: Requested to be a member on a Paper doc.
    :ivar paper_doc_resolve_comment: Paper doc comment resolved.
    :ivar paper_doc_revert: Restored a Paper doc to previous revision.
    :ivar paper_doc_slack_share: Paper doc link shared via slack.
    :ivar paper_doc_team_invite: Paper doc shared with team member. This event
        is deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar paper_doc_unresolve_comment: Unresolved a Paper doc comment.
    :ivar paper_doc_view: Viewed Paper doc.
    :ivar paper_folder_deleted: Paper folder archived. This event is deprecated
        and will not be logged going forward as the associated product
        functionality no longer exists.
    :ivar paper_folder_followed: Followed a Paper folder. This event is replaced
        by paper_content_change_subscription and will not be logged going
        forward.
    :ivar paper_folder_team_invite: Paper folder shared with team member. This
        event is deprecated and will not be logged going forward as the
        associated product functionality no longer exists.
    :ivar password_change: Changed password.
    :ivar password_reset: Reset password.
    :ivar password_reset_all: Reset all team member passwords.
    :ivar emm_create_exceptions_report: EMM excluded users report created.
    :ivar emm_create_usage_report: EMM mobile app usage report created.
    :ivar smart_sync_create_admin_privilege_report: Smart Sync non-admin devices
        report created.
    :ivar team_activity_create_report: Created a team activity report.
    :ivar collection_share: Shared an album.
    :ivar file_add_comment: Added a file comment.
    :ivar file_like_comment: Liked a file comment. This event is deprecated and
        will not be logged going forward as the associated product functionality
        no longer exists.
    :ivar file_unlike_comment: Unliked a file comment. This event is deprecated
        and will not be logged going forward as the associated product
        functionality no longer exists.
    :ivar note_acl_invite_only: Changed a Paper document to be invite-only. This
        event is deprecated and will not be logged going forward as the
        associated product functionality no longer exists.
    :ivar note_acl_link: Changed a Paper document to be link accessible. This
        event is deprecated and will not be logged going forward as the
        associated product functionality no longer exists.
    :ivar note_acl_team_link: Changed a Paper document to be link accessible for
        the team. This event is deprecated and will not be logged going forward
        as the associated product functionality no longer exists.
    :ivar note_shared: Shared a Paper doc. This event is deprecated and will not
        be logged going forward as the associated product functionality no
        longer exists.
    :ivar note_share_receive: Shared Paper document received. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar open_note_shared: Opened a shared Paper doc. This event is deprecated
        and will not be logged going forward as the associated product
        functionality no longer exists.
    :ivar sf_add_group: Added the team to a shared folder.
    :ivar sf_allow_non_members_to_view_shared_links: Allowed non collaborators
        to view links to files in a shared folder. This event is deprecated and
        will not be logged going forward as the associated product functionality
        no longer exists.
    :ivar sf_invite_group: Invited a group to a shared folder. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar sf_nest: Changed parent of shared folder.
    :ivar sf_team_decline: Declined a team member's invitation to a shared
        folder.
    :ivar sf_team_grant_access: Granted access to a shared folder. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar sf_team_invite: Invited team members to a shared folder. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar sf_team_invite_change_role: Changed a team member's role in a shared
        folder. This event is deprecated and will not be logged going forward as
        the associated product functionality no longer exists.
    :ivar sf_team_join: Joined a team member's shared folder. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar sf_team_join_from_oob_link: Joined a team member's shared folder from
        a link. This event is deprecated and will not be logged going forward as
        the associated product functionality no longer exists.
    :ivar sf_team_uninvite: Unshared a folder with a team member. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar shared_content_add_invitees: Sent an email invitation to the
        membership of a shared file or folder.
    :ivar shared_content_add_link_expiry: Added an expiry to the link for the
        shared file or folder.
    :ivar shared_content_add_link_password: Added a password to the link for the
        shared file or folder.
    :ivar shared_content_add_member: Added users and/or groups to the membership
        of a shared file or folder.
    :ivar shared_content_change_downloads_policy: Changed whether members can
        download the shared file or folder.
    :ivar shared_content_change_invitee_role: Changed the access type of an
        invitee to a shared file or folder before the invitation was claimed.
    :ivar shared_content_change_link_audience: Changed the audience of the link
        for a shared file or folder.
    :ivar shared_content_change_link_expiry: Changed the expiry of the link for
        the shared file or folder.
    :ivar shared_content_change_link_password: Changed the password on the link
        for the shared file or folder.
    :ivar shared_content_change_member_role: Changed the access type of a shared
        file or folder member.
    :ivar shared_content_change_viewer_info_policy: Changed whether members can
        see who viewed the shared file or folder.
    :ivar shared_content_claim_invitation: Claimed membership to a team member's
        shared folder.
    :ivar shared_content_copy: Copied the shared file or folder to own Dropbox.
    :ivar shared_content_download: Downloaded the shared file or folder.
    :ivar shared_content_relinquish_membership: Left the membership of a shared
        file or folder.
    :ivar shared_content_remove_invitee: Removed an invitee from the membership
        of a shared file or folder before it was claimed.
    :ivar shared_content_remove_link_expiry: Removed the expiry of the link for
        the shared file or folder.
    :ivar shared_content_remove_link_password: Removed the password on the link
        for the shared file or folder.
    :ivar shared_content_remove_member: Removed a user or a group from the
        membership of a shared file or folder.
    :ivar shared_content_request_access: Requested to be on the membership of a
        shared file or folder.
    :ivar shared_content_unshare: Unshared a shared file or folder by clearing
        its membership and turning off its link.
    :ivar shared_content_view: Previewed the shared file or folder.
    :ivar shared_folder_change_confidentiality: Set or unset the confidential
        flag on a shared folder.
    :ivar shared_folder_change_link_policy: Changed who can access the shared
        folder via a link.
    :ivar shared_folder_change_member_management_policy: Changed who can manage
        the membership of a shared folder.
    :ivar shared_folder_change_member_policy: Changed who can become a member of
        the shared folder.
    :ivar shared_folder_create: Created a shared folder.
    :ivar shared_folder_mount: Added a shared folder to own Dropbox.
    :ivar shared_folder_transfer_ownership: Transferred the ownership of a
        shared folder to another member.
    :ivar shared_folder_unmount: Deleted a shared folder from Dropbox.
    :ivar shared_note_opened: Shared Paper document was opened. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar shmodel_app_create: Created a link to a file using an app.
    :ivar shmodel_create: Created a new link.
    :ivar shmodel_disable: Removed a link.
    :ivar shmodel_fb_share: Shared a link with Facebook users.
    :ivar shmodel_group_share: Shared a link with a group. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar shmodel_remove_expiration: Removed the expiration date from a link.
    :ivar shmodel_set_expiration: Added an expiration date to a link.
    :ivar shmodel_team_copy: Added a team member's file/folder to their Dropbox
        from a link.
    :ivar shmodel_team_download: Downloaded a team member's file/folder from a
        link.
    :ivar shmodel_team_share: Shared a link with team members.
    :ivar shmodel_team_view: Opened a team member's link.
    :ivar shmodel_visibility_password: Password-protected a link.
    :ivar shmodel_visibility_public: Made a file/folder visible to anyone with
        the link.
    :ivar shmodel_visibility_team_only: Made a file/folder visible only to team
        members with the link.
    :ivar remove_logout_url: Removed single sign-on logout URL. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar remove_sso_url: Changed the sign-out URL for SSO. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar sso_change_cert: Changed the X.509 certificate for SSO.
    :ivar sso_change_login_url: Changed the sign-in URL for SSO.
    :ivar sso_change_logout_url: Changed the sign-out URL for SSO.
    :ivar sso_change_saml_identity_mode: Changed the SAML identity mode for SSO.
    :ivar team_folder_change_status: Changed the archival status of a team
        folder.
    :ivar team_folder_create: Created a new team folder in active status.
    :ivar team_folder_downgrade: Downgraded a team folder to a regular shared
        folder.
    :ivar team_folder_permanently_delete: Permanently deleted an archived team
        folder.
    :ivar team_folder_rename: Renamed an active or archived team folder.
    :ivar account_capture_change_policy: Changed the account capture policy on a
        domain belonging to the team.
    :ivar allow_download_disabled: Disabled allow downloads. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar allow_download_enabled: Enabled allow downloads. This event is
        deprecated and will not be logged going forward as the associated
        product functionality no longer exists.
    :ivar data_placement_restriction_change_policy: Set a restriction policy
        regarding the location of data centers where team data resides.
    :ivar data_placement_restriction_satisfy_policy: Satisfied a previously set
        restriction policy regarding the location of data centers where team
        data resides (i.e. all data have been migrated according to the
        restriction placed).
    :ivar device_approvals_change_desktop_policy: Set or removed a limit on the
        number of computers each team member can link to their work Dropbox
        account.
    :ivar device_approvals_change_mobile_policy: Set or removed a limit on the
        number of mobiles devices each team member can link to their work
        Dropbox account.
    :ivar device_approvals_change_overage_action: Changed the action taken when
        a team member is already over the limits (e.g when they join the team,
        an admin lowers limits, etc.).
    :ivar device_approvals_change_unlink_action: Changed the action taken with
        respect to approval limits when a team member unlinks an approved
        device.
    :ivar emm_add_exception: Added an exception for one or more team members to
        optionally use the regular Dropbox app when EMM is enabled.
    :ivar emm_change_policy: Enabled or disabled enterprise mobility management
        for team members.
    :ivar emm_remove_exception: Removed an exception for one or more team
        members to optionally use the regular Dropbox app when EMM is enabled.
    :ivar extended_version_history_change_policy: Accepted or opted out of
        extended version history.
    :ivar file_comments_change_policy: Enabled or disabled commenting on team
        files.
    :ivar file_requests_change_policy: Enabled or disabled file requests.
    :ivar file_requests_emails_enabled: Enabled file request emails for
        everyone. This event is deprecated and will not be logged going forward
        as the associated product functionality no longer exists.
    :ivar file_requests_emails_restricted_to_team_only: Allowed file request
        emails for the team. This event is deprecated and will not be logged
        going forward as the associated product functionality no longer exists.
    :ivar google_sso_change_policy: Enabled or disabled Google single sign-on
        for the team.
    :ivar group_user_management_change_policy: Changed who can create groups.
    :ivar member_requests_change_policy: Changed whether users can find the team
        when not invited.
    :ivar member_space_limits_add_exception: Added an exception for one or more
        team members to bypass space limits imposed by policy.
    :ivar member_space_limits_change_policy: Changed the storage limits applied
        to team members by policy.
    :ivar member_space_limits_remove_exception: Removed an exception for one or
        more team members to bypass space limits imposed by policy.
    :ivar member_suggestions_change_policy: Enabled or disabled the option for
        team members to suggest new members to add to the team.
    :ivar microsoft_office_addin_change_policy: Enabled or disabled the
        Microsoft Office add-in, which lets team members save files to Dropbox
        directly from Microsoft Office.
    :ivar network_control_change_policy: Enabled or disabled network control.
    :ivar paper_change_deployment_policy: Changed whether Dropbox Paper, when
        enabled, is deployed to all teams or to specific members of the team.
    :ivar paper_change_member_policy: Changed whether team members can share
        Paper documents externally (i.e. outside the team), and if so, whether
        they should be accessible only by team members or anyone by default.
    :ivar paper_change_policy: Enabled or disabled Dropbox Paper for the team.
    :ivar permanent_delete_change_policy: Enabled or disabled the ability of
        team members to permanently delete content.
    :ivar sharing_change_folder_join_policy: Changed whether team members can
        join shared folders owned externally (i.e. outside the team).
    :ivar sharing_change_link_policy: Changed whether team members can share
        links externally (i.e. outside the team), and if so, whether links
        should be accessible only by team members or anyone by default.
    :ivar sharing_change_member_policy: Changed whether team members can share
        files and folders externally (i.e. outside the team).
    :ivar smart_sync_change_policy: Changed the default Smart Sync policy for
        team members.
    :ivar sso_change_policy: Change the single sign-on policy for the team.
    :ivar tfa_change_policy: Change two-step verification policy for the team.
    :ivar two_account_change_policy: Enabled or disabled the option for team
        members to link a personal Dropbox account in addition to their work
        account to the same computer.
    :ivar web_sessions_change_fixed_length_policy: Changed how long team members
        can stay signed in to Dropbox on the web.
    :ivar web_sessions_change_idle_length_policy: Changed how long team members
        can be idle while signed in to Dropbox on the web.
    :ivar team_profile_add_logo: Added a team logo to be displayed on shared
        link headers.
    :ivar team_profile_change_logo: Changed the team logo to be displayed on
        shared link headers.
    :ivar team_profile_change_name: Changed the team name.
    :ivar team_profile_remove_logo: Removed the team logo to be displayed on
        shared link headers.
    :ivar tfa_add_backup_phone: Added a backup phone for two-step verification.
    :ivar tfa_add_security_key: Added a security key for two-step verification.
    :ivar tfa_change_backup_phone: Changed the backup phone for two-step
        verification.
    :ivar tfa_change_status: Enabled, disabled or changed the configuration for
        two-step verification.
    :ivar tfa_remove_backup_phone: Removed the backup phone for two-step
        verification.
    :ivar tfa_remove_security_key: Removed a security key for two-step
        verification.
    :ivar tfa_reset: Reset two-step verification for team member.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    member_change_membership_type = None
    # Attribute is overwritten below the class definition
    member_permanently_delete_account_contents = None
    # Attribute is overwritten below the class definition
    member_space_limits_change_status = None
    # Attribute is overwritten below the class definition
    member_transfer_account_contents = None
    # Attribute is overwritten below the class definition
    paper_enabled_users_group_addition = None
    # Attribute is overwritten below the class definition
    paper_enabled_users_group_removal = None
    # Attribute is overwritten below the class definition
    paper_external_view_allow = None
    # Attribute is overwritten below the class definition
    paper_external_view_default_team = None
    # Attribute is overwritten below the class definition
    paper_external_view_forbid = None
    # Attribute is overwritten below the class definition
    sf_external_invite_warn = None
    # Attribute is overwritten below the class definition
    team_merge = None
    # Attribute is overwritten below the class definition
    app_link_team = None
    # Attribute is overwritten below the class definition
    app_link_user = None
    # Attribute is overwritten below the class definition
    app_unlink_team = None
    # Attribute is overwritten below the class definition
    app_unlink_user = None
    # Attribute is overwritten below the class definition
    device_change_ip_desktop = None
    # Attribute is overwritten below the class definition
    device_change_ip_mobile = None
    # Attribute is overwritten below the class definition
    device_change_ip_web = None
    # Attribute is overwritten below the class definition
    device_delete_on_unlink_fail = None
    # Attribute is overwritten below the class definition
    device_delete_on_unlink_success = None
    # Attribute is overwritten below the class definition
    device_link_fail = None
    # Attribute is overwritten below the class definition
    device_link_success = None
    # Attribute is overwritten below the class definition
    device_management_disabled = None
    # Attribute is overwritten below the class definition
    device_management_enabled = None
    # Attribute is overwritten below the class definition
    device_unlink = None
    # Attribute is overwritten below the class definition
    emm_refresh_auth_token = None
    # Attribute is overwritten below the class definition
    account_capture_change_availability = None
    # Attribute is overwritten below the class definition
    account_capture_migrate_account = None
    # Attribute is overwritten below the class definition
    account_capture_relinquish_account = None
    # Attribute is overwritten below the class definition
    disabled_domain_invites = None
    # Attribute is overwritten below the class definition
    domain_invites_approve_request_to_join_team = None
    # Attribute is overwritten below the class definition
    domain_invites_decline_request_to_join_team = None
    # Attribute is overwritten below the class definition
    domain_invites_email_existing_users = None
    # Attribute is overwritten below the class definition
    domain_invites_request_to_join_team = None
    # Attribute is overwritten below the class definition
    domain_invites_set_invite_new_user_pref_to_no = None
    # Attribute is overwritten below the class definition
    domain_invites_set_invite_new_user_pref_to_yes = None
    # Attribute is overwritten below the class definition
    domain_verification_add_domain_fail = None
    # Attribute is overwritten below the class definition
    domain_verification_add_domain_success = None
    # Attribute is overwritten below the class definition
    domain_verification_remove_domain = None
    # Attribute is overwritten below the class definition
    enabled_domain_invites = None
    # Attribute is overwritten below the class definition
    create_folder = None
    # Attribute is overwritten below the class definition
    file_add = None
    # Attribute is overwritten below the class definition
    file_copy = None
    # Attribute is overwritten below the class definition
    file_delete = None
    # Attribute is overwritten below the class definition
    file_download = None
    # Attribute is overwritten below the class definition
    file_edit = None
    # Attribute is overwritten below the class definition
    file_get_copy_reference = None
    # Attribute is overwritten below the class definition
    file_move = None
    # Attribute is overwritten below the class definition
    file_permanently_delete = None
    # Attribute is overwritten below the class definition
    file_preview = None
    # Attribute is overwritten below the class definition
    file_rename = None
    # Attribute is overwritten below the class definition
    file_restore = None
    # Attribute is overwritten below the class definition
    file_revert = None
    # Attribute is overwritten below the class definition
    file_rollback_changes = None
    # Attribute is overwritten below the class definition
    file_save_copy_reference = None
    # Attribute is overwritten below the class definition
    file_request_add_deadline = None
    # Attribute is overwritten below the class definition
    file_request_change_folder = None
    # Attribute is overwritten below the class definition
    file_request_change_title = None
    # Attribute is overwritten below the class definition
    file_request_close = None
    # Attribute is overwritten below the class definition
    file_request_create = None
    # Attribute is overwritten below the class definition
    file_request_receive_file = None
    # Attribute is overwritten below the class definition
    file_request_remove_deadline = None
    # Attribute is overwritten below the class definition
    file_request_send = None
    # Attribute is overwritten below the class definition
    group_add_external_id = None
    # Attribute is overwritten below the class definition
    group_add_member = None
    # Attribute is overwritten below the class definition
    group_change_external_id = None
    # Attribute is overwritten below the class definition
    group_change_management_type = None
    # Attribute is overwritten below the class definition
    group_change_member_role = None
    # Attribute is overwritten below the class definition
    group_create = None
    # Attribute is overwritten below the class definition
    group_delete = None
    # Attribute is overwritten below the class definition
    group_description_updated = None
    # Attribute is overwritten below the class definition
    group_join_policy_updated = None
    # Attribute is overwritten below the class definition
    group_moved = None
    # Attribute is overwritten below the class definition
    group_remove_external_id = None
    # Attribute is overwritten below the class definition
    group_remove_member = None
    # Attribute is overwritten below the class definition
    group_rename = None
    # Attribute is overwritten below the class definition
    emm_login_success = None
    # Attribute is overwritten below the class definition
    logout = None
    # Attribute is overwritten below the class definition
    password_login_fail = None
    # Attribute is overwritten below the class definition
    password_login_success = None
    # Attribute is overwritten below the class definition
    reseller_support_session_end = None
    # Attribute is overwritten below the class definition
    reseller_support_session_start = None
    # Attribute is overwritten below the class definition
    sign_in_as_session_end = None
    # Attribute is overwritten below the class definition
    sign_in_as_session_start = None
    # Attribute is overwritten below the class definition
    sso_login_fail = None
    # Attribute is overwritten below the class definition
    member_add_name = None
    # Attribute is overwritten below the class definition
    member_change_email = None
    # Attribute is overwritten below the class definition
    member_change_name = None
    # Attribute is overwritten below the class definition
    member_change_role = None
    # Attribute is overwritten below the class definition
    member_invite = None
    # Attribute is overwritten below the class definition
    member_join = None
    # Attribute is overwritten below the class definition
    member_leave = None
    # Attribute is overwritten below the class definition
    member_recover = None
    # Attribute is overwritten below the class definition
    member_suggest = None
    # Attribute is overwritten below the class definition
    member_suspend = None
    # Attribute is overwritten below the class definition
    member_unsuspend = None
    # Attribute is overwritten below the class definition
    paper_content_add_member = None
    # Attribute is overwritten below the class definition
    paper_content_add_to_folder = None
    # Attribute is overwritten below the class definition
    paper_content_archive = None
    # Attribute is overwritten below the class definition
    paper_content_change_subscription = None
    # Attribute is overwritten below the class definition
    paper_content_create = None
    # Attribute is overwritten below the class definition
    paper_content_permanently_delete = None
    # Attribute is overwritten below the class definition
    paper_content_remove_from_folder = None
    # Attribute is overwritten below the class definition
    paper_content_remove_member = None
    # Attribute is overwritten below the class definition
    paper_content_rename = None
    # Attribute is overwritten below the class definition
    paper_content_restore = None
    # Attribute is overwritten below the class definition
    paper_doc_add_comment = None
    # Attribute is overwritten below the class definition
    paper_doc_change_member_role = None
    # Attribute is overwritten below the class definition
    paper_doc_change_sharing_policy = None
    # Attribute is overwritten below the class definition
    paper_doc_deleted = None
    # Attribute is overwritten below the class definition
    paper_doc_delete_comment = None
    # Attribute is overwritten below the class definition
    paper_doc_download = None
    # Attribute is overwritten below the class definition
    paper_doc_edit = None
    # Attribute is overwritten below the class definition
    paper_doc_edit_comment = None
    # Attribute is overwritten below the class definition
    paper_doc_followed = None
    # Attribute is overwritten below the class definition
    paper_doc_mention = None
    # Attribute is overwritten below the class definition
    paper_doc_request_access = None
    # Attribute is overwritten below the class definition
    paper_doc_resolve_comment = None
    # Attribute is overwritten below the class definition
    paper_doc_revert = None
    # Attribute is overwritten below the class definition
    paper_doc_slack_share = None
    # Attribute is overwritten below the class definition
    paper_doc_team_invite = None
    # Attribute is overwritten below the class definition
    paper_doc_unresolve_comment = None
    # Attribute is overwritten below the class definition
    paper_doc_view = None
    # Attribute is overwritten below the class definition
    paper_folder_deleted = None
    # Attribute is overwritten below the class definition
    paper_folder_followed = None
    # Attribute is overwritten below the class definition
    paper_folder_team_invite = None
    # Attribute is overwritten below the class definition
    password_change = None
    # Attribute is overwritten below the class definition
    password_reset = None
    # Attribute is overwritten below the class definition
    password_reset_all = None
    # Attribute is overwritten below the class definition
    emm_create_exceptions_report = None
    # Attribute is overwritten below the class definition
    emm_create_usage_report = None
    # Attribute is overwritten below the class definition
    smart_sync_create_admin_privilege_report = None
    # Attribute is overwritten below the class definition
    team_activity_create_report = None
    # Attribute is overwritten below the class definition
    collection_share = None
    # Attribute is overwritten below the class definition
    file_add_comment = None
    # Attribute is overwritten below the class definition
    file_like_comment = None
    # Attribute is overwritten below the class definition
    file_unlike_comment = None
    # Attribute is overwritten below the class definition
    note_acl_invite_only = None
    # Attribute is overwritten below the class definition
    note_acl_link = None
    # Attribute is overwritten below the class definition
    note_acl_team_link = None
    # Attribute is overwritten below the class definition
    note_shared = None
    # Attribute is overwritten below the class definition
    note_share_receive = None
    # Attribute is overwritten below the class definition
    open_note_shared = None
    # Attribute is overwritten below the class definition
    sf_add_group = None
    # Attribute is overwritten below the class definition
    sf_allow_non_members_to_view_shared_links = None
    # Attribute is overwritten below the class definition
    sf_invite_group = None
    # Attribute is overwritten below the class definition
    sf_nest = None
    # Attribute is overwritten below the class definition
    sf_team_decline = None
    # Attribute is overwritten below the class definition
    sf_team_grant_access = None
    # Attribute is overwritten below the class definition
    sf_team_invite = None
    # Attribute is overwritten below the class definition
    sf_team_invite_change_role = None
    # Attribute is overwritten below the class definition
    sf_team_join = None
    # Attribute is overwritten below the class definition
    sf_team_join_from_oob_link = None
    # Attribute is overwritten below the class definition
    sf_team_uninvite = None
    # Attribute is overwritten below the class definition
    shared_content_add_invitees = None
    # Attribute is overwritten below the class definition
    shared_content_add_link_expiry = None
    # Attribute is overwritten below the class definition
    shared_content_add_link_password = None
    # Attribute is overwritten below the class definition
    shared_content_add_member = None
    # Attribute is overwritten below the class definition
    shared_content_change_downloads_policy = None
    # Attribute is overwritten below the class definition
    shared_content_change_invitee_role = None
    # Attribute is overwritten below the class definition
    shared_content_change_link_audience = None
    # Attribute is overwritten below the class definition
    shared_content_change_link_expiry = None
    # Attribute is overwritten below the class definition
    shared_content_change_link_password = None
    # Attribute is overwritten below the class definition
    shared_content_change_member_role = None
    # Attribute is overwritten below the class definition
    shared_content_change_viewer_info_policy = None
    # Attribute is overwritten below the class definition
    shared_content_claim_invitation = None
    # Attribute is overwritten below the class definition
    shared_content_copy = None
    # Attribute is overwritten below the class definition
    shared_content_download = None
    # Attribute is overwritten below the class definition
    shared_content_relinquish_membership = None
    # Attribute is overwritten below the class definition
    shared_content_remove_invitee = None
    # Attribute is overwritten below the class definition
    shared_content_remove_link_expiry = None
    # Attribute is overwritten below the class definition
    shared_content_remove_link_password = None
    # Attribute is overwritten below the class definition
    shared_content_remove_member = None
    # Attribute is overwritten below the class definition
    shared_content_request_access = None
    # Attribute is overwritten below the class definition
    shared_content_unshare = None
    # Attribute is overwritten below the class definition
    shared_content_view = None
    # Attribute is overwritten below the class definition
    shared_folder_change_confidentiality = None
    # Attribute is overwritten below the class definition
    shared_folder_change_link_policy = None
    # Attribute is overwritten below the class definition
    shared_folder_change_member_management_policy = None
    # Attribute is overwritten below the class definition
    shared_folder_change_member_policy = None
    # Attribute is overwritten below the class definition
    shared_folder_create = None
    # Attribute is overwritten below the class definition
    shared_folder_mount = None
    # Attribute is overwritten below the class definition
    shared_folder_transfer_ownership = None
    # Attribute is overwritten below the class definition
    shared_folder_unmount = None
    # Attribute is overwritten below the class definition
    shared_note_opened = None
    # Attribute is overwritten below the class definition
    shmodel_app_create = None
    # Attribute is overwritten below the class definition
    shmodel_create = None
    # Attribute is overwritten below the class definition
    shmodel_disable = None
    # Attribute is overwritten below the class definition
    shmodel_fb_share = None
    # Attribute is overwritten below the class definition
    shmodel_group_share = None
    # Attribute is overwritten below the class definition
    shmodel_remove_expiration = None
    # Attribute is overwritten below the class definition
    shmodel_set_expiration = None
    # Attribute is overwritten below the class definition
    shmodel_team_copy = None
    # Attribute is overwritten below the class definition
    shmodel_team_download = None
    # Attribute is overwritten below the class definition
    shmodel_team_share = None
    # Attribute is overwritten below the class definition
    shmodel_team_view = None
    # Attribute is overwritten below the class definition
    shmodel_visibility_password = None
    # Attribute is overwritten below the class definition
    shmodel_visibility_public = None
    # Attribute is overwritten below the class definition
    shmodel_visibility_team_only = None
    # Attribute is overwritten below the class definition
    remove_logout_url = None
    # Attribute is overwritten below the class definition
    remove_sso_url = None
    # Attribute is overwritten below the class definition
    sso_change_cert = None
    # Attribute is overwritten below the class definition
    sso_change_login_url = None
    # Attribute is overwritten below the class definition
    sso_change_logout_url = None
    # Attribute is overwritten below the class definition
    sso_change_saml_identity_mode = None
    # Attribute is overwritten below the class definition
    team_folder_change_status = None
    # Attribute is overwritten below the class definition
    team_folder_create = None
    # Attribute is overwritten below the class definition
    team_folder_downgrade = None
    # Attribute is overwritten below the class definition
    team_folder_permanently_delete = None
    # Attribute is overwritten below the class definition
    team_folder_rename = None
    # Attribute is overwritten below the class definition
    account_capture_change_policy = None
    # Attribute is overwritten below the class definition
    allow_download_disabled = None
    # Attribute is overwritten below the class definition
    allow_download_enabled = None
    # Attribute is overwritten below the class definition
    data_placement_restriction_change_policy = None
    # Attribute is overwritten below the class definition
    data_placement_restriction_satisfy_policy = None
    # Attribute is overwritten below the class definition
    device_approvals_change_desktop_policy = None
    # Attribute is overwritten below the class definition
    device_approvals_change_mobile_policy = None
    # Attribute is overwritten below the class definition
    device_approvals_change_overage_action = None
    # Attribute is overwritten below the class definition
    device_approvals_change_unlink_action = None
    # Attribute is overwritten below the class definition
    emm_add_exception = None
    # Attribute is overwritten below the class definition
    emm_change_policy = None
    # Attribute is overwritten below the class definition
    emm_remove_exception = None
    # Attribute is overwritten below the class definition
    extended_version_history_change_policy = None
    # Attribute is overwritten below the class definition
    file_comments_change_policy = None
    # Attribute is overwritten below the class definition
    file_requests_change_policy = None
    # Attribute is overwritten below the class definition
    file_requests_emails_enabled = None
    # Attribute is overwritten below the class definition
    file_requests_emails_restricted_to_team_only = None
    # Attribute is overwritten below the class definition
    google_sso_change_policy = None
    # Attribute is overwritten below the class definition
    group_user_management_change_policy = None
    # Attribute is overwritten below the class definition
    member_requests_change_policy = None
    # Attribute is overwritten below the class definition
    member_space_limits_add_exception = None
    # Attribute is overwritten below the class definition
    member_space_limits_change_policy = None
    # Attribute is overwritten below the class definition
    member_space_limits_remove_exception = None
    # Attribute is overwritten below the class definition
    member_suggestions_change_policy = None
    # Attribute is overwritten below the class definition
    microsoft_office_addin_change_policy = None
    # Attribute is overwritten below the class definition
    network_control_change_policy = None
    # Attribute is overwritten below the class definition
    paper_change_deployment_policy = None
    # Attribute is overwritten below the class definition
    paper_change_member_policy = None
    # Attribute is overwritten below the class definition
    paper_change_policy = None
    # Attribute is overwritten below the class definition
    permanent_delete_change_policy = None
    # Attribute is overwritten below the class definition
    sharing_change_folder_join_policy = None
    # Attribute is overwritten below the class definition
    sharing_change_link_policy = None
    # Attribute is overwritten below the class definition
    sharing_change_member_policy = None
    # Attribute is overwritten below the class definition
    smart_sync_change_policy = None
    # Attribute is overwritten below the class definition
    sso_change_policy = None
    # Attribute is overwritten below the class definition
    tfa_change_policy = None
    # Attribute is overwritten below the class definition
    two_account_change_policy = None
    # Attribute is overwritten below the class definition
    web_sessions_change_fixed_length_policy = None
    # Attribute is overwritten below the class definition
    web_sessions_change_idle_length_policy = None
    # Attribute is overwritten below the class definition
    team_profile_add_logo = None
    # Attribute is overwritten below the class definition
    team_profile_change_logo = None
    # Attribute is overwritten below the class definition
    team_profile_change_name = None
    # Attribute is overwritten below the class definition
    team_profile_remove_logo = None
    # Attribute is overwritten below the class definition
    tfa_add_backup_phone = None
    # Attribute is overwritten below the class definition
    tfa_add_security_key = None
    # Attribute is overwritten below the class definition
    tfa_change_backup_phone = None
    # Attribute is overwritten below the class definition
    tfa_change_status = None
    # Attribute is overwritten below the class definition
    tfa_remove_backup_phone = None
    # Attribute is overwritten below the class definition
    tfa_remove_security_key = None
    # Attribute is overwritten below the class definition
    tfa_reset = None
    # Attribute is overwritten below the class definition
    other = None

    def is_member_change_membership_type(self):
        """
        Check if the union tag is ``member_change_membership_type``.

        :rtype: bool
        """
        return self._tag == 'member_change_membership_type'

    def is_member_permanently_delete_account_contents(self):
        """
        Check if the union tag is ``member_permanently_delete_account_contents``.

        :rtype: bool
        """
        return self._tag == 'member_permanently_delete_account_contents'

    def is_member_space_limits_change_status(self):
        """
        Check if the union tag is ``member_space_limits_change_status``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_status'

    def is_member_transfer_account_contents(self):
        """
        Check if the union tag is ``member_transfer_account_contents``.

        :rtype: bool
        """
        return self._tag == 'member_transfer_account_contents'

    def is_paper_enabled_users_group_addition(self):
        """
        Check if the union tag is ``paper_enabled_users_group_addition``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_addition'

    def is_paper_enabled_users_group_removal(self):
        """
        Check if the union tag is ``paper_enabled_users_group_removal``.

        :rtype: bool
        """
        return self._tag == 'paper_enabled_users_group_removal'

    def is_paper_external_view_allow(self):
        """
        Check if the union tag is ``paper_external_view_allow``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_allow'

    def is_paper_external_view_default_team(self):
        """
        Check if the union tag is ``paper_external_view_default_team``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_default_team'

    def is_paper_external_view_forbid(self):
        """
        Check if the union tag is ``paper_external_view_forbid``.

        :rtype: bool
        """
        return self._tag == 'paper_external_view_forbid'

    def is_sf_external_invite_warn(self):
        """
        Check if the union tag is ``sf_external_invite_warn``.

        :rtype: bool
        """
        return self._tag == 'sf_external_invite_warn'

    def is_team_merge(self):
        """
        Check if the union tag is ``team_merge``.

        :rtype: bool
        """
        return self._tag == 'team_merge'

    def is_app_link_team(self):
        """
        Check if the union tag is ``app_link_team``.

        :rtype: bool
        """
        return self._tag == 'app_link_team'

    def is_app_link_user(self):
        """
        Check if the union tag is ``app_link_user``.

        :rtype: bool
        """
        return self._tag == 'app_link_user'

    def is_app_unlink_team(self):
        """
        Check if the union tag is ``app_unlink_team``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_team'

    def is_app_unlink_user(self):
        """
        Check if the union tag is ``app_unlink_user``.

        :rtype: bool
        """
        return self._tag == 'app_unlink_user'

    def is_device_change_ip_desktop(self):
        """
        Check if the union tag is ``device_change_ip_desktop``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_desktop'

    def is_device_change_ip_mobile(self):
        """
        Check if the union tag is ``device_change_ip_mobile``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_mobile'

    def is_device_change_ip_web(self):
        """
        Check if the union tag is ``device_change_ip_web``.

        :rtype: bool
        """
        return self._tag == 'device_change_ip_web'

    def is_device_delete_on_unlink_fail(self):
        """
        Check if the union tag is ``device_delete_on_unlink_fail``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_fail'

    def is_device_delete_on_unlink_success(self):
        """
        Check if the union tag is ``device_delete_on_unlink_success``.

        :rtype: bool
        """
        return self._tag == 'device_delete_on_unlink_success'

    def is_device_link_fail(self):
        """
        Check if the union tag is ``device_link_fail``.

        :rtype: bool
        """
        return self._tag == 'device_link_fail'

    def is_device_link_success(self):
        """
        Check if the union tag is ``device_link_success``.

        :rtype: bool
        """
        return self._tag == 'device_link_success'

    def is_device_management_disabled(self):
        """
        Check if the union tag is ``device_management_disabled``.

        :rtype: bool
        """
        return self._tag == 'device_management_disabled'

    def is_device_management_enabled(self):
        """
        Check if the union tag is ``device_management_enabled``.

        :rtype: bool
        """
        return self._tag == 'device_management_enabled'

    def is_device_unlink(self):
        """
        Check if the union tag is ``device_unlink``.

        :rtype: bool
        """
        return self._tag == 'device_unlink'

    def is_emm_refresh_auth_token(self):
        """
        Check if the union tag is ``emm_refresh_auth_token``.

        :rtype: bool
        """
        return self._tag == 'emm_refresh_auth_token'

    def is_account_capture_change_availability(self):
        """
        Check if the union tag is ``account_capture_change_availability``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_availability'

    def is_account_capture_migrate_account(self):
        """
        Check if the union tag is ``account_capture_migrate_account``.

        :rtype: bool
        """
        return self._tag == 'account_capture_migrate_account'

    def is_account_capture_relinquish_account(self):
        """
        Check if the union tag is ``account_capture_relinquish_account``.

        :rtype: bool
        """
        return self._tag == 'account_capture_relinquish_account'

    def is_disabled_domain_invites(self):
        """
        Check if the union tag is ``disabled_domain_invites``.

        :rtype: bool
        """
        return self._tag == 'disabled_domain_invites'

    def is_domain_invites_approve_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_approve_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_approve_request_to_join_team'

    def is_domain_invites_decline_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_decline_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_decline_request_to_join_team'

    def is_domain_invites_email_existing_users(self):
        """
        Check if the union tag is ``domain_invites_email_existing_users``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_email_existing_users'

    def is_domain_invites_request_to_join_team(self):
        """
        Check if the union tag is ``domain_invites_request_to_join_team``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_request_to_join_team'

    def is_domain_invites_set_invite_new_user_pref_to_no(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_no``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_no'

    def is_domain_invites_set_invite_new_user_pref_to_yes(self):
        """
        Check if the union tag is ``domain_invites_set_invite_new_user_pref_to_yes``.

        :rtype: bool
        """
        return self._tag == 'domain_invites_set_invite_new_user_pref_to_yes'

    def is_domain_verification_add_domain_fail(self):
        """
        Check if the union tag is ``domain_verification_add_domain_fail``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_fail'

    def is_domain_verification_add_domain_success(self):
        """
        Check if the union tag is ``domain_verification_add_domain_success``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_add_domain_success'

    def is_domain_verification_remove_domain(self):
        """
        Check if the union tag is ``domain_verification_remove_domain``.

        :rtype: bool
        """
        return self._tag == 'domain_verification_remove_domain'

    def is_enabled_domain_invites(self):
        """
        Check if the union tag is ``enabled_domain_invites``.

        :rtype: bool
        """
        return self._tag == 'enabled_domain_invites'

    def is_create_folder(self):
        """
        Check if the union tag is ``create_folder``.

        :rtype: bool
        """
        return self._tag == 'create_folder'

    def is_file_add(self):
        """
        Check if the union tag is ``file_add``.

        :rtype: bool
        """
        return self._tag == 'file_add'

    def is_file_copy(self):
        """
        Check if the union tag is ``file_copy``.

        :rtype: bool
        """
        return self._tag == 'file_copy'

    def is_file_delete(self):
        """
        Check if the union tag is ``file_delete``.

        :rtype: bool
        """
        return self._tag == 'file_delete'

    def is_file_download(self):
        """
        Check if the union tag is ``file_download``.

        :rtype: bool
        """
        return self._tag == 'file_download'

    def is_file_edit(self):
        """
        Check if the union tag is ``file_edit``.

        :rtype: bool
        """
        return self._tag == 'file_edit'

    def is_file_get_copy_reference(self):
        """
        Check if the union tag is ``file_get_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'file_get_copy_reference'

    def is_file_move(self):
        """
        Check if the union tag is ``file_move``.

        :rtype: bool
        """
        return self._tag == 'file_move'

    def is_file_permanently_delete(self):
        """
        Check if the union tag is ``file_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'file_permanently_delete'

    def is_file_preview(self):
        """
        Check if the union tag is ``file_preview``.

        :rtype: bool
        """
        return self._tag == 'file_preview'

    def is_file_rename(self):
        """
        Check if the union tag is ``file_rename``.

        :rtype: bool
        """
        return self._tag == 'file_rename'

    def is_file_restore(self):
        """
        Check if the union tag is ``file_restore``.

        :rtype: bool
        """
        return self._tag == 'file_restore'

    def is_file_revert(self):
        """
        Check if the union tag is ``file_revert``.

        :rtype: bool
        """
        return self._tag == 'file_revert'

    def is_file_rollback_changes(self):
        """
        Check if the union tag is ``file_rollback_changes``.

        :rtype: bool
        """
        return self._tag == 'file_rollback_changes'

    def is_file_save_copy_reference(self):
        """
        Check if the union tag is ``file_save_copy_reference``.

        :rtype: bool
        """
        return self._tag == 'file_save_copy_reference'

    def is_file_request_add_deadline(self):
        """
        Check if the union tag is ``file_request_add_deadline``.

        :rtype: bool
        """
        return self._tag == 'file_request_add_deadline'

    def is_file_request_change_folder(self):
        """
        Check if the union tag is ``file_request_change_folder``.

        :rtype: bool
        """
        return self._tag == 'file_request_change_folder'

    def is_file_request_change_title(self):
        """
        Check if the union tag is ``file_request_change_title``.

        :rtype: bool
        """
        return self._tag == 'file_request_change_title'

    def is_file_request_close(self):
        """
        Check if the union tag is ``file_request_close``.

        :rtype: bool
        """
        return self._tag == 'file_request_close'

    def is_file_request_create(self):
        """
        Check if the union tag is ``file_request_create``.

        :rtype: bool
        """
        return self._tag == 'file_request_create'

    def is_file_request_receive_file(self):
        """
        Check if the union tag is ``file_request_receive_file``.

        :rtype: bool
        """
        return self._tag == 'file_request_receive_file'

    def is_file_request_remove_deadline(self):
        """
        Check if the union tag is ``file_request_remove_deadline``.

        :rtype: bool
        """
        return self._tag == 'file_request_remove_deadline'

    def is_file_request_send(self):
        """
        Check if the union tag is ``file_request_send``.

        :rtype: bool
        """
        return self._tag == 'file_request_send'

    def is_group_add_external_id(self):
        """
        Check if the union tag is ``group_add_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_add_external_id'

    def is_group_add_member(self):
        """
        Check if the union tag is ``group_add_member``.

        :rtype: bool
        """
        return self._tag == 'group_add_member'

    def is_group_change_external_id(self):
        """
        Check if the union tag is ``group_change_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_change_external_id'

    def is_group_change_management_type(self):
        """
        Check if the union tag is ``group_change_management_type``.

        :rtype: bool
        """
        return self._tag == 'group_change_management_type'

    def is_group_change_member_role(self):
        """
        Check if the union tag is ``group_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'group_change_member_role'

    def is_group_create(self):
        """
        Check if the union tag is ``group_create``.

        :rtype: bool
        """
        return self._tag == 'group_create'

    def is_group_delete(self):
        """
        Check if the union tag is ``group_delete``.

        :rtype: bool
        """
        return self._tag == 'group_delete'

    def is_group_description_updated(self):
        """
        Check if the union tag is ``group_description_updated``.

        :rtype: bool
        """
        return self._tag == 'group_description_updated'

    def is_group_join_policy_updated(self):
        """
        Check if the union tag is ``group_join_policy_updated``.

        :rtype: bool
        """
        return self._tag == 'group_join_policy_updated'

    def is_group_moved(self):
        """
        Check if the union tag is ``group_moved``.

        :rtype: bool
        """
        return self._tag == 'group_moved'

    def is_group_remove_external_id(self):
        """
        Check if the union tag is ``group_remove_external_id``.

        :rtype: bool
        """
        return self._tag == 'group_remove_external_id'

    def is_group_remove_member(self):
        """
        Check if the union tag is ``group_remove_member``.

        :rtype: bool
        """
        return self._tag == 'group_remove_member'

    def is_group_rename(self):
        """
        Check if the union tag is ``group_rename``.

        :rtype: bool
        """
        return self._tag == 'group_rename'

    def is_emm_login_success(self):
        """
        Check if the union tag is ``emm_login_success``.

        :rtype: bool
        """
        return self._tag == 'emm_login_success'

    def is_logout(self):
        """
        Check if the union tag is ``logout``.

        :rtype: bool
        """
        return self._tag == 'logout'

    def is_password_login_fail(self):
        """
        Check if the union tag is ``password_login_fail``.

        :rtype: bool
        """
        return self._tag == 'password_login_fail'

    def is_password_login_success(self):
        """
        Check if the union tag is ``password_login_success``.

        :rtype: bool
        """
        return self._tag == 'password_login_success'

    def is_reseller_support_session_end(self):
        """
        Check if the union tag is ``reseller_support_session_end``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_end'

    def is_reseller_support_session_start(self):
        """
        Check if the union tag is ``reseller_support_session_start``.

        :rtype: bool
        """
        return self._tag == 'reseller_support_session_start'

    def is_sign_in_as_session_end(self):
        """
        Check if the union tag is ``sign_in_as_session_end``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_end'

    def is_sign_in_as_session_start(self):
        """
        Check if the union tag is ``sign_in_as_session_start``.

        :rtype: bool
        """
        return self._tag == 'sign_in_as_session_start'

    def is_sso_login_fail(self):
        """
        Check if the union tag is ``sso_login_fail``.

        :rtype: bool
        """
        return self._tag == 'sso_login_fail'

    def is_member_add_name(self):
        """
        Check if the union tag is ``member_add_name``.

        :rtype: bool
        """
        return self._tag == 'member_add_name'

    def is_member_change_email(self):
        """
        Check if the union tag is ``member_change_email``.

        :rtype: bool
        """
        return self._tag == 'member_change_email'

    def is_member_change_name(self):
        """
        Check if the union tag is ``member_change_name``.

        :rtype: bool
        """
        return self._tag == 'member_change_name'

    def is_member_change_role(self):
        """
        Check if the union tag is ``member_change_role``.

        :rtype: bool
        """
        return self._tag == 'member_change_role'

    def is_member_invite(self):
        """
        Check if the union tag is ``member_invite``.

        :rtype: bool
        """
        return self._tag == 'member_invite'

    def is_member_join(self):
        """
        Check if the union tag is ``member_join``.

        :rtype: bool
        """
        return self._tag == 'member_join'

    def is_member_leave(self):
        """
        Check if the union tag is ``member_leave``.

        :rtype: bool
        """
        return self._tag == 'member_leave'

    def is_member_recover(self):
        """
        Check if the union tag is ``member_recover``.

        :rtype: bool
        """
        return self._tag == 'member_recover'

    def is_member_suggest(self):
        """
        Check if the union tag is ``member_suggest``.

        :rtype: bool
        """
        return self._tag == 'member_suggest'

    def is_member_suspend(self):
        """
        Check if the union tag is ``member_suspend``.

        :rtype: bool
        """
        return self._tag == 'member_suspend'

    def is_member_unsuspend(self):
        """
        Check if the union tag is ``member_unsuspend``.

        :rtype: bool
        """
        return self._tag == 'member_unsuspend'

    def is_paper_content_add_member(self):
        """
        Check if the union tag is ``paper_content_add_member``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_member'

    def is_paper_content_add_to_folder(self):
        """
        Check if the union tag is ``paper_content_add_to_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_content_add_to_folder'

    def is_paper_content_archive(self):
        """
        Check if the union tag is ``paper_content_archive``.

        :rtype: bool
        """
        return self._tag == 'paper_content_archive'

    def is_paper_content_change_subscription(self):
        """
        Check if the union tag is ``paper_content_change_subscription``.

        :rtype: bool
        """
        return self._tag == 'paper_content_change_subscription'

    def is_paper_content_create(self):
        """
        Check if the union tag is ``paper_content_create``.

        :rtype: bool
        """
        return self._tag == 'paper_content_create'

    def is_paper_content_permanently_delete(self):
        """
        Check if the union tag is ``paper_content_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'paper_content_permanently_delete'

    def is_paper_content_remove_from_folder(self):
        """
        Check if the union tag is ``paper_content_remove_from_folder``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_from_folder'

    def is_paper_content_remove_member(self):
        """
        Check if the union tag is ``paper_content_remove_member``.

        :rtype: bool
        """
        return self._tag == 'paper_content_remove_member'

    def is_paper_content_rename(self):
        """
        Check if the union tag is ``paper_content_rename``.

        :rtype: bool
        """
        return self._tag == 'paper_content_rename'

    def is_paper_content_restore(self):
        """
        Check if the union tag is ``paper_content_restore``.

        :rtype: bool
        """
        return self._tag == 'paper_content_restore'

    def is_paper_doc_add_comment(self):
        """
        Check if the union tag is ``paper_doc_add_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_add_comment'

    def is_paper_doc_change_member_role(self):
        """
        Check if the union tag is ``paper_doc_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_member_role'

    def is_paper_doc_change_sharing_policy(self):
        """
        Check if the union tag is ``paper_doc_change_sharing_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_change_sharing_policy'

    def is_paper_doc_deleted(self):
        """
        Check if the union tag is ``paper_doc_deleted``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_deleted'

    def is_paper_doc_delete_comment(self):
        """
        Check if the union tag is ``paper_doc_delete_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_delete_comment'

    def is_paper_doc_download(self):
        """
        Check if the union tag is ``paper_doc_download``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_download'

    def is_paper_doc_edit(self):
        """
        Check if the union tag is ``paper_doc_edit``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit'

    def is_paper_doc_edit_comment(self):
        """
        Check if the union tag is ``paper_doc_edit_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_edit_comment'

    def is_paper_doc_followed(self):
        """
        Check if the union tag is ``paper_doc_followed``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_followed'

    def is_paper_doc_mention(self):
        """
        Check if the union tag is ``paper_doc_mention``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_mention'

    def is_paper_doc_request_access(self):
        """
        Check if the union tag is ``paper_doc_request_access``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_request_access'

    def is_paper_doc_resolve_comment(self):
        """
        Check if the union tag is ``paper_doc_resolve_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_resolve_comment'

    def is_paper_doc_revert(self):
        """
        Check if the union tag is ``paper_doc_revert``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_revert'

    def is_paper_doc_slack_share(self):
        """
        Check if the union tag is ``paper_doc_slack_share``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_slack_share'

    def is_paper_doc_team_invite(self):
        """
        Check if the union tag is ``paper_doc_team_invite``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_team_invite'

    def is_paper_doc_unresolve_comment(self):
        """
        Check if the union tag is ``paper_doc_unresolve_comment``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_unresolve_comment'

    def is_paper_doc_view(self):
        """
        Check if the union tag is ``paper_doc_view``.

        :rtype: bool
        """
        return self._tag == 'paper_doc_view'

    def is_paper_folder_deleted(self):
        """
        Check if the union tag is ``paper_folder_deleted``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_deleted'

    def is_paper_folder_followed(self):
        """
        Check if the union tag is ``paper_folder_followed``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_followed'

    def is_paper_folder_team_invite(self):
        """
        Check if the union tag is ``paper_folder_team_invite``.

        :rtype: bool
        """
        return self._tag == 'paper_folder_team_invite'

    def is_password_change(self):
        """
        Check if the union tag is ``password_change``.

        :rtype: bool
        """
        return self._tag == 'password_change'

    def is_password_reset(self):
        """
        Check if the union tag is ``password_reset``.

        :rtype: bool
        """
        return self._tag == 'password_reset'

    def is_password_reset_all(self):
        """
        Check if the union tag is ``password_reset_all``.

        :rtype: bool
        """
        return self._tag == 'password_reset_all'

    def is_emm_create_exceptions_report(self):
        """
        Check if the union tag is ``emm_create_exceptions_report``.

        :rtype: bool
        """
        return self._tag == 'emm_create_exceptions_report'

    def is_emm_create_usage_report(self):
        """
        Check if the union tag is ``emm_create_usage_report``.

        :rtype: bool
        """
        return self._tag == 'emm_create_usage_report'

    def is_smart_sync_create_admin_privilege_report(self):
        """
        Check if the union tag is ``smart_sync_create_admin_privilege_report``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_create_admin_privilege_report'

    def is_team_activity_create_report(self):
        """
        Check if the union tag is ``team_activity_create_report``.

        :rtype: bool
        """
        return self._tag == 'team_activity_create_report'

    def is_collection_share(self):
        """
        Check if the union tag is ``collection_share``.

        :rtype: bool
        """
        return self._tag == 'collection_share'

    def is_file_add_comment(self):
        """
        Check if the union tag is ``file_add_comment``.

        :rtype: bool
        """
        return self._tag == 'file_add_comment'

    def is_file_like_comment(self):
        """
        Check if the union tag is ``file_like_comment``.

        :rtype: bool
        """
        return self._tag == 'file_like_comment'

    def is_file_unlike_comment(self):
        """
        Check if the union tag is ``file_unlike_comment``.

        :rtype: bool
        """
        return self._tag == 'file_unlike_comment'

    def is_note_acl_invite_only(self):
        """
        Check if the union tag is ``note_acl_invite_only``.

        :rtype: bool
        """
        return self._tag == 'note_acl_invite_only'

    def is_note_acl_link(self):
        """
        Check if the union tag is ``note_acl_link``.

        :rtype: bool
        """
        return self._tag == 'note_acl_link'

    def is_note_acl_team_link(self):
        """
        Check if the union tag is ``note_acl_team_link``.

        :rtype: bool
        """
        return self._tag == 'note_acl_team_link'

    def is_note_shared(self):
        """
        Check if the union tag is ``note_shared``.

        :rtype: bool
        """
        return self._tag == 'note_shared'

    def is_note_share_receive(self):
        """
        Check if the union tag is ``note_share_receive``.

        :rtype: bool
        """
        return self._tag == 'note_share_receive'

    def is_open_note_shared(self):
        """
        Check if the union tag is ``open_note_shared``.

        :rtype: bool
        """
        return self._tag == 'open_note_shared'

    def is_sf_add_group(self):
        """
        Check if the union tag is ``sf_add_group``.

        :rtype: bool
        """
        return self._tag == 'sf_add_group'

    def is_sf_allow_non_members_to_view_shared_links(self):
        """
        Check if the union tag is ``sf_allow_non_members_to_view_shared_links``.

        :rtype: bool
        """
        return self._tag == 'sf_allow_non_members_to_view_shared_links'

    def is_sf_invite_group(self):
        """
        Check if the union tag is ``sf_invite_group``.

        :rtype: bool
        """
        return self._tag == 'sf_invite_group'

    def is_sf_nest(self):
        """
        Check if the union tag is ``sf_nest``.

        :rtype: bool
        """
        return self._tag == 'sf_nest'

    def is_sf_team_decline(self):
        """
        Check if the union tag is ``sf_team_decline``.

        :rtype: bool
        """
        return self._tag == 'sf_team_decline'

    def is_sf_team_grant_access(self):
        """
        Check if the union tag is ``sf_team_grant_access``.

        :rtype: bool
        """
        return self._tag == 'sf_team_grant_access'

    def is_sf_team_invite(self):
        """
        Check if the union tag is ``sf_team_invite``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite'

    def is_sf_team_invite_change_role(self):
        """
        Check if the union tag is ``sf_team_invite_change_role``.

        :rtype: bool
        """
        return self._tag == 'sf_team_invite_change_role'

    def is_sf_team_join(self):
        """
        Check if the union tag is ``sf_team_join``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join'

    def is_sf_team_join_from_oob_link(self):
        """
        Check if the union tag is ``sf_team_join_from_oob_link``.

        :rtype: bool
        """
        return self._tag == 'sf_team_join_from_oob_link'

    def is_sf_team_uninvite(self):
        """
        Check if the union tag is ``sf_team_uninvite``.

        :rtype: bool
        """
        return self._tag == 'sf_team_uninvite'

    def is_shared_content_add_invitees(self):
        """
        Check if the union tag is ``shared_content_add_invitees``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_invitees'

    def is_shared_content_add_link_expiry(self):
        """
        Check if the union tag is ``shared_content_add_link_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_expiry'

    def is_shared_content_add_link_password(self):
        """
        Check if the union tag is ``shared_content_add_link_password``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_link_password'

    def is_shared_content_add_member(self):
        """
        Check if the union tag is ``shared_content_add_member``.

        :rtype: bool
        """
        return self._tag == 'shared_content_add_member'

    def is_shared_content_change_downloads_policy(self):
        """
        Check if the union tag is ``shared_content_change_downloads_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_downloads_policy'

    def is_shared_content_change_invitee_role(self):
        """
        Check if the union tag is ``shared_content_change_invitee_role``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_invitee_role'

    def is_shared_content_change_link_audience(self):
        """
        Check if the union tag is ``shared_content_change_link_audience``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_audience'

    def is_shared_content_change_link_expiry(self):
        """
        Check if the union tag is ``shared_content_change_link_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_expiry'

    def is_shared_content_change_link_password(self):
        """
        Check if the union tag is ``shared_content_change_link_password``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_link_password'

    def is_shared_content_change_member_role(self):
        """
        Check if the union tag is ``shared_content_change_member_role``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_member_role'

    def is_shared_content_change_viewer_info_policy(self):
        """
        Check if the union tag is ``shared_content_change_viewer_info_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_content_change_viewer_info_policy'

    def is_shared_content_claim_invitation(self):
        """
        Check if the union tag is ``shared_content_claim_invitation``.

        :rtype: bool
        """
        return self._tag == 'shared_content_claim_invitation'

    def is_shared_content_copy(self):
        """
        Check if the union tag is ``shared_content_copy``.

        :rtype: bool
        """
        return self._tag == 'shared_content_copy'

    def is_shared_content_download(self):
        """
        Check if the union tag is ``shared_content_download``.

        :rtype: bool
        """
        return self._tag == 'shared_content_download'

    def is_shared_content_relinquish_membership(self):
        """
        Check if the union tag is ``shared_content_relinquish_membership``.

        :rtype: bool
        """
        return self._tag == 'shared_content_relinquish_membership'

    def is_shared_content_remove_invitee(self):
        """
        Check if the union tag is ``shared_content_remove_invitee``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_invitee'

    def is_shared_content_remove_link_expiry(self):
        """
        Check if the union tag is ``shared_content_remove_link_expiry``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_expiry'

    def is_shared_content_remove_link_password(self):
        """
        Check if the union tag is ``shared_content_remove_link_password``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_link_password'

    def is_shared_content_remove_member(self):
        """
        Check if the union tag is ``shared_content_remove_member``.

        :rtype: bool
        """
        return self._tag == 'shared_content_remove_member'

    def is_shared_content_request_access(self):
        """
        Check if the union tag is ``shared_content_request_access``.

        :rtype: bool
        """
        return self._tag == 'shared_content_request_access'

    def is_shared_content_unshare(self):
        """
        Check if the union tag is ``shared_content_unshare``.

        :rtype: bool
        """
        return self._tag == 'shared_content_unshare'

    def is_shared_content_view(self):
        """
        Check if the union tag is ``shared_content_view``.

        :rtype: bool
        """
        return self._tag == 'shared_content_view'

    def is_shared_folder_change_confidentiality(self):
        """
        Check if the union tag is ``shared_folder_change_confidentiality``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_confidentiality'

    def is_shared_folder_change_link_policy(self):
        """
        Check if the union tag is ``shared_folder_change_link_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_link_policy'

    def is_shared_folder_change_member_management_policy(self):
        """
        Check if the union tag is ``shared_folder_change_member_management_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_member_management_policy'

    def is_shared_folder_change_member_policy(self):
        """
        Check if the union tag is ``shared_folder_change_member_policy``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_change_member_policy'

    def is_shared_folder_create(self):
        """
        Check if the union tag is ``shared_folder_create``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_create'

    def is_shared_folder_mount(self):
        """
        Check if the union tag is ``shared_folder_mount``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_mount'

    def is_shared_folder_transfer_ownership(self):
        """
        Check if the union tag is ``shared_folder_transfer_ownership``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_transfer_ownership'

    def is_shared_folder_unmount(self):
        """
        Check if the union tag is ``shared_folder_unmount``.

        :rtype: bool
        """
        return self._tag == 'shared_folder_unmount'

    def is_shared_note_opened(self):
        """
        Check if the union tag is ``shared_note_opened``.

        :rtype: bool
        """
        return self._tag == 'shared_note_opened'

    def is_shmodel_app_create(self):
        """
        Check if the union tag is ``shmodel_app_create``.

        :rtype: bool
        """
        return self._tag == 'shmodel_app_create'

    def is_shmodel_create(self):
        """
        Check if the union tag is ``shmodel_create``.

        :rtype: bool
        """
        return self._tag == 'shmodel_create'

    def is_shmodel_disable(self):
        """
        Check if the union tag is ``shmodel_disable``.

        :rtype: bool
        """
        return self._tag == 'shmodel_disable'

    def is_shmodel_fb_share(self):
        """
        Check if the union tag is ``shmodel_fb_share``.

        :rtype: bool
        """
        return self._tag == 'shmodel_fb_share'

    def is_shmodel_group_share(self):
        """
        Check if the union tag is ``shmodel_group_share``.

        :rtype: bool
        """
        return self._tag == 'shmodel_group_share'

    def is_shmodel_remove_expiration(self):
        """
        Check if the union tag is ``shmodel_remove_expiration``.

        :rtype: bool
        """
        return self._tag == 'shmodel_remove_expiration'

    def is_shmodel_set_expiration(self):
        """
        Check if the union tag is ``shmodel_set_expiration``.

        :rtype: bool
        """
        return self._tag == 'shmodel_set_expiration'

    def is_shmodel_team_copy(self):
        """
        Check if the union tag is ``shmodel_team_copy``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_copy'

    def is_shmodel_team_download(self):
        """
        Check if the union tag is ``shmodel_team_download``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_download'

    def is_shmodel_team_share(self):
        """
        Check if the union tag is ``shmodel_team_share``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_share'

    def is_shmodel_team_view(self):
        """
        Check if the union tag is ``shmodel_team_view``.

        :rtype: bool
        """
        return self._tag == 'shmodel_team_view'

    def is_shmodel_visibility_password(self):
        """
        Check if the union tag is ``shmodel_visibility_password``.

        :rtype: bool
        """
        return self._tag == 'shmodel_visibility_password'

    def is_shmodel_visibility_public(self):
        """
        Check if the union tag is ``shmodel_visibility_public``.

        :rtype: bool
        """
        return self._tag == 'shmodel_visibility_public'

    def is_shmodel_visibility_team_only(self):
        """
        Check if the union tag is ``shmodel_visibility_team_only``.

        :rtype: bool
        """
        return self._tag == 'shmodel_visibility_team_only'

    def is_remove_logout_url(self):
        """
        Check if the union tag is ``remove_logout_url``.

        :rtype: bool
        """
        return self._tag == 'remove_logout_url'

    def is_remove_sso_url(self):
        """
        Check if the union tag is ``remove_sso_url``.

        :rtype: bool
        """
        return self._tag == 'remove_sso_url'

    def is_sso_change_cert(self):
        """
        Check if the union tag is ``sso_change_cert``.

        :rtype: bool
        """
        return self._tag == 'sso_change_cert'

    def is_sso_change_login_url(self):
        """
        Check if the union tag is ``sso_change_login_url``.

        :rtype: bool
        """
        return self._tag == 'sso_change_login_url'

    def is_sso_change_logout_url(self):
        """
        Check if the union tag is ``sso_change_logout_url``.

        :rtype: bool
        """
        return self._tag == 'sso_change_logout_url'

    def is_sso_change_saml_identity_mode(self):
        """
        Check if the union tag is ``sso_change_saml_identity_mode``.

        :rtype: bool
        """
        return self._tag == 'sso_change_saml_identity_mode'

    def is_team_folder_change_status(self):
        """
        Check if the union tag is ``team_folder_change_status``.

        :rtype: bool
        """
        return self._tag == 'team_folder_change_status'

    def is_team_folder_create(self):
        """
        Check if the union tag is ``team_folder_create``.

        :rtype: bool
        """
        return self._tag == 'team_folder_create'

    def is_team_folder_downgrade(self):
        """
        Check if the union tag is ``team_folder_downgrade``.

        :rtype: bool
        """
        return self._tag == 'team_folder_downgrade'

    def is_team_folder_permanently_delete(self):
        """
        Check if the union tag is ``team_folder_permanently_delete``.

        :rtype: bool
        """
        return self._tag == 'team_folder_permanently_delete'

    def is_team_folder_rename(self):
        """
        Check if the union tag is ``team_folder_rename``.

        :rtype: bool
        """
        return self._tag == 'team_folder_rename'

    def is_account_capture_change_policy(self):
        """
        Check if the union tag is ``account_capture_change_policy``.

        :rtype: bool
        """
        return self._tag == 'account_capture_change_policy'

    def is_allow_download_disabled(self):
        """
        Check if the union tag is ``allow_download_disabled``.

        :rtype: bool
        """
        return self._tag == 'allow_download_disabled'

    def is_allow_download_enabled(self):
        """
        Check if the union tag is ``allow_download_enabled``.

        :rtype: bool
        """
        return self._tag == 'allow_download_enabled'

    def is_data_placement_restriction_change_policy(self):
        """
        Check if the union tag is ``data_placement_restriction_change_policy``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_change_policy'

    def is_data_placement_restriction_satisfy_policy(self):
        """
        Check if the union tag is ``data_placement_restriction_satisfy_policy``.

        :rtype: bool
        """
        return self._tag == 'data_placement_restriction_satisfy_policy'

    def is_device_approvals_change_desktop_policy(self):
        """
        Check if the union tag is ``device_approvals_change_desktop_policy``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_desktop_policy'

    def is_device_approvals_change_mobile_policy(self):
        """
        Check if the union tag is ``device_approvals_change_mobile_policy``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_mobile_policy'

    def is_device_approvals_change_overage_action(self):
        """
        Check if the union tag is ``device_approvals_change_overage_action``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_overage_action'

    def is_device_approvals_change_unlink_action(self):
        """
        Check if the union tag is ``device_approvals_change_unlink_action``.

        :rtype: bool
        """
        return self._tag == 'device_approvals_change_unlink_action'

    def is_emm_add_exception(self):
        """
        Check if the union tag is ``emm_add_exception``.

        :rtype: bool
        """
        return self._tag == 'emm_add_exception'

    def is_emm_change_policy(self):
        """
        Check if the union tag is ``emm_change_policy``.

        :rtype: bool
        """
        return self._tag == 'emm_change_policy'

    def is_emm_remove_exception(self):
        """
        Check if the union tag is ``emm_remove_exception``.

        :rtype: bool
        """
        return self._tag == 'emm_remove_exception'

    def is_extended_version_history_change_policy(self):
        """
        Check if the union tag is ``extended_version_history_change_policy``.

        :rtype: bool
        """
        return self._tag == 'extended_version_history_change_policy'

    def is_file_comments_change_policy(self):
        """
        Check if the union tag is ``file_comments_change_policy``.

        :rtype: bool
        """
        return self._tag == 'file_comments_change_policy'

    def is_file_requests_change_policy(self):
        """
        Check if the union tag is ``file_requests_change_policy``.

        :rtype: bool
        """
        return self._tag == 'file_requests_change_policy'

    def is_file_requests_emails_enabled(self):
        """
        Check if the union tag is ``file_requests_emails_enabled``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_enabled'

    def is_file_requests_emails_restricted_to_team_only(self):
        """
        Check if the union tag is ``file_requests_emails_restricted_to_team_only``.

        :rtype: bool
        """
        return self._tag == 'file_requests_emails_restricted_to_team_only'

    def is_google_sso_change_policy(self):
        """
        Check if the union tag is ``google_sso_change_policy``.

        :rtype: bool
        """
        return self._tag == 'google_sso_change_policy'

    def is_group_user_management_change_policy(self):
        """
        Check if the union tag is ``group_user_management_change_policy``.

        :rtype: bool
        """
        return self._tag == 'group_user_management_change_policy'

    def is_member_requests_change_policy(self):
        """
        Check if the union tag is ``member_requests_change_policy``.

        :rtype: bool
        """
        return self._tag == 'member_requests_change_policy'

    def is_member_space_limits_add_exception(self):
        """
        Check if the union tag is ``member_space_limits_add_exception``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_add_exception'

    def is_member_space_limits_change_policy(self):
        """
        Check if the union tag is ``member_space_limits_change_policy``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_change_policy'

    def is_member_space_limits_remove_exception(self):
        """
        Check if the union tag is ``member_space_limits_remove_exception``.

        :rtype: bool
        """
        return self._tag == 'member_space_limits_remove_exception'

    def is_member_suggestions_change_policy(self):
        """
        Check if the union tag is ``member_suggestions_change_policy``.

        :rtype: bool
        """
        return self._tag == 'member_suggestions_change_policy'

    def is_microsoft_office_addin_change_policy(self):
        """
        Check if the union tag is ``microsoft_office_addin_change_policy``.

        :rtype: bool
        """
        return self._tag == 'microsoft_office_addin_change_policy'

    def is_network_control_change_policy(self):
        """
        Check if the union tag is ``network_control_change_policy``.

        :rtype: bool
        """
        return self._tag == 'network_control_change_policy'

    def is_paper_change_deployment_policy(self):
        """
        Check if the union tag is ``paper_change_deployment_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_deployment_policy'

    def is_paper_change_member_policy(self):
        """
        Check if the union tag is ``paper_change_member_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_member_policy'

    def is_paper_change_policy(self):
        """
        Check if the union tag is ``paper_change_policy``.

        :rtype: bool
        """
        return self._tag == 'paper_change_policy'

    def is_permanent_delete_change_policy(self):
        """
        Check if the union tag is ``permanent_delete_change_policy``.

        :rtype: bool
        """
        return self._tag == 'permanent_delete_change_policy'

    def is_sharing_change_folder_join_policy(self):
        """
        Check if the union tag is ``sharing_change_folder_join_policy``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_folder_join_policy'

    def is_sharing_change_link_policy(self):
        """
        Check if the union tag is ``sharing_change_link_policy``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_link_policy'

    def is_sharing_change_member_policy(self):
        """
        Check if the union tag is ``sharing_change_member_policy``.

        :rtype: bool
        """
        return self._tag == 'sharing_change_member_policy'

    def is_smart_sync_change_policy(self):
        """
        Check if the union tag is ``smart_sync_change_policy``.

        :rtype: bool
        """
        return self._tag == 'smart_sync_change_policy'

    def is_sso_change_policy(self):
        """
        Check if the union tag is ``sso_change_policy``.

        :rtype: bool
        """
        return self._tag == 'sso_change_policy'

    def is_tfa_change_policy(self):
        """
        Check if the union tag is ``tfa_change_policy``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_policy'

    def is_two_account_change_policy(self):
        """
        Check if the union tag is ``two_account_change_policy``.

        :rtype: bool
        """
        return self._tag == 'two_account_change_policy'

    def is_web_sessions_change_fixed_length_policy(self):
        """
        Check if the union tag is ``web_sessions_change_fixed_length_policy``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_fixed_length_policy'

    def is_web_sessions_change_idle_length_policy(self):
        """
        Check if the union tag is ``web_sessions_change_idle_length_policy``.

        :rtype: bool
        """
        return self._tag == 'web_sessions_change_idle_length_policy'

    def is_team_profile_add_logo(self):
        """
        Check if the union tag is ``team_profile_add_logo``.

        :rtype: bool
        """
        return self._tag == 'team_profile_add_logo'

    def is_team_profile_change_logo(self):
        """
        Check if the union tag is ``team_profile_change_logo``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_logo'

    def is_team_profile_change_name(self):
        """
        Check if the union tag is ``team_profile_change_name``.

        :rtype: bool
        """
        return self._tag == 'team_profile_change_name'

    def is_team_profile_remove_logo(self):
        """
        Check if the union tag is ``team_profile_remove_logo``.

        :rtype: bool
        """
        return self._tag == 'team_profile_remove_logo'

    def is_tfa_add_backup_phone(self):
        """
        Check if the union tag is ``tfa_add_backup_phone``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_backup_phone'

    def is_tfa_add_security_key(self):
        """
        Check if the union tag is ``tfa_add_security_key``.

        :rtype: bool
        """
        return self._tag == 'tfa_add_security_key'

    def is_tfa_change_backup_phone(self):
        """
        Check if the union tag is ``tfa_change_backup_phone``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_backup_phone'

    def is_tfa_change_status(self):
        """
        Check if the union tag is ``tfa_change_status``.

        :rtype: bool
        """
        return self._tag == 'tfa_change_status'

    def is_tfa_remove_backup_phone(self):
        """
        Check if the union tag is ``tfa_remove_backup_phone``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_backup_phone'

    def is_tfa_remove_security_key(self):
        """
        Check if the union tag is ``tfa_remove_security_key``.

        :rtype: bool
        """
        return self._tag == 'tfa_remove_security_key'

    def is_tfa_reset(self):
        """
        Check if the union tag is ``tfa_reset``.

        :rtype: bool
        """
        return self._tag == 'tfa_reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'EventType(%r, %r)' % (self._tag, self._value)

EventType_validator = bv.Union(EventType)

class ExtendedVersionHistoryChangePolicyDetails(object):
    """
    Accepted or opted out of extended version history.

    :ivar new_value: New extended version history policy.
    :ivar previous_value: Previous extended version history policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New extended version history policy.

        :rtype: ExtendedVersionHistoryPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous extended version history policy. Might be missing due to
        historical data gap.

        :rtype: ExtendedVersionHistoryPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'ExtendedVersionHistoryChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

ExtendedVersionHistoryChangePolicyDetails_validator = bv.Struct(ExtendedVersionHistoryChangePolicyDetails)

class ExtendedVersionHistoryPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    limited = None
    # Attribute is overwritten below the class definition
    unlimited = None
    # Attribute is overwritten below the class definition
    other = None

    def is_limited(self):
        """
        Check if the union tag is ``limited``.

        :rtype: bool
        """
        return self._tag == 'limited'

    def is_unlimited(self):
        """
        Check if the union tag is ``unlimited``.

        :rtype: bool
        """
        return self._tag == 'unlimited'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ExtendedVersionHistoryPolicy(%r, %r)' % (self._tag, self._value)

ExtendedVersionHistoryPolicy_validator = bv.Union(ExtendedVersionHistoryPolicy)

class ExternalSharingAccessibilityPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    default_team_only = None
    # Attribute is overwritten below the class definition
    default_anyone = None
    # Attribute is overwritten below the class definition
    other = None

    def is_team_only(self):
        """
        Check if the union tag is ``team_only``.

        :rtype: bool
        """
        return self._tag == 'team_only'

    def is_default_team_only(self):
        """
        Check if the union tag is ``default_team_only``.

        :rtype: bool
        """
        return self._tag == 'default_team_only'

    def is_default_anyone(self):
        """
        Check if the union tag is ``default_anyone``.

        :rtype: bool
        """
        return self._tag == 'default_anyone'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ExternalSharingAccessibilityPolicy(%r, %r)' % (self._tag, self._value)

ExternalSharingAccessibilityPolicy_validator = bv.Union(ExternalSharingAccessibilityPolicy)

class ExternalSharingPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    team_only = None
    # Attribute is overwritten below the class definition
    anyone = None
    # Attribute is overwritten below the class definition
    other = None

    def is_team_only(self):
        """
        Check if the union tag is ``team_only``.

        :rtype: bool
        """
        return self._tag == 'team_only'

    def is_anyone(self):
        """
        Check if the union tag is ``anyone``.

        :rtype: bool
        """
        return self._tag == 'anyone'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'ExternalSharingPolicy(%r, %r)' % (self._tag, self._value)

ExternalSharingPolicy_validator = bv.Union(ExternalSharingPolicy)

class FileAddCommentDetails(object):
    """
    Added a file comment.

    :ivar target_index: Target asset index.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 comment_text=None):
        self._target_index_value = None
        self._target_index_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if target_index is not None:
            self.target_index = target_index
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'FileAddCommentDetails(target_index={!r}, comment_text={!r})'.format(
            self._target_index_value,
            self._comment_text_value,
        )

FileAddCommentDetails_validator = bv.Struct(FileAddCommentDetails)

class FileAddDetails(object):
    """
    Added files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileAddDetails()'

FileAddDetails_validator = bv.Struct(FileAddDetails)

class FileCommentsChangePolicyDetails(object):
    """
    Enabled or disabled commenting on team files.

    :ivar new_value: New commenting on team files policy.
    :ivar previous_value: Previous commenting on team files policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New commenting on team files policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous commenting on team files policy. Might be missing due to
        historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'FileCommentsChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

FileCommentsChangePolicyDetails_validator = bv.Struct(FileCommentsChangePolicyDetails)

class FileCopyDetails(object):
    """
    Copied files and/or folders.

    :ivar src_index: Source asset index.
    :ivar dest_index: Destination asset index.
    """

    __slots__ = [
        '_src_index_value',
        '_src_index_present',
        '_dest_index_value',
        '_dest_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 src_index=None,
                 dest_index=None):
        self._src_index_value = None
        self._src_index_present = False
        self._dest_index_value = None
        self._dest_index_present = False
        if src_index is not None:
            self.src_index = src_index
        if dest_index is not None:
            self.dest_index = dest_index

    @property
    def src_index(self):
        """
        Source asset index.

        :rtype: long
        """
        if self._src_index_present:
            return self._src_index_value
        else:
            raise AttributeError("missing required field 'src_index'")

    @src_index.setter
    def src_index(self, val):
        val = self._src_index_validator.validate(val)
        self._src_index_value = val
        self._src_index_present = True

    @src_index.deleter
    def src_index(self):
        self._src_index_value = None
        self._src_index_present = False

    @property
    def dest_index(self):
        """
        Destination asset index.

        :rtype: long
        """
        if self._dest_index_present:
            return self._dest_index_value
        else:
            raise AttributeError("missing required field 'dest_index'")

    @dest_index.setter
    def dest_index(self, val):
        val = self._dest_index_validator.validate(val)
        self._dest_index_value = val
        self._dest_index_present = True

    @dest_index.deleter
    def dest_index(self):
        self._dest_index_value = None
        self._dest_index_present = False

    def __repr__(self):
        return 'FileCopyDetails(src_index={!r}, dest_index={!r})'.format(
            self._src_index_value,
            self._dest_index_value,
        )

FileCopyDetails_validator = bv.Struct(FileCopyDetails)

class FileDeleteDetails(object):
    """
    Deleted files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileDeleteDetails()'

FileDeleteDetails_validator = bv.Struct(FileDeleteDetails)

class FileDownloadDetails(object):
    """
    Downloaded files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileDownloadDetails()'

FileDownloadDetails_validator = bv.Struct(FileDownloadDetails)

class FileEditDetails(object):
    """
    Edited files.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileEditDetails()'

FileEditDetails_validator = bv.Struct(FileEditDetails)

class FileGetCopyReferenceDetails(object):
    """
    Create a copy reference to a file or folder.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileGetCopyReferenceDetails()'

FileGetCopyReferenceDetails_validator = bv.Struct(FileGetCopyReferenceDetails)

class FileLikeCommentDetails(object):
    """
    Liked a file comment.

    :ivar target_index: Target asset index.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 comment_text=None):
        self._target_index_value = None
        self._target_index_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if target_index is not None:
            self.target_index = target_index
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'FileLikeCommentDetails(target_index={!r}, comment_text={!r})'.format(
            self._target_index_value,
            self._comment_text_value,
        )

FileLikeCommentDetails_validator = bv.Struct(FileLikeCommentDetails)

class FileOrFolderLogInfo(object):
    """
    Generic information relevant both for files and folders

    :ivar path: Path relative to event context.
    :ivar display_name: Display name. Might be missing due to historical data
        gap.
    :ivar file_id: Unique ID. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_path_value',
        '_path_present',
        '_display_name_value',
        '_display_name_present',
        '_file_id_value',
        '_file_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 display_name=None,
                 file_id=None):
        self._path_value = None
        self._path_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._file_id_value = None
        self._file_id_present = False
        if path is not None:
            self.path = path
        if display_name is not None:
            self.display_name = display_name
        if file_id is not None:
            self.file_id = file_id

    @property
    def path(self):
        """
        Path relative to event context.

        :rtype: PathLogInfo
        """
        if self._path_present:
            return self._path_value
        else:
            raise AttributeError("missing required field 'path'")

    @path.setter
    def path(self, val):
        self._path_validator.validate_type_only(val)
        self._path_value = val
        self._path_present = True

    @path.deleter
    def path(self):
        self._path_value = None
        self._path_present = False

    @property
    def display_name(self):
        """
        Display name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def file_id(self):
        """
        Unique ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._file_id_present:
            return self._file_id_value
        else:
            return None

    @file_id.setter
    def file_id(self, val):
        if val is None:
            del self.file_id
            return
        val = self._file_id_validator.validate(val)
        self._file_id_value = val
        self._file_id_present = True

    @file_id.deleter
    def file_id(self):
        self._file_id_value = None
        self._file_id_present = False

    def __repr__(self):
        return 'FileOrFolderLogInfo(path={!r}, display_name={!r}, file_id={!r})'.format(
            self._path_value,
            self._display_name_value,
            self._file_id_value,
        )

FileOrFolderLogInfo_validator = bv.Struct(FileOrFolderLogInfo)

class FileLogInfo(FileOrFolderLogInfo):
    """
    File's logged information.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 display_name=None,
                 file_id=None):
        super(FileLogInfo, self).__init__(path,
                                          display_name,
                                          file_id)

    def __repr__(self):
        return 'FileLogInfo(path={!r}, display_name={!r}, file_id={!r})'.format(
            self._path_value,
            self._display_name_value,
            self._file_id_value,
        )

FileLogInfo_validator = bv.Struct(FileLogInfo)

class FileMoveDetails(object):
    """
    Moved files and/or folders.

    :ivar src_index: Source asset index.
    :ivar dest_index: Destination asset index.
    """

    __slots__ = [
        '_src_index_value',
        '_src_index_present',
        '_dest_index_value',
        '_dest_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 src_index=None,
                 dest_index=None):
        self._src_index_value = None
        self._src_index_present = False
        self._dest_index_value = None
        self._dest_index_present = False
        if src_index is not None:
            self.src_index = src_index
        if dest_index is not None:
            self.dest_index = dest_index

    @property
    def src_index(self):
        """
        Source asset index.

        :rtype: long
        """
        if self._src_index_present:
            return self._src_index_value
        else:
            raise AttributeError("missing required field 'src_index'")

    @src_index.setter
    def src_index(self, val):
        val = self._src_index_validator.validate(val)
        self._src_index_value = val
        self._src_index_present = True

    @src_index.deleter
    def src_index(self):
        self._src_index_value = None
        self._src_index_present = False

    @property
    def dest_index(self):
        """
        Destination asset index.

        :rtype: long
        """
        if self._dest_index_present:
            return self._dest_index_value
        else:
            raise AttributeError("missing required field 'dest_index'")

    @dest_index.setter
    def dest_index(self, val):
        val = self._dest_index_validator.validate(val)
        self._dest_index_value = val
        self._dest_index_present = True

    @dest_index.deleter
    def dest_index(self):
        self._dest_index_value = None
        self._dest_index_present = False

    def __repr__(self):
        return 'FileMoveDetails(src_index={!r}, dest_index={!r})'.format(
            self._src_index_value,
            self._dest_index_value,
        )

FileMoveDetails_validator = bv.Struct(FileMoveDetails)

class FilePermanentlyDeleteDetails(object):
    """
    Permanently deleted files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FilePermanentlyDeleteDetails()'

FilePermanentlyDeleteDetails_validator = bv.Struct(FilePermanentlyDeleteDetails)

class FilePreviewDetails(object):
    """
    Previewed files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FilePreviewDetails()'

FilePreviewDetails_validator = bv.Struct(FilePreviewDetails)

class FileRenameDetails(object):
    """
    Renamed files and/or folders.

    :ivar src_index: Source asset index.
    :ivar dest_index: Destination asset index.
    """

    __slots__ = [
        '_src_index_value',
        '_src_index_present',
        '_dest_index_value',
        '_dest_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 src_index=None,
                 dest_index=None):
        self._src_index_value = None
        self._src_index_present = False
        self._dest_index_value = None
        self._dest_index_present = False
        if src_index is not None:
            self.src_index = src_index
        if dest_index is not None:
            self.dest_index = dest_index

    @property
    def src_index(self):
        """
        Source asset index.

        :rtype: long
        """
        if self._src_index_present:
            return self._src_index_value
        else:
            raise AttributeError("missing required field 'src_index'")

    @src_index.setter
    def src_index(self, val):
        val = self._src_index_validator.validate(val)
        self._src_index_value = val
        self._src_index_present = True

    @src_index.deleter
    def src_index(self):
        self._src_index_value = None
        self._src_index_present = False

    @property
    def dest_index(self):
        """
        Destination asset index.

        :rtype: long
        """
        if self._dest_index_present:
            return self._dest_index_value
        else:
            raise AttributeError("missing required field 'dest_index'")

    @dest_index.setter
    def dest_index(self, val):
        val = self._dest_index_validator.validate(val)
        self._dest_index_value = val
        self._dest_index_present = True

    @dest_index.deleter
    def dest_index(self):
        self._dest_index_value = None
        self._dest_index_present = False

    def __repr__(self):
        return 'FileRenameDetails(src_index={!r}, dest_index={!r})'.format(
            self._src_index_value,
            self._dest_index_value,
        )

FileRenameDetails_validator = bv.Struct(FileRenameDetails)

class FileRequestAddDeadlineDetails(object):
    """
    Added a deadline to a file request.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestAddDeadlineDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestAddDeadlineDetails_validator = bv.Struct(FileRequestAddDeadlineDetails)

class FileRequestChangeFolderDetails(object):
    """
    Changed the file request folder.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestChangeFolderDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestChangeFolderDetails_validator = bv.Struct(FileRequestChangeFolderDetails)

class FileRequestChangeTitleDetails(object):
    """
    Change the file request title.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestChangeTitleDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestChangeTitleDetails_validator = bv.Struct(FileRequestChangeTitleDetails)

class FileRequestCloseDetails(object):
    """
    Closed a file request.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestCloseDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestCloseDetails_validator = bv.Struct(FileRequestCloseDetails)

class FileRequestCreateDetails(object):
    """
    Created a file request.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestCreateDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestCreateDetails_validator = bv.Struct(FileRequestCreateDetails)

class FileRequestReceiveFileDetails(object):
    """
    Received files for a file request.

    :ivar request_title: File request title.
    :ivar submitted_file_names: Submitted file names.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
        '_submitted_file_names_value',
        '_submitted_file_names_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None,
                 submitted_file_names=None):
        self._request_title_value = None
        self._request_title_present = False
        self._submitted_file_names_value = None
        self._submitted_file_names_present = False
        if request_title is not None:
            self.request_title = request_title
        if submitted_file_names is not None:
            self.submitted_file_names = submitted_file_names

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    @property
    def submitted_file_names(self):
        """
        Submitted file names.

        :rtype: list of [str]
        """
        if self._submitted_file_names_present:
            return self._submitted_file_names_value
        else:
            raise AttributeError("missing required field 'submitted_file_names'")

    @submitted_file_names.setter
    def submitted_file_names(self, val):
        val = self._submitted_file_names_validator.validate(val)
        self._submitted_file_names_value = val
        self._submitted_file_names_present = True

    @submitted_file_names.deleter
    def submitted_file_names(self):
        self._submitted_file_names_value = None
        self._submitted_file_names_present = False

    def __repr__(self):
        return 'FileRequestReceiveFileDetails(request_title={!r}, submitted_file_names={!r})'.format(
            self._request_title_value,
            self._submitted_file_names_value,
        )

FileRequestReceiveFileDetails_validator = bv.Struct(FileRequestReceiveFileDetails)

class FileRequestRemoveDeadlineDetails(object):
    """
    Removed the file request deadline.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestRemoveDeadlineDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestRemoveDeadlineDetails_validator = bv.Struct(FileRequestRemoveDeadlineDetails)

class FileRequestSendDetails(object):
    """
    Sent file request to users via email.

    :ivar request_title: File request title.
    """

    __slots__ = [
        '_request_title_value',
        '_request_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 request_title=None):
        self._request_title_value = None
        self._request_title_present = False
        if request_title is not None:
            self.request_title = request_title

    @property
    def request_title(self):
        """
        File request title.

        :rtype: str
        """
        if self._request_title_present:
            return self._request_title_value
        else:
            raise AttributeError("missing required field 'request_title'")

    @request_title.setter
    def request_title(self, val):
        val = self._request_title_validator.validate(val)
        self._request_title_value = val
        self._request_title_present = True

    @request_title.deleter
    def request_title(self):
        self._request_title_value = None
        self._request_title_present = False

    def __repr__(self):
        return 'FileRequestSendDetails(request_title={!r})'.format(
            self._request_title_value,
        )

FileRequestSendDetails_validator = bv.Struct(FileRequestSendDetails)

class FileRequestsChangePolicyDetails(object):
    """
    Enabled or disabled file requests.

    :ivar new_value: New file requests policy.
    :ivar previous_value: Previous file requests policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New file requests policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous file requests policy. Might be missing due to historical data
        gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'FileRequestsChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

FileRequestsChangePolicyDetails_validator = bv.Struct(FileRequestsChangePolicyDetails)

class FileRequestsEmailsEnabledDetails(object):
    """
    Enabled file request emails for everyone.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileRequestsEmailsEnabledDetails()'

FileRequestsEmailsEnabledDetails_validator = bv.Struct(FileRequestsEmailsEnabledDetails)

class FileRequestsEmailsRestrictedToTeamOnlyDetails(object):
    """
    Allowed file request emails for the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileRequestsEmailsRestrictedToTeamOnlyDetails()'

FileRequestsEmailsRestrictedToTeamOnlyDetails_validator = bv.Struct(FileRequestsEmailsRestrictedToTeamOnlyDetails)

class FileRestoreDetails(object):
    """
    Restored deleted files and/or folders.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileRestoreDetails()'

FileRestoreDetails_validator = bv.Struct(FileRestoreDetails)

class FileRevertDetails(object):
    """
    Reverted files to a previous version.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileRevertDetails()'

FileRevertDetails_validator = bv.Struct(FileRevertDetails)

class FileRollbackChangesDetails(object):
    """
    Rolled back file change location changes.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'FileRollbackChangesDetails()'

FileRollbackChangesDetails_validator = bv.Struct(FileRollbackChangesDetails)

class FileSaveCopyReferenceDetails(object):
    """
    Save a file or folder using a copy reference.

    :ivar src_index: Source asset index.
    :ivar dest_index: Destination asset index.
    """

    __slots__ = [
        '_src_index_value',
        '_src_index_present',
        '_dest_index_value',
        '_dest_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 src_index=None,
                 dest_index=None):
        self._src_index_value = None
        self._src_index_present = False
        self._dest_index_value = None
        self._dest_index_present = False
        if src_index is not None:
            self.src_index = src_index
        if dest_index is not None:
            self.dest_index = dest_index

    @property
    def src_index(self):
        """
        Source asset index.

        :rtype: long
        """
        if self._src_index_present:
            return self._src_index_value
        else:
            raise AttributeError("missing required field 'src_index'")

    @src_index.setter
    def src_index(self, val):
        val = self._src_index_validator.validate(val)
        self._src_index_value = val
        self._src_index_present = True

    @src_index.deleter
    def src_index(self):
        self._src_index_value = None
        self._src_index_present = False

    @property
    def dest_index(self):
        """
        Destination asset index.

        :rtype: long
        """
        if self._dest_index_present:
            return self._dest_index_value
        else:
            raise AttributeError("missing required field 'dest_index'")

    @dest_index.setter
    def dest_index(self, val):
        val = self._dest_index_validator.validate(val)
        self._dest_index_value = val
        self._dest_index_present = True

    @dest_index.deleter
    def dest_index(self):
        self._dest_index_value = None
        self._dest_index_present = False

    def __repr__(self):
        return 'FileSaveCopyReferenceDetails(src_index={!r}, dest_index={!r})'.format(
            self._src_index_value,
            self._dest_index_value,
        )

FileSaveCopyReferenceDetails_validator = bv.Struct(FileSaveCopyReferenceDetails)

class FileUnlikeCommentDetails(object):
    """
    Unliked a file comment.

    :ivar target_index: Target asset index.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 comment_text=None):
        self._target_index_value = None
        self._target_index_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if target_index is not None:
            self.target_index = target_index
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'FileUnlikeCommentDetails(target_index={!r}, comment_text={!r})'.format(
            self._target_index_value,
            self._comment_text_value,
        )

FileUnlikeCommentDetails_validator = bv.Struct(FileUnlikeCommentDetails)

class FolderLogInfo(FileOrFolderLogInfo):
    """
    Folder's logged information.
    """

    __slots__ = [
    ]

    _has_required_fields = True

    def __init__(self,
                 path=None,
                 display_name=None,
                 file_id=None):
        super(FolderLogInfo, self).__init__(path,
                                            display_name,
                                            file_id)

    def __repr__(self):
        return 'FolderLogInfo(path={!r}, display_name={!r}, file_id={!r})'.format(
            self._path_value,
            self._display_name_value,
            self._file_id_value,
        )

FolderLogInfo_validator = bv.Struct(FolderLogInfo)

class GeoLocationLogInfo(object):
    """
    Geographic location details.

    :ivar city: City name.
    :ivar region: Region name.
    :ivar country: Country code.
    :ivar ip_address: IP address.
    """

    __slots__ = [
        '_city_value',
        '_city_present',
        '_region_value',
        '_region_present',
        '_country_value',
        '_country_present',
        '_ip_address_value',
        '_ip_address_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 ip_address=None,
                 city=None,
                 region=None,
                 country=None):
        self._city_value = None
        self._city_present = False
        self._region_value = None
        self._region_present = False
        self._country_value = None
        self._country_present = False
        self._ip_address_value = None
        self._ip_address_present = False
        if city is not None:
            self.city = city
        if region is not None:
            self.region = region
        if country is not None:
            self.country = country
        if ip_address is not None:
            self.ip_address = ip_address

    @property
    def city(self):
        """
        City name.

        :rtype: str
        """
        if self._city_present:
            return self._city_value
        else:
            return None

    @city.setter
    def city(self, val):
        if val is None:
            del self.city
            return
        val = self._city_validator.validate(val)
        self._city_value = val
        self._city_present = True

    @city.deleter
    def city(self):
        self._city_value = None
        self._city_present = False

    @property
    def region(self):
        """
        Region name.

        :rtype: str
        """
        if self._region_present:
            return self._region_value
        else:
            return None

    @region.setter
    def region(self, val):
        if val is None:
            del self.region
            return
        val = self._region_validator.validate(val)
        self._region_value = val
        self._region_present = True

    @region.deleter
    def region(self):
        self._region_value = None
        self._region_present = False

    @property
    def country(self):
        """
        Country code.

        :rtype: str
        """
        if self._country_present:
            return self._country_value
        else:
            return None

    @country.setter
    def country(self, val):
        if val is None:
            del self.country
            return
        val = self._country_validator.validate(val)
        self._country_value = val
        self._country_present = True

    @country.deleter
    def country(self):
        self._country_value = None
        self._country_present = False

    @property
    def ip_address(self):
        """
        IP address.

        :rtype: str
        """
        if self._ip_address_present:
            return self._ip_address_value
        else:
            raise AttributeError("missing required field 'ip_address'")

    @ip_address.setter
    def ip_address(self, val):
        val = self._ip_address_validator.validate(val)
        self._ip_address_value = val
        self._ip_address_present = True

    @ip_address.deleter
    def ip_address(self):
        self._ip_address_value = None
        self._ip_address_present = False

    def __repr__(self):
        return 'GeoLocationLogInfo(ip_address={!r}, city={!r}, region={!r}, country={!r})'.format(
            self._ip_address_value,
            self._city_value,
            self._region_value,
            self._country_value,
        )

GeoLocationLogInfo_validator = bv.Struct(GeoLocationLogInfo)

class GetTeamEventsArg(object):
    """
    :ivar limit: Number of results to return per call.
    :ivar account_id: Filter the events by account ID. Return ony events with
        this account_id as either Actor, Context, or Participants.
    :ivar time: Filter by time range.
    """

    __slots__ = [
        '_limit_value',
        '_limit_present',
        '_account_id_value',
        '_account_id_present',
        '_time_value',
        '_time_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 limit=None,
                 account_id=None,
                 time=None):
        self._limit_value = None
        self._limit_present = False
        self._account_id_value = None
        self._account_id_present = False
        self._time_value = None
        self._time_present = False
        if limit is not None:
            self.limit = limit
        if account_id is not None:
            self.account_id = account_id
        if time is not None:
            self.time = time

    @property
    def limit(self):
        """
        Number of results to return per call.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    @property
    def account_id(self):
        """
        Filter the events by account ID. Return ony events with this account_id
        as either Actor, Context, or Participants.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            return None

    @account_id.setter
    def account_id(self, val):
        if val is None:
            del self.account_id
            return
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def time(self):
        """
        Filter by time range.

        :rtype: team_common.TimeRange_validator
        """
        if self._time_present:
            return self._time_value
        else:
            return None

    @time.setter
    def time(self, val):
        if val is None:
            del self.time
            return
        self._time_validator.validate_type_only(val)
        self._time_value = val
        self._time_present = True

    @time.deleter
    def time(self):
        self._time_value = None
        self._time_present = False

    def __repr__(self):
        return 'GetTeamEventsArg(limit={!r}, account_id={!r}, time={!r})'.format(
            self._limit_value,
            self._account_id_value,
            self._time_value,
        )

GetTeamEventsArg_validator = bv.Struct(GetTeamEventsArg)

class GetTeamEventsContinueArg(object):
    """
    :ivar cursor: Indicates from what point to get the next set of events.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        Indicates from what point to get the next set of events.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def __repr__(self):
        return 'GetTeamEventsContinueArg(cursor={!r})'.format(
            self._cursor_value,
        )

GetTeamEventsContinueArg_validator = bv.Struct(GetTeamEventsContinueArg)

class GetTeamEventsContinueError(bb.Union):
    """
    Errors that can be raised when calling
    :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue`.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar bad_cursor: Bad cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    bad_cursor = None
    # Attribute is overwritten below the class definition
    other = None

    def is_bad_cursor(self):
        """
        Check if the union tag is ``bad_cursor``.

        :rtype: bool
        """
        return self._tag == 'bad_cursor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GetTeamEventsContinueError(%r, %r)' % (self._tag, self._value)

GetTeamEventsContinueError_validator = bv.Union(GetTeamEventsContinueError)

class GetTeamEventsError(bb.Union):
    """
    Errors that can be raised when calling
    :meth:`dropbox.dropbox.Dropbox.team_log_get_events`.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar account_id_not_found: No user found matching the provided account_id.
    :ivar invalid_time_range: Invalid time range.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    account_id_not_found = None
    # Attribute is overwritten below the class definition
    invalid_time_range = None
    # Attribute is overwritten below the class definition
    other = None

    def is_account_id_not_found(self):
        """
        Check if the union tag is ``account_id_not_found``.

        :rtype: bool
        """
        return self._tag == 'account_id_not_found'

    def is_invalid_time_range(self):
        """
        Check if the union tag is ``invalid_time_range``.

        :rtype: bool
        """
        return self._tag == 'invalid_time_range'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GetTeamEventsError(%r, %r)' % (self._tag, self._value)

GetTeamEventsError_validator = bv.Union(GetTeamEventsError)

class GetTeamEventsResult(object):
    """
    :ivar events: List of events.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` to obtain
        additional events.
    :ivar has_more: Is true if there are additional events that have not been
        returned yet. An additional call to
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` can
        retrieve them.
    """

    __slots__ = [
        '_events_value',
        '_events_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 events=None,
                 cursor=None,
                 has_more=None):
        self._events_value = None
        self._events_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if events is not None:
            self.events = events
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def events(self):
        """
        List of events.

        :rtype: list of [TeamEvent]
        """
        if self._events_present:
            return self._events_value
        else:
            raise AttributeError("missing required field 'events'")

    @events.setter
    def events(self, val):
        val = self._events_validator.validate(val)
        self._events_value = val
        self._events_present = True

    @events.deleter
    def events(self):
        self._events_value = None
        self._events_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` to obtain
        additional events.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        Is true if there are additional events that have not been returned yet.
        An additional call to
        :meth:`dropbox.dropbox.Dropbox.team_log_get_events_continue` can
        retrieve them.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def __repr__(self):
        return 'GetTeamEventsResult(events={!r}, cursor={!r}, has_more={!r})'.format(
            self._events_value,
            self._cursor_value,
            self._has_more_value,
        )

GetTeamEventsResult_validator = bv.Struct(GetTeamEventsResult)

class GoogleSsoChangePolicyDetails(object):
    """
    Enabled or disabled Google single sign-on for the team.

    :ivar new_value: New Google single sign-on policy.
    :ivar previous_value: Previous Google single sign-on policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New Google single sign-on policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous Google single sign-on policy. Might be missing due to
        historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'GoogleSsoChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

GoogleSsoChangePolicyDetails_validator = bv.Struct(GoogleSsoChangePolicyDetails)

class GroupAddExternalIdDetails(object):
    """
    Added an external ID for group.

    :ivar group_info: Group details.
    :ivar new_value: Current external id.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_new_value_value',
        '_new_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 new_value=None):
        self._group_info_value = None
        self._group_info_present = False
        self._new_value_value = None
        self._new_value_present = False
        if group_info is not None:
            self.group_info = group_info
        if new_value is not None:
            self.new_value = new_value

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def new_value(self):
        """
        Current external id.

        :rtype: str
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        val = self._new_value_validator.validate(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    def __repr__(self):
        return 'GroupAddExternalIdDetails(group_info={!r}, new_value={!r})'.format(
            self._group_info_value,
            self._new_value_value,
        )

GroupAddExternalIdDetails_validator = bv.Struct(GroupAddExternalIdDetails)

class GroupAddMemberDetails(object):
    """
    Added team members to a group.

    :ivar group_info: Group details.
    :ivar is_group_owner: Is group owner.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_is_group_owner_value',
        '_is_group_owner_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 is_group_owner=None):
        self._group_info_value = None
        self._group_info_present = False
        self._is_group_owner_value = None
        self._is_group_owner_present = False
        if group_info is not None:
            self.group_info = group_info
        if is_group_owner is not None:
            self.is_group_owner = is_group_owner

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def is_group_owner(self):
        """
        Is group owner.

        :rtype: bool
        """
        if self._is_group_owner_present:
            return self._is_group_owner_value
        else:
            raise AttributeError("missing required field 'is_group_owner'")

    @is_group_owner.setter
    def is_group_owner(self, val):
        val = self._is_group_owner_validator.validate(val)
        self._is_group_owner_value = val
        self._is_group_owner_present = True

    @is_group_owner.deleter
    def is_group_owner(self):
        self._is_group_owner_value = None
        self._is_group_owner_present = False

    def __repr__(self):
        return 'GroupAddMemberDetails(group_info={!r}, is_group_owner={!r})'.format(
            self._group_info_value,
            self._is_group_owner_value,
        )

GroupAddMemberDetails_validator = bv.Struct(GroupAddMemberDetails)

class GroupChangeExternalIdDetails(object):
    """
    Changed the external ID for group.

    :ivar group_info: Group details.
    :ivar new_value: Current external id.
    :ivar previous_value: Old external id.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 new_value=None,
                 previous_value=None):
        self._group_info_value = None
        self._group_info_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if group_info is not None:
            self.group_info = group_info
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def new_value(self):
        """
        Current external id.

        :rtype: str
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        val = self._new_value_validator.validate(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Old external id.

        :rtype: str
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        val = self._previous_value_validator.validate(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'GroupChangeExternalIdDetails(group_info={!r}, new_value={!r}, previous_value={!r})'.format(
            self._group_info_value,
            self._new_value_value,
            self._previous_value_value,
        )

GroupChangeExternalIdDetails_validator = bv.Struct(GroupChangeExternalIdDetails)

class GroupChangeManagementTypeDetails(object):
    """
    Changed group management type.

    :ivar group_info: Group details.
    :ivar new_value: New group management type.
    :ivar previous_value: Previous group management type. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 new_value=None,
                 previous_value=None):
        self._group_info_value = None
        self._group_info_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if group_info is not None:
            self.group_info = group_info
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def new_value(self):
        """
        New group management type.

        :rtype: GroupManagementType
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous group management type. Might be missing due to historical data
        gap.

        :rtype: GroupManagementType
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'GroupChangeManagementTypeDetails(group_info={!r}, new_value={!r}, previous_value={!r})'.format(
            self._group_info_value,
            self._new_value_value,
            self._previous_value_value,
        )

GroupChangeManagementTypeDetails_validator = bv.Struct(GroupChangeManagementTypeDetails)

class GroupChangeMemberRoleDetails(object):
    """
    Changed the manager permissions belonging to a group member.

    :ivar group_info: Group details.
    :ivar is_group_owner: Is group owner.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_is_group_owner_value',
        '_is_group_owner_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 is_group_owner=None):
        self._group_info_value = None
        self._group_info_present = False
        self._is_group_owner_value = None
        self._is_group_owner_present = False
        if group_info is not None:
            self.group_info = group_info
        if is_group_owner is not None:
            self.is_group_owner = is_group_owner

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def is_group_owner(self):
        """
        Is group owner.

        :rtype: bool
        """
        if self._is_group_owner_present:
            return self._is_group_owner_value
        else:
            raise AttributeError("missing required field 'is_group_owner'")

    @is_group_owner.setter
    def is_group_owner(self, val):
        val = self._is_group_owner_validator.validate(val)
        self._is_group_owner_value = val
        self._is_group_owner_present = True

    @is_group_owner.deleter
    def is_group_owner(self):
        self._is_group_owner_value = None
        self._is_group_owner_present = False

    def __repr__(self):
        return 'GroupChangeMemberRoleDetails(group_info={!r}, is_group_owner={!r})'.format(
            self._group_info_value,
            self._is_group_owner_value,
        )

GroupChangeMemberRoleDetails_validator = bv.Struct(GroupChangeMemberRoleDetails)

class GroupCreateDetails(object):
    """
    Created a group.

    :ivar group_info: Group details.
    :ivar is_admin_managed: Is admin managed group. Might be missing due to
        historical data gap.
    :ivar join_policy: Group join policy.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_is_admin_managed_value',
        '_is_admin_managed_present',
        '_join_policy_value',
        '_join_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 join_policy=None,
                 is_admin_managed=None):
        self._group_info_value = None
        self._group_info_present = False
        self._is_admin_managed_value = None
        self._is_admin_managed_present = False
        self._join_policy_value = None
        self._join_policy_present = False
        if group_info is not None:
            self.group_info = group_info
        if is_admin_managed is not None:
            self.is_admin_managed = is_admin_managed
        if join_policy is not None:
            self.join_policy = join_policy

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def is_admin_managed(self):
        """
        Is admin managed group. Might be missing due to historical data gap.

        :rtype: bool
        """
        if self._is_admin_managed_present:
            return self._is_admin_managed_value
        else:
            return None

    @is_admin_managed.setter
    def is_admin_managed(self, val):
        if val is None:
            del self.is_admin_managed
            return
        val = self._is_admin_managed_validator.validate(val)
        self._is_admin_managed_value = val
        self._is_admin_managed_present = True

    @is_admin_managed.deleter
    def is_admin_managed(self):
        self._is_admin_managed_value = None
        self._is_admin_managed_present = False

    @property
    def join_policy(self):
        """
        Group join policy.

        :rtype: GroupJoinPolicy
        """
        if self._join_policy_present:
            return self._join_policy_value
        else:
            raise AttributeError("missing required field 'join_policy'")

    @join_policy.setter
    def join_policy(self, val):
        self._join_policy_validator.validate_type_only(val)
        self._join_policy_value = val
        self._join_policy_present = True

    @join_policy.deleter
    def join_policy(self):
        self._join_policy_value = None
        self._join_policy_present = False

    def __repr__(self):
        return 'GroupCreateDetails(group_info={!r}, join_policy={!r}, is_admin_managed={!r})'.format(
            self._group_info_value,
            self._join_policy_value,
            self._is_admin_managed_value,
        )

GroupCreateDetails_validator = bv.Struct(GroupCreateDetails)

class GroupDeleteDetails(object):
    """
    Deleted a group.

    :ivar group_info: Group details.
    :ivar is_admin_managed: Is admin managed group. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_is_admin_managed_value',
        '_is_admin_managed_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 is_admin_managed=None):
        self._group_info_value = None
        self._group_info_present = False
        self._is_admin_managed_value = None
        self._is_admin_managed_present = False
        if group_info is not None:
            self.group_info = group_info
        if is_admin_managed is not None:
            self.is_admin_managed = is_admin_managed

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def is_admin_managed(self):
        """
        Is admin managed group. Might be missing due to historical data gap.

        :rtype: bool
        """
        if self._is_admin_managed_present:
            return self._is_admin_managed_value
        else:
            return None

    @is_admin_managed.setter
    def is_admin_managed(self, val):
        if val is None:
            del self.is_admin_managed
            return
        val = self._is_admin_managed_validator.validate(val)
        self._is_admin_managed_value = val
        self._is_admin_managed_present = True

    @is_admin_managed.deleter
    def is_admin_managed(self):
        self._is_admin_managed_value = None
        self._is_admin_managed_present = False

    def __repr__(self):
        return 'GroupDeleteDetails(group_info={!r}, is_admin_managed={!r})'.format(
            self._group_info_value,
            self._is_admin_managed_value,
        )

GroupDeleteDetails_validator = bv.Struct(GroupDeleteDetails)

class GroupDescriptionUpdatedDetails(object):
    """
    Updated a group.

    :ivar group_info: Group details.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None):
        self._group_info_value = None
        self._group_info_present = False
        if group_info is not None:
            self.group_info = group_info

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    def __repr__(self):
        return 'GroupDescriptionUpdatedDetails(group_info={!r})'.format(
            self._group_info_value,
        )

GroupDescriptionUpdatedDetails_validator = bv.Struct(GroupDescriptionUpdatedDetails)

class GroupJoinPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    open = None
    # Attribute is overwritten below the class definition
    request_to_join = None
    # Attribute is overwritten below the class definition
    other = None

    def is_open(self):
        """
        Check if the union tag is ``open``.

        :rtype: bool
        """
        return self._tag == 'open'

    def is_request_to_join(self):
        """
        Check if the union tag is ``request_to_join``.

        :rtype: bool
        """
        return self._tag == 'request_to_join'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GroupJoinPolicy(%r, %r)' % (self._tag, self._value)

GroupJoinPolicy_validator = bv.Union(GroupJoinPolicy)

class GroupJoinPolicyUpdatedDetails(object):
    """
    Updated a group join policy.

    :ivar group_info: Group details.
    :ivar is_admin_managed: Is admin managed group. Might be missing due to
        historical data gap.
    :ivar join_policy: Group join policy.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_is_admin_managed_value',
        '_is_admin_managed_present',
        '_join_policy_value',
        '_join_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 join_policy=None,
                 is_admin_managed=None):
        self._group_info_value = None
        self._group_info_present = False
        self._is_admin_managed_value = None
        self._is_admin_managed_present = False
        self._join_policy_value = None
        self._join_policy_present = False
        if group_info is not None:
            self.group_info = group_info
        if is_admin_managed is not None:
            self.is_admin_managed = is_admin_managed
        if join_policy is not None:
            self.join_policy = join_policy

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def is_admin_managed(self):
        """
        Is admin managed group. Might be missing due to historical data gap.

        :rtype: bool
        """
        if self._is_admin_managed_present:
            return self._is_admin_managed_value
        else:
            return None

    @is_admin_managed.setter
    def is_admin_managed(self, val):
        if val is None:
            del self.is_admin_managed
            return
        val = self._is_admin_managed_validator.validate(val)
        self._is_admin_managed_value = val
        self._is_admin_managed_present = True

    @is_admin_managed.deleter
    def is_admin_managed(self):
        self._is_admin_managed_value = None
        self._is_admin_managed_present = False

    @property
    def join_policy(self):
        """
        Group join policy.

        :rtype: GroupJoinPolicy
        """
        if self._join_policy_present:
            return self._join_policy_value
        else:
            raise AttributeError("missing required field 'join_policy'")

    @join_policy.setter
    def join_policy(self, val):
        self._join_policy_validator.validate_type_only(val)
        self._join_policy_value = val
        self._join_policy_present = True

    @join_policy.deleter
    def join_policy(self):
        self._join_policy_value = None
        self._join_policy_present = False

    def __repr__(self):
        return 'GroupJoinPolicyUpdatedDetails(group_info={!r}, join_policy={!r}, is_admin_managed={!r})'.format(
            self._group_info_value,
            self._join_policy_value,
            self._is_admin_managed_value,
        )

GroupJoinPolicyUpdatedDetails_validator = bv.Struct(GroupJoinPolicyUpdatedDetails)

class GroupLogInfo(object):
    """
    Group's logged information.

    :ivar group_id: The unique id of this group. Might be missing due to
        historical data gap.
    :ivar display_name: The name of this group.
    :ivar external_id: External group ID. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_group_id_value',
        '_group_id_present',
        '_display_name_value',
        '_display_name_present',
        '_external_id_value',
        '_external_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 display_name=None,
                 group_id=None,
                 external_id=None):
        self._group_id_value = None
        self._group_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._external_id_value = None
        self._external_id_present = False
        if group_id is not None:
            self.group_id = group_id
        if display_name is not None:
            self.display_name = display_name
        if external_id is not None:
            self.external_id = external_id

    @property
    def group_id(self):
        """
        The unique id of this group. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._group_id_present:
            return self._group_id_value
        else:
            return None

    @group_id.setter
    def group_id(self, val):
        if val is None:
            del self.group_id
            return
        val = self._group_id_validator.validate(val)
        self._group_id_value = val
        self._group_id_present = True

    @group_id.deleter
    def group_id(self):
        self._group_id_value = None
        self._group_id_present = False

    @property
    def display_name(self):
        """
        The name of this group.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            raise AttributeError("missing required field 'display_name'")

    @display_name.setter
    def display_name(self, val):
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def external_id(self):
        """
        External group ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._external_id_present:
            return self._external_id_value
        else:
            return None

    @external_id.setter
    def external_id(self, val):
        if val is None:
            del self.external_id
            return
        val = self._external_id_validator.validate(val)
        self._external_id_value = val
        self._external_id_present = True

    @external_id.deleter
    def external_id(self):
        self._external_id_value = None
        self._external_id_present = False

    def __repr__(self):
        return 'GroupLogInfo(display_name={!r}, group_id={!r}, external_id={!r})'.format(
            self._display_name_value,
            self._group_id_value,
            self._external_id_value,
        )

GroupLogInfo_validator = bv.Struct(GroupLogInfo)

class GroupManagementType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    admin_management_group = None
    # Attribute is overwritten below the class definition
    member_management_group = None
    # Attribute is overwritten below the class definition
    other = None

    def is_admin_management_group(self):
        """
        Check if the union tag is ``admin_management_group``.

        :rtype: bool
        """
        return self._tag == 'admin_management_group'

    def is_member_management_group(self):
        """
        Check if the union tag is ``member_management_group``.

        :rtype: bool
        """
        return self._tag == 'member_management_group'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GroupManagementType(%r, %r)' % (self._tag, self._value)

GroupManagementType_validator = bv.Union(GroupManagementType)

class GroupMovedDetails(object):
    """
    Moved a group.

    :ivar group_info: Group details.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None):
        self._group_info_value = None
        self._group_info_present = False
        if group_info is not None:
            self.group_info = group_info

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    def __repr__(self):
        return 'GroupMovedDetails(group_info={!r})'.format(
            self._group_info_value,
        )

GroupMovedDetails_validator = bv.Struct(GroupMovedDetails)

class GroupRemoveExternalIdDetails(object):
    """
    Removed the external ID for group.

    :ivar group_info: Group details.
    :ivar previous_value: Old external id.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 previous_value=None):
        self._group_info_value = None
        self._group_info_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if group_info is not None:
            self.group_info = group_info
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def previous_value(self):
        """
        Old external id.

        :rtype: str
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        val = self._previous_value_validator.validate(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'GroupRemoveExternalIdDetails(group_info={!r}, previous_value={!r})'.format(
            self._group_info_value,
            self._previous_value_value,
        )

GroupRemoveExternalIdDetails_validator = bv.Struct(GroupRemoveExternalIdDetails)

class GroupRemoveMemberDetails(object):
    """
    Removed team members from a group.

    :ivar group_info: Group details.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None):
        self._group_info_value = None
        self._group_info_present = False
        if group_info is not None:
            self.group_info = group_info

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    def __repr__(self):
        return 'GroupRemoveMemberDetails(group_info={!r})'.format(
            self._group_info_value,
        )

GroupRemoveMemberDetails_validator = bv.Struct(GroupRemoveMemberDetails)

class GroupRenameDetails(object):
    """
    Renamed a group.

    :ivar group_info: Group details.
    :ivar previous_value: Previous display name.
    """

    __slots__ = [
        '_group_info_value',
        '_group_info_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 group_info=None,
                 previous_value=None):
        self._group_info_value = None
        self._group_info_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if group_info is not None:
            self.group_info = group_info
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def group_info(self):
        """
        Group details.

        :rtype: GroupLogInfo
        """
        if self._group_info_present:
            return self._group_info_value
        else:
            raise AttributeError("missing required field 'group_info'")

    @group_info.setter
    def group_info(self, val):
        self._group_info_validator.validate_type_only(val)
        self._group_info_value = val
        self._group_info_present = True

    @group_info.deleter
    def group_info(self):
        self._group_info_value = None
        self._group_info_present = False

    @property
    def previous_value(self):
        """
        Previous display name.

        :rtype: str
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        val = self._previous_value_validator.validate(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'GroupRenameDetails(group_info={!r}, previous_value={!r})'.format(
            self._group_info_value,
            self._previous_value_value,
        )

GroupRenameDetails_validator = bv.Struct(GroupRenameDetails)

class GroupUserManagementChangePolicyDetails(object):
    """
    Changed who can create groups.

    :ivar new_value: New group users management policy.
    :ivar previous_value: Previous group users management policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New group users management policy.

        :rtype: GroupsUserManagementPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous group users management policy. Might be missing due to
        historical data gap.

        :rtype: GroupsUserManagementPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'GroupUserManagementChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

GroupUserManagementChangePolicyDetails_validator = bv.Struct(GroupUserManagementChangePolicyDetails)

class GroupsUserManagementPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    all_users = None
    # Attribute is overwritten below the class definition
    only_admins = None
    # Attribute is overwritten below the class definition
    other = None

    def is_all_users(self):
        """
        Check if the union tag is ``all_users``.

        :rtype: bool
        """
        return self._tag == 'all_users'

    def is_only_admins(self):
        """
        Check if the union tag is ``only_admins``.

        :rtype: bool
        """
        return self._tag == 'only_admins'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'GroupsUserManagementPolicy(%r, %r)' % (self._tag, self._value)

GroupsUserManagementPolicy_validator = bv.Union(GroupsUserManagementPolicy)

class HostLogInfo(object):
    """
    Host details.

    :ivar host_id: Host ID. Might be missing due to historical data gap.
    :ivar host_name: Host name. Might be missing due to historical data gap.
    """

    __slots__ = [
        '_host_id_value',
        '_host_id_present',
        '_host_name_value',
        '_host_name_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 host_id=None,
                 host_name=None):
        self._host_id_value = None
        self._host_id_present = False
        self._host_name_value = None
        self._host_name_present = False
        if host_id is not None:
            self.host_id = host_id
        if host_name is not None:
            self.host_name = host_name

    @property
    def host_id(self):
        """
        Host ID. Might be missing due to historical data gap.

        :rtype: long
        """
        if self._host_id_present:
            return self._host_id_value
        else:
            return None

    @host_id.setter
    def host_id(self, val):
        if val is None:
            del self.host_id
            return
        val = self._host_id_validator.validate(val)
        self._host_id_value = val
        self._host_id_present = True

    @host_id.deleter
    def host_id(self):
        self._host_id_value = None
        self._host_id_present = False

    @property
    def host_name(self):
        """
        Host name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._host_name_present:
            return self._host_name_value
        else:
            return None

    @host_name.setter
    def host_name(self, val):
        if val is None:
            del self.host_name
            return
        val = self._host_name_validator.validate(val)
        self._host_name_value = val
        self._host_name_present = True

    @host_name.deleter
    def host_name(self):
        self._host_name_value = None
        self._host_name_present = False

    def __repr__(self):
        return 'HostLogInfo(host_id={!r}, host_name={!r})'.format(
            self._host_id_value,
            self._host_name_value,
        )

HostLogInfo_validator = bv.Struct(HostLogInfo)

class LinkAudience(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    public = None
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    members = None
    # Attribute is overwritten below the class definition
    other = None

    def is_public(self):
        """
        Check if the union tag is ``public``.

        :rtype: bool
        """
        return self._tag == 'public'

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_members(self):
        """
        Check if the union tag is ``members``.

        :rtype: bool
        """
        return self._tag == 'members'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'LinkAudience(%r, %r)' % (self._tag, self._value)

LinkAudience_validator = bv.Union(LinkAudience)

class LogoutDetails(object):
    """
    Signed out.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'LogoutDetails()'

LogoutDetails_validator = bv.Struct(LogoutDetails)

class MemberAddNameDetails(object):
    """
    Set team member name when joining team.

    :ivar new_value: User's name.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None):
        self._new_value_value = None
        self._new_value_present = False
        if new_value is not None:
            self.new_value = new_value

    @property
    def new_value(self):
        """
        User's name.

        :rtype: UserNameLogInfo
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    def __repr__(self):
        return 'MemberAddNameDetails(new_value={!r})'.format(
            self._new_value_value,
        )

MemberAddNameDetails_validator = bv.Struct(MemberAddNameDetails)

class MemberChangeEmailDetails(object):
    """
    Changed team member email address.

    :ivar new_value: New email.
    :ivar previous_value: Previous email. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New email.

        :rtype: str
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        val = self._new_value_validator.validate(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous email. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        val = self._previous_value_validator.validate(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'MemberChangeEmailDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

MemberChangeEmailDetails_validator = bv.Struct(MemberChangeEmailDetails)

class MemberChangeMembershipTypeDetails(object):
    """
    Changed the membership type (limited vs full) for team member.

    :ivar prev_membership_type: Previous membership type.
    :ivar new_membership_type: New membership type.
    """

    __slots__ = [
        '_prev_membership_type_value',
        '_prev_membership_type_present',
        '_new_membership_type_value',
        '_new_membership_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 prev_membership_type=None,
                 new_membership_type=None):
        self._prev_membership_type_value = None
        self._prev_membership_type_present = False
        self._new_membership_type_value = None
        self._new_membership_type_present = False
        if prev_membership_type is not None:
            self.prev_membership_type = prev_membership_type
        if new_membership_type is not None:
            self.new_membership_type = new_membership_type

    @property
    def prev_membership_type(self):
        """
        Previous membership type.

        :rtype: long
        """
        if self._prev_membership_type_present:
            return self._prev_membership_type_value
        else:
            raise AttributeError("missing required field 'prev_membership_type'")

    @prev_membership_type.setter
    def prev_membership_type(self, val):
        val = self._prev_membership_type_validator.validate(val)
        self._prev_membership_type_value = val
        self._prev_membership_type_present = True

    @prev_membership_type.deleter
    def prev_membership_type(self):
        self._prev_membership_type_value = None
        self._prev_membership_type_present = False

    @property
    def new_membership_type(self):
        """
        New membership type.

        :rtype: long
        """
        if self._new_membership_type_present:
            return self._new_membership_type_value
        else:
            raise AttributeError("missing required field 'new_membership_type'")

    @new_membership_type.setter
    def new_membership_type(self, val):
        val = self._new_membership_type_validator.validate(val)
        self._new_membership_type_value = val
        self._new_membership_type_present = True

    @new_membership_type.deleter
    def new_membership_type(self):
        self._new_membership_type_value = None
        self._new_membership_type_present = False

    def __repr__(self):
        return 'MemberChangeMembershipTypeDetails(prev_membership_type={!r}, new_membership_type={!r})'.format(
            self._prev_membership_type_value,
            self._new_membership_type_value,
        )

MemberChangeMembershipTypeDetails_validator = bv.Struct(MemberChangeMembershipTypeDetails)

class MemberChangeNameDetails(object):
    """
    Changed team member name.

    :ivar new_value: New user's name.
    :ivar previous_value: Previous user's name.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New user's name.

        :rtype: UserNameLogInfo
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous user's name.

        :rtype: UserNameLogInfo
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'MemberChangeNameDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

MemberChangeNameDetails_validator = bv.Struct(MemberChangeNameDetails)

class MemberChangeRoleDetails(object):
    """
    Change the admin permissions belonging to team member.

    :ivar new_value: New admin role. Might be missing due to historical data
        gap.
    :ivar previous_value: Previous admin role. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New admin role. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            return None

    @new_value.setter
    def new_value(self, val):
        if val is None:
            del self.new_value
            return
        val = self._new_value_validator.validate(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous admin role. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        val = self._previous_value_validator.validate(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'MemberChangeRoleDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

MemberChangeRoleDetails_validator = bv.Struct(MemberChangeRoleDetails)

class MemberInviteDetails(object):
    """
    Invited a user to join the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberInviteDetails()'

MemberInviteDetails_validator = bv.Struct(MemberInviteDetails)

class MemberJoinDetails(object):
    """
    Joined the team.

    :ivar linked_apps: Linked Applications.
    :ivar initial_shared_folders: Shared folders.
    :ivar linked_devices: Linked devices.
    """

    __slots__ = [
        '_linked_apps_value',
        '_linked_apps_present',
        '_initial_shared_folders_value',
        '_initial_shared_folders_present',
        '_linked_devices_value',
        '_linked_devices_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 linked_apps=None,
                 initial_shared_folders=None,
                 linked_devices=None):
        self._linked_apps_value = None
        self._linked_apps_present = False
        self._initial_shared_folders_value = None
        self._initial_shared_folders_present = False
        self._linked_devices_value = None
        self._linked_devices_present = False
        if linked_apps is not None:
            self.linked_apps = linked_apps
        if initial_shared_folders is not None:
            self.initial_shared_folders = initial_shared_folders
        if linked_devices is not None:
            self.linked_devices = linked_devices

    @property
    def linked_apps(self):
        """
        Linked Applications.

        :rtype: list of [AppLogInfo]
        """
        if self._linked_apps_present:
            return self._linked_apps_value
        else:
            raise AttributeError("missing required field 'linked_apps'")

    @linked_apps.setter
    def linked_apps(self, val):
        val = self._linked_apps_validator.validate(val)
        self._linked_apps_value = val
        self._linked_apps_present = True

    @linked_apps.deleter
    def linked_apps(self):
        self._linked_apps_value = None
        self._linked_apps_present = False

    @property
    def initial_shared_folders(self):
        """
        Shared folders.

        :rtype: list of [SharedFolderLogInfo]
        """
        if self._initial_shared_folders_present:
            return self._initial_shared_folders_value
        else:
            raise AttributeError("missing required field 'initial_shared_folders'")

    @initial_shared_folders.setter
    def initial_shared_folders(self, val):
        val = self._initial_shared_folders_validator.validate(val)
        self._initial_shared_folders_value = val
        self._initial_shared_folders_present = True

    @initial_shared_folders.deleter
    def initial_shared_folders(self):
        self._initial_shared_folders_value = None
        self._initial_shared_folders_present = False

    @property
    def linked_devices(self):
        """
        Linked devices.

        :rtype: list of [DeviceLogInfo]
        """
        if self._linked_devices_present:
            return self._linked_devices_value
        else:
            raise AttributeError("missing required field 'linked_devices'")

    @linked_devices.setter
    def linked_devices(self, val):
        val = self._linked_devices_validator.validate(val)
        self._linked_devices_value = val
        self._linked_devices_present = True

    @linked_devices.deleter
    def linked_devices(self):
        self._linked_devices_value = None
        self._linked_devices_present = False

    def __repr__(self):
        return 'MemberJoinDetails(linked_apps={!r}, initial_shared_folders={!r}, linked_devices={!r})'.format(
            self._linked_apps_value,
            self._initial_shared_folders_value,
            self._linked_devices_value,
        )

MemberJoinDetails_validator = bv.Struct(MemberJoinDetails)

class MemberLeaveDetails(object):
    """
    Removed a team member.

    :ivar member_was_on_team: True if the member had joined the team before
        leaving, False otherwise.
    """

    __slots__ = [
        '_member_was_on_team_value',
        '_member_was_on_team_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 member_was_on_team=None):
        self._member_was_on_team_value = None
        self._member_was_on_team_present = False
        if member_was_on_team is not None:
            self.member_was_on_team = member_was_on_team

    @property
    def member_was_on_team(self):
        """
        True if the member had joined the team before leaving, False otherwise.

        :rtype: bool
        """
        if self._member_was_on_team_present:
            return self._member_was_on_team_value
        else:
            raise AttributeError("missing required field 'member_was_on_team'")

    @member_was_on_team.setter
    def member_was_on_team(self, val):
        val = self._member_was_on_team_validator.validate(val)
        self._member_was_on_team_value = val
        self._member_was_on_team_present = True

    @member_was_on_team.deleter
    def member_was_on_team(self):
        self._member_was_on_team_value = None
        self._member_was_on_team_present = False

    def __repr__(self):
        return 'MemberLeaveDetails(member_was_on_team={!r})'.format(
            self._member_was_on_team_value,
        )

MemberLeaveDetails_validator = bv.Struct(MemberLeaveDetails)

class MemberPermanentlyDeleteAccountContentsDetails(object):
    """
    Permanently deleted contents of a removed team member account.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberPermanentlyDeleteAccountContentsDetails()'

MemberPermanentlyDeleteAccountContentsDetails_validator = bv.Struct(MemberPermanentlyDeleteAccountContentsDetails)

class MemberRecoverDetails(object):
    """
    Recovered a removed member.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberRecoverDetails()'

MemberRecoverDetails_validator = bv.Struct(MemberRecoverDetails)

class MemberRequestsChangePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    require_approval = None
    # Attribute is overwritten below the class definition
    auto_approval = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_require_approval(self):
        """
        Check if the union tag is ``require_approval``.

        :rtype: bool
        """
        return self._tag == 'require_approval'

    def is_auto_approval(self):
        """
        Check if the union tag is ``auto_approval``.

        :rtype: bool
        """
        return self._tag == 'auto_approval'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'MemberRequestsChangePolicy(%r, %r)' % (self._tag, self._value)

MemberRequestsChangePolicy_validator = bv.Union(MemberRequestsChangePolicy)

class MemberRequestsChangePolicyDetails(object):
    """
    Changed whether users can find the team when not invited.

    :ivar new_value: New member change requests policy.
    :ivar previous_value: Previous member change requests policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New member change requests policy.

        :rtype: MemberRequestsChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous member change requests policy. Might be missing due to
        historical data gap.

        :rtype: MemberRequestsChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'MemberRequestsChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

MemberRequestsChangePolicyDetails_validator = bv.Struct(MemberRequestsChangePolicyDetails)

class MemberSpaceLimitsAddExceptionDetails(object):
    """
    Added an exception for one or more team members to bypass space limits
    imposed by policy.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberSpaceLimitsAddExceptionDetails()'

MemberSpaceLimitsAddExceptionDetails_validator = bv.Struct(MemberSpaceLimitsAddExceptionDetails)

class MemberSpaceLimitsChangePolicyDetails(object):
    """
    Changed the storage limits applied to team members by policy.

    :ivar previous_value: Previous storage limits policy.
    :ivar new_value: New storage limits policy.
    """

    __slots__ = [
        '_previous_value_value',
        '_previous_value_present',
        '_new_value_value',
        '_new_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_value=None,
                 new_value=None):
        self._previous_value_value = None
        self._previous_value_present = False
        self._new_value_value = None
        self._new_value_present = False
        if previous_value is not None:
            self.previous_value = previous_value
        if new_value is not None:
            self.new_value = new_value

    @property
    def previous_value(self):
        """
        Previous storage limits policy.

        :rtype: SpaceLimitsLevel
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            raise AttributeError("missing required field 'previous_value'")

    @previous_value.setter
    def previous_value(self, val):
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    @property
    def new_value(self):
        """
        New storage limits policy.

        :rtype: SpaceLimitsLevel
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    def __repr__(self):
        return 'MemberSpaceLimitsChangePolicyDetails(previous_value={!r}, new_value={!r})'.format(
            self._previous_value_value,
            self._new_value_value,
        )

MemberSpaceLimitsChangePolicyDetails_validator = bv.Struct(MemberSpaceLimitsChangePolicyDetails)

class MemberSpaceLimitsChangeStatusDetails(object):
    """
    Changed the status with respect to whether the team member is under or over
    storage quota specified by policy.

    :ivar previous_status: Previous storage quota status.
    :ivar new_status: New storage quota status.
    """

    __slots__ = [
        '_previous_status_value',
        '_previous_status_present',
        '_new_status_value',
        '_new_status_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_status=None,
                 new_status=None):
        self._previous_status_value = None
        self._previous_status_present = False
        self._new_status_value = None
        self._new_status_present = False
        if previous_status is not None:
            self.previous_status = previous_status
        if new_status is not None:
            self.new_status = new_status

    @property
    def previous_status(self):
        """
        Previous storage quota status.

        :rtype: SpaceLimitsStatus
        """
        if self._previous_status_present:
            return self._previous_status_value
        else:
            raise AttributeError("missing required field 'previous_status'")

    @previous_status.setter
    def previous_status(self, val):
        self._previous_status_validator.validate_type_only(val)
        self._previous_status_value = val
        self._previous_status_present = True

    @previous_status.deleter
    def previous_status(self):
        self._previous_status_value = None
        self._previous_status_present = False

    @property
    def new_status(self):
        """
        New storage quota status.

        :rtype: SpaceLimitsStatus
        """
        if self._new_status_present:
            return self._new_status_value
        else:
            raise AttributeError("missing required field 'new_status'")

    @new_status.setter
    def new_status(self, val):
        self._new_status_validator.validate_type_only(val)
        self._new_status_value = val
        self._new_status_present = True

    @new_status.deleter
    def new_status(self):
        self._new_status_value = None
        self._new_status_present = False

    def __repr__(self):
        return 'MemberSpaceLimitsChangeStatusDetails(previous_status={!r}, new_status={!r})'.format(
            self._previous_status_value,
            self._new_status_value,
        )

MemberSpaceLimitsChangeStatusDetails_validator = bv.Struct(MemberSpaceLimitsChangeStatusDetails)

class MemberSpaceLimitsRemoveExceptionDetails(object):
    """
    Removed an exception for one or more team members to bypass space limits
    imposed by policy.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberSpaceLimitsRemoveExceptionDetails()'

MemberSpaceLimitsRemoveExceptionDetails_validator = bv.Struct(MemberSpaceLimitsRemoveExceptionDetails)

class MemberSuggestDetails(object):
    """
    Suggested a new team member to be added to the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberSuggestDetails()'

MemberSuggestDetails_validator = bv.Struct(MemberSuggestDetails)

class MemberSuggestionsChangePolicyDetails(object):
    """
    Enabled or disabled the option for team members to suggest new members to
    add to the team.

    :ivar new_value: New team member suggestions policy.
    :ivar previous_value: Previous team member suggestions policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New team member suggestions policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous team member suggestions policy. Might be missing due to
        historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'MemberSuggestionsChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

MemberSuggestionsChangePolicyDetails_validator = bv.Struct(MemberSuggestionsChangePolicyDetails)

class MemberSuspendDetails(object):
    """
    Suspended a team member.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberSuspendDetails()'

MemberSuspendDetails_validator = bv.Struct(MemberSuspendDetails)

class MemberTransferAccountContentsDetails(object):
    """
    Transferred contents of a removed team member account to another member.

    :ivar src_index: Source asset index.
    :ivar dest_index: Destination asset index.
    """

    __slots__ = [
        '_src_index_value',
        '_src_index_present',
        '_dest_index_value',
        '_dest_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 src_index=None,
                 dest_index=None):
        self._src_index_value = None
        self._src_index_present = False
        self._dest_index_value = None
        self._dest_index_present = False
        if src_index is not None:
            self.src_index = src_index
        if dest_index is not None:
            self.dest_index = dest_index

    @property
    def src_index(self):
        """
        Source asset index.

        :rtype: long
        """
        if self._src_index_present:
            return self._src_index_value
        else:
            raise AttributeError("missing required field 'src_index'")

    @src_index.setter
    def src_index(self, val):
        val = self._src_index_validator.validate(val)
        self._src_index_value = val
        self._src_index_present = True

    @src_index.deleter
    def src_index(self):
        self._src_index_value = None
        self._src_index_present = False

    @property
    def dest_index(self):
        """
        Destination asset index.

        :rtype: long
        """
        if self._dest_index_present:
            return self._dest_index_value
        else:
            raise AttributeError("missing required field 'dest_index'")

    @dest_index.setter
    def dest_index(self, val):
        val = self._dest_index_validator.validate(val)
        self._dest_index_value = val
        self._dest_index_present = True

    @dest_index.deleter
    def dest_index(self):
        self._dest_index_value = None
        self._dest_index_present = False

    def __repr__(self):
        return 'MemberTransferAccountContentsDetails(src_index={!r}, dest_index={!r})'.format(
            self._src_index_value,
            self._dest_index_value,
        )

MemberTransferAccountContentsDetails_validator = bv.Struct(MemberTransferAccountContentsDetails)

class MemberUnsuspendDetails(object):
    """
    Unsuspended a team member.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MemberUnsuspendDetails()'

MemberUnsuspendDetails_validator = bv.Struct(MemberUnsuspendDetails)

class MicrosoftOfficeAddinChangePolicyDetails(object):
    """
    Enabled or disabled the Microsoft Office add-in, which lets team members
    save files to Dropbox directly from Microsoft Office.

    :ivar new_value: New Microsoft Office addin policy.
    :ivar previous_value: Previous Microsoft Office addin policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New Microsoft Office addin policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous Microsoft Office addin policy. Might be missing due to
        historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'MicrosoftOfficeAddinChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

MicrosoftOfficeAddinChangePolicyDetails_validator = bv.Struct(MicrosoftOfficeAddinChangePolicyDetails)

class MissingDetails(object):
    """
    An indication that an event was returned with missing details
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'MissingDetails()'

MissingDetails_validator = bv.Struct(MissingDetails)

class MobileSessionLogInfo(SessionLogInfo):
    """
    Mobile session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 session_id=None):
        super(MobileSessionLogInfo, self).__init__(session_id)

    def __repr__(self):
        return 'MobileSessionLogInfo(session_id={!r})'.format(
            self._session_id_value,
        )

MobileSessionLogInfo_validator = bv.Struct(MobileSessionLogInfo)

class NamespaceRelativePathLogInfo(object):
    """
    Namespace relative path details.

    :ivar ns_id: Namespace ID. Might be missing due to historical data gap.
    :ivar relative_path: A path relative to the specified namespace ID. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_ns_id_value',
        '_ns_id_present',
        '_relative_path_value',
        '_relative_path_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 ns_id=None,
                 relative_path=None):
        self._ns_id_value = None
        self._ns_id_present = False
        self._relative_path_value = None
        self._relative_path_present = False
        if ns_id is not None:
            self.ns_id = ns_id
        if relative_path is not None:
            self.relative_path = relative_path

    @property
    def ns_id(self):
        """
        Namespace ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._ns_id_present:
            return self._ns_id_value
        else:
            return None

    @ns_id.setter
    def ns_id(self, val):
        if val is None:
            del self.ns_id
            return
        val = self._ns_id_validator.validate(val)
        self._ns_id_value = val
        self._ns_id_present = True

    @ns_id.deleter
    def ns_id(self):
        self._ns_id_value = None
        self._ns_id_present = False

    @property
    def relative_path(self):
        """
        A path relative to the specified namespace ID. Might be missing due to
        historical data gap.

        :rtype: str
        """
        if self._relative_path_present:
            return self._relative_path_value
        else:
            return None

    @relative_path.setter
    def relative_path(self, val):
        if val is None:
            del self.relative_path
            return
        val = self._relative_path_validator.validate(val)
        self._relative_path_value = val
        self._relative_path_present = True

    @relative_path.deleter
    def relative_path(self):
        self._relative_path_value = None
        self._relative_path_present = False

    def __repr__(self):
        return 'NamespaceRelativePathLogInfo(ns_id={!r}, relative_path={!r})'.format(
            self._ns_id_value,
            self._relative_path_value,
        )

NamespaceRelativePathLogInfo_validator = bv.Struct(NamespaceRelativePathLogInfo)

class NetworkControlChangePolicyDetails(object):
    """
    Enabled or disabled network control.

    :ivar new_value: New network control policy.
    :ivar previous_value: Previous network control policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New network control policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous network control policy. Might be missing due to historical data
        gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'NetworkControlChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

NetworkControlChangePolicyDetails_validator = bv.Struct(NetworkControlChangePolicyDetails)

class UserLogInfo(object):
    """
    User's logged information.

    :ivar account_id: User unique ID. Might be missing due to historical data
        gap.
    :ivar display_name: User display name. Might be missing due to historical
        data gap.
    :ivar email: User email address. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_account_id_value',
        '_account_id_present',
        '_display_name_value',
        '_display_name_present',
        '_email_value',
        '_email_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 account_id=None,
                 display_name=None,
                 email=None):
        self._account_id_value = None
        self._account_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        self._email_value = None
        self._email_present = False
        if account_id is not None:
            self.account_id = account_id
        if display_name is not None:
            self.display_name = display_name
        if email is not None:
            self.email = email

    @property
    def account_id(self):
        """
        User unique ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._account_id_present:
            return self._account_id_value
        else:
            return None

    @account_id.setter
    def account_id(self, val):
        if val is None:
            del self.account_id
            return
        val = self._account_id_validator.validate(val)
        self._account_id_value = val
        self._account_id_present = True

    @account_id.deleter
    def account_id(self):
        self._account_id_value = None
        self._account_id_present = False

    @property
    def display_name(self):
        """
        User display name. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            return None

    @display_name.setter
    def display_name(self, val):
        if val is None:
            del self.display_name
            return
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    @property
    def email(self):
        """
        User email address. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._email_present:
            return self._email_value
        else:
            return None

    @email.setter
    def email(self, val):
        if val is None:
            del self.email
            return
        val = self._email_validator.validate(val)
        self._email_value = val
        self._email_present = True

    @email.deleter
    def email(self):
        self._email_value = None
        self._email_present = False

    def __repr__(self):
        return 'UserLogInfo(account_id={!r}, display_name={!r}, email={!r})'.format(
            self._account_id_value,
            self._display_name_value,
            self._email_value,
        )

UserLogInfo_validator = bv.StructTree(UserLogInfo)

class NonTeamMemberLogInfo(UserLogInfo):
    """
    Non team member's logged information.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self,
                 account_id=None,
                 display_name=None,
                 email=None):
        super(NonTeamMemberLogInfo, self).__init__(account_id,
                                                   display_name,
                                                   email)

    def __repr__(self):
        return 'NonTeamMemberLogInfo(account_id={!r}, display_name={!r}, email={!r})'.format(
            self._account_id_value,
            self._display_name_value,
            self._email_value,
        )

NonTeamMemberLogInfo_validator = bv.Struct(NonTeamMemberLogInfo)

class NoteAclInviteOnlyDetails(object):
    """
    Changed a Paper document to be invite-only.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'NoteAclInviteOnlyDetails()'

NoteAclInviteOnlyDetails_validator = bv.Struct(NoteAclInviteOnlyDetails)

class NoteAclLinkDetails(object):
    """
    Changed a Paper document to be link accessible.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'NoteAclLinkDetails()'

NoteAclLinkDetails_validator = bv.Struct(NoteAclLinkDetails)

class NoteAclTeamLinkDetails(object):
    """
    Changed a Paper document to be link accessible for the team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'NoteAclTeamLinkDetails()'

NoteAclTeamLinkDetails_validator = bv.Struct(NoteAclTeamLinkDetails)

class NoteShareReceiveDetails(object):
    """
    Shared Paper document received.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'NoteShareReceiveDetails()'

NoteShareReceiveDetails_validator = bv.Struct(NoteShareReceiveDetails)

class NoteSharedDetails(object):
    """
    Shared a Paper doc.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'NoteSharedDetails()'

NoteSharedDetails_validator = bv.Struct(NoteSharedDetails)

class OpenNoteSharedDetails(object):
    """
    Opened a shared Paper doc.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'OpenNoteSharedDetails()'

OpenNoteSharedDetails_validator = bv.Struct(OpenNoteSharedDetails)

class OptionalChangePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    disabled = None
    # Attribute is overwritten below the class definition
    optional = None
    # Attribute is overwritten below the class definition
    required = None
    # Attribute is overwritten below the class definition
    other = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def is_optional(self):
        """
        Check if the union tag is ``optional``.

        :rtype: bool
        """
        return self._tag == 'optional'

    def is_required(self):
        """
        Check if the union tag is ``required``.

        :rtype: bool
        """
        return self._tag == 'required'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'OptionalChangePolicy(%r, %r)' % (self._tag, self._value)

OptionalChangePolicy_validator = bv.Union(OptionalChangePolicy)

class OriginLogInfo(object):
    """
    The origin from which the actor performed the action.

    :ivar geo_location: Geographic location details.
    :ivar host: Host details.
    :ivar access_method: The method that was used to perform the action.
    """

    __slots__ = [
        '_geo_location_value',
        '_geo_location_present',
        '_host_value',
        '_host_present',
        '_access_method_value',
        '_access_method_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 access_method=None,
                 geo_location=None,
                 host=None):
        self._geo_location_value = None
        self._geo_location_present = False
        self._host_value = None
        self._host_present = False
        self._access_method_value = None
        self._access_method_present = False
        if geo_location is not None:
            self.geo_location = geo_location
        if host is not None:
            self.host = host
        if access_method is not None:
            self.access_method = access_method

    @property
    def geo_location(self):
        """
        Geographic location details.

        :rtype: GeoLocationLogInfo
        """
        if self._geo_location_present:
            return self._geo_location_value
        else:
            return None

    @geo_location.setter
    def geo_location(self, val):
        if val is None:
            del self.geo_location
            return
        self._geo_location_validator.validate_type_only(val)
        self._geo_location_value = val
        self._geo_location_present = True

    @geo_location.deleter
    def geo_location(self):
        self._geo_location_value = None
        self._geo_location_present = False

    @property
    def host(self):
        """
        Host details.

        :rtype: HostLogInfo
        """
        if self._host_present:
            return self._host_value
        else:
            return None

    @host.setter
    def host(self, val):
        if val is None:
            del self.host
            return
        self._host_validator.validate_type_only(val)
        self._host_value = val
        self._host_present = True

    @host.deleter
    def host(self):
        self._host_value = None
        self._host_present = False

    @property
    def access_method(self):
        """
        The method that was used to perform the action.

        :rtype: AccessMethodLogInfo
        """
        if self._access_method_present:
            return self._access_method_value
        else:
            raise AttributeError("missing required field 'access_method'")

    @access_method.setter
    def access_method(self, val):
        self._access_method_validator.validate_type_only(val)
        self._access_method_value = val
        self._access_method_present = True

    @access_method.deleter
    def access_method(self):
        self._access_method_value = None
        self._access_method_present = False

    def __repr__(self):
        return 'OriginLogInfo(access_method={!r}, geo_location={!r}, host={!r})'.format(
            self._access_method_value,
            self._geo_location_value,
            self._host_value,
        )

OriginLogInfo_validator = bv.Struct(OriginLogInfo)

class PaperAccessType(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    viewer = None
    # Attribute is overwritten below the class definition
    commenter = None
    # Attribute is overwritten below the class definition
    editor = None
    # Attribute is overwritten below the class definition
    other = None

    def is_viewer(self):
        """
        Check if the union tag is ``viewer``.

        :rtype: bool
        """
        return self._tag == 'viewer'

    def is_commenter(self):
        """
        Check if the union tag is ``commenter``.

        :rtype: bool
        """
        return self._tag == 'commenter'

    def is_editor(self):
        """
        Check if the union tag is ``editor``.

        :rtype: bool
        """
        return self._tag == 'editor'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PaperAccessType(%r, %r)' % (self._tag, self._value)

PaperAccessType_validator = bv.Union(PaperAccessType)

class PaperChangeDeploymentPolicyDetails(object):
    """
    Changed whether Dropbox Paper, when enabled, is deployed to all teams or to
    specific members of the team.

    :ivar new_value: New Dropbox Paper deployment policy.
    :ivar previous_value: Previous Dropbox Paper deployment policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New Dropbox Paper deployment policy.

        :rtype: PaperDeploymentPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous Dropbox Paper deployment policy. Might be missing due to
        historical data gap.

        :rtype: PaperDeploymentPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'PaperChangeDeploymentPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

PaperChangeDeploymentPolicyDetails_validator = bv.Struct(PaperChangeDeploymentPolicyDetails)

class PaperChangeMemberPolicyDetails(object):
    """
    Changed whether team members can share Paper documents externally (i.e.
    outside the team), and if so, whether they should be accessible only by team
    members or anyone by default.

    :ivar new_value: New paper external accessibility policy.
    :ivar previous_value: Previous paper external accessibility policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New paper external accessibility policy.

        :rtype: ExternalSharingAccessibilityPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous paper external accessibility policy. Might be missing due to
        historical data gap.

        :rtype: ExternalSharingAccessibilityPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'PaperChangeMemberPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

PaperChangeMemberPolicyDetails_validator = bv.Struct(PaperChangeMemberPolicyDetails)

class PaperChangePolicyDetails(object):
    """
    Enabled or disabled Dropbox Paper for the team.

    :ivar new_value: New Dropbox Paper policy.
    :ivar previous_value: Previous Dropbox Paper policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New Dropbox Paper policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous Dropbox Paper policy. Might be missing due to historical data
        gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'PaperChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

PaperChangePolicyDetails_validator = bv.Struct(PaperChangePolicyDetails)

class PaperContentAddMemberDetails(object):
    """
    Added users to the membership of a Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentAddMemberDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentAddMemberDetails_validator = bv.Struct(PaperContentAddMemberDetails)

class PaperContentAddToFolderDetails(object):
    """
    Added Paper doc or folder to a folder.

    :ivar event_uuid: Event unique identifier.
    :ivar target_index: Target asset index.
    :ivar parent_index: Parent asset index.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_target_index_value',
        '_target_index_present',
        '_parent_index_value',
        '_parent_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 target_index=None,
                 parent_index=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._target_index_value = None
        self._target_index_present = False
        self._parent_index_value = None
        self._parent_index_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if target_index is not None:
            self.target_index = target_index
        if parent_index is not None:
            self.parent_index = parent_index

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def parent_index(self):
        """
        Parent asset index.

        :rtype: long
        """
        if self._parent_index_present:
            return self._parent_index_value
        else:
            raise AttributeError("missing required field 'parent_index'")

    @parent_index.setter
    def parent_index(self, val):
        val = self._parent_index_validator.validate(val)
        self._parent_index_value = val
        self._parent_index_present = True

    @parent_index.deleter
    def parent_index(self):
        self._parent_index_value = None
        self._parent_index_present = False

    def __repr__(self):
        return 'PaperContentAddToFolderDetails(event_uuid={!r}, target_index={!r}, parent_index={!r})'.format(
            self._event_uuid_value,
            self._target_index_value,
            self._parent_index_value,
        )

PaperContentAddToFolderDetails_validator = bv.Struct(PaperContentAddToFolderDetails)

class PaperContentArchiveDetails(object):
    """
    Archived Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentArchiveDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentArchiveDetails_validator = bv.Struct(PaperContentArchiveDetails)

class PaperContentChangeSubscriptionDetails(object):
    """
    Followed or unfollowed a Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    :ivar new_subscription_level: New subscription level.
    :ivar previous_subscription_level: Previous subscription level. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_new_subscription_level_value',
        '_new_subscription_level_present',
        '_previous_subscription_level_value',
        '_previous_subscription_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 new_subscription_level=None,
                 previous_subscription_level=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._new_subscription_level_value = None
        self._new_subscription_level_present = False
        self._previous_subscription_level_value = None
        self._previous_subscription_level_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if new_subscription_level is not None:
            self.new_subscription_level = new_subscription_level
        if previous_subscription_level is not None:
            self.previous_subscription_level = previous_subscription_level

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def new_subscription_level(self):
        """
        New subscription level.

        :rtype: PaperTaggedValue
        """
        if self._new_subscription_level_present:
            return self._new_subscription_level_value
        else:
            raise AttributeError("missing required field 'new_subscription_level'")

    @new_subscription_level.setter
    def new_subscription_level(self, val):
        self._new_subscription_level_validator.validate_type_only(val)
        self._new_subscription_level_value = val
        self._new_subscription_level_present = True

    @new_subscription_level.deleter
    def new_subscription_level(self):
        self._new_subscription_level_value = None
        self._new_subscription_level_present = False

    @property
    def previous_subscription_level(self):
        """
        Previous subscription level. Might be missing due to historical data
        gap.

        :rtype: PaperTaggedValue
        """
        if self._previous_subscription_level_present:
            return self._previous_subscription_level_value
        else:
            return None

    @previous_subscription_level.setter
    def previous_subscription_level(self, val):
        if val is None:
            del self.previous_subscription_level
            return
        self._previous_subscription_level_validator.validate_type_only(val)
        self._previous_subscription_level_value = val
        self._previous_subscription_level_present = True

    @previous_subscription_level.deleter
    def previous_subscription_level(self):
        self._previous_subscription_level_value = None
        self._previous_subscription_level_present = False

    def __repr__(self):
        return 'PaperContentChangeSubscriptionDetails(event_uuid={!r}, new_subscription_level={!r}, previous_subscription_level={!r})'.format(
            self._event_uuid_value,
            self._new_subscription_level_value,
            self._previous_subscription_level_value,
        )

PaperContentChangeSubscriptionDetails_validator = bv.Struct(PaperContentChangeSubscriptionDetails)

class PaperContentCreateDetails(object):
    """
    Created a Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentCreateDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentCreateDetails_validator = bv.Struct(PaperContentCreateDetails)

class PaperContentPermanentlyDeleteDetails(object):
    """
    Permanently deleted a Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentPermanentlyDeleteDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentPermanentlyDeleteDetails_validator = bv.Struct(PaperContentPermanentlyDeleteDetails)

class PaperContentRemoveFromFolderDetails(object):
    """
    Removed Paper doc or folder from a folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentRemoveFromFolderDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentRemoveFromFolderDetails_validator = bv.Struct(PaperContentRemoveFromFolderDetails)

class PaperContentRemoveMemberDetails(object):
    """
    Removed a user from the membership of a Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentRemoveMemberDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentRemoveMemberDetails_validator = bv.Struct(PaperContentRemoveMemberDetails)

class PaperContentRenameDetails(object):
    """
    Renamed Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentRenameDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentRenameDetails_validator = bv.Struct(PaperContentRenameDetails)

class PaperContentRestoreDetails(object):
    """
    Restored an archived Paper doc or folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperContentRestoreDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperContentRestoreDetails_validator = bv.Struct(PaperContentRestoreDetails)

class PaperDeploymentPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    partial = None
    # Attribute is overwritten below the class definition
    full = None
    # Attribute is overwritten below the class definition
    other = None

    def is_partial(self):
        """
        Check if the union tag is ``partial``.

        :rtype: bool
        """
        return self._tag == 'partial'

    def is_full(self):
        """
        Check if the union tag is ``full``.

        :rtype: bool
        """
        return self._tag == 'full'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PaperDeploymentPolicy(%r, %r)' % (self._tag, self._value)

PaperDeploymentPolicy_validator = bv.Union(PaperDeploymentPolicy)

class PaperDocAddCommentDetails(object):
    """
    Added a Paper doc comment.

    :ivar event_uuid: Event unique identifier.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 comment_text=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'PaperDocAddCommentDetails(event_uuid={!r}, comment_text={!r})'.format(
            self._event_uuid_value,
            self._comment_text_value,
        )

PaperDocAddCommentDetails_validator = bv.Struct(PaperDocAddCommentDetails)

class PaperDocChangeMemberRoleDetails(object):
    """
    Changed the access type of a Paper doc member.

    :ivar event_uuid: Event unique identifier.
    :ivar access_type: Paper doc access type.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_access_type_value',
        '_access_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 access_type=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._access_type_value = None
        self._access_type_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if access_type is not None:
            self.access_type = access_type

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def access_type(self):
        """
        Paper doc access type.

        :rtype: PaperAccessType
        """
        if self._access_type_present:
            return self._access_type_value
        else:
            raise AttributeError("missing required field 'access_type'")

    @access_type.setter
    def access_type(self, val):
        self._access_type_validator.validate_type_only(val)
        self._access_type_value = val
        self._access_type_present = True

    @access_type.deleter
    def access_type(self):
        self._access_type_value = None
        self._access_type_present = False

    def __repr__(self):
        return 'PaperDocChangeMemberRoleDetails(event_uuid={!r}, access_type={!r})'.format(
            self._event_uuid_value,
            self._access_type_value,
        )

PaperDocChangeMemberRoleDetails_validator = bv.Struct(PaperDocChangeMemberRoleDetails)

class PaperDocChangeSharingPolicyDetails(object):
    """
    Changed the sharing policy for Paper doc.

    :ivar event_uuid: Event unique identifier.
    :ivar public_sharing_policy: Sharing policy with external users. Might be
        missing due to historical data gap.
    :ivar team_sharing_policy: Sharing policy with team. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_public_sharing_policy_value',
        '_public_sharing_policy_present',
        '_team_sharing_policy_value',
        '_team_sharing_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 public_sharing_policy=None,
                 team_sharing_policy=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._public_sharing_policy_value = None
        self._public_sharing_policy_present = False
        self._team_sharing_policy_value = None
        self._team_sharing_policy_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if public_sharing_policy is not None:
            self.public_sharing_policy = public_sharing_policy
        if team_sharing_policy is not None:
            self.team_sharing_policy = team_sharing_policy

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def public_sharing_policy(self):
        """
        Sharing policy with external users. Might be missing due to historical
        data gap.

        :rtype: str
        """
        if self._public_sharing_policy_present:
            return self._public_sharing_policy_value
        else:
            return None

    @public_sharing_policy.setter
    def public_sharing_policy(self, val):
        if val is None:
            del self.public_sharing_policy
            return
        val = self._public_sharing_policy_validator.validate(val)
        self._public_sharing_policy_value = val
        self._public_sharing_policy_present = True

    @public_sharing_policy.deleter
    def public_sharing_policy(self):
        self._public_sharing_policy_value = None
        self._public_sharing_policy_present = False

    @property
    def team_sharing_policy(self):
        """
        Sharing policy with team. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._team_sharing_policy_present:
            return self._team_sharing_policy_value
        else:
            return None

    @team_sharing_policy.setter
    def team_sharing_policy(self, val):
        if val is None:
            del self.team_sharing_policy
            return
        val = self._team_sharing_policy_validator.validate(val)
        self._team_sharing_policy_value = val
        self._team_sharing_policy_present = True

    @team_sharing_policy.deleter
    def team_sharing_policy(self):
        self._team_sharing_policy_value = None
        self._team_sharing_policy_present = False

    def __repr__(self):
        return 'PaperDocChangeSharingPolicyDetails(event_uuid={!r}, public_sharing_policy={!r}, team_sharing_policy={!r})'.format(
            self._event_uuid_value,
            self._public_sharing_policy_value,
            self._team_sharing_policy_value,
        )

PaperDocChangeSharingPolicyDetails_validator = bv.Struct(PaperDocChangeSharingPolicyDetails)

class PaperDocDeleteCommentDetails(object):
    """
    Deleted a Paper doc comment.

    :ivar event_uuid: Event unique identifier.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 comment_text=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'PaperDocDeleteCommentDetails(event_uuid={!r}, comment_text={!r})'.format(
            self._event_uuid_value,
            self._comment_text_value,
        )

PaperDocDeleteCommentDetails_validator = bv.Struct(PaperDocDeleteCommentDetails)

class PaperDocDeletedDetails(object):
    """
    Paper doc archived.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocDeletedDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocDeletedDetails_validator = bv.Struct(PaperDocDeletedDetails)

class PaperDocDownloadDetails(object):
    """
    Downloaded a Paper doc in a particular output format.

    :ivar event_uuid: Event unique identifier.
    :ivar export_file_format: Export file format.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_export_file_format_value',
        '_export_file_format_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 export_file_format=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._export_file_format_value = None
        self._export_file_format_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if export_file_format is not None:
            self.export_file_format = export_file_format

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def export_file_format(self):
        """
        Export file format.

        :rtype: PaperDownloadFormat
        """
        if self._export_file_format_present:
            return self._export_file_format_value
        else:
            raise AttributeError("missing required field 'export_file_format'")

    @export_file_format.setter
    def export_file_format(self, val):
        self._export_file_format_validator.validate_type_only(val)
        self._export_file_format_value = val
        self._export_file_format_present = True

    @export_file_format.deleter
    def export_file_format(self):
        self._export_file_format_value = None
        self._export_file_format_present = False

    def __repr__(self):
        return 'PaperDocDownloadDetails(event_uuid={!r}, export_file_format={!r})'.format(
            self._event_uuid_value,
            self._export_file_format_value,
        )

PaperDocDownloadDetails_validator = bv.Struct(PaperDocDownloadDetails)

class PaperDocEditCommentDetails(object):
    """
    Edited a Paper doc comment.

    :ivar event_uuid: Event unique identifier.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 comment_text=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'PaperDocEditCommentDetails(event_uuid={!r}, comment_text={!r})'.format(
            self._event_uuid_value,
            self._comment_text_value,
        )

PaperDocEditCommentDetails_validator = bv.Struct(PaperDocEditCommentDetails)

class PaperDocEditDetails(object):
    """
    Edited a Paper doc.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocEditDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocEditDetails_validator = bv.Struct(PaperDocEditDetails)

class PaperDocFollowedDetails(object):
    """
    Followed a Paper doc.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocFollowedDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocFollowedDetails_validator = bv.Struct(PaperDocFollowedDetails)

class PaperDocMentionDetails(object):
    """
    Mentioned a member in a Paper doc.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocMentionDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocMentionDetails_validator = bv.Struct(PaperDocMentionDetails)

class PaperDocRequestAccessDetails(object):
    """
    Requested to be a member on a Paper doc.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocRequestAccessDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocRequestAccessDetails_validator = bv.Struct(PaperDocRequestAccessDetails)

class PaperDocResolveCommentDetails(object):
    """
    Paper doc comment resolved.

    :ivar event_uuid: Event unique identifier.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 comment_text=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'PaperDocResolveCommentDetails(event_uuid={!r}, comment_text={!r})'.format(
            self._event_uuid_value,
            self._comment_text_value,
        )

PaperDocResolveCommentDetails_validator = bv.Struct(PaperDocResolveCommentDetails)

class PaperDocRevertDetails(object):
    """
    Restored a Paper doc to previous revision.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocRevertDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocRevertDetails_validator = bv.Struct(PaperDocRevertDetails)

class PaperDocSlackShareDetails(object):
    """
    Paper doc link shared via slack.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocSlackShareDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocSlackShareDetails_validator = bv.Struct(PaperDocSlackShareDetails)

class PaperDocTeamInviteDetails(object):
    """
    Paper doc shared with team member.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocTeamInviteDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocTeamInviteDetails_validator = bv.Struct(PaperDocTeamInviteDetails)

class PaperDocUnresolveCommentDetails(object):
    """
    Unresolved a Paper doc comment.

    :ivar event_uuid: Event unique identifier.
    :ivar comment_text: Comment text. Might be missing due to historical data
        gap.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
        '_comment_text_value',
        '_comment_text_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None,
                 comment_text=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        self._comment_text_value = None
        self._comment_text_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid
        if comment_text is not None:
            self.comment_text = comment_text

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    @property
    def comment_text(self):
        """
        Comment text. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._comment_text_present:
            return self._comment_text_value
        else:
            return None

    @comment_text.setter
    def comment_text(self, val):
        if val is None:
            del self.comment_text
            return
        val = self._comment_text_validator.validate(val)
        self._comment_text_value = val
        self._comment_text_present = True

    @comment_text.deleter
    def comment_text(self):
        self._comment_text_value = None
        self._comment_text_present = False

    def __repr__(self):
        return 'PaperDocUnresolveCommentDetails(event_uuid={!r}, comment_text={!r})'.format(
            self._event_uuid_value,
            self._comment_text_value,
        )

PaperDocUnresolveCommentDetails_validator = bv.Struct(PaperDocUnresolveCommentDetails)

class PaperDocViewDetails(object):
    """
    Viewed Paper doc.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperDocViewDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperDocViewDetails_validator = bv.Struct(PaperDocViewDetails)

class PaperDocumentLogInfo(object):
    """
    Paper document's logged information.

    :ivar doc_id: Papers document Id.
    :ivar doc_title: Paper document title.
    """

    __slots__ = [
        '_doc_id_value',
        '_doc_id_present',
        '_doc_title_value',
        '_doc_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 doc_title=None):
        self._doc_id_value = None
        self._doc_id_present = False
        self._doc_title_value = None
        self._doc_title_present = False
        if doc_id is not None:
            self.doc_id = doc_id
        if doc_title is not None:
            self.doc_title = doc_title

    @property
    def doc_id(self):
        """
        Papers document Id.

        :rtype: str
        """
        if self._doc_id_present:
            return self._doc_id_value
        else:
            raise AttributeError("missing required field 'doc_id'")

    @doc_id.setter
    def doc_id(self, val):
        val = self._doc_id_validator.validate(val)
        self._doc_id_value = val
        self._doc_id_present = True

    @doc_id.deleter
    def doc_id(self):
        self._doc_id_value = None
        self._doc_id_present = False

    @property
    def doc_title(self):
        """
        Paper document title.

        :rtype: str
        """
        if self._doc_title_present:
            return self._doc_title_value
        else:
            raise AttributeError("missing required field 'doc_title'")

    @doc_title.setter
    def doc_title(self, val):
        val = self._doc_title_validator.validate(val)
        self._doc_title_value = val
        self._doc_title_present = True

    @doc_title.deleter
    def doc_title(self):
        self._doc_title_value = None
        self._doc_title_present = False

    def __repr__(self):
        return 'PaperDocumentLogInfo(doc_id={!r}, doc_title={!r})'.format(
            self._doc_id_value,
            self._doc_title_value,
        )

PaperDocumentLogInfo_validator = bv.Struct(PaperDocumentLogInfo)

class PaperDownloadFormat(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    docx = None
    # Attribute is overwritten below the class definition
    html = None
    # Attribute is overwritten below the class definition
    markdown = None
    # Attribute is overwritten below the class definition
    other = None

    def is_docx(self):
        """
        Check if the union tag is ``docx``.

        :rtype: bool
        """
        return self._tag == 'docx'

    def is_html(self):
        """
        Check if the union tag is ``html``.

        :rtype: bool
        """
        return self._tag == 'html'

    def is_markdown(self):
        """
        Check if the union tag is ``markdown``.

        :rtype: bool
        """
        return self._tag == 'markdown'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PaperDownloadFormat(%r, %r)' % (self._tag, self._value)

PaperDownloadFormat_validator = bv.Union(PaperDownloadFormat)

class PaperEnabledUsersGroupAdditionDetails(object):
    """
    Users added to Paper enabled users list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PaperEnabledUsersGroupAdditionDetails()'

PaperEnabledUsersGroupAdditionDetails_validator = bv.Struct(PaperEnabledUsersGroupAdditionDetails)

class PaperEnabledUsersGroupRemovalDetails(object):
    """
    Users removed from Paper enabled users list.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PaperEnabledUsersGroupRemovalDetails()'

PaperEnabledUsersGroupRemovalDetails_validator = bv.Struct(PaperEnabledUsersGroupRemovalDetails)

class PaperExternalViewAllowDetails(object):
    """
    Paper external sharing policy changed: anyone.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PaperExternalViewAllowDetails()'

PaperExternalViewAllowDetails_validator = bv.Struct(PaperExternalViewAllowDetails)

class PaperExternalViewDefaultTeamDetails(object):
    """
    Paper external sharing policy changed: default team.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PaperExternalViewDefaultTeamDetails()'

PaperExternalViewDefaultTeamDetails_validator = bv.Struct(PaperExternalViewDefaultTeamDetails)

class PaperExternalViewForbidDetails(object):
    """
    Paper external sharing policy changed: team-only.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PaperExternalViewForbidDetails()'

PaperExternalViewForbidDetails_validator = bv.Struct(PaperExternalViewForbidDetails)

class PaperFolderDeletedDetails(object):
    """
    Paper folder archived.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperFolderDeletedDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperFolderDeletedDetails_validator = bv.Struct(PaperFolderDeletedDetails)

class PaperFolderFollowedDetails(object):
    """
    Followed a Paper folder.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperFolderFollowedDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperFolderFollowedDetails_validator = bv.Struct(PaperFolderFollowedDetails)

class PaperFolderLogInfo(object):
    """
    Paper folder's logged information.

    :ivar folder_id: Papers folder Id.
    :ivar folder_name: Paper folder name.
    """

    __slots__ = [
        '_folder_id_value',
        '_folder_id_present',
        '_folder_name_value',
        '_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 folder_id=None,
                 folder_name=None):
        self._folder_id_value = None
        self._folder_id_present = False
        self._folder_name_value = None
        self._folder_name_present = False
        if folder_id is not None:
            self.folder_id = folder_id
        if folder_name is not None:
            self.folder_name = folder_name

    @property
    def folder_id(self):
        """
        Papers folder Id.

        :rtype: str
        """
        if self._folder_id_present:
            return self._folder_id_value
        else:
            raise AttributeError("missing required field 'folder_id'")

    @folder_id.setter
    def folder_id(self, val):
        val = self._folder_id_validator.validate(val)
        self._folder_id_value = val
        self._folder_id_present = True

    @folder_id.deleter
    def folder_id(self):
        self._folder_id_value = None
        self._folder_id_present = False

    @property
    def folder_name(self):
        """
        Paper folder name.

        :rtype: str
        """
        if self._folder_name_present:
            return self._folder_name_value
        else:
            raise AttributeError("missing required field 'folder_name'")

    @folder_name.setter
    def folder_name(self, val):
        val = self._folder_name_validator.validate(val)
        self._folder_name_value = val
        self._folder_name_present = True

    @folder_name.deleter
    def folder_name(self):
        self._folder_name_value = None
        self._folder_name_present = False

    def __repr__(self):
        return 'PaperFolderLogInfo(folder_id={!r}, folder_name={!r})'.format(
            self._folder_id_value,
            self._folder_name_value,
        )

PaperFolderLogInfo_validator = bv.Struct(PaperFolderLogInfo)

class PaperFolderTeamInviteDetails(object):
    """
    Paper folder shared with team member.

    :ivar event_uuid: Event unique identifier.
    """

    __slots__ = [
        '_event_uuid_value',
        '_event_uuid_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 event_uuid=None):
        self._event_uuid_value = None
        self._event_uuid_present = False
        if event_uuid is not None:
            self.event_uuid = event_uuid

    @property
    def event_uuid(self):
        """
        Event unique identifier.

        :rtype: str
        """
        if self._event_uuid_present:
            return self._event_uuid_value
        else:
            raise AttributeError("missing required field 'event_uuid'")

    @event_uuid.setter
    def event_uuid(self, val):
        val = self._event_uuid_validator.validate(val)
        self._event_uuid_value = val
        self._event_uuid_present = True

    @event_uuid.deleter
    def event_uuid(self):
        self._event_uuid_value = None
        self._event_uuid_present = False

    def __repr__(self):
        return 'PaperFolderTeamInviteDetails(event_uuid={!r})'.format(
            self._event_uuid_value,
        )

PaperFolderTeamInviteDetails_validator = bv.Struct(PaperFolderTeamInviteDetails)

class PaperTaggedValue(object):
    """
    Paper tagged value.

    :ivar tag: Tag.
    """

    __slots__ = [
        '_tag_value',
        '_tag_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 tag=None):
        self._tag_value = None
        self._tag_present = False
        if tag is not None:
            self.tag = tag

    @property
    def tag(self):
        """
        Tag.

        :rtype: str
        """
        if self._tag_present:
            return self._tag_value
        else:
            raise AttributeError("missing required field 'tag'")

    @tag.setter
    def tag(self, val):
        val = self._tag_validator.validate(val)
        self._tag_value = val
        self._tag_present = True

    @tag.deleter
    def tag(self):
        self._tag_value = None
        self._tag_present = False

    def __repr__(self):
        return 'PaperTaggedValue(tag={!r})'.format(
            self._tag_value,
        )

PaperTaggedValue_validator = bv.Struct(PaperTaggedValue)

class ParticipantLogInfo(bb.Union):
    """
    A user or group

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar UserLogInfo user: User details.
    :ivar GroupLogInfo group: Group details.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def user(cls, val):
        """
        Create an instance of this class set to the ``user`` tag with value
        ``val``.

        :param UserLogInfo val:
        :rtype: ParticipantLogInfo
        """
        return cls('user', val)

    @classmethod
    def group(cls, val):
        """
        Create an instance of this class set to the ``group`` tag with value
        ``val``.

        :param GroupLogInfo val:
        :rtype: ParticipantLogInfo
        """
        return cls('group', val)

    def is_user(self):
        """
        Check if the union tag is ``user``.

        :rtype: bool
        """
        return self._tag == 'user'

    def is_group(self):
        """
        Check if the union tag is ``group``.

        :rtype: bool
        """
        return self._tag == 'group'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_user(self):
        """
        User details.

        Only call this if :meth:`is_user` is true.

        :rtype: UserLogInfo
        """
        if not self.is_user():
            raise AttributeError("tag 'user' not set")
        return self._value

    def get_group(self):
        """
        Group details.

        Only call this if :meth:`is_group` is true.

        :rtype: GroupLogInfo
        """
        if not self.is_group():
            raise AttributeError("tag 'group' not set")
        return self._value

    def __repr__(self):
        return 'ParticipantLogInfo(%r, %r)' % (self._tag, self._value)

ParticipantLogInfo_validator = bv.Union(ParticipantLogInfo)

class PasswordChangeDetails(object):
    """
    Changed password.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PasswordChangeDetails()'

PasswordChangeDetails_validator = bv.Struct(PasswordChangeDetails)

class PasswordLoginFailDetails(object):
    """
    Failed to sign in using a password.

    :ivar failure_reason: Login failure reason. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_failure_reason_value',
        '_failure_reason_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 failure_reason=None):
        self._failure_reason_value = None
        self._failure_reason_present = False
        if failure_reason is not None:
            self.failure_reason = failure_reason

    @property
    def failure_reason(self):
        """
        Login failure reason. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._failure_reason_present:
            return self._failure_reason_value
        else:
            return None

    @failure_reason.setter
    def failure_reason(self, val):
        if val is None:
            del self.failure_reason
            return
        val = self._failure_reason_validator.validate(val)
        self._failure_reason_value = val
        self._failure_reason_present = True

    @failure_reason.deleter
    def failure_reason(self):
        self._failure_reason_value = None
        self._failure_reason_present = False

    def __repr__(self):
        return 'PasswordLoginFailDetails(failure_reason={!r})'.format(
            self._failure_reason_value,
        )

PasswordLoginFailDetails_validator = bv.Struct(PasswordLoginFailDetails)

class PasswordLoginSuccessDetails(object):
    """
    Signed in using a password.

    :ivar is_emm_managed: Tells if the user signed in from an EMM managed
        device.
    """

    __slots__ = [
        '_is_emm_managed_value',
        '_is_emm_managed_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 is_emm_managed=None):
        self._is_emm_managed_value = None
        self._is_emm_managed_present = False
        if is_emm_managed is not None:
            self.is_emm_managed = is_emm_managed

    @property
    def is_emm_managed(self):
        """
        Tells if the user signed in from an EMM managed device.

        :rtype: bool
        """
        if self._is_emm_managed_present:
            return self._is_emm_managed_value
        else:
            raise AttributeError("missing required field 'is_emm_managed'")

    @is_emm_managed.setter
    def is_emm_managed(self, val):
        val = self._is_emm_managed_validator.validate(val)
        self._is_emm_managed_value = val
        self._is_emm_managed_present = True

    @is_emm_managed.deleter
    def is_emm_managed(self):
        self._is_emm_managed_value = None
        self._is_emm_managed_present = False

    def __repr__(self):
        return 'PasswordLoginSuccessDetails(is_emm_managed={!r})'.format(
            self._is_emm_managed_value,
        )

PasswordLoginSuccessDetails_validator = bv.Struct(PasswordLoginSuccessDetails)

class PasswordResetAllDetails(object):
    """
    Reset all team member passwords.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PasswordResetAllDetails()'

PasswordResetAllDetails_validator = bv.Struct(PasswordResetAllDetails)

class PasswordResetDetails(object):
    """
    Reset password.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'PasswordResetDetails()'

PasswordResetDetails_validator = bv.Struct(PasswordResetDetails)

class PathLogInfo(object):
    """
    Path's details.

    :ivar contextual: Fully qualified path relative to event's context. Might be
        missing due to historical data gap.
    :ivar namespace_relative: Path relative to the namespace containing the
        content.
    """

    __slots__ = [
        '_contextual_value',
        '_contextual_present',
        '_namespace_relative_value',
        '_namespace_relative_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 namespace_relative=None,
                 contextual=None):
        self._contextual_value = None
        self._contextual_present = False
        self._namespace_relative_value = None
        self._namespace_relative_present = False
        if contextual is not None:
            self.contextual = contextual
        if namespace_relative is not None:
            self.namespace_relative = namespace_relative

    @property
    def contextual(self):
        """
        Fully qualified path relative to event's context. Might be missing due
        to historical data gap.

        :rtype: str
        """
        if self._contextual_present:
            return self._contextual_value
        else:
            return None

    @contextual.setter
    def contextual(self, val):
        if val is None:
            del self.contextual
            return
        val = self._contextual_validator.validate(val)
        self._contextual_value = val
        self._contextual_present = True

    @contextual.deleter
    def contextual(self):
        self._contextual_value = None
        self._contextual_present = False

    @property
    def namespace_relative(self):
        """
        Path relative to the namespace containing the content.

        :rtype: NamespaceRelativePathLogInfo
        """
        if self._namespace_relative_present:
            return self._namespace_relative_value
        else:
            raise AttributeError("missing required field 'namespace_relative'")

    @namespace_relative.setter
    def namespace_relative(self, val):
        self._namespace_relative_validator.validate_type_only(val)
        self._namespace_relative_value = val
        self._namespace_relative_present = True

    @namespace_relative.deleter
    def namespace_relative(self):
        self._namespace_relative_value = None
        self._namespace_relative_present = False

    def __repr__(self):
        return 'PathLogInfo(namespace_relative={!r}, contextual={!r})'.format(
            self._namespace_relative_value,
            self._contextual_value,
        )

PathLogInfo_validator = bv.Struct(PathLogInfo)

class PermanentDeleteChangePolicyDetails(object):
    """
    Enabled or disabled the ability of team members to permanently delete
    content.

    :ivar new_value: New permanent delete content policy.
    :ivar previous_value: Previous permanent delete content policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New permanent delete content policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous permanent delete content policy. Might be missing due to
        historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'PermanentDeleteChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

PermanentDeleteChangePolicyDetails_validator = bv.Struct(PermanentDeleteChangePolicyDetails)

class PlacementRestriction(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    europe_only = None
    # Attribute is overwritten below the class definition
    none = None
    # Attribute is overwritten below the class definition
    other = None

    def is_europe_only(self):
        """
        Check if the union tag is ``europe_only``.

        :rtype: bool
        """
        return self._tag == 'europe_only'

    def is_none(self):
        """
        Check if the union tag is ``none``.

        :rtype: bool
        """
        return self._tag == 'none'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'PlacementRestriction(%r, %r)' % (self._tag, self._value)

PlacementRestriction_validator = bv.Union(PlacementRestriction)

class RemoveLogoutUrlDetails(object):
    """
    Removed single sign-on logout URL.

    :ivar previous_sso_logout_url: Previous single sign-on logout URL.
    :ivar new_sso_logout_url: New single sign-on logout URL. Might be missing
        due to historical data gap.
    """

    __slots__ = [
        '_previous_sso_logout_url_value',
        '_previous_sso_logout_url_present',
        '_new_sso_logout_url_value',
        '_new_sso_logout_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_sso_logout_url=None,
                 new_sso_logout_url=None):
        self._previous_sso_logout_url_value = None
        self._previous_sso_logout_url_present = False
        self._new_sso_logout_url_value = None
        self._new_sso_logout_url_present = False
        if previous_sso_logout_url is not None:
            self.previous_sso_logout_url = previous_sso_logout_url
        if new_sso_logout_url is not None:
            self.new_sso_logout_url = new_sso_logout_url

    @property
    def previous_sso_logout_url(self):
        """
        Previous single sign-on logout URL.

        :rtype: str
        """
        if self._previous_sso_logout_url_present:
            return self._previous_sso_logout_url_value
        else:
            raise AttributeError("missing required field 'previous_sso_logout_url'")

    @previous_sso_logout_url.setter
    def previous_sso_logout_url(self, val):
        val = self._previous_sso_logout_url_validator.validate(val)
        self._previous_sso_logout_url_value = val
        self._previous_sso_logout_url_present = True

    @previous_sso_logout_url.deleter
    def previous_sso_logout_url(self):
        self._previous_sso_logout_url_value = None
        self._previous_sso_logout_url_present = False

    @property
    def new_sso_logout_url(self):
        """
        New single sign-on logout URL. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._new_sso_logout_url_present:
            return self._new_sso_logout_url_value
        else:
            return None

    @new_sso_logout_url.setter
    def new_sso_logout_url(self, val):
        if val is None:
            del self.new_sso_logout_url
            return
        val = self._new_sso_logout_url_validator.validate(val)
        self._new_sso_logout_url_value = val
        self._new_sso_logout_url_present = True

    @new_sso_logout_url.deleter
    def new_sso_logout_url(self):
        self._new_sso_logout_url_value = None
        self._new_sso_logout_url_present = False

    def __repr__(self):
        return 'RemoveLogoutUrlDetails(previous_sso_logout_url={!r}, new_sso_logout_url={!r})'.format(
            self._previous_sso_logout_url_value,
            self._new_sso_logout_url_value,
        )

RemoveLogoutUrlDetails_validator = bv.Struct(RemoveLogoutUrlDetails)

class RemoveSsoUrlDetails(object):
    """
    Changed the sign-out URL for SSO.

    :ivar previous_sso_url: Previous SSO Url.
    """

    __slots__ = [
        '_previous_sso_url_value',
        '_previous_sso_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_sso_url=None):
        self._previous_sso_url_value = None
        self._previous_sso_url_present = False
        if previous_sso_url is not None:
            self.previous_sso_url = previous_sso_url

    @property
    def previous_sso_url(self):
        """
        Previous SSO Url.

        :rtype: str
        """
        if self._previous_sso_url_present:
            return self._previous_sso_url_value
        else:
            raise AttributeError("missing required field 'previous_sso_url'")

    @previous_sso_url.setter
    def previous_sso_url(self, val):
        val = self._previous_sso_url_validator.validate(val)
        self._previous_sso_url_value = val
        self._previous_sso_url_present = True

    @previous_sso_url.deleter
    def previous_sso_url(self):
        self._previous_sso_url_value = None
        self._previous_sso_url_present = False

    def __repr__(self):
        return 'RemoveSsoUrlDetails(previous_sso_url={!r})'.format(
            self._previous_sso_url_value,
        )

RemoveSsoUrlDetails_validator = bv.Struct(RemoveSsoUrlDetails)

class ResellerLogInfo(object):
    """
    Reseller information.

    :ivar reseller_name: Reseller name.
    :ivar reseller_id: Reseller ID.
    """

    __slots__ = [
        '_reseller_name_value',
        '_reseller_name_present',
        '_reseller_id_value',
        '_reseller_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 reseller_name=None,
                 reseller_id=None):
        self._reseller_name_value = None
        self._reseller_name_present = False
        self._reseller_id_value = None
        self._reseller_id_present = False
        if reseller_name is not None:
            self.reseller_name = reseller_name
        if reseller_id is not None:
            self.reseller_id = reseller_id

    @property
    def reseller_name(self):
        """
        Reseller name.

        :rtype: str
        """
        if self._reseller_name_present:
            return self._reseller_name_value
        else:
            raise AttributeError("missing required field 'reseller_name'")

    @reseller_name.setter
    def reseller_name(self, val):
        val = self._reseller_name_validator.validate(val)
        self._reseller_name_value = val
        self._reseller_name_present = True

    @reseller_name.deleter
    def reseller_name(self):
        self._reseller_name_value = None
        self._reseller_name_present = False

    @property
    def reseller_id(self):
        """
        Reseller ID.

        :rtype: str
        """
        if self._reseller_id_present:
            return self._reseller_id_value
        else:
            raise AttributeError("missing required field 'reseller_id'")

    @reseller_id.setter
    def reseller_id(self, val):
        val = self._reseller_id_validator.validate(val)
        self._reseller_id_value = val
        self._reseller_id_present = True

    @reseller_id.deleter
    def reseller_id(self):
        self._reseller_id_value = None
        self._reseller_id_present = False

    def __repr__(self):
        return 'ResellerLogInfo(reseller_name={!r}, reseller_id={!r})'.format(
            self._reseller_name_value,
            self._reseller_id_value,
        )

ResellerLogInfo_validator = bv.Struct(ResellerLogInfo)

class ResellerSupportSessionEndDetails(object):
    """
    Ended reseller support session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ResellerSupportSessionEndDetails()'

ResellerSupportSessionEndDetails_validator = bv.Struct(ResellerSupportSessionEndDetails)

class ResellerSupportSessionStartDetails(object):
    """
    Started reseller support session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ResellerSupportSessionStartDetails()'

ResellerSupportSessionStartDetails_validator = bv.Struct(ResellerSupportSessionStartDetails)

class SessionsManagementIdleLengthPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    none = None
    # Attribute is overwritten below the class definition
    minute_10 = None
    # Attribute is overwritten below the class definition
    minute_30 = None
    # Attribute is overwritten below the class definition
    hour_1 = None
    # Attribute is overwritten below the class definition
    hour_8 = None
    # Attribute is overwritten below the class definition
    hour_24 = None
    # Attribute is overwritten below the class definition
    hour_48 = None
    # Attribute is overwritten below the class definition
    other = None

    def is_none(self):
        """
        Check if the union tag is ``none``.

        :rtype: bool
        """
        return self._tag == 'none'

    def is_minute_10(self):
        """
        Check if the union tag is ``minute_10``.

        :rtype: bool
        """
        return self._tag == 'minute_10'

    def is_minute_30(self):
        """
        Check if the union tag is ``minute_30``.

        :rtype: bool
        """
        return self._tag == 'minute_30'

    def is_hour_1(self):
        """
        Check if the union tag is ``hour_1``.

        :rtype: bool
        """
        return self._tag == 'hour_1'

    def is_hour_8(self):
        """
        Check if the union tag is ``hour_8``.

        :rtype: bool
        """
        return self._tag == 'hour_8'

    def is_hour_24(self):
        """
        Check if the union tag is ``hour_24``.

        :rtype: bool
        """
        return self._tag == 'hour_24'

    def is_hour_48(self):
        """
        Check if the union tag is ``hour_48``.

        :rtype: bool
        """
        return self._tag == 'hour_48'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SessionsManagementIdleLengthPolicy(%r, %r)' % (self._tag, self._value)

SessionsManagementIdleLengthPolicy_validator = bv.Union(SessionsManagementIdleLengthPolicy)

class SessionsManagementSessionLengthPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    day_1 = None
    # Attribute is overwritten below the class definition
    day_7 = None
    # Attribute is overwritten below the class definition
    day_14 = None
    # Attribute is overwritten below the class definition
    month_1 = None
    # Attribute is overwritten below the class definition
    month_3 = None
    # Attribute is overwritten below the class definition
    month_6 = None
    # Attribute is overwritten below the class definition
    year_1 = None
    # Attribute is overwritten below the class definition
    other = None

    def is_day_1(self):
        """
        Check if the union tag is ``day_1``.

        :rtype: bool
        """
        return self._tag == 'day_1'

    def is_day_7(self):
        """
        Check if the union tag is ``day_7``.

        :rtype: bool
        """
        return self._tag == 'day_7'

    def is_day_14(self):
        """
        Check if the union tag is ``day_14``.

        :rtype: bool
        """
        return self._tag == 'day_14'

    def is_month_1(self):
        """
        Check if the union tag is ``month_1``.

        :rtype: bool
        """
        return self._tag == 'month_1'

    def is_month_3(self):
        """
        Check if the union tag is ``month_3``.

        :rtype: bool
        """
        return self._tag == 'month_3'

    def is_month_6(self):
        """
        Check if the union tag is ``month_6``.

        :rtype: bool
        """
        return self._tag == 'month_6'

    def is_year_1(self):
        """
        Check if the union tag is ``year_1``.

        :rtype: bool
        """
        return self._tag == 'year_1'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SessionsManagementSessionLengthPolicy(%r, %r)' % (self._tag, self._value)

SessionsManagementSessionLengthPolicy_validator = bv.Union(SessionsManagementSessionLengthPolicy)

class SfAddGroupDetails(object):
    """
    Added the team to a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar team_name: Team name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_team_name_value',
        '_team_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 team_name=None,
                 sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._team_name_value = None
        self._team_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if team_name is not None:
            self.team_name = team_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def team_name(self):
        """
        Team name.

        :rtype: str
        """
        if self._team_name_present:
            return self._team_name_value
        else:
            raise AttributeError("missing required field 'team_name'")

    @team_name.setter
    def team_name(self, val):
        val = self._team_name_validator.validate(val)
        self._team_name_value = val
        self._team_name_present = True

    @team_name.deleter
    def team_name(self):
        self._team_name_value = None
        self._team_name_present = False

    def __repr__(self):
        return 'SfAddGroupDetails(target_index={!r}, original_folder_name={!r}, team_name={!r}, sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._team_name_value,
            self._sharing_permission_value,
        )

SfAddGroupDetails_validator = bv.Struct(SfAddGroupDetails)

class SfAllowNonMembersToViewSharedLinksDetails(object):
    """
    Allowed non collaborators to view links to files in a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SfAllowNonMembersToViewSharedLinksDetails(target_index={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SfAllowNonMembersToViewSharedLinksDetails_validator = bv.Struct(SfAllowNonMembersToViewSharedLinksDetails)

class SfExternalInviteWarnDetails(object):
    """
    Admin settings: team members see a warning before sharing folders outside
    the team (DEPRECATED FEATURE).
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'SfExternalInviteWarnDetails()'

SfExternalInviteWarnDetails_validator = bv.Struct(SfExternalInviteWarnDetails)

class SfInviteGroupDetails(object):
    """
    Invited a group to a shared folder.

    :ivar target_index: Target asset index.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None):
        self._target_index_value = None
        self._target_index_present = False
        if target_index is not None:
            self.target_index = target_index

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    def __repr__(self):
        return 'SfInviteGroupDetails(target_index={!r})'.format(
            self._target_index_value,
        )

SfInviteGroupDetails_validator = bv.Struct(SfInviteGroupDetails)

class SfNestDetails(object):
    """
    Changed parent of shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar prev_parent_ns_id: Previous parent namespace ID. Might be missing due
        to historical data gap.
    :ivar new_parent_ns_id: New parent namespace ID. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_prev_parent_ns_id_value',
        '_prev_parent_ns_id_present',
        '_new_parent_ns_id_value',
        '_new_parent_ns_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 prev_parent_ns_id=None,
                 new_parent_ns_id=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._prev_parent_ns_id_value = None
        self._prev_parent_ns_id_present = False
        self._new_parent_ns_id_value = None
        self._new_parent_ns_id_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if prev_parent_ns_id is not None:
            self.prev_parent_ns_id = prev_parent_ns_id
        if new_parent_ns_id is not None:
            self.new_parent_ns_id = new_parent_ns_id

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def prev_parent_ns_id(self):
        """
        Previous parent namespace ID. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._prev_parent_ns_id_present:
            return self._prev_parent_ns_id_value
        else:
            return None

    @prev_parent_ns_id.setter
    def prev_parent_ns_id(self, val):
        if val is None:
            del self.prev_parent_ns_id
            return
        val = self._prev_parent_ns_id_validator.validate(val)
        self._prev_parent_ns_id_value = val
        self._prev_parent_ns_id_present = True

    @prev_parent_ns_id.deleter
    def prev_parent_ns_id(self):
        self._prev_parent_ns_id_value = None
        self._prev_parent_ns_id_present = False

    @property
    def new_parent_ns_id(self):
        """
        New parent namespace ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._new_parent_ns_id_present:
            return self._new_parent_ns_id_value
        else:
            return None

    @new_parent_ns_id.setter
    def new_parent_ns_id(self, val):
        if val is None:
            del self.new_parent_ns_id
            return
        val = self._new_parent_ns_id_validator.validate(val)
        self._new_parent_ns_id_value = val
        self._new_parent_ns_id_present = True

    @new_parent_ns_id.deleter
    def new_parent_ns_id(self):
        self._new_parent_ns_id_value = None
        self._new_parent_ns_id_present = False

    def __repr__(self):
        return 'SfNestDetails(target_index={!r}, original_folder_name={!r}, prev_parent_ns_id={!r}, new_parent_ns_id={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._prev_parent_ns_id_value,
            self._new_parent_ns_id_value,
        )

SfNestDetails_validator = bv.Struct(SfNestDetails)

class SfTeamDeclineDetails(object):
    """
    Declined a team member's invitation to a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SfTeamDeclineDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SfTeamDeclineDetails_validator = bv.Struct(SfTeamDeclineDetails)

class SfTeamGrantAccessDetails(object):
    """
    Granted access to a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SfTeamGrantAccessDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SfTeamGrantAccessDetails_validator = bv.Struct(SfTeamGrantAccessDetails)

class SfTeamInviteChangeRoleDetails(object):
    """
    Changed a team member's role in a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar previous_sharing_permission: Previous sharing permission. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_previous_sharing_permission_value',
        '_previous_sharing_permission_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 sharing_permission=None,
                 previous_sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._previous_sharing_permission_value = None
        self._previous_sharing_permission_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if previous_sharing_permission is not None:
            self.previous_sharing_permission = previous_sharing_permission

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def previous_sharing_permission(self):
        """
        Previous sharing permission. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._previous_sharing_permission_present:
            return self._previous_sharing_permission_value
        else:
            return None

    @previous_sharing_permission.setter
    def previous_sharing_permission(self, val):
        if val is None:
            del self.previous_sharing_permission
            return
        val = self._previous_sharing_permission_validator.validate(val)
        self._previous_sharing_permission_value = val
        self._previous_sharing_permission_present = True

    @previous_sharing_permission.deleter
    def previous_sharing_permission(self):
        self._previous_sharing_permission_value = None
        self._previous_sharing_permission_present = False

    def __repr__(self):
        return 'SfTeamInviteChangeRoleDetails(target_index={!r}, original_folder_name={!r}, sharing_permission={!r}, previous_sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._sharing_permission_value,
            self._previous_sharing_permission_value,
        )

SfTeamInviteChangeRoleDetails_validator = bv.Struct(SfTeamInviteChangeRoleDetails)

class SfTeamInviteDetails(object):
    """
    Invited team members to a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    def __repr__(self):
        return 'SfTeamInviteDetails(target_index={!r}, original_folder_name={!r}, sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._sharing_permission_value,
        )

SfTeamInviteDetails_validator = bv.Struct(SfTeamInviteDetails)

class SfTeamJoinDetails(object):
    """
    Joined a team member's shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SfTeamJoinDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SfTeamJoinDetails_validator = bv.Struct(SfTeamJoinDetails)

class SfTeamJoinFromOobLinkDetails(object):
    """
    Joined a team member's shared folder from a link.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar token_key: Shared link token key.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_token_key_value',
        '_token_key_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 token_key=None,
                 sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._token_key_value = None
        self._token_key_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if token_key is not None:
            self.token_key = token_key
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def token_key(self):
        """
        Shared link token key.

        :rtype: str
        """
        if self._token_key_present:
            return self._token_key_value
        else:
            return None

    @token_key.setter
    def token_key(self, val):
        if val is None:
            del self.token_key
            return
        val = self._token_key_validator.validate(val)
        self._token_key_value = val
        self._token_key_present = True

    @token_key.deleter
    def token_key(self):
        self._token_key_value = None
        self._token_key_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    def __repr__(self):
        return 'SfTeamJoinFromOobLinkDetails(target_index={!r}, original_folder_name={!r}, token_key={!r}, sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._token_key_value,
            self._sharing_permission_value,
        )

SfTeamJoinFromOobLinkDetails_validator = bv.Struct(SfTeamJoinFromOobLinkDetails)

class SfTeamUninviteDetails(object):
    """
    Unshared a folder with a team member.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SfTeamUninviteDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SfTeamUninviteDetails_validator = bv.Struct(SfTeamUninviteDetails)

class SharedContentAddInviteesDetails(object):
    """
    Sent an email invitation to the membership of a shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    def __repr__(self):
        return 'SharedContentAddInviteesDetails(target_index={!r}, original_folder_name={!r}, sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._sharing_permission_value,
        )

SharedContentAddInviteesDetails_validator = bv.Struct(SharedContentAddInviteesDetails)

class SharedContentAddLinkExpiryDetails(object):
    """
    Added an expiry to the link for the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar expiration_start_date: Expiration starting date.
    :ivar expiration_days: The number of days from the starting expiration date
        after which the link will expire.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_expiration_start_date_value',
        '_expiration_start_date_present',
        '_expiration_days_value',
        '_expiration_days_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 expiration_start_date=None,
                 expiration_days=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._expiration_start_date_value = None
        self._expiration_start_date_present = False
        self._expiration_days_value = None
        self._expiration_days_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if expiration_start_date is not None:
            self.expiration_start_date = expiration_start_date
        if expiration_days is not None:
            self.expiration_days = expiration_days

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def expiration_start_date(self):
        """
        Expiration starting date.

        :rtype: str
        """
        if self._expiration_start_date_present:
            return self._expiration_start_date_value
        else:
            raise AttributeError("missing required field 'expiration_start_date'")

    @expiration_start_date.setter
    def expiration_start_date(self, val):
        val = self._expiration_start_date_validator.validate(val)
        self._expiration_start_date_value = val
        self._expiration_start_date_present = True

    @expiration_start_date.deleter
    def expiration_start_date(self):
        self._expiration_start_date_value = None
        self._expiration_start_date_present = False

    @property
    def expiration_days(self):
        """
        The number of days from the starting expiration date after which the
        link will expire.

        :rtype: long
        """
        if self._expiration_days_present:
            return self._expiration_days_value
        else:
            raise AttributeError("missing required field 'expiration_days'")

    @expiration_days.setter
    def expiration_days(self, val):
        val = self._expiration_days_validator.validate(val)
        self._expiration_days_value = val
        self._expiration_days_present = True

    @expiration_days.deleter
    def expiration_days(self):
        self._expiration_days_value = None
        self._expiration_days_present = False

    def __repr__(self):
        return 'SharedContentAddLinkExpiryDetails(target_index={!r}, expiration_start_date={!r}, expiration_days={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._expiration_start_date_value,
            self._expiration_days_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SharedContentAddLinkExpiryDetails_validator = bv.Struct(SharedContentAddLinkExpiryDetails)

class SharedContentAddLinkPasswordDetails(object):
    """
    Added a password to the link for the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SharedContentAddLinkPasswordDetails(target_index={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SharedContentAddLinkPasswordDetails_validator = bv.Struct(SharedContentAddLinkPasswordDetails)

class SharedContentAddMemberDetails(object):
    """
    Added users and/or groups to the membership of a shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 sharing_permission=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SharedContentAddMemberDetails(target_index={!r}, original_folder_name={!r}, sharing_permission={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._sharing_permission_value,
            self._shared_folder_type_value,
        )

SharedContentAddMemberDetails_validator = bv.Struct(SharedContentAddMemberDetails)

class SharedContentChangeDownloadsPolicyDetails(object):
    """
    Changed whether members can download the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar new_value: New downlaod policy.
    :ivar previous_value: Previous downlaod policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 new_value=None,
                 original_folder_name=None,
                 shared_folder_type=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def new_value(self):
        """
        New downlaod policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous downlaod policy. Might be missing due to historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedContentChangeDownloadsPolicyDetails(target_index={!r}, new_value={!r}, original_folder_name={!r}, shared_folder_type={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._new_value_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
            self._previous_value_value,
        )

SharedContentChangeDownloadsPolicyDetails_validator = bv.Struct(SharedContentChangeDownloadsPolicyDetails)

class SharedContentChangeInviteeRoleDetails(object):
    """
    Changed the access type of an invitee to a shared file or folder before the
    invitation was claimed.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar previous_sharing_permission: Previous sharing permission. Might be
        missing due to historical data gap.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_previous_sharing_permission_value',
        '_previous_sharing_permission_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 previous_sharing_permission=None,
                 sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._previous_sharing_permission_value = None
        self._previous_sharing_permission_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if previous_sharing_permission is not None:
            self.previous_sharing_permission = previous_sharing_permission
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def previous_sharing_permission(self):
        """
        Previous sharing permission. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._previous_sharing_permission_present:
            return self._previous_sharing_permission_value
        else:
            return None

    @previous_sharing_permission.setter
    def previous_sharing_permission(self, val):
        if val is None:
            del self.previous_sharing_permission
            return
        val = self._previous_sharing_permission_validator.validate(val)
        self._previous_sharing_permission_value = val
        self._previous_sharing_permission_present = True

    @previous_sharing_permission.deleter
    def previous_sharing_permission(self):
        self._previous_sharing_permission_value = None
        self._previous_sharing_permission_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    def __repr__(self):
        return 'SharedContentChangeInviteeRoleDetails(target_index={!r}, original_folder_name={!r}, previous_sharing_permission={!r}, sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._previous_sharing_permission_value,
            self._sharing_permission_value,
        )

SharedContentChangeInviteeRoleDetails_validator = bv.Struct(SharedContentChangeInviteeRoleDetails)

class SharedContentChangeLinkAudienceDetails(object):
    """
    Changed the audience of the link for a shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar new_value: New link audience value.
    :ivar previous_value: Previous link audience value. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 new_value=None,
                 original_folder_name=None,
                 shared_folder_type=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def new_value(self):
        """
        New link audience value.

        :rtype: LinkAudience
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous link audience value. Might be missing due to historical data
        gap.

        :rtype: LinkAudience
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedContentChangeLinkAudienceDetails(target_index={!r}, new_value={!r}, original_folder_name={!r}, shared_folder_type={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._new_value_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
            self._previous_value_value,
        )

SharedContentChangeLinkAudienceDetails_validator = bv.Struct(SharedContentChangeLinkAudienceDetails)

class SharedContentChangeLinkExpiryDetails(object):
    """
    Changed the expiry of the link for the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar expiration_start_date: Expiration starting date.
    :ivar expiration_days: The number of days from the starting expiration date
        after which the link will expire.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_expiration_start_date_value',
        '_expiration_start_date_present',
        '_expiration_days_value',
        '_expiration_days_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 expiration_start_date=None,
                 expiration_days=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._expiration_start_date_value = None
        self._expiration_start_date_present = False
        self._expiration_days_value = None
        self._expiration_days_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if expiration_start_date is not None:
            self.expiration_start_date = expiration_start_date
        if expiration_days is not None:
            self.expiration_days = expiration_days

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def expiration_start_date(self):
        """
        Expiration starting date.

        :rtype: str
        """
        if self._expiration_start_date_present:
            return self._expiration_start_date_value
        else:
            raise AttributeError("missing required field 'expiration_start_date'")

    @expiration_start_date.setter
    def expiration_start_date(self, val):
        val = self._expiration_start_date_validator.validate(val)
        self._expiration_start_date_value = val
        self._expiration_start_date_present = True

    @expiration_start_date.deleter
    def expiration_start_date(self):
        self._expiration_start_date_value = None
        self._expiration_start_date_present = False

    @property
    def expiration_days(self):
        """
        The number of days from the starting expiration date after which the
        link will expire.

        :rtype: long
        """
        if self._expiration_days_present:
            return self._expiration_days_value
        else:
            raise AttributeError("missing required field 'expiration_days'")

    @expiration_days.setter
    def expiration_days(self, val):
        val = self._expiration_days_validator.validate(val)
        self._expiration_days_value = val
        self._expiration_days_present = True

    @expiration_days.deleter
    def expiration_days(self):
        self._expiration_days_value = None
        self._expiration_days_present = False

    def __repr__(self):
        return 'SharedContentChangeLinkExpiryDetails(target_index={!r}, expiration_start_date={!r}, expiration_days={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._expiration_start_date_value,
            self._expiration_days_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SharedContentChangeLinkExpiryDetails_validator = bv.Struct(SharedContentChangeLinkExpiryDetails)

class SharedContentChangeLinkPasswordDetails(object):
    """
    Changed the password on the link for the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SharedContentChangeLinkPasswordDetails(target_index={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SharedContentChangeLinkPasswordDetails_validator = bv.Struct(SharedContentChangeLinkPasswordDetails)

class SharedContentChangeMemberRoleDetails(object):
    """
    Changed the access type of a shared file or folder member.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar previous_sharing_permission: Previous sharing permission. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_previous_sharing_permission_value',
        '_previous_sharing_permission_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 sharing_permission=None,
                 shared_folder_type=None,
                 previous_sharing_permission=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._previous_sharing_permission_value = None
        self._previous_sharing_permission_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if previous_sharing_permission is not None:
            self.previous_sharing_permission = previous_sharing_permission

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def previous_sharing_permission(self):
        """
        Previous sharing permission. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._previous_sharing_permission_present:
            return self._previous_sharing_permission_value
        else:
            return None

    @previous_sharing_permission.setter
    def previous_sharing_permission(self, val):
        if val is None:
            del self.previous_sharing_permission
            return
        val = self._previous_sharing_permission_validator.validate(val)
        self._previous_sharing_permission_value = val
        self._previous_sharing_permission_present = True

    @previous_sharing_permission.deleter
    def previous_sharing_permission(self):
        self._previous_sharing_permission_value = None
        self._previous_sharing_permission_present = False

    def __repr__(self):
        return 'SharedContentChangeMemberRoleDetails(target_index={!r}, original_folder_name={!r}, sharing_permission={!r}, shared_folder_type={!r}, previous_sharing_permission={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._sharing_permission_value,
            self._shared_folder_type_value,
            self._previous_sharing_permission_value,
        )

SharedContentChangeMemberRoleDetails_validator = bv.Struct(SharedContentChangeMemberRoleDetails)

class SharedContentChangeViewerInfoPolicyDetails(object):
    """
    Changed whether members can see who viewed the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar new_value: New viewer info policy.
    :ivar previous_value: Previous view info policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 new_value=None,
                 original_folder_name=None,
                 shared_folder_type=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def new_value(self):
        """
        New viewer info policy.

        :rtype: EnableDisableChangePolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous view info policy. Might be missing due to historical data gap.

        :rtype: EnableDisableChangePolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedContentChangeViewerInfoPolicyDetails(target_index={!r}, new_value={!r}, original_folder_name={!r}, shared_folder_type={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._new_value_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
            self._previous_value_value,
        )

SharedContentChangeViewerInfoPolicyDetails_validator = bv.Struct(SharedContentChangeViewerInfoPolicyDetails)

class SharedContentClaimInvitationDetails(object):
    """
    Claimed membership to a team member's shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_content_link: Shared content link.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_content_link_value',
        '_shared_content_link_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_content_link=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_content_link_value = None
        self._shared_content_link_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_content_link is not None:
            self.shared_content_link = shared_content_link

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_content_link(self):
        """
        Shared content link.

        :rtype: str
        """
        if self._shared_content_link_present:
            return self._shared_content_link_value
        else:
            return None

    @shared_content_link.setter
    def shared_content_link(self, val):
        if val is None:
            del self.shared_content_link
            return
        val = self._shared_content_link_validator.validate(val)
        self._shared_content_link_value = val
        self._shared_content_link_present = True

    @shared_content_link.deleter
    def shared_content_link(self):
        self._shared_content_link_value = None
        self._shared_content_link_present = False

    def __repr__(self):
        return 'SharedContentClaimInvitationDetails(target_index={!r}, original_folder_name={!r}, shared_content_link={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_content_link_value,
        )

SharedContentClaimInvitationDetails_validator = bv.Struct(SharedContentClaimInvitationDetails)

class SharedContentCopyDetails(object):
    """
    Copied the shared file or folder to own Dropbox.

    :ivar shared_content_link: Shared content link.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar src_index: Source asset index.
    :ivar dest_index: Destination asset index.
    :ivar target_index: Target asset index.
    """

    __slots__ = [
        '_shared_content_link_value',
        '_shared_content_link_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_src_index_value',
        '_src_index_present',
        '_dest_index_value',
        '_dest_index_present',
        '_target_index_value',
        '_target_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_content_link=None,
                 src_index=None,
                 dest_index=None,
                 target_index=None,
                 sharing_permission=None):
        self._shared_content_link_value = None
        self._shared_content_link_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._src_index_value = None
        self._src_index_present = False
        self._dest_index_value = None
        self._dest_index_present = False
        self._target_index_value = None
        self._target_index_present = False
        if shared_content_link is not None:
            self.shared_content_link = shared_content_link
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if src_index is not None:
            self.src_index = src_index
        if dest_index is not None:
            self.dest_index = dest_index
        if target_index is not None:
            self.target_index = target_index

    @property
    def shared_content_link(self):
        """
        Shared content link.

        :rtype: str
        """
        if self._shared_content_link_present:
            return self._shared_content_link_value
        else:
            raise AttributeError("missing required field 'shared_content_link'")

    @shared_content_link.setter
    def shared_content_link(self, val):
        val = self._shared_content_link_validator.validate(val)
        self._shared_content_link_value = val
        self._shared_content_link_present = True

    @shared_content_link.deleter
    def shared_content_link(self):
        self._shared_content_link_value = None
        self._shared_content_link_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def src_index(self):
        """
        Source asset index.

        :rtype: long
        """
        if self._src_index_present:
            return self._src_index_value
        else:
            raise AttributeError("missing required field 'src_index'")

    @src_index.setter
    def src_index(self, val):
        val = self._src_index_validator.validate(val)
        self._src_index_value = val
        self._src_index_present = True

    @src_index.deleter
    def src_index(self):
        self._src_index_value = None
        self._src_index_present = False

    @property
    def dest_index(self):
        """
        Destination asset index.

        :rtype: long
        """
        if self._dest_index_present:
            return self._dest_index_value
        else:
            raise AttributeError("missing required field 'dest_index'")

    @dest_index.setter
    def dest_index(self, val):
        val = self._dest_index_validator.validate(val)
        self._dest_index_value = val
        self._dest_index_present = True

    @dest_index.deleter
    def dest_index(self):
        self._dest_index_value = None
        self._dest_index_present = False

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    def __repr__(self):
        return 'SharedContentCopyDetails(shared_content_link={!r}, src_index={!r}, dest_index={!r}, target_index={!r}, sharing_permission={!r})'.format(
            self._shared_content_link_value,
            self._src_index_value,
            self._dest_index_value,
            self._target_index_value,
            self._sharing_permission_value,
        )

SharedContentCopyDetails_validator = bv.Struct(SharedContentCopyDetails)

class SharedContentDownloadDetails(object):
    """
    Downloaded the shared file or folder.

    :ivar shared_content_link: Shared content link.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar target_index: Target asset index.
    """

    __slots__ = [
        '_shared_content_link_value',
        '_shared_content_link_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_target_index_value',
        '_target_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_content_link=None,
                 target_index=None,
                 sharing_permission=None):
        self._shared_content_link_value = None
        self._shared_content_link_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._target_index_value = None
        self._target_index_present = False
        if shared_content_link is not None:
            self.shared_content_link = shared_content_link
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if target_index is not None:
            self.target_index = target_index

    @property
    def shared_content_link(self):
        """
        Shared content link.

        :rtype: str
        """
        if self._shared_content_link_present:
            return self._shared_content_link_value
        else:
            raise AttributeError("missing required field 'shared_content_link'")

    @shared_content_link.setter
    def shared_content_link(self, val):
        val = self._shared_content_link_validator.validate(val)
        self._shared_content_link_value = val
        self._shared_content_link_present = True

    @shared_content_link.deleter
    def shared_content_link(self):
        self._shared_content_link_value = None
        self._shared_content_link_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    def __repr__(self):
        return 'SharedContentDownloadDetails(shared_content_link={!r}, target_index={!r}, sharing_permission={!r})'.format(
            self._shared_content_link_value,
            self._target_index_value,
            self._sharing_permission_value,
        )

SharedContentDownloadDetails_validator = bv.Struct(SharedContentDownloadDetails)

class SharedContentRelinquishMembershipDetails(object):
    """
    Left the membership of a shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SharedContentRelinquishMembershipDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SharedContentRelinquishMembershipDetails_validator = bv.Struct(SharedContentRelinquishMembershipDetails)

class SharedContentRemoveInviteeDetails(object):
    """
    Removed an invitee from the membership of a shared file or folder before it
    was claimed.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SharedContentRemoveInviteeDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SharedContentRemoveInviteeDetails_validator = bv.Struct(SharedContentRemoveInviteeDetails)

class SharedContentRemoveLinkExpiryDetails(object):
    """
    Removed the expiry of the link for the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SharedContentRemoveLinkExpiryDetails(target_index={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SharedContentRemoveLinkExpiryDetails_validator = bv.Struct(SharedContentRemoveLinkExpiryDetails)

class SharedContentRemoveLinkPasswordDetails(object):
    """
    Removed the password on the link for the shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SharedContentRemoveLinkPasswordDetails(target_index={!r}, original_folder_name={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_folder_type_value,
        )

SharedContentRemoveLinkPasswordDetails_validator = bv.Struct(SharedContentRemoveLinkPasswordDetails)

class SharedContentRemoveMemberDetails(object):
    """
    Removed a user or a group from the membership of a shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 sharing_permission=None,
                 shared_folder_type=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    def __repr__(self):
        return 'SharedContentRemoveMemberDetails(target_index={!r}, original_folder_name={!r}, sharing_permission={!r}, shared_folder_type={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._sharing_permission_value,
            self._shared_folder_type_value,
        )

SharedContentRemoveMemberDetails_validator = bv.Struct(SharedContentRemoveMemberDetails)

class SharedContentRequestAccessDetails(object):
    """
    Requested to be on the membership of a shared file or folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_content_link: Shared content link.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_content_link_value',
        '_shared_content_link_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 shared_content_link=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_content_link_value = None
        self._shared_content_link_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_content_link is not None:
            self.shared_content_link = shared_content_link

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_content_link(self):
        """
        Shared content link.

        :rtype: str
        """
        if self._shared_content_link_present:
            return self._shared_content_link_value
        else:
            return None

    @shared_content_link.setter
    def shared_content_link(self, val):
        if val is None:
            del self.shared_content_link
            return
        val = self._shared_content_link_validator.validate(val)
        self._shared_content_link_value = val
        self._shared_content_link_present = True

    @shared_content_link.deleter
    def shared_content_link(self):
        self._shared_content_link_value = None
        self._shared_content_link_present = False

    def __repr__(self):
        return 'SharedContentRequestAccessDetails(target_index={!r}, original_folder_name={!r}, shared_content_link={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._shared_content_link_value,
        )

SharedContentRequestAccessDetails_validator = bv.Struct(SharedContentRequestAccessDetails)

class SharedContentUnshareDetails(object):
    """
    Unshared a shared file or folder by clearing its membership and turning off
    its link.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            return None

    @original_folder_name.setter
    def original_folder_name(self, val):
        if val is None:
            del self.original_folder_name
            return
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SharedContentUnshareDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SharedContentUnshareDetails_validator = bv.Struct(SharedContentUnshareDetails)

class SharedContentViewDetails(object):
    """
    Previewed the shared file or folder.

    :ivar shared_content_link: Shared content link.
    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar target_index: Target asset index.
    """

    __slots__ = [
        '_shared_content_link_value',
        '_shared_content_link_present',
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_target_index_value',
        '_target_index_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 shared_content_link=None,
                 target_index=None,
                 sharing_permission=None):
        self._shared_content_link_value = None
        self._shared_content_link_present = False
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._target_index_value = None
        self._target_index_present = False
        if shared_content_link is not None:
            self.shared_content_link = shared_content_link
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if target_index is not None:
            self.target_index = target_index

    @property
    def shared_content_link(self):
        """
        Shared content link.

        :rtype: str
        """
        if self._shared_content_link_present:
            return self._shared_content_link_value
        else:
            raise AttributeError("missing required field 'shared_content_link'")

    @shared_content_link.setter
    def shared_content_link(self, val):
        val = self._shared_content_link_validator.validate(val)
        self._shared_content_link_value = val
        self._shared_content_link_present = True

    @shared_content_link.deleter
    def shared_content_link(self):
        self._shared_content_link_value = None
        self._shared_content_link_present = False

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    def __repr__(self):
        return 'SharedContentViewDetails(shared_content_link={!r}, target_index={!r}, sharing_permission={!r})'.format(
            self._shared_content_link_value,
            self._target_index_value,
            self._sharing_permission_value,
        )

SharedContentViewDetails_validator = bv.Struct(SharedContentViewDetails)

class SharedFolderChangeConfidentialityDetails(object):
    """
    Set or unset the confidential flag on a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar new_value: New confidentiality value.
    :ivar previous_value: Previous confidentiality value. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 new_value=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def new_value(self):
        """
        New confidentiality value.

        :rtype: Confidentiality
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous confidentiality value. Might be missing due to historical data
        gap.

        :rtype: Confidentiality
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedFolderChangeConfidentialityDetails(target_index={!r}, original_folder_name={!r}, new_value={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._new_value_value,
            self._previous_value_value,
        )

SharedFolderChangeConfidentialityDetails_validator = bv.Struct(SharedFolderChangeConfidentialityDetails)

class SharedFolderChangeLinkPolicyDetails(object):
    """
    Changed who can access the shared folder via a link.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar new_value: New shared folder link policy.
    :ivar previous_value: Previous shared folder link policy. Might be missing
        due to historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 new_value=None,
                 shared_folder_type=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def new_value(self):
        """
        New shared folder link policy.

        :rtype: SharedFolderLinkPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous shared folder link policy. Might be missing due to historical
        data gap.

        :rtype: SharedFolderLinkPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedFolderChangeLinkPolicyDetails(target_index={!r}, original_folder_name={!r}, new_value={!r}, shared_folder_type={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._new_value_value,
            self._shared_folder_type_value,
            self._previous_value_value,
        )

SharedFolderChangeLinkPolicyDetails_validator = bv.Struct(SharedFolderChangeLinkPolicyDetails)

class SharedFolderChangeMemberManagementPolicyDetails(object):
    """
    Changed who can manage the membership of a shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar new_value: New membership management policy.
    :ivar previous_value: Previous membership management policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 new_value=None,
                 shared_folder_type=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def new_value(self):
        """
        New membership management policy.

        :rtype: SharedFolderMembershipManagementPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous membership management policy. Might be missing due to
        historical data gap.

        :rtype: SharedFolderMembershipManagementPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedFolderChangeMemberManagementPolicyDetails(target_index={!r}, original_folder_name={!r}, new_value={!r}, shared_folder_type={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._new_value_value,
            self._shared_folder_type_value,
            self._previous_value_value,
        )

SharedFolderChangeMemberManagementPolicyDetails_validator = bv.Struct(SharedFolderChangeMemberManagementPolicyDetails)

class SharedFolderChangeMemberPolicyDetails(object):
    """
    Changed who can become a member of the shared folder.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    :ivar shared_folder_type: Shared folder type. Might be missing due to
        historical data gap.
    :ivar new_value: New external invite policy.
    :ivar previous_value: Previous external invite policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
        '_shared_folder_type_value',
        '_shared_folder_type_present',
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None,
                 new_value=None,
                 shared_folder_type=None,
                 previous_value=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name
        if shared_folder_type is not None:
            self.shared_folder_type = shared_folder_type
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    @property
    def shared_folder_type(self):
        """
        Shared folder type. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._shared_folder_type_present:
            return self._shared_folder_type_value
        else:
            return None

    @shared_folder_type.setter
    def shared_folder_type(self, val):
        if val is None:
            del self.shared_folder_type
            return
        val = self._shared_folder_type_validator.validate(val)
        self._shared_folder_type_value = val
        self._shared_folder_type_present = True

    @shared_folder_type.deleter
    def shared_folder_type(self):
        self._shared_folder_type_value = None
        self._shared_folder_type_present = False

    @property
    def new_value(self):
        """
        New external invite policy.

        :rtype: ExternalSharingPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous external invite policy. Might be missing due to historical data
        gap.

        :rtype: ExternalSharingPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharedFolderChangeMemberPolicyDetails(target_index={!r}, original_folder_name={!r}, new_value={!r}, shared_folder_type={!r}, previous_value={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
            self._new_value_value,
            self._shared_folder_type_value,
            self._previous_value_value,
        )

SharedFolderChangeMemberPolicyDetails_validator = bv.Struct(SharedFolderChangeMemberPolicyDetails)

class SharedFolderCreateDetails(object):
    """
    Created a shared folder.

    :ivar target_index: Target asset index.
    :ivar parent_ns_id: Parent namespace ID. Might be missing due to historical
        data gap.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_parent_ns_id_value',
        '_parent_ns_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 parent_ns_id=None):
        self._target_index_value = None
        self._target_index_present = False
        self._parent_ns_id_value = None
        self._parent_ns_id_present = False
        if target_index is not None:
            self.target_index = target_index
        if parent_ns_id is not None:
            self.parent_ns_id = parent_ns_id

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def parent_ns_id(self):
        """
        Parent namespace ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._parent_ns_id_present:
            return self._parent_ns_id_value
        else:
            return None

    @parent_ns_id.setter
    def parent_ns_id(self, val):
        if val is None:
            del self.parent_ns_id
            return
        val = self._parent_ns_id_validator.validate(val)
        self._parent_ns_id_value = val
        self._parent_ns_id_present = True

    @parent_ns_id.deleter
    def parent_ns_id(self):
        self._parent_ns_id_value = None
        self._parent_ns_id_present = False

    def __repr__(self):
        return 'SharedFolderCreateDetails(target_index={!r}, parent_ns_id={!r})'.format(
            self._target_index_value,
            self._parent_ns_id_value,
        )

SharedFolderCreateDetails_validator = bv.Struct(SharedFolderCreateDetails)

class SharedFolderLinkPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    members_only = None
    # Attribute is overwritten below the class definition
    members_and_team = None
    # Attribute is overwritten below the class definition
    anyone = None
    # Attribute is overwritten below the class definition
    other = None

    def is_members_only(self):
        """
        Check if the union tag is ``members_only``.

        :rtype: bool
        """
        return self._tag == 'members_only'

    def is_members_and_team(self):
        """
        Check if the union tag is ``members_and_team``.

        :rtype: bool
        """
        return self._tag == 'members_and_team'

    def is_anyone(self):
        """
        Check if the union tag is ``anyone``.

        :rtype: bool
        """
        return self._tag == 'anyone'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedFolderLinkPolicy(%r, %r)' % (self._tag, self._value)

SharedFolderLinkPolicy_validator = bv.Union(SharedFolderLinkPolicy)

class SharedFolderLogInfo(object):
    """
    SharedFolder's logged information.

    :ivar ns_id: Namespace ID. Might be missing due to historical data gap.
    :ivar display_name: Shared folder display name.
    """

    __slots__ = [
        '_ns_id_value',
        '_ns_id_present',
        '_display_name_value',
        '_display_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 display_name=None,
                 ns_id=None):
        self._ns_id_value = None
        self._ns_id_present = False
        self._display_name_value = None
        self._display_name_present = False
        if ns_id is not None:
            self.ns_id = ns_id
        if display_name is not None:
            self.display_name = display_name

    @property
    def ns_id(self):
        """
        Namespace ID. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._ns_id_present:
            return self._ns_id_value
        else:
            return None

    @ns_id.setter
    def ns_id(self, val):
        if val is None:
            del self.ns_id
            return
        val = self._ns_id_validator.validate(val)
        self._ns_id_value = val
        self._ns_id_present = True

    @ns_id.deleter
    def ns_id(self):
        self._ns_id_value = None
        self._ns_id_present = False

    @property
    def display_name(self):
        """
        Shared folder display name.

        :rtype: str
        """
        if self._display_name_present:
            return self._display_name_value
        else:
            raise AttributeError("missing required field 'display_name'")

    @display_name.setter
    def display_name(self, val):
        val = self._display_name_validator.validate(val)
        self._display_name_value = val
        self._display_name_present = True

    @display_name.deleter
    def display_name(self):
        self._display_name_value = None
        self._display_name_present = False

    def __repr__(self):
        return 'SharedFolderLogInfo(display_name={!r}, ns_id={!r})'.format(
            self._display_name_value,
            self._ns_id_value,
        )

SharedFolderLogInfo_validator = bv.Struct(SharedFolderLogInfo)

class SharedFolderMembershipManagementPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    owner = None
    # Attribute is overwritten below the class definition
    editors = None
    # Attribute is overwritten below the class definition
    other = None

    def is_owner(self):
        """
        Check if the union tag is ``owner``.

        :rtype: bool
        """
        return self._tag == 'owner'

    def is_editors(self):
        """
        Check if the union tag is ``editors``.

        :rtype: bool
        """
        return self._tag == 'editors'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SharedFolderMembershipManagementPolicy(%r, %r)' % (self._tag, self._value)

SharedFolderMembershipManagementPolicy_validator = bv.Union(SharedFolderMembershipManagementPolicy)

class SharedFolderMountDetails(object):
    """
    Added a shared folder to own Dropbox.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SharedFolderMountDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SharedFolderMountDetails_validator = bv.Struct(SharedFolderMountDetails)

class SharedFolderTransferOwnershipDetails(object):
    """
    Transferred the ownership of a shared folder to another member.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SharedFolderTransferOwnershipDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SharedFolderTransferOwnershipDetails_validator = bv.Struct(SharedFolderTransferOwnershipDetails)

class SharedFolderUnmountDetails(object):
    """
    Deleted a shared folder from Dropbox.

    :ivar target_index: Target asset index.
    :ivar original_folder_name: Original shared folder name.
    """

    __slots__ = [
        '_target_index_value',
        '_target_index_present',
        '_original_folder_name_value',
        '_original_folder_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 target_index=None,
                 original_folder_name=None):
        self._target_index_value = None
        self._target_index_present = False
        self._original_folder_name_value = None
        self._original_folder_name_present = False
        if target_index is not None:
            self.target_index = target_index
        if original_folder_name is not None:
            self.original_folder_name = original_folder_name

    @property
    def target_index(self):
        """
        Target asset index.

        :rtype: long
        """
        if self._target_index_present:
            return self._target_index_value
        else:
            raise AttributeError("missing required field 'target_index'")

    @target_index.setter
    def target_index(self, val):
        val = self._target_index_validator.validate(val)
        self._target_index_value = val
        self._target_index_present = True

    @target_index.deleter
    def target_index(self):
        self._target_index_value = None
        self._target_index_present = False

    @property
    def original_folder_name(self):
        """
        Original shared folder name.

        :rtype: str
        """
        if self._original_folder_name_present:
            return self._original_folder_name_value
        else:
            raise AttributeError("missing required field 'original_folder_name'")

    @original_folder_name.setter
    def original_folder_name(self, val):
        val = self._original_folder_name_validator.validate(val)
        self._original_folder_name_value = val
        self._original_folder_name_present = True

    @original_folder_name.deleter
    def original_folder_name(self):
        self._original_folder_name_value = None
        self._original_folder_name_present = False

    def __repr__(self):
        return 'SharedFolderUnmountDetails(target_index={!r}, original_folder_name={!r})'.format(
            self._target_index_value,
            self._original_folder_name_value,
        )

SharedFolderUnmountDetails_validator = bv.Struct(SharedFolderUnmountDetails)

class SharedNoteOpenedDetails(object):
    """
    Shared Paper document was opened.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'SharedNoteOpenedDetails()'

SharedNoteOpenedDetails_validator = bv.Struct(SharedNoteOpenedDetails)

class SharingChangeFolderJoinPolicyDetails(object):
    """
    Changed whether team members can join shared folders owned externally (i.e.
    outside the team).

    :ivar new_value: New external join policy.
    :ivar previous_value: Previous external join policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New external join policy.

        :rtype: ExternalSharingPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous external join policy. Might be missing due to historical data
        gap.

        :rtype: ExternalSharingPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharingChangeFolderJoinPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

SharingChangeFolderJoinPolicyDetails_validator = bv.Struct(SharingChangeFolderJoinPolicyDetails)

class SharingChangeLinkPolicyDetails(object):
    """
    Changed whether team members can share links externally (i.e. outside the
    team), and if so, whether links should be accessible only by team members or
    anyone by default.

    :ivar new_value: New external link accessibility policy.
    :ivar previous_value: Previous external link accessibility policy. Might be
        missing due to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New external link accessibility policy.

        :rtype: ExternalSharingAccessibilityPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous external link accessibility policy. Might be missing due to
        historical data gap.

        :rtype: ExternalSharingAccessibilityPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharingChangeLinkPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

SharingChangeLinkPolicyDetails_validator = bv.Struct(SharingChangeLinkPolicyDetails)

class SharingChangeMemberPolicyDetails(object):
    """
    Changed whether team members can share files and folders externally (i.e.
    outside the team).

    :ivar new_value: New external invite policy.
    :ivar previous_value: Previous external invite policy. Might be missing due
        to historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New external invite policy.

        :rtype: ExternalSharingPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous external invite policy. Might be missing due to historical data
        gap.

        :rtype: ExternalSharingPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SharingChangeMemberPolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

SharingChangeMemberPolicyDetails_validator = bv.Struct(SharingChangeMemberPolicyDetails)

class ShmodelAppCreateDetails(object):
    """
    Created a link to a file using an app.

    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar token_key: Shared link token key.
    """

    __slots__ = [
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_token_key_value',
        '_token_key_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 sharing_permission=None,
                 token_key=None):
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._token_key_value = None
        self._token_key_present = False
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if token_key is not None:
            self.token_key = token_key

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def token_key(self):
        """
        Shared link token key.

        :rtype: str
        """
        if self._token_key_present:
            return self._token_key_value
        else:
            return None

    @token_key.setter
    def token_key(self, val):
        if val is None:
            del self.token_key
            return
        val = self._token_key_validator.validate(val)
        self._token_key_value = val
        self._token_key_present = True

    @token_key.deleter
    def token_key(self):
        self._token_key_value = None
        self._token_key_present = False

    def __repr__(self):
        return 'ShmodelAppCreateDetails(sharing_permission={!r}, token_key={!r})'.format(
            self._sharing_permission_value,
            self._token_key_value,
        )

ShmodelAppCreateDetails_validator = bv.Struct(ShmodelAppCreateDetails)

class ShmodelCreateDetails(object):
    """
    Created a new link.

    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar token_key: Shared link token key.
    """

    __slots__ = [
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_token_key_value',
        '_token_key_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 sharing_permission=None,
                 token_key=None):
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._token_key_value = None
        self._token_key_present = False
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if token_key is not None:
            self.token_key = token_key

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def token_key(self):
        """
        Shared link token key.

        :rtype: str
        """
        if self._token_key_present:
            return self._token_key_value
        else:
            return None

    @token_key.setter
    def token_key(self, val):
        if val is None:
            del self.token_key
            return
        val = self._token_key_validator.validate(val)
        self._token_key_value = val
        self._token_key_present = True

    @token_key.deleter
    def token_key(self):
        self._token_key_value = None
        self._token_key_present = False

    def __repr__(self):
        return 'ShmodelCreateDetails(sharing_permission={!r}, token_key={!r})'.format(
            self._sharing_permission_value,
            self._token_key_value,
        )

ShmodelCreateDetails_validator = bv.Struct(ShmodelCreateDetails)

class ShmodelDisableDetails(object):
    """
    Removed a link.

    :ivar sharing_permission: Sharing permission. Might be missing due to
        historical data gap.
    :ivar token_key: Shared link token key.
    """

    __slots__ = [
        '_sharing_permission_value',
        '_sharing_permission_present',
        '_token_key_value',
        '_token_key_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 sharing_permission=None,
                 token_key=None):
        self._sharing_permission_value = None
        self._sharing_permission_present = False
        self._token_key_value = None
        self._token_key_present = False
        if sharing_permission is not None:
            self.sharing_permission = sharing_permission
        if token_key is not None:
            self.token_key = token_key

    @property
    def sharing_permission(self):
        """
        Sharing permission. Might be missing due to historical data gap.

        :rtype: str
        """
        if self._sharing_permission_present:
            return self._sharing_permission_value
        else:
            return None

    @sharing_permission.setter
    def sharing_permission(self, val):
        if val is None:
            del self.sharing_permission
            return
        val = self._sharing_permission_validator.validate(val)
        self._sharing_permission_value = val
        self._sharing_permission_present = True

    @sharing_permission.deleter
    def sharing_permission(self):
        self._sharing_permission_value = None
        self._sharing_permission_present = False

    @property
    def token_key(self):
        """
        Shared link token key.

        :rtype: str
        """
        if self._token_key_present:
            return self._token_key_value
        else:
            return None

    @token_key.setter
    def token_key(self, val):
        if val is None:
            del self.token_key
            return
        val = self._token_key_validator.validate(val)
        self._token_key_value = val
        self._token_key_present = True

    @token_key.deleter
    def token_key(self):
        self._token_key_value = None
        self._token_key_present = False

    def __repr__(self):
        return 'ShmodelDisableDetails(sharing_permission={!r}, token_key={!r})'.format(
            self._sharing_permission_value,
            self._token_key_value,
        )

ShmodelDisableDetails_validator = bv.Struct(ShmodelDisableDetails)

class ShmodelFbShareDetails(object):
    """
    Shared a link with Facebook users.

    :ivar sharing_non_member_recipients: Sharing non member recipients.
    """

    __slots__ = [
        '_sharing_non_member_recipients_value',
        '_sharing_non_member_recipients_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 sharing_non_member_recipients=None):
        self._sharing_non_member_recipients_value = None
        self._sharing_non_member_recipients_present = False
        if sharing_non_member_recipients is not None:
            self.sharing_non_member_recipients = sharing_non_member_recipients

    @property
    def sharing_non_member_recipients(self):
        """
        Sharing non member recipients.

        :rtype: list of [NonTeamMemberLogInfo]
        """
        if self._sharing_non_member_recipients_present:
            return self._sharing_non_member_recipients_value
        else:
            raise AttributeError("missing required field 'sharing_non_member_recipients'")

    @sharing_non_member_recipients.setter
    def sharing_non_member_recipients(self, val):
        val = self._sharing_non_member_recipients_validator.validate(val)
        self._sharing_non_member_recipients_value = val
        self._sharing_non_member_recipients_present = True

    @sharing_non_member_recipients.deleter
    def sharing_non_member_recipients(self):
        self._sharing_non_member_recipients_value = None
        self._sharing_non_member_recipients_present = False

    def __repr__(self):
        return 'ShmodelFbShareDetails(sharing_non_member_recipients={!r})'.format(
            self._sharing_non_member_recipients_value,
        )

ShmodelFbShareDetails_validator = bv.Struct(ShmodelFbShareDetails)

class ShmodelGroupShareDetails(object):
    """
    Shared a link with a group.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelGroupShareDetails()'

ShmodelGroupShareDetails_validator = bv.Struct(ShmodelGroupShareDetails)

class ShmodelRemoveExpirationDetails(object):
    """
    Removed the expiration date from a link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelRemoveExpirationDetails()'

ShmodelRemoveExpirationDetails_validator = bv.Struct(ShmodelRemoveExpirationDetails)

class ShmodelSetExpirationDetails(object):
    """
    Added an expiration date to a link.

    :ivar expiration_start_date: Expiration starting date.
    :ivar expiration_days: The number of days from the starting expiration date
        after which the link will expire.
    """

    __slots__ = [
        '_expiration_start_date_value',
        '_expiration_start_date_present',
        '_expiration_days_value',
        '_expiration_days_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 expiration_start_date=None,
                 expiration_days=None):
        self._expiration_start_date_value = None
        self._expiration_start_date_present = False
        self._expiration_days_value = None
        self._expiration_days_present = False
        if expiration_start_date is not None:
            self.expiration_start_date = expiration_start_date
        if expiration_days is not None:
            self.expiration_days = expiration_days

    @property
    def expiration_start_date(self):
        """
        Expiration starting date.

        :rtype: str
        """
        if self._expiration_start_date_present:
            return self._expiration_start_date_value
        else:
            raise AttributeError("missing required field 'expiration_start_date'")

    @expiration_start_date.setter
    def expiration_start_date(self, val):
        val = self._expiration_start_date_validator.validate(val)
        self._expiration_start_date_value = val
        self._expiration_start_date_present = True

    @expiration_start_date.deleter
    def expiration_start_date(self):
        self._expiration_start_date_value = None
        self._expiration_start_date_present = False

    @property
    def expiration_days(self):
        """
        The number of days from the starting expiration date after which the
        link will expire.

        :rtype: long
        """
        if self._expiration_days_present:
            return self._expiration_days_value
        else:
            raise AttributeError("missing required field 'expiration_days'")

    @expiration_days.setter
    def expiration_days(self, val):
        val = self._expiration_days_validator.validate(val)
        self._expiration_days_value = val
        self._expiration_days_present = True

    @expiration_days.deleter
    def expiration_days(self):
        self._expiration_days_value = None
        self._expiration_days_present = False

    def __repr__(self):
        return 'ShmodelSetExpirationDetails(expiration_start_date={!r}, expiration_days={!r})'.format(
            self._expiration_start_date_value,
            self._expiration_days_value,
        )

ShmodelSetExpirationDetails_validator = bv.Struct(ShmodelSetExpirationDetails)

class ShmodelTeamCopyDetails(object):
    """
    Added a team member's file/folder to their Dropbox from a link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelTeamCopyDetails()'

ShmodelTeamCopyDetails_validator = bv.Struct(ShmodelTeamCopyDetails)

class ShmodelTeamDownloadDetails(object):
    """
    Downloaded a team member's file/folder from a link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelTeamDownloadDetails()'

ShmodelTeamDownloadDetails_validator = bv.Struct(ShmodelTeamDownloadDetails)

class ShmodelTeamShareDetails(object):
    """
    Shared a link with team members.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelTeamShareDetails()'

ShmodelTeamShareDetails_validator = bv.Struct(ShmodelTeamShareDetails)

class ShmodelTeamViewDetails(object):
    """
    Opened a team member's link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelTeamViewDetails()'

ShmodelTeamViewDetails_validator = bv.Struct(ShmodelTeamViewDetails)

class ShmodelVisibilityPasswordDetails(object):
    """
    Password-protected a link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelVisibilityPasswordDetails()'

ShmodelVisibilityPasswordDetails_validator = bv.Struct(ShmodelVisibilityPasswordDetails)

class ShmodelVisibilityPublicDetails(object):
    """
    Made a file/folder visible to anyone with the link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelVisibilityPublicDetails()'

ShmodelVisibilityPublicDetails_validator = bv.Struct(ShmodelVisibilityPublicDetails)

class ShmodelVisibilityTeamOnlyDetails(object):
    """
    Made a file/folder visible only to team members with the link.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'ShmodelVisibilityTeamOnlyDetails()'

ShmodelVisibilityTeamOnlyDetails_validator = bv.Struct(ShmodelVisibilityTeamOnlyDetails)

class SignInAsSessionEndDetails(object):
    """
    Ended admin sign-in-as session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'SignInAsSessionEndDetails()'

SignInAsSessionEndDetails_validator = bv.Struct(SignInAsSessionEndDetails)

class SignInAsSessionStartDetails(object):
    """
    Started admin sign-in-as session.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'SignInAsSessionStartDetails()'

SignInAsSessionStartDetails_validator = bv.Struct(SignInAsSessionStartDetails)

class SmartSyncChangePolicyDetails(object):
    """
    Changed the default Smart Sync policy for team members.

    :ivar new_value: New smart sync policy.
    :ivar previous_value: Previous smart sync policy. Might be missing due to
        historical data gap.
    """

    __slots__ = [
        '_new_value_value',
        '_new_value_present',
        '_previous_value_value',
        '_previous_value_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 new_value=None,
                 previous_value=None):
        self._new_value_value = None
        self._new_value_present = False
        self._previous_value_value = None
        self._previous_value_present = False
        if new_value is not None:
            self.new_value = new_value
        if previous_value is not None:
            self.previous_value = previous_value

    @property
    def new_value(self):
        """
        New smart sync policy.

        :rtype: SmartSyncPolicy
        """
        if self._new_value_present:
            return self._new_value_value
        else:
            raise AttributeError("missing required field 'new_value'")

    @new_value.setter
    def new_value(self, val):
        self._new_value_validator.validate_type_only(val)
        self._new_value_value = val
        self._new_value_present = True

    @new_value.deleter
    def new_value(self):
        self._new_value_value = None
        self._new_value_present = False

    @property
    def previous_value(self):
        """
        Previous smart sync policy. Might be missing due to historical data gap.

        :rtype: SmartSyncPolicy
        """
        if self._previous_value_present:
            return self._previous_value_value
        else:
            return None

    @previous_value.setter
    def previous_value(self, val):
        if val is None:
            del self.previous_value
            return
        self._previous_value_validator.validate_type_only(val)
        self._previous_value_value = val
        self._previous_value_present = True

    @previous_value.deleter
    def previous_value(self):
        self._previous_value_value = None
        self._previous_value_present = False

    def __repr__(self):
        return 'SmartSyncChangePolicyDetails(new_value={!r}, previous_value={!r})'.format(
            self._new_value_value,
            self._previous_value_value,
        )

SmartSyncChangePolicyDetails_validator = bv.Struct(SmartSyncChangePolicyDetails)

class SmartSyncCreateAdminPrivilegeReportDetails(object):
    """
    Smart Sync non-admin devices report created.
    """

    __slots__ = [
    ]

    _has_required_fields = False

    def __init__(self):
        pass

    def __repr__(self):
        return 'SmartSyncCreateAdminPrivilegeReportDetails()'

SmartSyncCreateAdminPrivilegeReportDetails_validator = bv.Struct(SmartSyncCreateAdminPrivilegeReportDetails)

class SmartSyncPolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    local_only = None
    # Attribute is overwritten below the class definition
    synced = None
    # Attribute is overwritten below the class definition
    other = None

    def is_local_only(self):
        """
        Check if the union tag is ``local_only``.

        :rtype: bool
        """
        return self._tag == 'local_only'

    def is_synced(self):
        """
        Check if the union tag is ``synced``.

        :rtype: bool
        """
        return self._tag == 'synced'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SmartSyncPolicy(%r, %r)' % (self._tag, self._value)

SmartSyncPolicy_validator = bv.Union(SmartSyncPolicy)

class SpaceLimitsLevel(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    generous = None
    # Attribute is overwritten below the class definition
    moderate = None
    # Attribute is overwritten below the class definition
    no_limit = None
    # Attribute is overwritten below the class definition
    strict = None
    # Attribute is overwritten below the class definition
    other = None

    def is_generous(self):
        """
        Check if the union tag is ``generous``.

        :rtype: bool
        """
        return self._tag == 'generous'

    def is_moderate(self):
        """
        Check if the union tag is ``moderate``.

        :rtype: bool
        """
        return self._tag == 'moderate'

    def is_no_limit(self):
        """
        Check if the union tag is ``no_limit``.

        :rtype: bool
        """
        return self._tag == 'no_limit'

    def is_strict(self):
        """
        Check if the union tag is ``strict``.

        :rtype: bool
        """
        return self._tag == 'strict'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SpaceLimitsLevel(%r, %r)' % (self._tag, self._value)

SpaceLimitsLevel_validator = bv.Union(SpaceLimitsLevel)

class SpaceLimitsStatus(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    within_quota = None
    # Attribute is overwritten below the class definition
    near_quota = None
    # Attribute is overwritten below the class definition
    over_quota = None
    # Attribute is overwritten below the class definition
    other = None

    def is_within_quota(self):
        """
        Check if the union tag is ``within_quota``.

        :rtype: bool
        """
        return self._tag == 'within_quota'

    def is_near_quota(self):
        """
        Check if the union tag is ``near_quota``.

        :rtype: bool
        """
        return self._tag == 'near_quota'

    def is_over_quota(self):
        """
        Check if the union tag is ``over_quota``.

        :rtype: bool
        """
        return self._tag == 'over_quota'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def __repr__(self):
        return 'SpaceLimitsStatus(%r, %r)' % (self._tag, self._value)

SpaceLimitsStatus_validator = bv.Union(SpaceLimitsStatus)

class SsoChangeCertDetails(object):
    """
    Changed the X.509 certificate for SSO.

    :ivar subject: Certificate subject.
    :ivar issuer: Certificate issuer.
    :ivar issue_date: Certificate issue date.
    :ivar expiration_date: Certificate expiration date.
    :ivar serial_number: Certificate serial number.
    :ivar sha1_fingerprint: Certificate sha1 fingerprint.
    :ivar common_name: Certificate common name.
    """

    __slots__ = [
        '_subject_value',
        '_subject_present',
        '_issuer_value',
        '_issuer_present',
        '_issue_date_value',
        '_issue_date_present',
        '_expiration_date_value',
        '_expiration_date_present',
        '_serial_number_value',
        '_serial_number_present',
        '_sha1_fingerprint_value',
        '_sha1_fingerprint_present',
        '_common_name_value',
        '_common_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 subject=None,
                 issuer=None,
                 issue_date=None,
                 expiration_date=None,
                 serial_number=None,
                 sha1_fingerprint=None,
                 common_name=None):
        self._subject_value = None
        self._subject_present = False
        self._issuer_value = None
        self._issuer_present = False
        self._issue_date_value = None
        self._issue_date_present = False
        self._expiration_date_value = None
        self._expiration_date_present = False
        self._serial_number_value = None
        self._serial_number_present = False
        self._sha1_fingerprint_value = None
        self._sha1_fingerprint_present = False
        self._common_name_value = None
        self._common_name_present = False
        if subject is not None:
            self.subject = subject
        if issuer is not None:
            self.issuer = issuer
        if issue_date is not None:
            self.issue_date = issue_date
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if serial_number is not None:
            self.serial_number = serial_number
        if sha1_fingerprint is not None:
            self.sha1_fingerprint = sha1_fingerprint
        if common_name is not None:
            self.common_name = common_name

    @property
    def subject(self):
        """
        Certificate subject.

        :rtype: str
        """
        if self._subject_present:
            return self._subject_value
        else:
            raise AttributeError("missing required field 'subject'")

    @subject.setter
    def subject(self, val):
        val = self._subject_validator.validate(val)
        self._subject_value = val
        self._subject_present = True

    @subject.deleter
    def subject(self):
        self._subject_value = None
        self._subject_present = False

    @property
    def issuer(self):
        """
        Certificate issuer.

        :rtype: str
        """
        if self._issuer_present:
            return self._issuer_value
        else:
            raise AttributeError("missing required field 'issuer'")

    @issuer.setter
    def issuer(self, val):
        val = self._issuer_validator.validate(val)
        self._issuer_value = val
        self._issuer_present = True

    @issuer.deleter
    def issuer(self):
        self._issuer_value = None
        self._issuer_present = False

    @property
    def issue_date(self):
        """
        Certificate issue date.

        :rtype: str
        """
        if self._issue_date_present:
            return self._issue_date_value
        else:
            raise AttributeError("missing required field 'issue_date'")

    @issue_date.setter
    def issue_date(self, val):
        val = self._issue_date_validator.validate(val)
        self._issue_date_value = val
        self._issue_date_present = True

    @issue_date.deleter
    def issue_date(self):
        self._issue_date_value = None
        self._issue_date_present = False

    @property
    def expiration_date(self):
        """
        Certificate expiration date.

        :rtype: str
        """
        if self._expiration_date_present:
            return self._expiration_date_value
        else:
            raise AttributeError("missing required field 'expiration_date'")

    @expiration_date.setter
    def expiration_date(self, val):
        val = self._expiration_date_validator.validate(val)
        self._expiration_date_value = val
        self._expiration_date_present = True

    @expiration_date.deleter
    def expiration_date(self):
        self._expiration_date_value = None
        self._expiration_date_present = False

    @property
    def serial_number(self):
        """
        Certificate serial number.

        :rtype: str
        """
        if self._serial_number_present:
            return self._serial_number_value
        else:
            raise AttributeError("missing required field 'serial_number'")

    @serial_number.setter
    def serial_number(self, val):
        val = self._serial_number_validator.validate(val)
        self._serial_number_value = val
        self._serial_number_present = True

    @serial_number.deleter
    def serial_number(self):
        self._serial_number_value = None
        self._serial_number_present = False

    @property
    def sha1_fingerprint(self):
        """
        Certificate sha1 fingerprint.

        :rtype: str
        """
        if self._sha1_fingerprint_present:
            return self._sha1_fingerprint_value
        else:
            raise AttributeError("missing required field 'sha1_fingerprint'")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, val):
        val = self._sha1_fingerprint_validator.validate(val)
        self._sha1_fingerprint_value = val
        self._sha1_fingerprint_present = True

    @sha1_fingerprint.deleter
    def sha1_fingerprint(self):
        self._sha1_fingerprint_value = None
        self._sha1_fingerprint_present = False

    @property
    def common_name(self):
        """
        Certificate common name.

        :rtype: str
        """
        if self._common_name_present:
            return self._common_name_value
        else:
            raise AttributeError("missing required field 'common_name'")

    @common_name.setter
    def common_name(self, val):
        val = self._common_name_validator.validate(val)
        self._common_name_value = val
        self._common_name_present = True

    @common_name.deleter
    def common_name(self):
        self._common_name_value = None
        self._common_name_present = False

    def __repr__(self):
        return 'SsoChangeCertDetails(subject={!r}, issuer={!r}, issue_date={!r}, expiration_date={!r}, serial_number={!r}, sha1_fingerprint={!r}, common_name={!r})'.format(
            self._subject_value,
            self._issuer_value,
            self._issue_date_value,
            self._expiration_date_value,
            self._serial_number_value,
            self._sha1_fingerprint_value,
            self._common_name_value,
        )

SsoChangeCertDetails_validator = bv.Struct(SsoChangeCertDetails)

class SsoChangeLoginUrlDetails(object):
    """
    Changed the sign-in URL for SSO.

    :ivar previous_sso_url: Previous SSO Url.
    :ivar new_sso_url: New SSO Url.
    """

    __slots__ = [
        '_previous_sso_url_value',
        '_previous_sso_url_present',
        '_new_sso_url_value',
        '_new_sso_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_sso_url=None,
                 new_sso_url=None):
        self._previous_sso_url_value = None
        self._previous_sso_url_present = False
        self._new_sso_url_value = None
        self._new_sso_url_present = False
        if previous_sso_url is not None:
            self.previous_sso_url = previous_sso_url
        if new_sso_url is not None:
            self.new_sso_url = new_sso_url

    @property
    def previous_sso_url(self):
        """
        Previous SSO Url.

        :rtype: str
        """
        if self._previous_sso_url_present:
            return self._previous_sso_url_value
        else:
            raise AttributeError("missing required field 'previous_sso_url'")

    @previous_sso_url.setter
    def previous_sso_url(self, val):
        val = self._previous_sso_url_validator.validate(val)
        self._previous_sso_url_value = val
        self._previous_sso_url_present = True

    @previous_sso_url.deleter
    def previous_sso_url(self):
        self._previous_sso_url_value = None
        self._previous_sso_url_present = False

    @property
    def new_sso_url(self):
        """
        New SSO Url.

        :rtype: str
        """
        if self._new_sso_url_present:
            return self._new_sso_url_value
        else:
            raise AttributeError("missing required field 'new_sso_url'")

    @new_sso_url.setter
    def new_sso_url(self, val):
        val = self._new_sso_url_validator.validate(val)
        self._new_sso_url_value = val
        self._new_sso_url_present = True

    @new_sso_url.deleter
    def new_sso_url(self):
        self._new_sso_url_value = None
        self._new_sso_url_present = False

    def __repr__(self):
        return 'SsoChangeLoginUrlDetails(previous_sso_url={!r}, new_sso_url={!r})'.format(
            self._previous_sso_url_value,
            self._new_sso_url_value,
        )

SsoChangeLoginUrlDetails_validator = bv.Struct(SsoChangeLoginUrlDetails)

class SsoChangeLogoutUrlDetails(object):
    """
    Changed the sign-out URL for SSO.

    :ivar previous_sso_logout_url: Previous single sign-on logout URL.
    :ivar new_sso_logout_url: New single sign-on logout URL. Might be missing
        due to historical data gap.
    """

    __slots__ = [
        '_previous_sso_logout_url_value',
        '_previous_sso_logout_url_present',
        '_new_sso_logout_url_value',
        '_new_sso_logout_url_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 previous_sso_logout_url=None,
                 new_sso_logout_url=None):
        self._previous_sso_logout_url_value = None
        self._previous_sso_logout_url_present = False
        self._new_sso_logout_url_value = None
        self._new_sso_logout_url_present = False
        if previous_sso_logout_url is not None:
            self.previous_sso_logout_url = previous_sso_logout_url
        if new_sso_logout_url is not None:
            self.new_sso_logout_url = new_sso_logout_url

    @property
    def previous_sso_logout_url(self):
        """
        Previous single sign-on logout URL.

        :rtype: str
        """
        if self._previous_sso_logout_url_present:
            return self._previous_sso_logout_url_value
        else:
            raise AttributeError("missing required field 'previous_sso_logout_url'")

    @previous_sso_logout_url.setter
    def previous_sso_logout_url(self, val):
        val = self._previous_sso_logout_url_validator.validate(val)
        self._previous_sso_logout_url_value = val
        self._previous_sso_logout_url_present = True

    @previous_sso_logout_url.deleter
    def previous_sso_logout_url(self):
        self._previous_sso_logout_url_value = None
        self._previous_sso_logout_url_present = False

    @property
    def new_sso_logout_url(self):
        """
        New single sign-on logout URL. Might be missing due to historical data
        gap.

        :rtype: str
        """
        if self._new_sso_logout_url_present:
            return self._new_sso_logout_url_value
        else:
            return None

    @new_sso_logout_url.setter
    def new_sso_logout_url(self, val):
        if val is None:
            del self.new_sso_logout_url
            return
        val = self._new_sso_logout_url_validator.validate(val)
        self._new_sso_logout_url_value = val
        self._new_sso_logout_url_present = True

    @new_sso_logout_url.deleter
    def new_sso_logout_url(self)