/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.model.SiteNodeStringComparator;

class SortedTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 4130060741120936997L;
    private Comparator<SiteNode> comparator;

    public SortedTreeModel(TreeNode treeNode, SiteNodeStringComparator siteNodeStringComparator) {
        super(treeNode);
        this.comparator = siteNodeStringComparator;
    }

    public SortedTreeModel(TreeNode treeNode) {
        super(treeNode);
        this.comparator = new SiteNodeStringComparator();
    }

    public SortedTreeModel(TreeNode treeNode, boolean bl, Comparator<SiteNode> comparator) {
        super(treeNode, bl);
        this.comparator = comparator;
    }

    public void insertNodeInto(SiteNode siteNode, SiteNode siteNode2) {
        int n = this.findIndexFor(siteNode, siteNode2);
        super.insertNodeInto(siteNode, siteNode2, n);
    }

    public void insertNodeInto(SiteNode siteNode, SiteNode siteNode2, int n) {
        this.insertNodeInto(siteNode, siteNode2);
    }

    private int findIndexFor(SiteNode siteNode, SiteNode siteNode2) {
        int n = siteNode2.getChildCount();
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return this.comparator.compare(siteNode, (SiteNode)siteNode2.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return this.findIndexFor(siteNode, siteNode2, 0, n - 1);
    }

    private int findIndexFor(SiteNode siteNode, SiteNode siteNode2, int n, int n2) {
        if (n == n2) {
            return this.comparator.compare(siteNode, (SiteNode)siteNode2.getChildAt(n)) <= 0 ? n : n + 1;
        }
        int n3 = (n + n2) / 2;
        if (this.comparator.compare(siteNode, (SiteNode)siteNode2.getChildAt(n3)) <= 0) {
            return this.findIndexFor(siteNode, siteNode2, n, n3);
        }
        return this.findIndexFor(siteNode, siteNode2, n3 + 1, n2);
    }
}

