/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractAppParamPlugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.ascan.ActiveScript;
import org.zaproxy.zap.extension.ascan.ActiveScript2;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptsActiveScanner
extends AbstractAppParamPlugin {
    private ExtensionScript extension = null;
    private static Logger logger = Logger.getLogger(ScriptsActiveScanner.class);
    private Set<ScriptWrapper> scriptsNoInterface = new HashSet<ScriptWrapper>();

    @Override
    public int getId() {
        return 50000;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("ascan.scripts.activescanner.title");
    }

    @Override
    public String[] getDependency() {
        return null;
    }

    @Override
    public String getDescription() {
        return "N/A";
    }

    @Override
    public int getCategory() {
        return 3;
    }

    @Override
    public String getSolution() {
        return "N/A";
    }

    @Override
    public String getReference() {
        return "N/A";
    }

    @Override
    public void init() {
        if (this.shouldSkipScan()) {
            this.getParent().pluginSkipped(this, Constant.messages.getString("ascan.scripts.skip.reason"));
        }
    }

    private boolean shouldSkipScan() {
        if (this.getExtension() == null) {
            return true;
        }
        List<ScriptWrapper> list = this.getActiveScripts();
        if (list.isEmpty()) {
            return true;
        }
        for (ScriptWrapper scriptWrapper : list) {
            if (!scriptWrapper.isEnabled()) continue;
            return false;
        }
        return true;
    }

    private List<ScriptWrapper> getActiveScripts() {
        return this.getExtension().getScripts("active");
    }

    private ExtensionScript getExtension() {
        if (this.extension == null) {
            this.extension = (ExtensionScript)Control.getSingleton().getExtensionLoader().getExtension("ExtensionScript");
        }
        return this.extension;
    }

    @Override
    public void scan() {
        List<ScriptWrapper> list = this.getActiveScripts();
        Iterator<ScriptWrapper> iterator = list.iterator();
        while (iterator.hasNext() && !this.isStop()) {
            ScriptWrapper scriptWrapper = iterator.next();
            try {
                if (!scriptWrapper.isEnabled()) continue;
                ActiveScript2 activeScript2 = this.extension.getInterface(scriptWrapper, ActiveScript2.class);
                if (activeScript2 != null) {
                    HttpMessage httpMessage = this.getNewMsg();
                    logger.debug((Object)("Calling script " + scriptWrapper.getName() + " scanNode for " + httpMessage.getRequestHeader().getURI()));
                    activeScript2.scanNode(this, httpMessage);
                    continue;
                }
                this.scriptsNoInterface.add(scriptWrapper);
            }
            catch (Exception exception) {
                this.extension.handleScriptException(scriptWrapper, exception);
            }
        }
        if (!this.isStop()) {
            super.scan();
        }
        this.scriptsNoInterface.clear();
    }

    @Override
    public void scan(HttpMessage httpMessage, String string, String string2) {
        List<ScriptWrapper> list = this.getActiveScripts();
        Iterator<ScriptWrapper> iterator = list.iterator();
        while (iterator.hasNext() && !this.isStop()) {
            ScriptWrapper scriptWrapper = iterator.next();
            try {
                if (!scriptWrapper.isEnabled()) continue;
                ActiveScript activeScript = this.extension.getInterface(scriptWrapper, ActiveScript.class);
                if (activeScript != null) {
                    logger.debug((Object)("Calling script " + scriptWrapper.getName() + " scan for " + httpMessage.getRequestHeader().getURI() + "param=" + string + " value=" + string2));
                    activeScript.scan(this, httpMessage, string, string2);
                    continue;
                }
                if (!this.scriptsNoInterface.contains(scriptWrapper)) continue;
                this.extension.handleFailedScriptInterface(scriptWrapper, Constant.messages.getString("ascan.scripts.interface.active.error", scriptWrapper.getName()));
            }
            catch (Exception exception) {
                this.extension.handleScriptException(scriptWrapper, exception);
            }
        }
    }

    @Override
    public boolean isStop() {
        return super.isStop();
    }

    public String setParam(HttpMessage httpMessage, String string, String string2) {
        return super.setParameter(httpMessage, string, string2);
    }

    @Override
    public void sendAndReceive(HttpMessage httpMessage) throws HttpException, IOException {
        super.sendAndReceive(httpMessage);
    }

    @Override
    public void sendAndReceive(HttpMessage httpMessage, boolean bl) throws HttpException, IOException {
        super.sendAndReceive(httpMessage, bl);
    }

    @Override
    public void sendAndReceive(HttpMessage httpMessage, boolean bl, boolean bl2) throws HttpException, IOException {
        super.sendAndReceive(httpMessage, bl, bl2);
    }

    public void raiseAlert(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n3, int n4, HttpMessage httpMessage) {
        super.bingo(n, n2, string, string2, string3, string4, string5, string6, string7, string8, n3, n4, httpMessage);
    }

    @Override
    public int getRisk() {
        return 0;
    }

    @Override
    public int getCweId() {
        return 0;
    }

    @Override
    public int getWascId() {
        return 0;
    }
}

