/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httpsessions.ExtensionHttpSessions;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.ParamsTableModel;

public class SiteParameters {
    private ExtensionParams extension;
    private String site;
    private ParamsTableModel model = new ParamsTableModel();
    private Map<String, HtmlParameterStats> cookieParams = new HashMap<String, HtmlParameterStats>();
    private Map<String, HtmlParameterStats> urlParams = new HashMap<String, HtmlParameterStats>();
    private Map<String, HtmlParameterStats> formParams = new HashMap<String, HtmlParameterStats>();
    private Map<String, HtmlParameterStats> headerParams = new HashMap<String, HtmlParameterStats>();

    public SiteParameters(ExtensionParams extensionParams, String string) {
        this.extension = extensionParams;
        this.site = string;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String string) {
        this.site = string;
    }

    public boolean hasParams() {
        return !this.cookieParams.isEmpty() || !this.urlParams.isEmpty() || !this.formParams.isEmpty() || !this.headerParams.isEmpty();
    }

    public HtmlParameterStats getParam(HtmlParameter.Type type, String string) {
        switch (type) {
            case cookie: {
                return this.cookieParams.get(string);
            }
            case url: {
                return this.urlParams.get(string);
            }
            case form: {
                return this.formParams.get(string);
            }
            case header: {
                return this.headerParams.get(string);
            }
        }
        return null;
    }

    public List<HtmlParameterStats> getParams(HtmlParameter.Type type) {
        ArrayList<HtmlParameterStats> arrayList = new ArrayList<HtmlParameterStats>();
        switch (type) {
            case cookie: {
                arrayList.addAll(this.cookieParams.values());
                break;
            }
            case url: {
                arrayList.addAll(this.urlParams.values());
                break;
            }
            case form: {
                arrayList.addAll(this.formParams.values());
                break;
            }
            case header: {
                arrayList.addAll(this.headerParams.values());
            }
        }
        return arrayList;
    }

    public List<HtmlParameterStats> getParams() {
        ArrayList<HtmlParameterStats> arrayList = new ArrayList<HtmlParameterStats>();
        arrayList.addAll(this.cookieParams.values());
        arrayList.addAll(this.urlParams.values());
        arrayList.addAll(this.formParams.values());
        arrayList.addAll(this.headerParams.values());
        return arrayList;
    }

    public HtmlParameterStats addParam(String string, HtmlParameter htmlParameter, HttpMessage httpMessage) {
        HtmlParameterStats htmlParameterStats;
        Map<String, HtmlParameterStats> map = null;
        switch (htmlParameter.getType()) {
            case cookie: {
                map = this.cookieParams;
                break;
            }
            case url: {
                map = this.urlParams;
                break;
            }
            case form: {
                map = this.formParams;
                break;
            }
            case header: {
                map = this.headerParams;
            }
        }
        if (map != null && map.containsKey(htmlParameter.getName())) {
            htmlParameterStats = map.get(htmlParameter.getName());
            htmlParameterStats.incTimesUsed();
            htmlParameterStats.addValue(htmlParameter.getValue());
        } else {
            htmlParameterStats = new HtmlParameterStats(string, htmlParameter.getName(), htmlParameter.getType(), htmlParameter.getValue(), htmlParameter.getFlags());
            ExtensionHttpSessions extensionHttpSessions = this.extension.getExtensionHttpSessions();
            if (extensionHttpSessions != null && htmlParameter.getType().equals((Object)HtmlParameter.Type.cookie) && extensionHttpSessions.isSessionToken(string, htmlParameter.getName())) {
                htmlParameterStats.addFlag(HtmlParameter.Flags.session.name());
            }
            if (map == null) {
                map = new HashMap<String, HtmlParameterStats>();
            }
            map.put(htmlParameter.getName(), htmlParameterStats);
            this.model.addHtmlParameterStats(htmlParameterStats);
        }
        return htmlParameterStats;
    }

    public ParamsTableModel getModel() {
        return this.model;
    }

    private Set<String> stringToSet(String string) {
        String[] stringArray;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray = string.split(",")) {
            hashSet.add(string2);
        }
        return hashSet;
    }

    public void addParam(String string, RecordParam recordParam) {
        Map<String, HtmlParameterStats> map = null;
        HtmlParameter.Type type = HtmlParameter.Type.valueOf(recordParam.getType());
        switch (type) {
            case cookie: {
                map = this.cookieParams;
                break;
            }
            case url: {
                map = this.urlParams;
                break;
            }
            case form: {
                map = this.formParams;
                break;
            }
            case header: {
                map = this.headerParams;
            }
        }
        HtmlParameterStats htmlParameterStats = new HtmlParameterStats(recordParam.getParamId(), this.site, recordParam.getName(), recordParam.getType(), recordParam.getUsed(), this.stringToSet(recordParam.getValues()), this.stringToSet(recordParam.getFlags()));
        if (map != null) {
            map.put(recordParam.getName(), htmlParameterStats);
            this.model.addHtmlParameterStats(htmlParameterStats);
        }
    }
}

