/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;

public class SpiderParam
extends AbstractParam {
    private static final String SPIDER_MAX_DEPTH = "spider.maxDepth";
    private static final String SPIDER_THREAD = "spider.thread";
    private static final String SPIDER_POST_FORM = "spider.postform";
    private static final String SPIDER_PROCESS_FORM = "spider.processform";
    private static final String SPIDER_SKIP_URL = "spider.skipurl";
    private static final String SPIDER_REQUEST_WAIT = "spider.requestwait";
    private static final String SPIDER_PARSE_COMMENTS = "spider.parseComments";
    private static final String SPIDER_PARSE_ROBOTS_TXT = "spider.parseRobotsTxt";
    private static final String SPIDER_PARSE_SITEMAP_XML = "spider.parseSitemapXml";
    private static final String SPIDER_PARSE_SVN_ENTRIES = "spider.parseSVNentries";
    private static final String SPIDER_PARSE_GIT = "spider.parseGit";
    private static final String SPIDER_HANDLE_PARAMETERS = "spider.handleParameters";
    private static final String SPIDER_HANDLE_ODATA_PARAMETERS = "spider.handleODataParameters";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_KEY = "spider.domainsAlwaysInScope";
    private static final String ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY = "spider.domainsAlwaysInScope.domainAlwaysInScope";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_VALUE_KEY = "name";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_REGEX_KEY = "regex";
    private static final String DOMAIN_ALWAYS_IN_SCOPE_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_DOMAIN_ALWAYS_IN_SCOPE = "spider.confirmRemoveDomainAlwaysInScope";
    private static final String MAX_SCANS_IN_UI = "spider.maxScansInUI";
    private static final String SHOW_ADV_DIALOG = "spider.advDialog";
    private static final String MAX_DURATION = "spider.maxDuration";
    private static final String MAX_CHILDREN = "spider.maxChildren";
    private static final String SPIDER_SENDER_REFERER_HEADER = "spider.sendRefererHeader";
    private int maxDepth = 5;
    private int threadCount = 2;
    private boolean parseComments = true;
    private boolean parseRobotsTxt = true;
    private boolean parseSitemapXml = true;
    private boolean parseSVNentries = false;
    private boolean parseGit = false;
    private boolean processForm = true;
    private boolean postForm = false;
    private int requestWait = 200;
    private String skipURL = "";
    private Pattern patternSkipURL = null;
    private String userAgent = null;
    private HandleParametersOption handleParametersVisited = HandleParametersOption.USE_ALL;
    private boolean handleODataParametersVisited = false;
    private int maxDuration = 0;
    private int maxChildren;
    private List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(0);
    private List<DomainAlwaysInScopeMatcher> domainsAlwaysInScopeEnabled = new ArrayList<DomainAlwaysInScopeMatcher>(0);
    private boolean confirmRemoveDomainAlwaysInScope;
    private int maxScansInUI = 5;
    private boolean showAdvancedDialog = false;
    private static final Logger log = Logger.getLogger(SpiderParam.class);
    private boolean sendRefererHeader = true;

    @Override
    protected void parse() {
        this.updateOptions();
        try {
            this.threadCount = this.getConfig().getInt(SPIDER_THREAD, 2);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.maxDepth = this.getConfig().getInt(SPIDER_MAX_DEPTH, 5);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.maxDuration = this.getConfig().getInt(MAX_DURATION, 0);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.maxChildren = this.getConfig().getInt(MAX_CHILDREN, 0);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.maxScansInUI = this.getConfig().getInt(MAX_SCANS_IN_UI, 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.showAdvancedDialog = this.getConfig().getBoolean(SHOW_ADV_DIALOG, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.processForm = this.getConfig().getBoolean(SPIDER_PROCESS_FORM, false);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.postForm = this.getConfig().getBoolean(SPIDER_POST_FORM, false);
        }
        catch (ConversionException conversionException) {
            log.info((Object)"Warning while parsing config file: spider.postform was not in the expected format due to an upgrade. Converting  it!");
            if (!this.getConfig().getProperty(SPIDER_POST_FORM).toString().equals("0")) {
                this.getConfig().setProperty(SPIDER_POST_FORM, (Object)"true");
                this.postForm = true;
            }
            this.getConfig().setProperty(SPIDER_POST_FORM, (Object)"false");
            this.postForm = false;
        }
        try {
            this.requestWait = this.getConfig().getInt(SPIDER_REQUEST_WAIT, 200);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.parseComments = this.getConfig().getBoolean(SPIDER_PARSE_COMMENTS, true);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.parseRobotsTxt = this.getConfig().getBoolean(SPIDER_PARSE_ROBOTS_TXT, true);
        }
        catch (Exception exception) {
            log.error((Object)("Error while parsing config file: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            this.parseSitemapXml = this.getConfig().getBoolean(SPIDER_PARSE_SITEMAP_XML, true);
        }
        catch (Exception exception) {
            log.error((Object)("Error while parsing config file: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            this.parseSVNentries = this.getConfig().getBoolean(SPIDER_PARSE_SVN_ENTRIES, false);
        }
        catch (Exception exception) {
            log.error((Object)("Error while parsing config file: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            this.parseGit = this.getConfig().getBoolean(SPIDER_PARSE_GIT, false);
        }
        catch (Exception exception) {
            log.error((Object)("Error while parsing config file: " + exception.getMessage()), (Throwable)exception);
        }
        try {
            this.setSkipURLString(this.getConfig().getString(SPIDER_SKIP_URL, ""));
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.setHandleParameters(HandleParametersOption.valueOf(this.getConfig().getString(SPIDER_HANDLE_PARAMETERS, HandleParametersOption.USE_ALL.toString())));
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.handleODataParametersVisited = this.getConfig().getBoolean(SPIDER_HANDLE_ODATA_PARAMETERS, false);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        this.loadDomainsAlwaysInScope();
        try {
            this.confirmRemoveDomainAlwaysInScope = this.getConfig().getBoolean(CONFIRM_REMOVE_DOMAIN_ALWAYS_IN_SCOPE, true);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while loading the confirm \"domain always in scope\" remove option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.sendRefererHeader = this.getConfig().getBoolean(SPIDER_SENDER_REFERER_HEADER, true);
        }
        catch (ConversionException conversionException) {
            log.error((Object)("Error while parsing config file: " + conversionException.getMessage()), (Throwable)conversionException);
            this.sendRefererHeader = true;
        }
    }

    private void updateOptions() {
        if (this.getConfig().containsKey("spider.scope")) {
            this.migrateOldDomainsInScopeOption(this.getConfig().getString("spider.scope", ""));
            this.getConfig().clearProperty("spider.scope");
        }
    }

    private void migrateOldDomainsInScopeOption(String string) {
        List<DomainAlwaysInScopeMatcher> list = SpiderParam.convertOldDomainsInScopeOption(string);
        if (!list.isEmpty()) {
            this.setDomainsAlwaysInScope(list);
        }
    }

    private static List<DomainAlwaysInScopeMatcher> convertOldDomainsInScopeOption(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomainAlwaysInScopeMatcher> arrayList = new ArrayList<DomainAlwaysInScopeMatcher>();
        for (String string2 : stringArray = string.split(";")) {
            String string3 = string2.trim();
            if (string3.isEmpty()) continue;
            if (string3.contains("*")) {
                string3 = string3.replace(".", "\\.").replace("+", "\\+").replace("*", ".*?");
                try {
                    Pattern pattern = Pattern.compile(string3, 2);
                    arrayList.add(new DomainAlwaysInScopeMatcher(pattern));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)("Failed to migrate a domain always in scope, name: " + string2), (Throwable)illegalArgumentException);
                }
                continue;
            }
            arrayList.add(new DomainAlwaysInScopeMatcher(string3));
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
        this.getConfig().setProperty(SPIDER_MAX_DEPTH, (Object)Integer.toString(this.maxDepth));
    }

    @Deprecated
    public String getScopeText() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher : this.domainsAlwaysInScope) {
            if (domainAlwaysInScopeMatcher.isRegex()) continue;
            stringBuilder.append(domainAlwaysInScopeMatcher.getValue()).append(';');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public String getScope() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher : this.domainsAlwaysInScope) {
            if (domainAlwaysInScopeMatcher.isRegex()) {
                stringBuilder.append("\\Q").append(domainAlwaysInScopeMatcher.getValue()).append("\\E");
            } else {
                stringBuilder.append(domainAlwaysInScopeMatcher.getValue());
            }
            stringBuilder.append('|');
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append("(");
            stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length() - 1, ")$");
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public void setScopeString(String string) {
        this.setDomainsAlwaysInScope(SpiderParam.convertOldDomainsInScopeOption(string));
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int n) {
        this.threadCount = n;
        this.getConfig().setProperty(SPIDER_THREAD, (Object)Integer.toString(this.threadCount));
    }

    public boolean isPostForm() {
        return this.postForm;
    }

    public void setPostForm(boolean bl) {
        this.postForm = bl;
        this.getConfig().setProperty(SPIDER_POST_FORM, (Object)Boolean.toString(bl));
    }

    public boolean isProcessForm() {
        return this.processForm;
    }

    public void setProcessForm(boolean bl) {
        this.processForm = bl;
        this.getConfig().setProperty(SPIDER_PROCESS_FORM, (Object)Boolean.toString(bl));
    }

    public void setSkipURLString(String string) {
        this.skipURL = string;
        this.getConfig().setProperty(SPIDER_SKIP_URL, (Object)this.skipURL);
        this.parseSkipURL(this.skipURL);
    }

    public String getSkipURLString() {
        return this.skipURL;
    }

    public boolean isSkipURL(URI uRI) {
        if (this.patternSkipURL == null || uRI == null) {
            return false;
        }
        String string = uRI.toString();
        return this.patternSkipURL.matcher(string).find();
    }

    private void parseSkipURL(String string) {
        this.patternSkipURL = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(\\s+$)|(^\\s+)", "");
        string = "\\A(" + string.replaceAll("\\s+", "|") + ")";
        this.patternSkipURL = Pattern.compile(string, 10);
    }

    public int getRequestWaitTime() {
        return this.requestWait;
    }

    public void setRequestWaitTime(int n) {
        this.requestWait = n;
        this.getConfig().setProperty(SPIDER_REQUEST_WAIT, (Object)Integer.toString(n));
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public boolean isParseComments() {
        return this.parseComments;
    }

    public void setParseComments(boolean bl) {
        this.parseComments = bl;
        this.getConfig().setProperty(SPIDER_PARSE_COMMENTS, (Object)Boolean.toString(bl));
    }

    public boolean isParseRobotsTxt() {
        return this.parseRobotsTxt;
    }

    public boolean isParseSitemapXml() {
        return this.parseSitemapXml;
    }

    public boolean isParseSVNEntries() {
        return this.parseSVNentries;
    }

    public boolean isParseGit() {
        return this.parseGit;
    }

    public void setParseRobotsTxt(boolean bl) {
        this.parseRobotsTxt = bl;
        this.getConfig().setProperty(SPIDER_PARSE_ROBOTS_TXT, (Object)Boolean.toString(bl));
    }

    public void setParseSitemapXml(boolean bl) {
        this.parseSitemapXml = bl;
        this.getConfig().setProperty(SPIDER_PARSE_SITEMAP_XML, (Object)Boolean.toString(bl));
    }

    public void setParseSVNEntries(boolean bl) {
        this.parseSVNentries = bl;
        this.getConfig().setProperty(SPIDER_PARSE_SVN_ENTRIES, (Object)Boolean.toString(bl));
    }

    public void setParseGit(boolean bl) {
        this.parseGit = bl;
        this.getConfig().setProperty(SPIDER_PARSE_GIT, (Object)Boolean.toString(bl));
    }

    public HandleParametersOption getHandleParameters() {
        return this.handleParametersVisited;
    }

    public void setHandleParameters(HandleParametersOption handleParametersOption) {
        this.handleParametersVisited = handleParametersOption;
        this.getConfig().setProperty(SPIDER_HANDLE_PARAMETERS, (Object)handleParametersOption.toString());
    }

    public void setHandleParameters(String string) {
        this.handleParametersVisited = HandleParametersOption.valueOf(string);
        this.getConfig().setProperty(SPIDER_HANDLE_PARAMETERS, (Object)this.handleParametersVisited.toString());
    }

    public boolean isHandleODataParametersVisited() {
        return this.handleODataParametersVisited;
    }

    public void setHandleODataParametersVisited(boolean bl) {
        this.handleODataParametersVisited = bl;
        this.getConfig().setProperty(SPIDER_HANDLE_ODATA_PARAMETERS, (Object)Boolean.toString(bl));
    }

    @ZapApiIgnore
    public List<DomainAlwaysInScopeMatcher> getDomainsAlwaysInScope() {
        return this.domainsAlwaysInScope;
    }

    @ZapApiIgnore
    public List<DomainAlwaysInScopeMatcher> getDomainsAlwaysInScopeEnabled() {
        return this.domainsAlwaysInScopeEnabled;
    }

    public void setDomainsAlwaysInScope(List<DomainAlwaysInScopeMatcher> list) {
        if (list == null || list.isEmpty()) {
            ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY);
            this.domainsAlwaysInScope = Collections.emptyList();
            this.domainsAlwaysInScopeEnabled = Collections.emptyList();
            return;
        }
        this.domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(list);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY);
        int n = list.size();
        ArrayList<DomainAlwaysInScopeMatcher> arrayList = new ArrayList<DomainAlwaysInScopeMatcher>(n);
        for (int i = 0; i < n; ++i) {
            String string = "spider.domainsAlwaysInScope.domainAlwaysInScope(" + i + ").";
            DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = list.get(i);
            this.getConfig().setProperty(string + DOMAIN_ALWAYS_IN_SCOPE_VALUE_KEY, (Object)domainAlwaysInScopeMatcher.getValue());
            this.getConfig().setProperty(string + DOMAIN_ALWAYS_IN_SCOPE_REGEX_KEY, (Object)domainAlwaysInScopeMatcher.isRegex());
            this.getConfig().setProperty(string + DOMAIN_ALWAYS_IN_SCOPE_ENABLED_KEY, (Object)domainAlwaysInScopeMatcher.isEnabled());
            if (!domainAlwaysInScopeMatcher.isEnabled()) continue;
            arrayList.add(domainAlwaysInScopeMatcher);
        }
        arrayList.trimToSize();
        this.domainsAlwaysInScopeEnabled = arrayList;
    }

    private void loadDomainsAlwaysInScope() {
        List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_DOMAINS_ALWAYS_IN_SCOPE_KEY);
        this.domainsAlwaysInScope = new ArrayList<DomainAlwaysInScopeMatcher>(list.size());
        ArrayList<DomainAlwaysInScopeMatcher> arrayList = new ArrayList<DomainAlwaysInScopeMatcher>(list.size());
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            String string = hierarchicalConfiguration.getString(DOMAIN_ALWAYS_IN_SCOPE_VALUE_KEY, "");
            if ("".equals(string)) {
                log.warn((Object)"Failed to read an spider domain in scope entry, required value is empty.");
            }
            DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher = null;
            boolean bl = hierarchicalConfiguration.getBoolean(DOMAIN_ALWAYS_IN_SCOPE_REGEX_KEY, false);
            if (bl) {
                try {
                    Pattern pattern = DomainAlwaysInScopeMatcher.createPattern(string);
                    domainAlwaysInScopeMatcher = new DomainAlwaysInScopeMatcher(pattern);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.error((Object)("Failed to read an spider domain in scope entry with regex: " + string), (Throwable)illegalArgumentException);
                }
            } else {
                domainAlwaysInScopeMatcher = new DomainAlwaysInScopeMatcher(string);
            }
            if (domainAlwaysInScopeMatcher == null) continue;
            domainAlwaysInScopeMatcher.setEnabled(hierarchicalConfiguration.getBoolean(DOMAIN_ALWAYS_IN_SCOPE_ENABLED_KEY, true));
            this.domainsAlwaysInScope.add(domainAlwaysInScopeMatcher);
            if (!domainAlwaysInScopeMatcher.isEnabled()) continue;
            arrayList.add(domainAlwaysInScopeMatcher);
        }
        arrayList.trimToSize();
        this.domainsAlwaysInScopeEnabled = arrayList;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveDomainAlwaysInScope() {
        return this.confirmRemoveDomainAlwaysInScope;
    }

    @ZapApiIgnore
    public void setConfirmRemoveDomainAlwaysInScope(boolean bl) {
        this.confirmRemoveDomainAlwaysInScope = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_DOMAIN_ALWAYS_IN_SCOPE, (Object)this.confirmRemoveDomainAlwaysInScope);
    }

    public int getMaxScansInUI() {
        return this.maxScansInUI;
    }

    public void setMaxScansInUI(int n) {
        this.maxScansInUI = n;
        this.getConfig().setProperty(MAX_SCANS_IN_UI, (Object)this.maxScansInUI);
    }

    public boolean isShowAdvancedDialog() {
        return this.showAdvancedDialog;
    }

    public void setShowAdvancedDialog(boolean bl) {
        this.showAdvancedDialog = bl;
        this.getConfig().setProperty(SHOW_ADV_DIALOG, (Object)this.showAdvancedDialog);
    }

    public boolean isSendRefererHeader() {
        return this.sendRefererHeader;
    }

    public void setSendRefererHeader(boolean bl) {
        if (bl == this.sendRefererHeader) {
            return;
        }
        this.sendRefererHeader = bl;
        this.getConfig().setProperty(SPIDER_SENDER_REFERER_HEADER, (Object)this.sendRefererHeader);
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int n) {
        this.maxDuration = n;
        this.getConfig().setProperty(MAX_DURATION, (Object)n);
    }

    public int getMaxChildren() {
        return this.maxChildren;
    }

    public void setMaxChildren(int n) {
        this.maxChildren = n;
        this.getConfig().setProperty(MAX_CHILDREN, (Object)n);
    }

    public static enum HandleParametersOption {
        IGNORE_COMPLETELY,
        IGNORE_VALUE,
        USE_ALL;


        public String getName() {
            switch (this) {
                case IGNORE_COMPLETELY: {
                    return Constant.messages.getString("spider.options.value.handleparameters.ignoreAll");
                }
                case IGNORE_VALUE: {
                    return Constant.messages.getString("spider.options.value.handleparameters.ignoreValue");
                }
                case USE_ALL: {
                    return Constant.messages.getString("spider.options.value.handleparameters.useAll");
                }
            }
            return null;
        }
    }
}

