Pre-built binaries for Windows can be downloaded [here][bin]. However, other
components of the project does not work on Windows. You might want to consider
installing fzf on [Windows Subsystem for Linux][wsl] where everything runs
flawlessly.

[bin]: https://github.com/junegunn/fzf-bin/releases
[wsl]: https://blogs.msdn.microsoft.com/wsl/

### Relative Filepaths

fzf uses `dir /s/b` as its default command for performance but it outputs absolute filepaths.
To use relative filepaths, set `FZF_DEFAULT_COMMAND` to any of the following and run it in cmd.exe because it has no overhead:

- cmd.exe https://github.com/junegunn/fzf/pull/971#issuecomment-313971408
  ```dosbatch
  cmd.exe /q/V:ON/c "for /f %A in ('dir /s/b 2^> nul') do set RELPATH=%A && echo !RELPATH:%cd%\=!"
  ```
- powershell https://github.com/junegunn/fzf/issues/960
  ```dosbatch
  powershell.exe -NoLogo -NoProfile -Noninteractive -Command "Get-ChildItem -File -Recurse -Name"
  ```
- [sift](https://sift-tool.org/)
  ```dosbatch
  sift --targets . 2> nul
  ```
- [rg](https://github.com/BurntSushi/ripgrep) (supports UTF-16 as of [0.5.0](https://github.com/BurntSushi/ripgrep/blob/master/CHANGELOG.md#050-2017-03-12))
  ```dosbatch
  rg --files . 2> nul
  ```

### PowerShell support

https://github.com/kelleyma49/PSFzf