#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cryptohash
version: 0.11.9
id: cryptohash-0.11.9-5SvW3EVnn256KJIvG9DiJ4
key: cryptohash-0.11.9-5SvW3EVnn256KJIvG9DiJ4
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
homepage: http://github.com/vincenthz/hs-cryptohash
synopsis: collection of crypto hashes, fast, pure and practical
description:
    DEPRECATED: this library is still fully functional, but please use cryptonite for new projects
    and convert old one to use cryptonite. This is where things are at nowadays.
    .
    A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
    with performance close to the fastest implementations available in other languages.
    .
    The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
    .
    Simple examples using the unified API:
    .
    > import Crypto.Hash
    >
    > sha1 :: ByteString -> Digest SHA1
    > sha1 = hash
    >
    > hexSha3_512 :: ByteString -> String
    > hexSha3_512 bs = show (hash bs :: Digest SHA3_512)
    .
    Simple examples using the module API:
    .
    > import qualified Crypto.Hash.SHA1 as SHA1
    >
    > main = putStrLn $ show $ SHA1.hash (Data.ByteString.pack [0..255])
    .
    > import qualified Crypto.Hash.SHA3 as SHA3
    >
    > main = putStrLn $ show $ digest
    >   where digest = SHA3.finalize ctx
    >         ctx    = foldl'\'' SHA3.update iCtx (map Data.ByteString.pack [ [1,2,3], [4,5,6] ]
    >         iCtx   = SHA3.init 224
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
indefinite: False
exposed-modules:
    Crypto.Hash Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
    Crypto.Hash.RIPEMD160 Crypto.Hash.SHA1 Crypto.Hash.SHA224
    Crypto.Hash.SHA256 Crypto.Hash.SHA3 Crypto.Hash.SHA384
    Crypto.Hash.SHA512 Crypto.Hash.SHA512t Crypto.Hash.Skein256
    Crypto.Hash.Skein512 Crypto.Hash.Tiger Crypto.Hash.Types
    Crypto.Hash.Whirlpool Crypto.MAC Crypto.MAC.HMAC Crypto.MAC.SHA3
hidden-modules: Crypto.Hash.Internal
abi: 3da8e1c1c284a996ac69c9ae626509c5
trusted: False
import-dirs: /usr/lib/ghc-8.2.1/site-local/cryptohash-0.11.9
library-dirs: /usr/lib/ghc-8.2.1/site-local/cryptohash-0.11.9
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.1/cryptohash-0.11.9
hs-libraries: HScryptohash-0.11.9-5SvW3EVnn256KJIvG9DiJ4
depends:
    base-4.10.0.0 bytestring-0.10.8.2
    byteable-0.1.1-3VfNJqauCum9lD10cS8nmH
    cryptonite-0.24-C1J9hVFCfh2He3zHd0GhfC
    memory-0.14.8-HEYe2msABjoBOvbV0yaOyF ghc-prim-0.5.1.0
abi-depends: base-4.10.0.0=32d562aa6d04d35ac79a0f49c17325ff
             bytestring-0.10.8.2=4f0c9618a8f04261f970de9708e01603
             byteable-0.1.1-3VfNJqauCum9lD10cS8nmH=1033f0009ffea40431f55947ee171f57
             cryptonite-0.24-C1J9hVFCfh2He3zHd0GhfC=293d28e0aaf3f9d9f0c0c4cf3081903a
             memory-0.14.8-HEYe2msABjoBOvbV0yaOyF=b0f20aa3b64be0ebd469eea8536158a5
             ghc-prim-0.5.1.0=557c7fce76ef13c2417583cc28848f14
haddock-interfaces: /usr/share/doc/haskell-cryptohash/html/cryptohash.haddock
haddock-html: /usr/share/doc/haskell-cryptohash/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

