/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ro extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Ora Africii Centrale",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Ora standard a Moscovei",
               "MSK",
               "Ora de var\u0103 a Moscovei",
               "MSD",
               "Ora Moscovei",
               "MT",
            };
        final String[] Japan = new String[] {
               "Ora standard a Japoniei",
               "JST",
               "Ora de var\u0103 a Japoniei",
               "JDT",
               "Ora Japoniei",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "Ora standard a Pakistanului",
               "PKT",
               "Ora de var\u0103 a Pakistanului",
               "PKST",
               "Ora Pakistanului",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "Ora standard din Taipei",
               "CST",
               "Ora de var\u0103 din Taipei",
               "CDT",
               "Ora din Taipei",
               "CT",
            };
        final String[] Hovd = new String[] {
               "Ora standard din Hovd",
               "HOVT",
               "Ora de var\u0103 din Hovd",
               "HOVST",
               "Ora din Hovd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "Ora standard din Magadan",
               "MAGT",
               "Ora de var\u0103 din Magadan",
               "MAGST",
               "Ora din Magadan",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard a Australiei Central Occidentale",
               "ACWST",
               "Ora de var\u0103 a Australiei Central Occidentale",
               "ACWDT",
               "Ora Australiei Central Occidentale",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard a Europei Centrale",
               "CET",
               "Ora de var\u0103 a Europei Centrale",
               "CEST",
               "Ora Europei Centrale",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard din Sahalin",
               "SAKT",
               "Ora de var\u0103 din Sahalin",
               "SAKST",
               "Ora din Sahalin",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "Ora standard din Paraguay",
               "PYT",
               "Ora de var\u0103 din Paraguay",
               "PYST",
               "Ora din Paraguay",
               "PYT",
            };
        final String[] Acre = new String[] {
               "Ora standard Acre",
               "ACT",
               "Ora de var\u0103 Acre",
               "ACST",
               "Ora Acre",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "Ora din Malaysia",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard oriental\u0103 nord-american\u0103",
               "EST",
               "Ora de var\u0103 oriental\u0103 nord-american\u0103",
               "EDT",
               "Ora oriental\u0103 nord-american\u0103",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard din Lord Howe",
               "LHST",
               "Ora de var\u0103 din Lord Howe",
               "LHDT",
               "Ora din Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Ora standard a Noii Zeelande",
               "NZST",
               "Ora de var\u0103 a Noii Zeelande",
               "NZDT",
               "Ora Noii Zeelande",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora Oceanului Indian",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard din Yaku\u021bk",
               "YAKT",
               "Ora de var\u0103 din Yaku\u021bk",
               "YAKST",
               "Ora din Yaku\u021bk",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "Ora standard din Mauritius",
               "MUT",
               "Ora de var\u0103 din Mauritius",
               "MUST",
               "Ora din Mauritius",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora Africii Orientale",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "Ora Timorului de Est",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "Ora Insulelor Solomon",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "Ora din Kosrae",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora Insulelor Marshall",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard a Europei de Est",
               "EET",
               "Ora de var\u0103 a Europei de Est",
               "EEST",
               "Ora Europei de Est",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard din Newfoundland",
               "NST",
               "Ora de var\u0103 din Newfoundland",
               "NDT",
               "Ora din Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Ora Afganistanului",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standard din Hong Kong",
               "HKT",
               "Ora de var\u0103 din Hong Kong",
               "HKST",
               "Ora din Hong Kong",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "Ora standard a Argentinei Occidentale",
               "ART",
               "Ora de var\u0103 a Argentinei Occidentale",
               "ARST",
               "Ora Argentinei Occidentale",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "Ora standard \u00een zona Atlantic nord-american\u0103",
               "AST",
               "Ora de var\u0103 \u00een zona Atlantic nord-american\u0103",
               "ADT",
               "Ora zonei Atlantic nord-americane",
               "AT",
            };
        final String[] Ponape = new String[] {
               "Ora din Ponape",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "Ora Boliviei",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard din Saint-Pierre \u0219i Miquelon",
               "PMST",
               "Ora de var\u0103 din Saint-Pierre \u0219i Miquelon",
               "PMDT",
               "Ora din Saint-Pierre \u0219i Miquelon",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "Ora Indochinei",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard din Ekaterinburg",
               "YEKT",
               "Ora de var\u0103 din Ekaterinburg",
               "YEKST",
               "Ora din Ekaterinburg",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "Ora din Maldive",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "Ora din Tahiti",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "Ora standard a Israelului",
               "IST",
               "Ora de var\u0103 a Israelului",
               "IDT",
               "Ora Israelului",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora Indoneziei Centrale",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "Ora din Wallis \u0219i Futuna",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora Africii Meridionale",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Ora din Syowa",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "Ora din Insulele Line",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standard din Uzbekistan",
               "UZT",
               "Ora de var\u0103 din Uzbekistan",
               "UZST",
               "Ora din Uzbekistan",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "Ora standard din Omsk",
               "OMST",
               "Ora de var\u0103 din Omsk",
               "OMSST",
               "Ora din Omsk",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "Ora din Seychelles",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "Ora standard a Uruguayului",
               "UYT",
               "Ora de var\u0103 a Uruguayului",
               "UYST",
               "Ora Uruguayului",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "Ora Nepalului",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "Ora standard din Ulan Bator",
               "ULAT",
               "Ora de var\u0103 din Ulan Bator",
               "ULAST",
               "Ora din Ulan Bator",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "Ora standard central\u0103 nord-american\u0103",
               "CST",
               "Ora de var\u0103 central\u0103 nord-american\u0103",
               "CDT",
               "Ora central\u0103 nord-american\u0103",
               "CT",
            };
        final String[] Truk = new String[] {
               "Ora din Chuuk",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "Ora din Niue",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "Ora Insulei Wake",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "Ora standard din Insulele Falkland",
               "FKT",
               "Ora de var\u0103 din Insulele Falkland",
               "FKST",
               "Ora din Insulele Falkland",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "Ora standard din Vanuatu",
               "VUT",
               "Ora de var\u0103 din Vanuatu",
               "VUST",
               "Ora din Vanuatu",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard din Novosibirsk",
               "NOVT",
               "Ora de var\u0103 din Novosibirsk",
               "NOVST",
               "Ora din Novosibirsk",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "Ora din Singapore",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "Ora standard din Azore",
               "AZOT",
               "Ora de var\u0103 din Azore",
               "AZOST",
               "Ora din Azore",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "Ora standard din Apia",
               "WSST",
               "Ora de var\u0103 din Apia",
               "WSDT",
               "Ora din Apia",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "Ora Bhutanului",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "Ora Surinamului",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "Ora din Nauru",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard din Krasnoiarsk",
               "KRAT",
               "Ora de var\u0103 din Krasnoiarsk",
               "KRAST",
               "Ora din Krasnoiarsk",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora din Kazahstanul de Vest",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "Ora Myanmarului",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "Ora din Insula Christmas",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Ora standard a Amazonului",
               "AMT",
               "Ora de var\u0103 a Amazonului",
               "AMST",
               "Ora Amazonului",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora din Kazahstanul de Est",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "Ora standard din Fiji",
               "FJT",
               "Ora de var\u0103 din Fiji",
               "FJST",
               "Ora din Fiji",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "Ora din Reunion",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "Ora Insulelor Cocos",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "Ora standard din Chatham",
               "CHAST",
               "Ora de var\u0103 din Chatham",
               "CHADT",
               "Ora din Chatham",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "Ora din Vostok",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "Ora standard a Argentinei",
               "ART",
               "Ora de var\u0103 a Argentinei",
               "ARST",
               "Ora Argentinei",
               "ART",
            };
        final String[] Gambier = new String[] {
               "Ora din Gambier",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "Ora standard din Petropavlovsk-Kamcia\u021bki",
               "PETT",
               "Ora de var\u0103 din Petropavlovsk-Kamcia\u021bki",
               "PETST",
               "Ora din Petropavlovsk-Kamcia\u021bki",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "Ora din Tuvalu",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "Ora din Galapagos",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "Ora din Macquarie",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "Ora Venezuelei",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard din Hawaii-Aleutine",
               "HAST",
               "Ora de var\u0103 din Hawaii-Aleutine",
               "HADT",
               "Ora din Hawaii-Aleutine",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard a Australiei Centrale",
               "ACST",
               "Ora de var\u0103 a Australiei Centrale",
               "ACDT",
               "Ora Australiei Centrale",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard \u00een zona Pacific nord-american\u0103",
               "PST",
               "Ora de var\u0103 \u00een zona Pacific nord-american\u0103",
               "PDT",
               "Ora zonei Pacific nord-americane",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora Insulelor Phoenix",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standard din Turkmenistan",
               "TMT",
               "Ora de var\u0103 din Turkmenistan",
               "TMST",
               "Ora din Turkmenistan",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard a Europei de Vest",
               "WET",
               "Ora de var\u0103 a Europei de Vest",
               "WEST",
               "Ora Europei de Vest",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standard din Capul Verde",
               "CVT",
               "Ora de var\u0103 din Capul Verde",
               "CVST",
               "Ora din Capul Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Ora Insulelor Norfolk",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "Ora din Guyana",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "Ora din Pitcairn",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "Ora din Rothera",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "Ora standard din Samoa",
               "SST",
               "Ora de var\u0103 din Samoa",
               "SDT",
               "Ora din Samoa",
               "ST",
            };
        final String[] Palau = new String[] {
               "Ora din Palau",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "Ora Europei de Est \u00eendep\u0103rtate",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard a Azerbaidjanului",
               "AZT",
               "Ora de var\u0103 a Azerbaidjanului",
               "AZST",
               "Ora Azerbaidjanului",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "Ora din Mawson",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standard a zonei Pacific mexicane",
               "MST",
               "Ora de var\u0103 a zonei Pacific mexicane",
               "MDT",
               "Ora zonei Pacific mexicane",
               "MT",
            };
        final String[] Davis = new String[] {
               "Ora din Davis",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "Ora standard a Cubei",
               "CST",
               "Ora de var\u0103 a Cubei",
               "CDT",
               "Ora Cubei",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard a Africii Occidentale",
               "WAT",
               "Ora de var\u0103 a Africii Occidentale",
               "WAST",
               "Ora Africii Occidentale",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Ora de Greenwhich",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "Ora standard din Filipine",
               "PHT",
               "Ora de var\u0103 din Filipine",
               "PHST",
               "Ora din Filipine",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "Ora din Teritoriile Australe \u0219i Antarctice Franceze",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "Ora Georgiei de Sud",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standard a Noii Caledonii",
               "NCT",
               "Ora de var\u0103 a Noii Caledonii",
               "NCST",
               "Ora Noii Caledonii",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "Ora din Brunei Darussalam",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "Ora standard a Iranului",
               "IRST",
               "Ora de var\u0103 a Iranului",
               "IRDT",
               "Ora Iranului",
               "IRT",
            };
        final String[] Easter = new String[] {
               "Ora standard din Insula Pa\u0219telui",
               "EAST",
               "Ora de var\u0103 din Insula Pa\u0219telui",
               "EASST",
               "Ora din Insula Pa\u0219telui",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "Ora standard a Mexicului de nord-vest",
               "PST",
               "Ora de var\u0103 a Mexicului de nord-vest",
               "PDT",
               "Ora Mexicului de nord-vest",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora din Dumont-d\u2019Urville",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "Ora din Tadjikistan",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "Ora standard din Tonga",
               "TOT",
               "Ora de var\u0103 din Tonga",
               "TOST",
               "Ora din Tonga",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard din Bangladesh",
               "BDT",
               "Ora de var\u0103 din Bangladesh",
               "BDST",
               "Ora din Bangladesh",
               "BDT",
            };
        final String[] Peru = new String[] {
               "Ora standard din Peru",
               "PET",
               "Ora de var\u0103 din Peru",
               "PEST",
               "Ora din Peru",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standard a Groenlandei occidentale",
               "WGT",
               "Ora de var\u0103 a Groenlandei occidentale",
               "WGST",
               "Ora Groenlandei occidentale",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "Ora Ecuadorului",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standard a Groenlandei orientale",
               "EGT",
               "Ora de var\u0103 a Groenlandei orientale",
               "EGST",
               "Ora Groenlandei orientale",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "Ora standard a Golfului",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora Indoneziei de Est",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "Ora standard a Coreei",
               "KST",
               "Ora de var\u0103 a Coreei",
               "KDT",
               "Ora Coreei",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard a Australiei Occidentale",
               "AWST",
               "Ora de var\u0103 a Australiei Occidentale",
               "AWDT",
               "Ora Australiei Occidentale",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "Ora din K\u00e2rg\u00e2zstan",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora Indoneziei de Vest",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard a Australiei Orientale",
               "AEST",
               "Ora de var\u0103 a Australiei Orientale",
               "AEDT",
               "Ora Australiei Orientale",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "Ora Guianei Franceze",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "Ora standard a Columbiei",
               "COT",
               "Ora de var\u0103 a Columbiei",
               "COST",
               "Ora Columbiei",
               "COT",
            };
        final String[] Chile = new String[] {
               "Ora standard din Chile",
               "CLT",
               "Ora de var\u0103 din Chile",
               "CLST",
               "Ora din Chile",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora Insulelor Gilbert",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard \u00een zona montan\u0103 nord-american\u0103",
               "MST",
               "Ora de var\u0103 \u00een zona montan\u0103 nord-american\u0103",
               "MDT",
               "Ora zonei montane nord-americane",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Ora Insulelor Marchize",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "Ora standard arab\u0103",
               "AST",
               "Ora de var\u0103 arab\u0103",
               "ADT",
               "Ora arab\u0103",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Ora standard din Alaska",
               "AKST",
               "Ora de var\u0103 din Alaska",
               "AKDT",
               "Ora din Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard din Vladivostok",
               "VLAT",
               "Ora de var\u0103 din Vladivostok",
               "VLAST",
               "Ora din Vladivostok",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "Ora din Chamorro",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard din Irku\u021bk",
               "IRKT",
               "Ora de var\u0103 din Irku\u021bk",
               "IRKST",
               "Ora din Irku\u021bk",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "Ora standard a Georgiei",
               "GET",
               "Ora de var\u0103 a Georgiei",
               "GEST",
               "Ora Georgiei",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "Ora din Tokelau",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora din Papua Noua Guinee",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "Ora standard din Fernando de Noronha",
               "FNT",
               "Ora de var\u0103 din Fernando de Noronha",
               "FNST",
               "Ora din Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Ora standard din Choibalsan",
               "CHOT",
               "Ora de var\u0103 din Choibalsan",
               "CHOST",
               "Ora din Choibalsan",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "Ora standard a Brasiliei",
               "BRT",
               "Ora de var\u0103 a Brasiliei",
               "BRST",
               "Ora Brasiliei",
               "BRT",
            };
        final String[] China = new String[] {
               "Ora standard a Chinei",
               "CST",
               "Ora de var\u0103 a Chinei",
               "CDT",
               "Ora Chinei",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Ora standard a Armeniei",
               "AMT",
               "Ora de var\u0103 a Armeniei",
               "AMST",
               "Ora Armeniei",
               "AMT",
            };
        final String[] Samara = new String[] {
               "Ora standard din Samara",
               "SAMT",
               "Ora de var\u0103 din Samara",
               "SAMST",
               "Ora din Samara",
               "SAMT",
            };
        final String[] India = new String[] {
               "Ora Indiei",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "Ora standard a Insulelor Cook",
               "CKT",
               "Ora de var\u0103 a Insulelor Cook",
               "CKHST",
               "Ora Insulelor Cook",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 britanic\u0103",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Ora de Greenwhich",
                    "GMT",
                    "Ora de var\u0103 a Irlandei",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
