

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Invocation{/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Invocation</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="Usage.html">Prev</a> </td><th width="60%" align="center">Chapter 2. Usage</th><td width="20%" align="right"> <a accesskey="n" href="Suboptions.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="sect1"><div class="titlepage"><div><div><h2 class="title" ><a id="Invocation"></a>Invocation</h2></div></div></div><p>
If you're using GPSBabel, you will need to know how to do at least two things:
read data from a file, and write it to another file.  There are four basic
options you need to know to do those things:
</p><div class="segmentedlist"><table border="0"><thead><tr class="segtitle"><th>Command</th><th>Meaning</th></tr></thead><tbody><tr class="seglistitem"><td class="seg"><code class="option">-i</code> <em class="parameter"><code>format</code></em></td><td class="seg">Set input format</td></tr><tr class="seglistitem"><td class="seg"><code class="option">-f</code> <em class="parameter"><code>filename</code></em></td><td class="seg">Read file</td></tr><tr class="seglistitem"><td class="seg"><code class="option">-o</code> <em class="parameter"><code>format</code></em></td><td class="seg">Set output format</td></tr><tr class="seglistitem"><td class="seg"><code class="option">-F</code> <em class="parameter"><code>filename</code></em></td><td class="seg">Write output file</td></tr></tbody></table></div><div class="important" style="margin-left: 0.5in; margin-right: 0.5in;"><h3 class="title">Important</h3><p>
Case matters.  Notably <code class="option">-f</code> (lowercase) sets the <span class="emphasis"><em>input</em></span> file.  <code class="option"> -F</code> (uppercase) sets the <span class="emphasis"><em>output</em></span> file. 
</p></div><p>
The <em class="parameter"><code>format</code></em> parameters in the above list
refer to the names of formats or file types supported by GPSBabel. 
</p><p><strong class="userinput"><code>gpsbabel -? </code></strong></p><p>will always show you the supported file types.  In this document, the
various supported formats are listed in <a class="xref" href="The_Formats.html" title="Chapter 3. The Formats">Chapter 3, <em>The Formats</em></a>.  The 
name that you would use on the command line follows the format name in 
parentheses.
</p><p>
Options are <span class="emphasis"><em>always</em></span> processed in order from left to right.
In practical terms, this means that things you want to read should appear
in the command before things you want to write.   This sometimes surprises
new users as adding options to turn on debugging at the end, for example, 
doesn't work as the debugging is turned on after all the interesting work is
done.   The reason for this strict ordering becomes more apparent once you
learn about mixing formats and filters.
</p><p>
The <em class="parameter"><code>filename</code></em> parameters specify the 
name of a file to be read or written.
</p><p>To use
         GPSBabel in its simplest form, just tell it what you're reading, where to read
         it from, what you're writing, and what to write it to.  For
         example:</p><p><strong class="userinput"><code>gpsbabel -i geo -f /tmp/geocaching.loc -o gpx -F /tmp/geocaching.gpx</code></strong></p><p>tells it to read the file <code class="filename">/tmp/geocaching.loc</code> in geocaching.com
         format and create a new file <code class="filename">/tmp/geocaching.gpx</code> in GPX format.   It's important to note that the names have nothing to do with the formats actually used.</p><p> This command will read from a Magellan unit attached
         to the first serial port on a Linux system (device names will
         vary on other OSes; typically COMx: on WIndows) and write them as a geocaching loc file.</p><div class="example"><a id="linux_download_from_magellan"></a><p class="title"><strong>Example 2.1. Command showing Linux download from Magellan serial and writing to .loc file</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i magellan -f /dev/ttyS0 -o geo -F mag.loc</code></strong></p></div></div><br class="example-break" /><p>This second command does the same on Microsoft Windows.</p><div class="example"><a id="windows_download_from_magellan"></a><p class="title"><strong>Example 2.2. Command showing Windows download from Magellan serial and writing to .loc file</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i magellan -f com1 -o geo -F mag.loc</code></strong></p></div></div><br class="example-break" /><p>Optionally, you may specify <em class="parameter"><code>-s</code></em> in any command line.  This
         causes the program to ignore any "short" names that may be
         present in the source data format and synthesize one from the
         long name.  This is particularly useful if you're writing to
         a target format that isn't the lowest common denominator but
         the source data was written for the lowest common
         denominator.  This is useful for writing data from geocaching.com
         to a GPS so my waypoints have "real" names instead of
         the 'GC1234' ones that are optimized for receivers of the lowest 
	common denominator.
         A geocacher using Linux with a Magellan receiver may thus find commands
         like this useful.</p><p><strong class="userinput"><code>gpsbabel -s -i geo -f geocaching.loc -o magellan -F /dev/ttyS0  </code></strong></p><p>His counterpart on Windows will find this equivalent</p><p><strong class="userinput"><code>gpsbabel -s -i geo -f geocaching.loc -o magellan -F com1</code></strong></p></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="Usage.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Usage.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="Suboptions.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Chapter 2. Usage </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Suboptions</td></tr></table></div>
  
      {/literal}{/block}
  